/*
 * Decompiled with CFR 0.152.
 */
package com.github.segmentio;

import com.github.segmentio.Options;
import com.github.segmentio.flush.Flusher;
import com.github.segmentio.flush.IBatchFactory;
import com.github.segmentio.models.Alias;
import com.github.segmentio.models.BasePayload;
import com.github.segmentio.models.Batch;
import com.github.segmentio.models.Callback;
import com.github.segmentio.models.Context;
import com.github.segmentio.models.EventProperties;
import com.github.segmentio.models.Identify;
import com.github.segmentio.models.Track;
import com.github.segmentio.models.Traits;
import com.github.segmentio.request.BlockingRequester;
import com.github.segmentio.request.IRequester;
import com.github.segmentio.stats.AnalyticsStatistics;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;

public class AnalyticsClient {
    private String writeKey;
    private Options options;
    private Flusher flusher;
    private IRequester requester;
    private AnalyticsStatistics statistics;
    private IBatchFactory factory = new IBatchFactory(){

        @Override
        public Batch create(List<BasePayload> batch) {
            return new Batch(AnalyticsClient.this.writeKey, batch);
        }
    };

    public AnalyticsClient(String writeKey) {
        this(writeKey, new Options());
    }

    public AnalyticsClient(String writeKey, Options options) {
        String errorPrefix = "analytics-java client must be initialized with a valid ";
        if (StringUtils.isEmpty((String)writeKey)) {
            throw new IllegalArgumentException(errorPrefix + "writeKey.");
        }
        if (options == null) {
            throw new IllegalArgumentException(errorPrefix + "options.");
        }
        this.writeKey = writeKey;
        this.options = options;
        this.statistics = new AnalyticsStatistics();
        this.requester = new BlockingRequester(this);
        this.flusher = new Flusher(this, this.factory, this.requester);
        this.flusher.start();
    }

    public void identify(String userId, Traits traits) {
        this.identify(userId, traits, null, null, null);
    }

    public void identify(String userId, Traits traits, Context context) {
        this.identify(userId, traits, null, context, null);
    }

    public void identify(String userId, Traits traits, DateTime timestamp, Context context) {
        this.identify(userId, traits, timestamp, context, null);
    }

    public void identify(String userId, Traits traits, DateTime timestamp, Context context, Callback callback) {
        if (context == null) {
            context = new Context();
        }
        if (traits == null) {
            traits = new Traits();
        }
        Identify identify = new Identify(userId, traits, timestamp, context, callback);
        this.flusher.enqueue(identify);
        this.statistics.updateIdentifies(1.0);
    }

    public void track(String userId, String event) {
        this.track(userId, event, null, null, null, null);
    }

    public void track(String userId, String event, EventProperties properties) {
        this.track(userId, event, properties, null, null, null);
    }

    public void track(String userId, String event, EventProperties properties, DateTime timestamp) {
        this.track(userId, event, properties, timestamp, null, null);
    }

    public void track(String userId, String event, EventProperties properties, DateTime timestamp, Context context) {
        this.track(userId, event, properties, timestamp, context, null);
    }

    public void track(String userId, String event, EventProperties properties, DateTime timestamp, Context context, Callback callback) {
        if (context == null) {
            context = new Context();
        }
        if (properties == null) {
            properties = new EventProperties(new Object[0]);
        }
        Track track = new Track(userId, event, properties, timestamp, context, callback);
        this.flusher.enqueue(track);
        this.statistics.updateTracks(1.0);
    }

    public void alias(String from, String to) {
        this.alias(from, to, null, null, null);
    }

    public void alias(String from, String to, DateTime timestamp) {
        this.alias(from, to, timestamp, null, null);
    }

    public void alias(String from, String to, Context context) {
        this.alias(from, to, null, context, null);
    }

    public void alias(String from, String to, DateTime timestamp, Context context) {
        this.alias(from, to, timestamp, context, null);
    }

    public void alias(String from, String to, DateTime timestamp, Context context, Callback callback) {
        if (context == null) {
            context = new Context();
        }
        Alias alias = new Alias(from, to, timestamp, context, callback);
        this.flusher.enqueue(alias);
        this.statistics.updateAlias(1.0);
    }

    public void flush() {
        this.flusher.flush();
    }

    public void close() {
        this.flusher.close();
        this.requester.close();
    }

    public String getWriteKey() {
        return this.writeKey;
    }

    public void setWriteKey(String writeKey) {
        this.writeKey = writeKey;
    }

    public Options getOptions() {
        return this.options;
    }

    public AnalyticsStatistics getStatistics() {
        return this.statistics;
    }
}

