/*
 * Decompiled with CFR 0.152.
 */
package com.github.searls.jasmine.thirdpartylibs;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;

public class ProjectClassLoaderFactory {
    private final Set<Artifact> artifacts;

    public ProjectClassLoaderFactory() {
        this(new HashSet<Artifact>());
    }

    public ProjectClassLoaderFactory(Set<Artifact> artifacts) {
        this.artifacts = artifacts;
    }

    public ClassLoader create() {
        ArrayList<String> classpathElements = new ArrayList<String>();
        for (Artifact artifact : this.artifacts) {
            classpathElements.add(artifact.getFile().getAbsolutePath());
        }
        return this.createURLClassLoader(classpathElements);
    }

    private ClassLoader createURLClassLoader(List<String> classpathElements) {
        ArrayList<URL> urls = new ArrayList<URL>();
        try {
            for (String element : classpathElements) {
                File elementFile = new File(element);
                urls.add(elementFile.toURI().toURL());
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return new URLClassLoader(urls.toArray(new URL[urls.size()]), Thread.currentThread().getContextClassLoader());
    }
}

