/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.format.util;

import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressString;
import inet.ipaddr.format.util.AddedTree;
import inet.ipaddr.format.util.AddedTreeBase;
import inet.ipaddr.format.util.AddressTrie;
import inet.ipaddr.format.util.BinaryTreeNode;
import inet.ipaddr.format.util.IPAddressAssociativeTrie;
import inet.ipaddr.format.validate.ChangeTracker;
import inet.ipaddr.ipv4.IPv4Address;
import inet.ipaddr.ipv6.IPv6Address;
import java.util.Iterator;
import java.util.Spliterator;

public class IPAddressTrie
extends AddressTrie<IPAddress> {
    private static final long serialVersionUID = 1L;
    static final IPv6Address IPV6_ROOT = new IPAddressString("::/0").getAddress().toIPv6();
    static final IPv4Address IPV4_ROOT = new IPAddressString("0.0.0.0/0").getAddress().toIPv4();

    public IPAddressTrie() {
        super(new IPAddressTrieNode());
    }

    protected IPAddressTrie(ChangeTracker changeTracker) {
        super(new IPAddressTrieNode(), changeTracker);
    }

    protected IPAddressTrie(IPAddressTrieNode root, AddressTrie.AddressBounds<IPAddress> bounds) {
        super(root, bounds);
    }

    protected IPAddressTrie(AddressTrie.AddressBounds<IPAddress> bounds) {
        super(new IPAddressTrieNode(), bounds);
    }

    @Override
    protected void adjustRoot(IPAddress addr) {
        if (this.isInitialRoot()) {
            if (addr.isIPv6()) {
                this.absoluteRoot().setIPv6Key();
            } else {
                this.absoluteRoot().setIPv4Key();
            }
        }
    }

    protected IPAddressTrie createNew(AddressTrie.AddressBounds<IPAddress> bounds) {
        return new IPAddressTrie(bounds);
    }

    protected IPAddressTrie createSubTrie(AddressTrie.AddressBounds<IPAddress> bounds) {
        return new IPAddressTrie(this.absoluteRoot(), bounds);
    }

    protected IPAddressTrieNode absoluteRoot() {
        return (IPAddressTrieNode)super.absoluteRoot();
    }

    @Override
    public AddedTreeBase<IPAddress, ? extends AddressTrie.SubNodesMapping<IPAddress, ? extends AddressTrie.SubNodesMapping<IPAddress, ?>>> constructAddedNodesTree() {
        IPAddressAssociativeTrie trie = new IPAddressAssociativeTrie();
        this.contructAddedTree(trie);
        return new AddedTree<IPAddress>(trie);
    }

    @Override
    public String toAddedNodesTreeString() {
        IPAddressAssociativeTrie trie = new IPAddressAssociativeTrie();
        this.contructAddedTree(trie);
        return IPAddressTrie.toAddedNodesTreeString(trie);
    }

    public IPAddressTrieNode removeElementsContainedBy(IPAddress addr) {
        return (IPAddressTrieNode)super.removeElementsContainedBy(addr);
    }

    public IPAddressTrieNode elementsContainedBy(IPAddress addr) {
        return (IPAddressTrieNode)super.elementsContainedBy(addr);
    }

    public IPAddressTrieNode removeElementsIntersectedBy(IPAddress addr) {
        return (IPAddressTrieNode)super.removeElementsIntersectedBy(addr);
    }

    public IPAddressTrieNode addIfNoElementsContaining(IPAddress addr) {
        return (IPAddressTrieNode)super.addIfNoElementsContaining(addr);
    }

    protected IPAddressTrieNode addIfNoElementsContaining(IPAddress addr, boolean checkBlockOrAddress) {
        return (IPAddressTrieNode)super.addIfNoElementsContaining(addr, checkBlockOrAddress);
    }

    public IPAddressTrieNode elementsContaining(IPAddress addr) {
        return (IPAddressTrieNode)super.elementsContaining(addr);
    }

    public IPAddressTrieNode longestPrefixMatchNode(IPAddress addr) {
        return (IPAddressTrieNode)super.longestPrefixMatchNode(addr);
    }

    public IPAddressTrieNode getAddedNode(IPAddress addr) {
        return (IPAddressTrieNode)super.getAddedNode(addr);
    }

    public IPAddressTrieNode getNode(IPAddress addr) {
        return (IPAddressTrieNode)super.getNode(addr);
    }

    public IPAddressTrieNode addNode(IPAddress addr) {
        return (IPAddressTrieNode)super.addNode(addr);
    }

    public IPAddressTrieNode addTrie(AddressTrie.TrieNode<IPAddress> trie) {
        return (IPAddressTrieNode)super.addTrie(trie);
    }

    @Override
    public Iterator<IPAddressTrieNode> nodeIterator(boolean forward) {
        return super.nodeIterator(forward);
    }

    @Override
    public Iterator<IPAddressTrieNode> allNodeIterator(boolean forward) {
        return super.allNodeIterator(forward);
    }

    @Override
    public Iterator<IPAddressTrieNode> blockSizeNodeIterator(boolean lowerSubNodeFirst) {
        return super.blockSizeNodeIterator(lowerSubNodeFirst);
    }

    @Override
    public Iterator<IPAddressTrieNode> blockSizeAllNodeIterator(boolean lowerSubNodeFirst) {
        return super.blockSizeAllNodeIterator(lowerSubNodeFirst);
    }

    @Override
    public <C> BinaryTreeNode.CachingIterator<IPAddressTrieNode, IPAddress, C> blockSizeCachingAllNodeIterator() {
        return super.blockSizeCachingAllNodeIterator();
    }

    @Override
    public Iterator<IPAddressTrieNode> containingFirstIterator(boolean forwardSubNodeOrder) {
        return super.containingFirstIterator(forwardSubNodeOrder);
    }

    @Override
    public <C> BinaryTreeNode.CachingIterator<IPAddressTrieNode, IPAddress, C> containingFirstAllNodeIterator(boolean forwardSubNodeOrder) {
        return super.containingFirstAllNodeIterator(forwardSubNodeOrder);
    }

    @Override
    public Iterator<IPAddressTrieNode> containedFirstIterator(boolean forwardSubNodeOrder) {
        return super.containedFirstIterator(forwardSubNodeOrder);
    }

    @Override
    public Iterator<IPAddressTrieNode> containedFirstAllNodeIterator(boolean forwardSubNodeOrder) {
        return super.containedFirstAllNodeIterator(forwardSubNodeOrder);
    }

    @Override
    public Spliterator<IPAddressTrieNode> nodeSpliterator(boolean forward) {
        return super.nodeSpliterator(forward);
    }

    @Override
    public Spliterator<IPAddressTrieNode> allNodeSpliterator(boolean forward) {
        return super.allNodeSpliterator(forward);
    }

    public IPAddressTrieNode lowerAddedNode(IPAddress addr) {
        return (IPAddressTrieNode)super.lowerAddedNode(addr);
    }

    public IPAddressTrieNode floorAddedNode(IPAddress addr) {
        return (IPAddressTrieNode)super.floorAddedNode(addr);
    }

    public IPAddressTrieNode higherAddedNode(IPAddress addr) {
        return (IPAddressTrieNode)super.higherAddedNode(addr);
    }

    public IPAddressTrieNode ceilingAddedNode(IPAddress addr) {
        return (IPAddressTrieNode)super.ceilingAddedNode(addr);
    }

    public IPAddressTrieNode containingFloorAddedNode(IPAddress addr) {
        return (IPAddressTrieNode)super.containingFloorAddedNode(addr);
    }

    protected IPAddressTrieNode containingFloorAddedNodeNoCheck(IPAddress addr) {
        return (IPAddressTrieNode)super.containingFloorAddedNodeNoCheck(addr);
    }

    public IPAddressTrieNode containingLowerAddedNode(IPAddress addr) {
        return (IPAddressTrieNode)super.containingLowerAddedNode(addr);
    }

    protected IPAddressTrieNode containingLowerAddedNodeNoCheck(IPAddress addr) {
        return (IPAddressTrieNode)super.containingLowerAddedNodeNoCheck(addr);
    }

    public IPAddressTrieNode containingCeilingAddedNode(IPAddress addr) {
        return (IPAddressTrieNode)super.containingCeilingAddedNode(addr);
    }

    protected IPAddressTrieNode containingCeilingAddedNodeNoCheck(IPAddress addr) {
        return (IPAddressTrieNode)super.containingCeilingAddedNodeNoCheck(addr);
    }

    public IPAddressTrieNode containingHigherAddedNode(IPAddress addr) {
        return (IPAddressTrieNode)super.containingHigherAddedNode(addr);
    }

    protected IPAddressTrieNode containingHigherAddedNodeNoCheck(IPAddress addr) {
        return (IPAddressTrieNode)super.containingHigherAddedNodeNoCheck(addr);
    }

    public IPAddressTrieNode firstNode() {
        return (IPAddressTrieNode)super.firstNode();
    }

    public IPAddressTrieNode lastNode() {
        return (IPAddressTrieNode)super.lastNode();
    }

    public IPAddressTrieNode firstAddedNode() {
        return (IPAddressTrieNode)super.firstAddedNode();
    }

    public IPAddressTrieNode lastAddedNode() {
        return (IPAddressTrieNode)super.lastAddedNode();
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof IPAddressTrie && super.equals(o);
    }

    protected IPAddressTrie clone(ChangeTracker tracker) {
        return (IPAddressTrie)super.clone(tracker);
    }

    @Override
    public IPAddressTrie clone() {
        return (IPAddressTrie)super.clone();
    }

    public static class IPAddressTrieNode
    extends AddressTrie.TrieNode<IPAddress> {
        private static final long serialVersionUID = 1L;

        protected IPAddressTrieNode(IPAddress addr) {
            super(addr);
        }

        public IPAddressTrieNode() {
            super(null);
        }

        @Override
        protected void replaceThisRoot(BinaryTreeNode<IPAddress> replacement) {
            super.replaceThisRoot(replacement);
            if (replacement == null) {
                this.setKey(null);
            }
        }

        void setIPv6Key() {
            this.setKey(IPV6_ROOT);
        }

        void setIPv4Key() {
            this.setKey(IPV4_ROOT);
        }

        protected IPAddressTrieNode createNewImpl(IPAddress newAddr) {
            return new IPAddressTrieNode(newAddr);
        }

        protected IPAddressTrie createNewTree() {
            return new IPAddressTrie();
        }

        @Override
        public IPAddressTrieNode getUpperSubNode() {
            return (IPAddressTrieNode)super.getUpperSubNode();
        }

        @Override
        public IPAddressTrieNode getLowerSubNode() {
            return (IPAddressTrieNode)super.getLowerSubNode();
        }

        @Override
        public IPAddressTrieNode getParent() {
            return (IPAddressTrieNode)super.getParent();
        }

        public IPAddressTrieNode removeElementsContainedBy(IPAddress addr) {
            return (IPAddressTrieNode)super.removeElementsContainedBy(addr);
        }

        public IPAddressTrieNode elementsContainedBy(IPAddress addr) {
            return (IPAddressTrieNode)super.elementsContainedBy(addr);
        }

        public IPAddressTrieNode elementsContaining(IPAddress addr) {
            return (IPAddressTrieNode)super.elementsContaining(addr);
        }

        public IPAddressTrieNode longestPrefixMatchNode(IPAddress addr) {
            return (IPAddressTrieNode)super.longestPrefixMatchNode(addr);
        }

        public IPAddressTrieNode getAddedNode(IPAddress addr) {
            return (IPAddressTrieNode)super.getAddedNode(addr);
        }

        public IPAddressTrieNode getNode(IPAddress addr) {
            return (IPAddressTrieNode)super.getNode(addr);
        }

        @Override
        public Iterator<IPAddressTrieNode> nodeIterator(boolean forward) {
            return super.nodeIterator(forward);
        }

        @Override
        public Iterator<IPAddressTrieNode> allNodeIterator(boolean forward) {
            return super.allNodeIterator(forward);
        }

        @Override
        public Iterator<IPAddressTrieNode> blockSizeNodeIterator(boolean lowerSubNodeFirst) {
            return super.blockSizeNodeIterator(lowerSubNodeFirst);
        }

        @Override
        public Iterator<IPAddressTrieNode> blockSizeAllNodeIterator(boolean lowerSubNodeFirst) {
            return super.blockSizeAllNodeIterator(lowerSubNodeFirst);
        }

        @Override
        public <C> BinaryTreeNode.CachingIterator<IPAddressTrieNode, IPAddress, C> blockSizeCachingAllNodeIterator() {
            return super.blockSizeCachingAllNodeIterator();
        }

        @Override
        public Iterator<IPAddressTrieNode> containingFirstIterator(boolean forwardSubNodeOrder) {
            return super.containingFirstIterator(forwardSubNodeOrder);
        }

        @Override
        public <C> BinaryTreeNode.CachingIterator<IPAddressTrieNode, IPAddress, C> containingFirstAllNodeIterator(boolean forwardSubNodeOrder) {
            return super.containingFirstAllNodeIterator(forwardSubNodeOrder);
        }

        @Override
        public Iterator<IPAddressTrieNode> containedFirstIterator(boolean forwardSubNodeOrder) {
            return super.containedFirstIterator(forwardSubNodeOrder);
        }

        @Override
        public Iterator<IPAddressTrieNode> containedFirstAllNodeIterator(boolean forwardSubNodeOrder) {
            return super.containedFirstAllNodeIterator(forwardSubNodeOrder);
        }

        @Override
        public Spliterator<IPAddressTrieNode> nodeSpliterator(boolean forward) {
            return super.nodeSpliterator(forward);
        }

        @Override
        public Spliterator<IPAddressTrieNode> allNodeSpliterator(boolean forward) {
            return super.allNodeSpliterator(forward);
        }

        @Override
        public IPAddressTrieNode previousAddedNode() {
            return (IPAddressTrieNode)super.previousAddedNode();
        }

        @Override
        public IPAddressTrieNode nextAddedNode() {
            return (IPAddressTrieNode)super.nextAddedNode();
        }

        @Override
        public IPAddressTrieNode nextNode() {
            return (IPAddressTrieNode)super.nextNode();
        }

        @Override
        public IPAddressTrieNode previousNode() {
            return (IPAddressTrieNode)super.previousNode();
        }

        public IPAddressTrieNode lowerAddedNode(IPAddress addr) {
            return (IPAddressTrieNode)super.lowerAddedNode(addr);
        }

        public IPAddressTrieNode floorAddedNode(IPAddress addr) {
            return (IPAddressTrieNode)super.floorAddedNode(addr);
        }

        public IPAddressTrieNode higherAddedNode(IPAddress addr) {
            return (IPAddressTrieNode)super.higherAddedNode(addr);
        }

        public IPAddressTrieNode ceilingAddedNode(IPAddress addr) {
            return (IPAddressTrieNode)super.ceilingAddedNode(addr);
        }

        @Override
        public IPAddressTrieNode firstNode() {
            return (IPAddressTrieNode)super.firstNode();
        }

        @Override
        public IPAddressTrieNode lastNode() {
            return (IPAddressTrieNode)super.lastNode();
        }

        @Override
        public IPAddressTrieNode firstAddedNode() {
            return (IPAddressTrieNode)super.firstAddedNode();
        }

        @Override
        public IPAddressTrieNode lastAddedNode() {
            return (IPAddressTrieNode)super.lastAddedNode();
        }

        public IPAddressTrie asNewTrie() {
            return (IPAddressTrie)super.asNewTrie();
        }

        @Override
        public IPAddressTrieNode cloneTree() {
            return (IPAddressTrieNode)super.cloneTree();
        }

        @Override
        public IPAddressTrieNode clone() {
            return (IPAddressTrieNode)super.clone();
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof IPAddressTrieNode && super.equals(o);
        }
    }
}

