/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.ipv6;

import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressSeqRange;
import inet.ipaddr.IPAddressSeqRangeList;
import inet.ipaddr.format.util.BigSpliterator;
import inet.ipaddr.ipv6.IPv6Address;
import inet.ipaddr.ipv6.IPv6AddressNetwork;
import inet.ipaddr.ipv6.IPv6AddressSeqRange;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.stream.Stream;

public class IPv6AddressSeqRangeList
extends IPAddressSeqRangeList
implements Iterable<IPv6Address> {
    private static final long serialVersionUID = 1L;

    public IPv6AddressSeqRangeList() {
    }

    public IPv6AddressSeqRangeList(int initialCapacity) {
        super(initialCapacity);
    }

    public IPv6AddressSeqRange[] getSeqRanges() {
        return this.ranges.toArray(new IPv6AddressSeqRange[this.ranges.size()]);
    }

    @Override
    public IPv6AddressSeqRangeList complementIntoList() {
        IPv6AddressNetwork network = this.isEmpty() ? IPv6Address.defaultIpv6Network() : this.getLowerSeqRange().getLower().getNetwork();
        IPv6Address zero = (IPv6Address)network.getNetworkMask(0, false);
        IPv6Address max = (IPv6Address)network.getNetworkMask(zero.getBitCount(), false);
        IPv6AddressSeqRangeList result = new IPv6AddressSeqRangeList();
        this.complement(result, zero, max);
        return result;
    }

    @Override
    public IPv6AddressSeqRangeList removeIntoList(IPAddressSeqRangeList list) {
        IPv6AddressSeqRangeList result = new IPv6AddressSeqRangeList();
        super.remove(list, result);
        return result;
    }

    @Override
    public IPv6AddressSeqRangeList intersectIntoList(IPAddressSeqRangeList list) {
        IPv6AddressSeqRangeList result = new IPv6AddressSeqRangeList();
        super.intersect(list, result);
        return result;
    }

    @Override
    public IPv6AddressSeqRangeList joinIntoList(IPAddressSeqRangeList list) {
        if (list.getSeqRangeCount() == 0) {
            return this.clone();
        }
        if (!list.getSeqRange(0).isIPv6()) {
            throw new IllegalArgumentException(IPv6AddressSeqRangeList.getMessage("ipaddress.error.mismatched.bit.size"));
        }
        IPv6AddressSeqRangeList result = new IPv6AddressSeqRangeList();
        super.join(list, result);
        return result;
    }

    @Override
    public boolean add(IPAddress address) {
        if (!address.isIPv6()) {
            throw new IllegalArgumentException(IPv6AddressSeqRangeList.getMessage("ipaddress.error.mismatched.bit.size"));
        }
        if (this.ranges.size() == 0) {
            this.addAddressToEmptyList(address);
            return true;
        }
        return this.doAdd(address);
    }

    void addInternalToNewList(IPv6Address address) {
        this.addAddressToEmptyList(address);
    }

    @Override
    public boolean add(IPAddressSeqRange seqRange) {
        if (!seqRange.isIPv6()) {
            throw new IllegalArgumentException(IPv6AddressSeqRangeList.getMessage("ipaddress.error.mismatched.bit.size"));
        }
        if (this.ranges.size() == 0) {
            this.addRangeToEmptyList(seqRange);
            return true;
        }
        return this.doAdd(seqRange);
    }

    @Override
    public IPv6Address getLower() {
        return (IPv6Address)super.getLower();
    }

    @Override
    public IPv6Address getUpper() {
        return (IPv6Address)super.getUpper();
    }

    @Override
    public IPv6AddressSeqRange getLowerSeqRange() {
        return (IPv6AddressSeqRange)super.getLowerSeqRange();
    }

    @Override
    public IPv6AddressSeqRange getUpperSeqRange() {
        return (IPv6AddressSeqRange)super.getUpperSeqRange();
    }

    @Override
    public IPv6AddressSeqRangeList clone() {
        return (IPv6AddressSeqRangeList)super.clone();
    }

    @Override
    public IPv6AddressSeqRange getSeqRange(int rangeIndex) {
        return (IPv6AddressSeqRange)this.ranges.get(rangeIndex);
    }

    @Override
    public IPv6Address remove(long addressIndex) {
        return (IPv6Address)super.remove(addressIndex);
    }

    @Override
    public IPv6Address increment(long addressIndex) {
        return (IPv6Address)super.increment(addressIndex);
    }

    @Override
    public IPv6Address get(long addressIndex) {
        return (IPv6Address)super.get(addressIndex);
    }

    @Override
    public IPv6AddressSeqRange getContainingSeqRange(long addressIndex) {
        return (IPv6AddressSeqRange)super.getContainingSeqRange(addressIndex);
    }

    @Override
    public IPv6Address remove(BigInteger addressIndex) {
        return (IPv6Address)super.remove(addressIndex);
    }

    @Override
    public IPv6Address increment(BigInteger addressIndex) {
        return (IPv6Address)super.increment(addressIndex);
    }

    @Override
    public IPv6Address get(BigInteger addressIndex) {
        return (IPv6Address)super.get(addressIndex);
    }

    @Override
    public IPv6AddressSeqRange getContainingSeqRange(BigInteger index) {
        return (IPv6AddressSeqRange)super.getContainingSeqRange(index);
    }

    @Override
    public IPv6AddressSeqRange coverWithSequentialRange() {
        return (IPv6AddressSeqRange)super.coverWithSequentialRange();
    }

    @Override
    public IPv6Address coverWithPrefixBlock() {
        return this.getLower().coverWithPrefixBlock(this.getUpper());
    }

    public IPv6Address[] spanWithPrefixBlocks() {
        if (this.ranges.size() == 0) {
            return IPv6AddressNetwork.EMPTY_ADDRESS;
        }
        return (IPv6Address[])this.getSpanningBlocks(IPv6AddressSeqRange::spanWithPrefixBlocks, IPv6Address[]::new);
    }

    public IPv6Address[] spanWithSequentialBlocks() {
        if (this.ranges.size() == 0) {
            return IPv6AddressNetwork.EMPTY_ADDRESS;
        }
        return (IPv6Address[])this.getSpanningBlocks(IPv6AddressSeqRange::spanWithSequentialBlocks, IPv6Address[]::new);
    }

    public Iterable<IPv6Address> getIterable() {
        return this;
    }

    public Iterable<IPv6AddressSeqRange> getSeqRangeIterable() {
        return super.getSeqRangeIterable();
    }

    public Iterator<IPv6AddressSeqRange> seqRangeIterator() {
        return super.seqRangeIterator();
    }

    @Override
    public Iterator<IPv6Address> iterator() {
        return super.iterator();
    }

    @Override
    public BigSpliterator<IPv6Address> spliterator() {
        return super.spliterator();
    }

    @Override
    public Stream<IPv6Address> stream() {
        return super.stream();
    }
}

