/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.format.validate;

import inet.ipaddr.Address;
import inet.ipaddr.AddressNetwork;

public class ParsedAddressGrouping {
    private static final Integer[] cache = new Integer[256];

    public static int getNetworkSegmentIndex(int networkPrefixLength, int bytesPerSegment, int bitsPerSegment) {
        if (bytesPerSegment > 1) {
            if (bytesPerSegment == 2) {
                return networkPrefixLength - 1 >> 4;
            }
            return (networkPrefixLength - 1) / bitsPerSegment;
        }
        return networkPrefixLength - 1 >> 3;
    }

    public static int getHostSegmentIndex(int networkPrefixLength, int bytesPerSegment, int bitsPerSegment) {
        if (bytesPerSegment > 1) {
            if (bytesPerSegment == 2) {
                return networkPrefixLength >> 4;
            }
            return networkPrefixLength / bitsPerSegment;
        }
        return networkPrefixLength >> 3;
    }

    public static Integer getSegmentPrefixLength(int bitsPerSegment, Integer prefixLength, int segmentIndex) {
        if (prefixLength != null) {
            return ParsedAddressGrouping.getPrefixedSegmentPrefixLength(bitsPerSegment, prefixLength, segmentIndex);
        }
        return null;
    }

    public static Integer getPrefixedSegmentPrefixLength(int bitsPerSegment, int prefixLength, int segmentIndex) {
        int decrement = bitsPerSegment == 8 ? segmentIndex << 3 : (bitsPerSegment == 16 ? segmentIndex << 4 : segmentIndex * bitsPerSegment);
        return ParsedAddressGrouping.getSegmentPrefixLength(bitsPerSegment, prefixLength - decrement);
    }

    public static Integer getSegmentPrefixLength(int segmentBits, int segmentPrefixedBits) {
        if (segmentPrefixedBits <= 0) {
            return 0;
        }
        if (segmentPrefixedBits <= segmentBits) {
            return segmentPrefixedBits;
        }
        return null;
    }

    public static Integer getNetworkPrefixLength(int bitsPerSegment, int segmentPrefixLength, int segmentIndex) {
        int increment = bitsPerSegment == 8 ? segmentIndex << 3 : (bitsPerSegment == 16 ? segmentIndex << 4 : segmentIndex * bitsPerSegment);
        return increment + segmentPrefixLength;
    }

    public static boolean isPrefixSubnet(Address.SegmentValueProvider lowerValueProvider, Address.SegmentValueProvider upperValueProvider, int segmentCount, int bytesPerSegment, int bitsPerSegment, int segmentMaxValue, Integer networkPrefixLength, AddressNetwork.PrefixConfiguration prefixConfiguration, boolean fullRangeOnly) {
        if (networkPrefixLength == null || prefixConfiguration.prefixedSubnetsAreExplicit()) {
            return false;
        }
        if (networkPrefixLength < 0) {
            networkPrefixLength = 0;
        } else {
            int totalBitCount;
            int n = bitsPerSegment == 8 ? segmentCount << 3 : (totalBitCount = bitsPerSegment == 16 ? segmentCount << 4 : segmentCount * bitsPerSegment);
            if (networkPrefixLength >= totalBitCount) {
                return false;
            }
        }
        if (prefixConfiguration.allPrefixedAddressesAreSubnets()) {
            return true;
        }
        int prefixedSegment = ParsedAddressGrouping.getHostSegmentIndex(networkPrefixLength, bytesPerSegment, bitsPerSegment);
        int i = prefixedSegment;
        if (i < segmentCount) {
            int segmentPrefixLength = ParsedAddressGrouping.getSegmentPrefixLength(bitsPerSegment, networkPrefixLength, i);
            do {
                int lower = lowerValueProvider.getValue(i);
                if (segmentPrefixLength == 0) {
                    if (lower != 0) {
                        return false;
                    }
                    int upper = upperValueProvider.getValue(i);
                    if (fullRangeOnly) {
                        if (upper != segmentMaxValue) {
                            return false;
                        }
                    } else {
                        int upperOnes = Integer.numberOfTrailingZeros(~upper);
                        if (upperOnes > 0) {
                            if (upper >>> upperOnes != 0) {
                                return false;
                            }
                            fullRangeOnly = true;
                        } else if (upper != 0) {
                            return false;
                        }
                    }
                } else {
                    int upper;
                    int segHostBits = bitsPerSegment - segmentPrefixLength;
                    if (fullRangeOnly) {
                        int hostMask = ~(-1 << segHostBits);
                        if ((hostMask & lower) != 0) {
                            return false;
                        }
                        upper = upperValueProvider.getValue(i);
                        if ((hostMask & upper) != hostMask) {
                            return false;
                        }
                    } else {
                        int upperZeros;
                        int lowerZeros = Integer.numberOfTrailingZeros(lower);
                        if (lowerZeros < segHostBits) {
                            return false;
                        }
                        upper = upperValueProvider.getValue(i);
                        int upperOnes = Integer.numberOfTrailingZeros(~upper);
                        if (upperOnes + (upperZeros = Integer.numberOfTrailingZeros((upper | -1 << bitsPerSegment) >>> upperOnes)) < segHostBits) {
                            return false;
                        }
                        if (upperOnes > 0) {
                            fullRangeOnly = true;
                        }
                    }
                }
                segmentPrefixLength = 0;
            } while (++i < segmentCount);
        }
        return true;
    }

    public static Integer cache(int i) {
        if (i >= 0 && i < cache.length) {
            return cache[i];
        }
        return i;
    }

    static {
        for (int i = 0; i < cache.length; ++i) {
            ParsedAddressGrouping.cache[i] = i;
        }
    }
}

