/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.format.standard;

import inet.ipaddr.IPAddress;
import inet.ipaddr.PrefixLenException;
import inet.ipaddr.format.AddressItem;
import inet.ipaddr.format.IPAddressGenericDivision;
import inet.ipaddr.format.standard.AddressDivision;
import inet.ipaddr.format.util.AddressSegmentParams;

public abstract class IPAddressDivision
extends AddressDivision
implements IPAddressGenericDivision {
    private static final long serialVersionUID = 4L;
    private final Integer divisionNetworkPrefix;
    protected transient String cachedWildcardString;
    private transient Boolean isSinglePrefixBlock;

    protected IPAddressDivision() {
        this(null);
    }

    protected IPAddressDivision(Integer networkPrefixLength) {
        if (networkPrefixLength != null && networkPrefixLength < 0) {
            throw new PrefixLenException(networkPrefixLength);
        }
        this.divisionNetworkPrefix = networkPrefixLength;
    }

    @Override
    public boolean isPrefixed() {
        return this.divisionNetworkPrefix != null;
    }

    @Override
    public Integer getDivisionPrefixLength() {
        return this.divisionNetworkPrefix;
    }

    public boolean matchesWithPrefixMask(long value, Integer divisionPrefixLen) {
        if (divisionPrefixLen == null) {
            return this.matches(value);
        }
        long mask = this.getDivisionNetworkMask(divisionPrefixLen);
        long matchingValue = value & mask;
        return matchingValue == (this.getDivisionValue() & mask) && matchingValue == (this.getUpperDivisionValue() & mask);
    }

    protected abstract long getDivisionNetworkMask(int var1);

    protected abstract long getDivisionHostMask(int var1);

    public Integer getBlockMaskPrefixLength(boolean network) {
        long invertedVal;
        long val;
        if (network) {
            val = this.getDivisionValue();
            invertedVal = (val ^ 0xFFFFFFFFFFFFFFFFL) & this.getMaxValue();
        } else {
            invertedVal = this.getDivisionValue();
            val = (invertedVal ^ 0xFFFFFFFFFFFFFFFFL) & this.getMaxValue();
        }
        int bitCount = this.getBitCount();
        int hostLength = Math.min(Long.numberOfTrailingZeros(val), bitCount);
        long shifted = invertedVal >>> hostLength;
        return shifted == 0L ? Integer.valueOf(bitCount - hostLength) : null;
    }

    @Override
    protected boolean isPrefixBlock(long segmentValue, long upperValue, int divisionPrefixLen) {
        if (divisionPrefixLen == 0) {
            return segmentValue == 0L && upperValue == this.getMaxValue();
        }
        return IPAddressDivision.testRange(segmentValue, upperValue, upperValue, this.getDivisionNetworkMask(divisionPrefixLen), this.getDivisionHostMask(divisionPrefixLen));
    }

    @Override
    protected boolean isSinglePrefixBlock(long segmentValue, long upperValue, int divisionPrefixLen) {
        return IPAddressDivision.testRange(segmentValue, segmentValue, upperValue, this.getDivisionNetworkMask(divisionPrefixLen), this.getDivisionHostMask(divisionPrefixLen));
    }

    boolean isSinglePrefixBlock(long segmentValue, int divisionPrefixLen) {
        return this.isSinglePrefixBlock(segmentValue, this.getUpperDivisionValue(), divisionPrefixLen);
    }

    @Override
    public boolean containsPrefixBlock(int divisionPrefixLen) {
        return this.isPrefixBlock(this.getDivisionValue(), this.getUpperDivisionValue(), divisionPrefixLen);
    }

    @Override
    public boolean isPrefixBlock() {
        return this.isPrefixed() && this.containsPrefixBlock(this.getDivisionPrefixLength());
    }

    @Override
    public boolean containsSinglePrefixBlock(int divisionPrefixLen) {
        return this.isSinglePrefixBlock(this.getDivisionValue(), this.getUpperDivisionValue(), divisionPrefixLen);
    }

    @Override
    public boolean isSinglePrefixBlock() {
        if (this.isSinglePrefixBlock == null) {
            this.isSinglePrefixBlock = this.isPrefixed() && this.containsSinglePrefixBlock(this.getDivisionPrefixLength());
        }
        return this.isSinglePrefixBlock;
    }

    protected boolean isBitwiseOrCompatibleWithRange(long maskValue, Integer divisionPrefixLen, boolean isAutoSubnets) {
        long value = this.getDivisionValue();
        long upperValue = this.getUpperDivisionValue();
        long maxValue = this.getMaxValue();
        if (divisionPrefixLen != null) {
            int divPrefLen = divisionPrefixLen;
            int bitCount = this.getBitCount();
            if (divPrefLen < 0 || divPrefLen > bitCount) {
                throw new PrefixLenException((AddressItem)this, divisionPrefixLen);
            }
            if (isAutoSubnets) {
                int shift = bitCount - divPrefLen;
                maskValue >>>= shift;
                value >>>= shift;
                upperValue >>>= shift;
                maxValue >>>= shift;
            }
        }
        return IPAddressDivision.isBitwiseOrCompatibleWithRange(value, upperValue, maskValue, maxValue);
    }

    protected boolean isMaskCompatibleWithRange(long maskValue, Integer divisionPrefixLen, boolean isAutoSubnets) {
        long value = this.getDivisionValue();
        long upperValue = this.getUpperDivisionValue();
        long maxValue = this.getMaxValue();
        if (divisionPrefixLen != null) {
            int divPrefLen = divisionPrefixLen;
            int bitCount = this.getBitCount();
            if (divPrefLen < 0 || divPrefLen > bitCount) {
                throw new PrefixLenException((AddressItem)this, divisionPrefixLen);
            }
            if (isAutoSubnets) {
                int shift = bitCount - divPrefLen;
                maskValue >>>= shift;
                value >>>= shift;
                upperValue >>>= shift;
                maxValue >>>= shift;
            }
        }
        return IPAddressDivision.isMaskCompatibleWithRange(value, upperValue, maskValue, maxValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getString() {
        String result = this.cachedString;
        if (result == null) {
            IPAddressDivision iPAddressDivision = this;
            synchronized (iPAddressDivision) {
                result = this.cachedString;
                if (result == null) {
                    if (this.isSinglePrefixBlock() || !this.isMultiple()) {
                        result = this.getDefaultString();
                    } else if (this.isFullRange()) {
                        result = IPAddress.SEGMENT_WILDCARD_STR;
                    } else {
                        long upperValue = this.getUpperDivisionValue();
                        if (this.isPrefixBlock()) {
                            upperValue &= this.getDivisionNetworkMask(this.getDivisionPrefixLength());
                        }
                        result = this.getDefaultRangeString(this.getDivisionValue(), upperValue, this.getDefaultTextualRadix());
                    }
                    this.cachedString = result;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getWildcardString() {
        String result = this.cachedWildcardString;
        if (result == null) {
            IPAddressDivision iPAddressDivision = this;
            synchronized (iPAddressDivision) {
                result = this.cachedWildcardString;
                if (result == null) {
                    result = !this.isPrefixed() || !this.isMultiple() ? this.getString() : (this.isFullRange() ? IPAddress.SEGMENT_WILDCARD_STR : this.getDefaultRangeString());
                    this.cachedWildcardString = result;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setDefaultAsFullRangeWildcardString() {
        if (this.cachedWildcardString == null) {
            IPAddressDivision iPAddressDivision = this;
            synchronized (iPAddressDivision) {
                this.cachedWildcardString = IPAddress.SEGMENT_WILDCARD_STR;
            }
        }
    }

    @Override
    protected void getUpperStringMasked(int radix, boolean uppercase, StringBuilder appendable) {
        long upperValue = this.getUpperDivisionValue();
        long mask = this.getDivisionNetworkMask(this.getDivisionPrefixLength());
        IPAddressDivision.toUnsignedString(upperValue &= mask, radix, 0, uppercase, uppercase ? UPPERCASE_DIGITS : DIGITS, appendable);
    }

    @Override
    public int getPrefixAdjustedRangeString(int segmentIndex, AddressSegmentParams params, StringBuilder appendable) {
        return super.getPrefixAdjustedRangeString(segmentIndex, params, appendable);
    }
}

