/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.format;

import inet.ipaddr.format.AddressDivisionGrouping;
import inet.ipaddr.format.AddressItem;
import inet.ipaddr.format.AddressStringDivision;
import inet.ipaddr.format.util.AddressSegmentParams;
import java.math.BigInteger;
import java.util.TreeMap;

public abstract class AddressDivisionBase
implements AddressItem,
AddressStringDivision {
    private static final long serialVersionUID = 4L;
    private static final String[] zeros;
    protected static final char[] DIGITS;
    protected static final char[] UPPERCASE_DIGITS;
    private static TreeMap<Long, Integer> maxDigitMap;
    private static TreeMap<Long, BigInteger> radixPowerMap;
    protected transient String cachedString;
    private transient byte[] lowerBytes;
    private transient byte[] upperBytes;

    static {
        int zerosLength = 20;
        zeros = new String[zerosLength];
        AddressDivisionBase.zeros[0] = "";
        int i = 1;
        while (i < zerosLength) {
            AddressDivisionBase.zeros[i] = String.valueOf(zeros[i - 1]) + '0';
            ++i;
        }
        DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
        UPPERCASE_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
        maxDigitMap = new TreeMap();
        radixPowerMap = new TreeMap();
    }

    protected AddressDivisionBase() {
    }

    @Override
    public byte[] getBytes() {
        byte[] cached = this.lowerBytes;
        if (cached == null) {
            this.lowerBytes = cached = this.getBytesImpl(true);
        }
        return (byte[])cached.clone();
    }

    @Override
    public byte[] getBytes(byte[] bytes, int index) {
        byte[] cached = this.lowerBytes;
        if (cached == null) {
            this.lowerBytes = cached = this.getBytesImpl(true);
        }
        return this.getBytes(bytes, index, cached);
    }

    @Override
    public byte[] getBytes(byte[] bytes) {
        return this.getBytes(bytes, 0);
    }

    private byte[] getBytes(byte[] provided, int startIndex, byte[] cached) {
        int byteCount = this.getBitCount() + 7 >> 3;
        if (provided == null || provided.length < byteCount + startIndex) {
            if (startIndex > 0) {
                byte[] bytes2 = new byte[byteCount + startIndex];
                if (provided != null) {
                    System.arraycopy(provided, 0, bytes2, 0, Math.min(startIndex, provided.length));
                }
                System.arraycopy(cached, 0, bytes2, startIndex, cached.length);
                return bytes2;
            }
            return (byte[])cached.clone();
        }
        System.arraycopy(cached, 0, provided, startIndex, byteCount);
        return provided;
    }

    @Override
    public byte[] getUpperBytes() {
        if (!this.isMultiple()) {
            return this.getBytes();
        }
        byte[] cached = this.upperBytes;
        if (cached == null) {
            this.upperBytes = cached = this.getBytesImpl(false);
        }
        return (byte[])cached.clone();
    }

    @Override
    public byte[] getUpperBytes(byte[] bytes, int index) {
        if (!this.isMultiple()) {
            return this.getBytes(bytes, index);
        }
        byte[] cached = this.upperBytes;
        if (cached == null) {
            this.upperBytes = cached = this.getBytesImpl(false);
        }
        return this.getBytes(bytes, index, cached);
    }

    @Override
    public byte[] getUpperBytes(byte[] bytes) {
        return this.getUpperBytes(bytes, 0);
    }

    protected abstract byte[] getBytesImpl(boolean var1);

    public abstract int getDefaultTextualRadix();

    public abstract int getMaxDigitCount();

    protected static int getMaxDigitCount(int radix, int bitCount, BigInteger maxValue) {
        long key = (long)radix << 32 | (long)bitCount;
        Integer digs = maxDigitMap.get(key);
        if (digs == null) {
            if (maxValue == null) {
                maxValue = AddressDivisionBase.getMaxValue(bitCount);
            }
            digs = AddressDivisionBase.getDigitCount(maxValue, BigInteger.valueOf(radix));
            maxDigitMap.put(key, digs);
        }
        return digs;
    }

    protected static BigInteger getMaxValue(int bitCount) {
        int maxBytes = (bitCount + 7) / 8;
        int topBits = bitCount % 8;
        if (topBits == 0) {
            topBits = 8;
        }
        byte[] max = new byte[maxBytes];
        max[0] = (byte)(~(-1 << topBits));
        int i = 1;
        while (i < max.length) {
            max[i] = -1;
            ++i;
        }
        return new BigInteger(1, max);
    }

    protected static int getDigitCount(BigInteger val, BigInteger radix) {
        if (val.equals(BigInteger.ZERO) || val.equals(BigInteger.ONE)) {
            return 1;
        }
        int result = 1;
        while (!(val = val.divide(radix)).equals(BigInteger.ZERO)) {
            ++result;
        }
        return result;
    }

    static int getMaxDigitCount(int radix, int bitCount, long maxValue) {
        long key = (long)radix << 32 | (long)bitCount;
        Integer digs = maxDigitMap.get(key);
        if (digs == null) {
            digs = AddressDivisionBase.getDigitCount(maxValue, radix);
            maxDigitMap.put(key, digs);
        }
        return digs;
    }

    public static int getDigitCount(long value, int radix) {
        int result = 1;
        if (radix == 16) {
            while ((value >>>= 4) != 0L) {
                ++result;
            }
        } else {
            if (radix == 10) {
                if (value < 10L) {
                    return 1;
                }
                if (value < 100L) {
                    return 2;
                }
                if (value < 1000L) {
                    return 3;
                }
                value /= 1000L;
                result = 3;
            } else if (radix == 8) {
                while ((value >>>= 3) != 0L) {
                    ++result;
                }
                return result;
            }
            while ((value /= (long)radix) != 0L) {
                ++result;
            }
        }
        return result;
    }

    protected static BigInteger getRadixPower(BigInteger radix, int power) {
        long key = (long)radix.intValue() << 32 | (long)power;
        BigInteger result = radixPowerMap.get(key);
        if (result == null) {
            if (power == 1) {
                result = radix;
            } else if ((power & 1) == 0) {
                BigInteger halfPower = AddressDivisionBase.getRadixPower(radix, power >> 1);
                result = halfPower.multiply(halfPower);
            } else {
                BigInteger halfPower = AddressDivisionBase.getRadixPower(radix, power - 1 >> 1);
                result = halfPower.multiply(halfPower).multiply(radix);
            }
            radixPowerMap.put(key, result);
        }
        return result;
    }

    protected abstract int adjustLowerLeadingZeroCount(int var1, int var2);

    protected abstract int adjustUpperLeadingZeroCount(int var1, int var2);

    private static void getSplitChar(int count, char splitDigitSeparator, String characters, String stringPrefix, StringBuilder builder) {
        while (count-- > 0) {
            if (stringPrefix.length() > 0) {
                builder.append(stringPrefix);
            }
            builder.append(characters);
            builder.append(splitDigitSeparator);
        }
        builder.setLength(builder.length() - 1);
    }

    private static void getSplitChar(int count, char splitDigitSeparator, char character, String stringPrefix, StringBuilder builder) {
        int prefLen = stringPrefix.length();
        while (count-- > 0) {
            if (prefLen > 0) {
                builder.append(stringPrefix);
            }
            builder.append(character);
            builder.append(splitDigitSeparator);
        }
        builder.setLength(builder.length() - 1);
    }

    private static void getSplitLeadingZeros(int leadingZeroCount, char splitDigitSeparator, String stringPrefix, StringBuilder builder) {
        AddressDivisionBase.getSplitChar(leadingZeroCount, splitDigitSeparator, '0', stringPrefix, builder);
    }

    protected static void getLeadingZeros(int leadingZeroCount, StringBuilder builder) {
        if (leadingZeroCount > 0) {
            String[] stringArray = zeros;
            if (leadingZeroCount >= stringArray.length) {
                int increment = stringArray.length - 1;
                String incrementStr = stringArray[increment];
                while (leadingZeroCount >= increment) {
                    builder.append(incrementStr);
                    leadingZeroCount -= increment;
                }
                builder.append(stringArray[leadingZeroCount]);
                return;
            }
            builder.append(stringArray[leadingZeroCount]);
        }
    }

    public String toString() {
        return this.getString();
    }

    protected abstract String getDefaultString();

    protected abstract String getDefaultRangeString();

    protected abstract String getDefaultSegmentWildcardString();

    protected abstract String getDefaultRangeSeparatorString();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString() {
        String result = this.cachedString;
        if (result == null) {
            AddressDivisionBase addressDivisionBase = this;
            synchronized (addressDivisionBase) {
                result = this.cachedString;
                if (result == null) {
                    if (!this.isMultiple()) {
                        result = this.getDefaultString();
                    } else if (!this.isFullRange() || (result = this.getDefaultSegmentWildcardString()) == null) {
                        result = this.getDefaultRangeString();
                    }
                    this.cachedString = result;
                }
            }
        }
        return result;
    }

    protected String getWildcardString() {
        return this.getString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getCachedString() {
        String result = this.cachedString;
        if (result == null) {
            AddressDivisionBase addressDivisionBase = this;
            synchronized (addressDivisionBase) {
                result = this.cachedString;
                if (result == null) {
                    this.cachedString = result = this.getDefaultString();
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setDefaultAsFullRangeString() {
        String result;
        if (this.cachedString == null && (result = this.getDefaultSegmentWildcardString()) != null) {
            AddressDivisionBase addressDivisionBase = this;
            synchronized (addressDivisionBase) {
                this.cachedString = result;
            }
        }
    }

    protected void setDefaultAsFullRangeWildcardString() {
        this.setDefaultAsFullRangeString();
    }

    protected abstract int getLowerStringLength(int var1);

    protected abstract int getUpperStringLength(int var1);

    protected abstract void getLowerString(int var1, boolean var2, StringBuilder var3);

    protected abstract void getLowerString(int var1, int var2, boolean var3, StringBuilder var4);

    protected abstract void getUpperString(int var1, boolean var2, StringBuilder var3);

    protected abstract void getUpperStringMasked(int var1, boolean var2, StringBuilder var3);

    protected abstract void getSplitLowerString(int var1, int var2, boolean var3, char var4, boolean var5, String var6, StringBuilder var7);

    protected abstract void getSplitRangeString(String var1, String var2, int var3, boolean var4, char var5, boolean var6, String var7, StringBuilder var8);

    protected abstract int getSplitRangeStringLength(String var1, String var2, int var3, int var4, boolean var5, char var6, boolean var7, String var8);

    protected abstract int getRangeDigitCount(int var1);

    protected void appendUppercase(CharSequence str, int radix, StringBuilder appendable) {
        if (radix > 10) {
            int i = 0;
            while (i < str.length()) {
                char c = str.charAt(i);
                if (c >= 'a' && c <= 'z') {
                    c = (char)(c + -32);
                }
                appendable.append(c);
                ++i;
            }
        } else {
            appendable.append(str);
        }
    }

    private static int getFullRangeString(String wildcard, StringBuilder appendable) {
        if (appendable == null) {
            return wildcard.length();
        }
        appendable.append(wildcard);
        return 0;
    }

    int getPrefixAdjustedRangeString(int segmentIndex, AddressSegmentParams params, StringBuilder appendable) {
        int rangeDigitCount;
        int leadingZeroCount = params.getLeadingZeros(segmentIndex);
        int radix = params.getRadix();
        int lowerLeadingZeroCount = this.adjustLowerLeadingZeroCount(leadingZeroCount, radix);
        int upperLeadingZeroCount = this.adjustUpperLeadingZeroCount(leadingZeroCount, radix);
        AddressDivisionGrouping.StringOptions.Wildcards wildcards = params.getWildcards();
        String rangeSeparator = wildcards.rangeSeparator;
        int n = rangeDigitCount = wildcards.singleWildcard == null ? 0 : this.getRangeDigitCount(radix);
        if (rangeDigitCount == 0 && radix == this.getDefaultTextualRadix() && !this.isFullRange()) {
            String str = this.getString();
            String rangeSep = this.getDefaultRangeSeparatorString();
            String stringPrefix = params.getSegmentStrPrefix();
            int prefLen = stringPrefix.length();
            if (lowerLeadingZeroCount == 0 && upperLeadingZeroCount == 0 && rangeSep.equals(rangeSeparator) && prefLen == 0) {
                if (appendable == null) {
                    return str.length();
                }
                if (params.isUppercase()) {
                    this.appendUppercase(str, radix, appendable);
                } else {
                    appendable.append(str);
                }
                return 0;
            }
            if (appendable == null) {
                int count = str.length() + (rangeSeparator.length() - rangeSep.length()) + lowerLeadingZeroCount + upperLeadingZeroCount;
                if (prefLen > 0) {
                    count += prefLen << 1;
                }
                return count;
            }
            int firstEnd = str.indexOf(rangeSep);
            if (prefLen > 0) {
                appendable.append(stringPrefix);
            }
            if (lowerLeadingZeroCount > 0) {
                AddressDivisionBase.getLeadingZeros(lowerLeadingZeroCount, appendable);
            }
            appendable.append(str.substring(0, firstEnd));
            appendable.append(rangeSeparator);
            if (prefLen > 0) {
                appendable.append(stringPrefix);
            }
            if (upperLeadingZeroCount > 0) {
                AddressDivisionBase.getLeadingZeros(upperLeadingZeroCount, appendable);
            }
            appendable.append(str.substring(firstEnd + rangeSep.length()));
            return 0;
        }
        rangeDigitCount = this.adjustRangeDigits(rangeDigitCount);
        if (leadingZeroCount < 0 && appendable == null) {
            int charLength = this.getMaxDigitCount(radix);
            String stringPrefix = params.getSegmentStrPrefix();
            int prefLen = stringPrefix.length();
            if (rangeDigitCount != 0) {
                int count = charLength;
                if (prefLen > 0) {
                    count += prefLen;
                }
                return count;
            }
            int count = charLength << 1;
            if (prefLen > 0) {
                count += prefLen << 1;
            }
            return count += rangeSeparator.length();
        }
        if (rangeDigitCount != 0) {
            return this.getRangeDigitString(segmentIndex, params, appendable);
        }
        return this.getRangeString(segmentIndex, params, lowerLeadingZeroCount, upperLeadingZeroCount, true, appendable);
    }

    @Override
    public int getLowerStandardString(int segmentIndex, AddressSegmentParams params, StringBuilder appendable) {
        int count = 0;
        String stringPrefix = params.getSegmentStrPrefix();
        int prefLen = stringPrefix.length();
        if (prefLen > 0) {
            if (appendable == null) {
                count += prefLen;
            } else {
                appendable.append(stringPrefix);
            }
        }
        int radix = params.getRadix();
        int leadingZeroCount = params.getLeadingZeros(segmentIndex);
        if ((leadingZeroCount = this.adjustLowerLeadingZeroCount(leadingZeroCount, radix)) != 0) {
            if (appendable == null) {
                if (leadingZeroCount < 0) {
                    return count + this.getMaxDigitCount(radix);
                }
                count += leadingZeroCount;
            } else {
                leadingZeroCount = this.adjustLowerLeadingZeroCount(leadingZeroCount, radix);
                AddressDivisionBase.getLeadingZeros(leadingZeroCount, appendable);
            }
        }
        boolean uppercase = params.isUppercase();
        if (radix == this.getDefaultTextualRadix()) {
            String str = this.getCachedString();
            if (appendable == null) {
                return count + str.length();
            }
            if (uppercase) {
                this.appendUppercase(str, radix, appendable);
            } else {
                appendable.append(str);
            }
        } else {
            if (appendable == null) {
                return count + this.getLowerStringLength(radix);
            }
            this.getLowerString(radix, uppercase, appendable);
        }
        return 0;
    }

    @Override
    public int getStandardString(int segmentIndex, AddressSegmentParams params, StringBuilder appendable) {
        String wildcard;
        if (!this.isMultiple()) {
            boolean splitDigits = params.isSplitDigits();
            if (splitDigits) {
                int radix = params.getRadix();
                int leadingZeroCount = params.getLeadingZeros(segmentIndex);
                leadingZeroCount = this.adjustLowerLeadingZeroCount(leadingZeroCount, radix);
                String stringPrefix = params.getSegmentStrPrefix();
                int prefLen = stringPrefix.length();
                if (appendable == null) {
                    int len = leadingZeroCount != 0 ? (leadingZeroCount < 0 ? this.getMaxDigitCount(radix) : this.getLowerStringLength(radix) + leadingZeroCount) : this.getLowerStringLength(radix);
                    int count = (len << 1) - 1;
                    if (prefLen > 0) {
                        count += len * prefLen;
                    }
                    return count;
                }
                char splitDigitSeparator = params.getSplitDigitSeparator() == null ? (char)'\u0000' : params.getSplitDigitSeparator().charValue();
                boolean reverseSplitDigits = params.isReverseSplitDigits();
                boolean uppercase = params.isUppercase();
                if (reverseSplitDigits) {
                    this.getSplitLowerString(radix, 0, uppercase, splitDigitSeparator, reverseSplitDigits, stringPrefix, appendable);
                    if (leadingZeroCount != 0) {
                        appendable.append(splitDigitSeparator);
                        AddressDivisionBase.getSplitLeadingZeros(leadingZeroCount, splitDigitSeparator, stringPrefix, appendable);
                    }
                } else {
                    if (leadingZeroCount != 0) {
                        AddressDivisionBase.getSplitLeadingZeros(leadingZeroCount, splitDigitSeparator, stringPrefix, appendable);
                        appendable.append(splitDigitSeparator);
                    }
                    this.getSplitLowerString(radix, 0, uppercase, splitDigitSeparator, reverseSplitDigits, stringPrefix, appendable);
                }
                return 0;
            }
            return this.getLowerStandardString(segmentIndex, params, appendable);
        }
        if (this.isFullRange() && (wildcard = params.getWildcards().wildcard) != null) {
            boolean splitDigits;
            if (wildcard.equals(this.getDefaultSegmentWildcardString())) {
                this.setDefaultAsFullRangeWildcardString();
            }
            if (splitDigits = params.isSplitDigits()) {
                int radix = params.getRadix();
                if (appendable == null) {
                    int len = this.getMaxDigitCount(radix);
                    int count = len * (wildcard.length() + 1) - 1;
                    return count;
                }
                char splitDigitSeparator = params.getSplitDigitSeparator() == null ? (char)'\u0000' : params.getSplitDigitSeparator().charValue();
                AddressDivisionBase.getSplitChar(this.getMaxDigitCount(radix), splitDigitSeparator, wildcard, "", appendable);
                return 0;
            }
            return AddressDivisionBase.getFullRangeString(wildcard, appendable);
        }
        return this.getRangeString(segmentIndex, params, appendable);
    }

    protected int getRangeString(int segmentIndex, AddressSegmentParams params, StringBuilder appendable) {
        boolean splitDigits = params.isSplitDigits();
        int radix = params.getRadix();
        int leadingZeroCount = params.getLeadingZeros(segmentIndex);
        AddressDivisionGrouping.StringOptions.Wildcards wildcards = params.getWildcards();
        String rangeSeparator = wildcards.rangeSeparator;
        int rangeDigitCount = wildcards.singleWildcard == null ? 0 : this.getRangeDigitCount(radix);
        int lowerLeadingZeroCount = this.adjustLowerLeadingZeroCount(leadingZeroCount, radix);
        int upperLeadingZeroCount = this.adjustUpperLeadingZeroCount(leadingZeroCount, radix);
        if (rangeDigitCount == 0 && radix == this.getDefaultTextualRadix() && !splitDigits && !this.isFullRange()) {
            String str = this.getWildcardString();
            String rangeSep = this.getDefaultRangeSeparatorString();
            String stringPrefix = params.getSegmentStrPrefix();
            int prefLen = stringPrefix.length();
            if (lowerLeadingZeroCount == 0 && upperLeadingZeroCount == 0 && prefLen == 0 && rangeSeparator.equals(rangeSep)) {
                if (appendable == null) {
                    return str.length();
                }
                appendable.append(str);
                return 0;
            }
            if (appendable == null) {
                int count = str.length() + (rangeSeparator.length() - rangeSep.length()) + lowerLeadingZeroCount + upperLeadingZeroCount;
                if (prefLen > 0) {
                    count += prefLen << 1;
                }
                return count;
            }
            int firstEnd = str.indexOf(rangeSep);
            if (prefLen > 0) {
                appendable.append(stringPrefix);
            }
            if (lowerLeadingZeroCount > 0) {
                AddressDivisionBase.getLeadingZeros(lowerLeadingZeroCount, appendable);
            }
            appendable.append(str.substring(0, firstEnd));
            appendable.append(rangeSeparator);
            if (prefLen > 0) {
                appendable.append(stringPrefix);
            }
            if (upperLeadingZeroCount > 0) {
                AddressDivisionBase.getLeadingZeros(upperLeadingZeroCount, appendable);
            }
            appendable.append(str.substring(firstEnd + rangeSep.length()));
            return 0;
        }
        if (!splitDigits && leadingZeroCount < 0 && appendable == null) {
            String stringPrefix = params.getSegmentStrPrefix();
            int prefLen = stringPrefix.length();
            int charLength = this.getMaxDigitCount(radix);
            if (rangeDigitCount != 0) {
                int count = charLength;
                if (prefLen > 0) {
                    count += prefLen;
                }
                return count;
            }
            int count = charLength << 1;
            if (prefLen > 0) {
                count += prefLen << 1;
            }
            return count += rangeSeparator.length();
        }
        if ((rangeDigitCount = this.adjustRangeDigits(rangeDigitCount)) != 0) {
            if (splitDigits) {
                return this.getSplitRangeDigitString(segmentIndex, params, appendable);
            }
            return this.getRangeDigitString(segmentIndex, params, appendable);
        }
        if (splitDigits) {
            return this.getSplitRangeString(segmentIndex, params, appendable);
        }
        return this.getRangeString(segmentIndex, params, lowerLeadingZeroCount, upperLeadingZeroCount, false, appendable);
    }

    protected int getSplitRangeDigitString(int segmentIndex, AddressSegmentParams params, StringBuilder appendable) {
        int radix = params.getRadix();
        int leadingZerosCount = params.getLeadingZeros(segmentIndex);
        leadingZerosCount = this.adjustLowerLeadingZeroCount(leadingZerosCount, radix);
        String stringPrefix = params.getSegmentStrPrefix();
        if (appendable == null) {
            int len = this.getLowerStringLength(radix) + leadingZerosCount;
            int count = (len << 1) - 1;
            int prefLen = stringPrefix.length();
            if (prefLen > 0) {
                count += len * prefLen;
            }
            return count;
        }
        AddressDivisionGrouping.StringOptions.Wildcards wildcards = params.getWildcards();
        int rangeDigits = this.adjustRangeDigits(this.getRangeDigitCount(radix));
        char splitDigitSeparator = params.getSplitDigitSeparator() == null ? (char)'\u0000' : params.getSplitDigitSeparator().charValue();
        boolean reverseSplitDigits = params.isReverseSplitDigits();
        boolean uppercase = params.isUppercase();
        if (reverseSplitDigits) {
            AddressDivisionBase.getSplitChar(rangeDigits, splitDigitSeparator, wildcards.singleWildcard, stringPrefix, appendable);
            appendable.append(splitDigitSeparator);
            this.getSplitLowerString(radix, rangeDigits, uppercase, splitDigitSeparator, reverseSplitDigits, stringPrefix, appendable);
            if (leadingZerosCount > 0) {
                appendable.append(splitDigitSeparator);
                AddressDivisionBase.getSplitLeadingZeros(leadingZerosCount, splitDigitSeparator, stringPrefix, appendable);
            }
        } else {
            if (leadingZerosCount != 0) {
                AddressDivisionBase.getSplitLeadingZeros(leadingZerosCount, splitDigitSeparator, stringPrefix, appendable);
                appendable.append(splitDigitSeparator);
            }
            this.getSplitLowerString(radix, rangeDigits, uppercase, splitDigitSeparator, reverseSplitDigits, stringPrefix, appendable);
            appendable.append(splitDigitSeparator);
            AddressDivisionBase.getSplitChar(rangeDigits, splitDigitSeparator, wildcards.singleWildcard, stringPrefix, appendable);
        }
        return 0;
    }

    protected int getRangeDigitString(int segmentIndex, AddressSegmentParams params, StringBuilder appendable) {
        int radix = params.getRadix();
        int leadingZerosCount = params.getLeadingZeros(segmentIndex);
        leadingZerosCount = this.adjustLowerLeadingZeroCount(leadingZerosCount, radix);
        String stringPrefix = params.getSegmentStrPrefix();
        int prefLen = stringPrefix.length();
        AddressDivisionGrouping.StringOptions.Wildcards wildcards = params.getWildcards();
        int rangeDigits = this.adjustRangeDigits(this.getRangeDigitCount(radix));
        if (appendable == null) {
            return this.getLowerStringLength(radix) + leadingZerosCount + prefLen;
        }
        if (prefLen > 0) {
            appendable.append(stringPrefix);
        }
        if (leadingZerosCount > 0) {
            AddressDivisionBase.getLeadingZeros(leadingZerosCount, appendable);
        }
        boolean uppercase = params.isUppercase();
        this.getLowerString(radix, rangeDigits, uppercase, appendable);
        int i = 0;
        while (i < rangeDigits) {
            appendable.append(wildcards.singleWildcard);
            ++i;
        }
        return 0;
    }

    int adjustRangeDigits(int rangeDigits) {
        if (!(rangeDigits == 0 || this.includesZero() && rangeDigits != 1)) {
            return rangeDigits;
        }
        return 0;
    }

    protected int getRangeString(int segmentIndex, AddressSegmentParams params, int lowerLeadingZerosCount, int upperLeadingZerosCount, boolean maskUpper, StringBuilder appendable) {
        String stringPrefix = params.getSegmentStrPrefix();
        int radix = params.getRadix();
        String rangeSeparator = params.getWildcards().rangeSeparator;
        boolean uppercase = params.isUppercase();
        return this.getRangeString(rangeSeparator, lowerLeadingZerosCount, upperLeadingZerosCount, stringPrefix, radix, uppercase, maskUpper, appendable);
    }

    protected int getRangeString(String rangeSeparator, int lowerLeadingZerosCount, int upperLeadingZerosCount, String stringPrefix, int radix, boolean uppercase, boolean maskUpper, StringBuilder appendable) {
        boolean hasStringPrefix;
        int prefLen = stringPrefix.length();
        boolean bl = hasStringPrefix = prefLen > 0;
        if (appendable == null) {
            int count = lowerLeadingZerosCount + upperLeadingZerosCount + this.getLowerStringLength(radix) + this.getUpperStringLength(radix) + rangeSeparator.length();
            if (hasStringPrefix) {
                count += prefLen << 1;
            }
            return count;
        }
        if (hasStringPrefix) {
            appendable.append(stringPrefix);
        }
        if (lowerLeadingZerosCount > 0) {
            AddressDivisionBase.getLeadingZeros(lowerLeadingZerosCount, appendable);
        }
        this.getLowerString(radix, uppercase, appendable);
        appendable.append(rangeSeparator);
        if (hasStringPrefix) {
            appendable.append(stringPrefix);
        }
        if (upperLeadingZerosCount > 0) {
            AddressDivisionBase.getLeadingZeros(upperLeadingZerosCount, appendable);
        }
        if (maskUpper) {
            this.getUpperStringMasked(radix, uppercase, appendable);
        } else {
            this.getUpperString(radix, uppercase, appendable);
        }
        return 0;
    }

    protected int getSplitRangeString(int segmentIndex, AddressSegmentParams params, StringBuilder appendable) {
        boolean hasLeadingZeros;
        String stringPrefix = params.getSegmentStrPrefix();
        int radix = params.getRadix();
        int leadingZeroCount = params.getLeadingZeros(segmentIndex);
        leadingZeroCount = this.adjustUpperLeadingZeroCount(leadingZeroCount, radix);
        AddressDivisionGrouping.StringOptions.Wildcards wildcards = params.getWildcards();
        boolean uppercase = params.isUppercase();
        char splitDigitSeparator = params.getSplitDigitSeparator() == null ? (char)'\u0000' : params.getSplitDigitSeparator().charValue();
        boolean reverseSplitDigits = params.isReverseSplitDigits();
        String rangeSeparator = wildcards.rangeSeparator;
        if (appendable == null) {
            return this.getSplitRangeStringLength(rangeSeparator, wildcards.wildcard, leadingZeroCount, radix, uppercase, splitDigitSeparator, reverseSplitDigits, stringPrefix);
        }
        boolean bl = hasLeadingZeros = leadingZeroCount != 0;
        if (hasLeadingZeros && !reverseSplitDigits) {
            AddressDivisionBase.getSplitLeadingZeros(leadingZeroCount, splitDigitSeparator, stringPrefix, appendable);
            appendable.append(splitDigitSeparator);
            hasLeadingZeros = false;
        }
        this.getSplitRangeString(rangeSeparator, wildcards.wildcard, radix, uppercase, splitDigitSeparator, reverseSplitDigits, stringPrefix, appendable);
        if (hasLeadingZeros) {
            appendable.append(splitDigitSeparator);
            AddressDivisionBase.getSplitLeadingZeros(leadingZeroCount, splitDigitSeparator, stringPrefix, appendable);
        }
        return 0;
    }
}

