/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr;

import inet.ipaddr.AddressComparator;
import inet.ipaddr.AddressNetwork;
import inet.ipaddr.AddressSection;
import inet.ipaddr.AddressSegment;
import inet.ipaddr.AddressSegmentSeries;
import inet.ipaddr.HostIdentifierException;
import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressNetwork;
import inet.ipaddr.IPAddressSegment;
import inet.ipaddr.IPAddressSegmentSeries;
import inet.ipaddr.IncompatibleAddressException;
import inet.ipaddr.InconsistentPrefixException;
import inet.ipaddr.NetworkMismatchException;
import inet.ipaddr.PrefixLenException;
import inet.ipaddr.SizeMismatchException;
import inet.ipaddr.format.AddressDivisionGrouping;
import inet.ipaddr.format.AddressItem;
import inet.ipaddr.format.IPAddressBitsDivision;
import inet.ipaddr.format.IPAddressDivision;
import inet.ipaddr.format.IPAddressDivisionGrouping;
import inet.ipaddr.format.IPAddressStringDivisionSeries;
import inet.ipaddr.format.util.IPAddressPartConfiguredString;
import inet.ipaddr.format.util.IPAddressPartStringCollection;
import inet.ipaddr.format.util.sql.IPAddressSQLTranslator;
import inet.ipaddr.format.util.sql.MySQLTranslator;
import inet.ipaddr.format.util.sql.SQLStringMatcher;
import inet.ipaddr.format.validate.ParsedAddressGrouping;
import inet.ipaddr.ipv6.IPv6AddressSegment;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigInteger;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.IntUnaryOperator;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;

public abstract class IPAddressSection
extends IPAddressDivisionGrouping
implements IPAddressSegmentSeries,
AddressSection {
    private static final long serialVersionUID = 4L;
    private static final IPAddressStringDivisionSeries[] EMPTY_PARTS = new IPAddressStringDivisionSeries[0];
    private transient PrefixCache prefixCache;
    private transient BigInteger cachedIPAddressCount;

    protected IPAddressSection(IPAddressSegment[] segments, boolean cloneSegments, boolean checkSegs) {
        super(cloneSegments ? (IPAddressDivision[])segments.clone() : segments, checkSegs);
        if (checkSegs) {
            AddressNetwork network = this.getNetwork();
            Integer previousSegmentPrefix = null;
            int i = 0;
            while (i < segments.length) {
                IPAddressSegment segment = segments[i];
                if (!network.equals(segment.getNetwork())) {
                    throw new NetworkMismatchException(segment);
                }
                Integer segPrefix = segment.getSegmentPrefixLength();
                if (previousSegmentPrefix == null) {
                    if (segPrefix != null) {
                        this.cachedPrefixLength = IPAddressSection.cacheBits(this.getNetworkPrefixLength(i, segPrefix));
                    }
                } else if (segPrefix == null || segPrefix != 0) {
                    throw new InconsistentPrefixException((AddressItem)segments[i - 1], (AddressItem)segment, segPrefix);
                }
                previousSegmentPrefix = segPrefix;
                ++i;
            }
            if (previousSegmentPrefix == null) {
                this.cachedPrefixLength = NO_PREFIX_LENGTH;
            }
        }
    }

    @Override
    protected Integer calculatePrefix() {
        int count = this.getSegmentCount();
        int i = 0;
        while (i < count) {
            IPAddressSegment div = this.getSegment(i);
            Integer prefix = div.getSegmentPrefixLength();
            if (prefix != null) {
                return this.getNetworkPrefixLength(i, prefix);
            }
            ++i;
        }
        return null;
    }

    protected abstract int getNetworkPrefixLength(int var1, int var2);

    protected void checkSegments(IPv6AddressSegment[] segs) {
        AddressNetwork network = this.getNetwork();
        IPv6AddressSegment[] iPv6AddressSegmentArray = segs;
        int n = segs.length;
        int n2 = 0;
        while (n2 < n) {
            IPv6AddressSegment seg = iPv6AddressSegmentArray[n2];
            if (!network.equals(((IPAddressSegment)seg).getNetwork())) {
                throw new NetworkMismatchException(seg);
            }
            ++n2;
        }
    }

    protected static String getMessage(String key) {
        return HostIdentifierException.getMessage(key);
    }

    protected void initCachedValues(Integer prefixLen, boolean network, Integer cachedNetworkPrefix, Integer cachedMinPrefix, Integer cachedEquivalentPrefix, BigInteger cachedCount, IPAddressDivisionGrouping.RangeList zeroSegments, IPAddressDivisionGrouping.RangeList zeroRanges) {
        if (this.prefixCache == null) {
            this.prefixCache = new PrefixCache();
        }
        if (network) {
            this.setNetworkMaskPrefix(prefixLen);
        } else {
            this.setHostMaskPrefix(prefixLen);
        }
        super.initCachedValues(cachedNetworkPrefix, cachedCount);
        this.prefixCache.cachedMinPrefix = cachedMinPrefix;
        this.prefixCache.cachedEquivalentPrefix = cachedEquivalentPrefix;
    }

    protected static IPAddressDivisionGrouping.RangeList getNoZerosRange() {
        return IPAddressDivisionGrouping.getNoZerosRange();
    }

    protected static IPAddressDivisionGrouping.RangeList getSingleRange(int index, int len) {
        return IPAddressDivisionGrouping.getSingleRange(index, len);
    }

    @Override
    public int getBitCount() {
        return this.getSegmentCount() * this.getBitsPerSegment();
    }

    @Override
    public int getByteCount() {
        return this.getSegmentCount() * this.getBytesPerSegment();
    }

    public static int bitsPerSegment(IPAddress.IPVersion version) {
        return IPAddressSegment.getBitCount(version);
    }

    public static int bytesPerSegment(IPAddress.IPVersion version) {
        return IPAddressSegment.getBitCount(version);
    }

    @Override
    public BigInteger getNonZeroHostCount() {
        if (this.isPrefixed() && this.getNetworkPrefixLength() < this.getBitCount()) {
            BigInteger cached = this.cachedIPAddressCount;
            if (cached == null) {
                this.cachedIPAddressCount = cached = this.getCountImpl(true);
            }
            return cached;
        }
        return this.getCount();
    }

    protected abstract BigInteger getCountImpl(boolean var1);

    @Override
    public BigInteger getCountImpl() {
        return this.getCountImpl(false);
    }

    public boolean isIPv4() {
        return false;
    }

    public boolean isIPv6() {
        return false;
    }

    protected static boolean isPrefixSubnet(IPAddressSegment[] sectionSegments, Integer networkPrefixLength, IPAddressNetwork<?, ?, ?, ?, ?> network, boolean fullRangeOnly) {
        int segmentCount = sectionSegments.length;
        if (segmentCount == 0) {
            return false;
        }
        IPAddressSegment seg = sectionSegments[0];
        return ParsedAddressGrouping.isPrefixSubnet(segmentIndex -> sectionSegments[segmentIndex].getLowerSegmentValue(), segmentIndex -> sectionSegments[segmentIndex].getUpperSegmentValue(), segmentCount, seg.getByteCount(), seg.getBitCount(), seg.getMaxSegmentValue(), networkPrefixLength, network.getPrefixConfiguration(), fullRangeOnly);
    }

    protected boolean isNetworkSection(int networkPrefixLength, boolean withPrefixLength) {
        int segmentCount = this.getSegmentCount();
        if (segmentCount == 0) {
            return true;
        }
        int bitsPerSegment = this.getBitsPerSegment();
        int prefixedSegmentIndex = IPAddressSection.getNetworkSegmentIndex(networkPrefixLength, this.getBytesPerSegment(), bitsPerSegment);
        if (prefixedSegmentIndex + 1 < segmentCount) {
            return false;
        }
        int segPrefLength = IPAddressSection.getPrefixedSegmentPrefixLength(bitsPerSegment, networkPrefixLength, prefixedSegmentIndex);
        return !this.getSegment(segmentCount - 1).isNetworkChangedByPrefix(segPrefLength, withPrefixLength);
    }

    protected boolean isHostSection(int networkPrefixLength) {
        int segmentCount = this.getSegmentCount();
        if (segmentCount == 0) {
            return true;
        }
        if (networkPrefixLength >= this.getBitsPerSegment()) {
            return false;
        }
        return !this.getSegment(0).isHostChangedByPrefix(networkPrefixLength);
    }

    protected static int getNetworkSegmentIndex(int networkPrefixLength, int bytesPerSegment, int bitsPerSegment) {
        return ParsedAddressGrouping.getNetworkSegmentIndex(networkPrefixLength, bytesPerSegment, bitsPerSegment);
    }

    protected static int getHostSegmentIndex(int networkPrefixLength, int bytesPerSegment, int bitsPerSegment) {
        return ParsedAddressGrouping.getHostSegmentIndex(networkPrefixLength, bytesPerSegment, bitsPerSegment);
    }

    private Integer checkForPrefixMask(boolean network) {
        int back;
        int front;
        if (network) {
            front = this.getSegment(0).getMaxSegmentValue();
            back = 0;
        } else {
            back = this.getSegment(0).getMaxSegmentValue();
            front = 0;
        }
        int prefixLen = 0;
        int count = this.getSegmentCount();
        int i = 0;
        while (i < count) {
            IPAddressSegment seg = this.getSegment(i);
            int value = seg.getLowerSegmentValue();
            if (value != front) {
                Integer segmentPrefixLen = seg.getBlockMaskPrefixLength(network);
                if (segmentPrefixLen == null) {
                    return null;
                }
                prefixLen += segmentPrefixLen.intValue();
                ++i;
                while (i < count) {
                    value = this.getSegment(i).getLowerSegmentValue();
                    if (value != back) {
                        return null;
                    }
                    ++i;
                }
            } else {
                prefixLen += seg.getBitCount();
            }
            ++i;
        }
        return IPAddressSection.cacheBits(prefixLen);
    }

    public Integer getBlockMaskPrefixLength(boolean network) {
        Integer prefixLen;
        if (network) {
            if (this.hasNoPrefixCache() || (prefixLen = this.prefixCache.networkMaskPrefixLen) == null) {
                prefixLen = this.setNetworkMaskPrefix(this.checkForPrefixMask(network));
            }
        } else if (this.hasNoPrefixCache() || (prefixLen = this.prefixCache.hostMaskPrefixLen) == null) {
            prefixLen = this.setHostMaskPrefix(this.checkForPrefixMask(network));
        }
        if (prefixLen < 0) {
            return null;
        }
        return prefixLen;
    }

    private Integer setHostMaskPrefix(Integer prefixLen) {
        if (prefixLen == null) {
            Integer n = NO_PREFIX_LENGTH;
            this.prefixCache.hostMaskPrefixLen = n;
            prefixLen = n;
        } else {
            this.prefixCache.hostMaskPrefixLen = prefixLen;
            this.prefixCache.networkMaskPrefixLen = IPAddressSection.NO_PREFIX_LENGTH;
        }
        return prefixLen;
    }

    private Integer setNetworkMaskPrefix(Integer prefixLen) {
        if (prefixLen == null) {
            Integer n = NO_PREFIX_LENGTH;
            this.prefixCache.networkMaskPrefixLen = n;
            prefixLen = n;
        } else {
            this.prefixCache.networkMaskPrefixLen = prefixLen;
            this.prefixCache.hostMaskPrefixLen = IPAddressSection.NO_PREFIX_LENGTH;
        }
        return prefixLen;
    }

    protected static <T extends IPAddress, R extends IPAddressSection, S extends IPAddressSegment> R getNetworkSection(R original, int networkPrefixLength, boolean withPrefixLength, IPAddressNetwork.IPAddressCreator<T, R, ?, S, ?> creator, BiFunction<Integer, Integer, S> segProducer) {
        if (networkPrefixLength < 0 || networkPrefixLength > original.getBitCount()) {
            throw new PrefixLenException(original, networkPrefixLength);
        }
        if (original.isNetworkSection(networkPrefixLength, withPrefixLength)) {
            return original;
        }
        int bitsPerSegment = original.getBitsPerSegment();
        int networkSegmentCount = original.getNetworkSegmentCount(networkPrefixLength);
        IPAddressSegment[] result = (IPAddressSegment[])creator.createSegmentArray(networkSegmentCount);
        int i = 0;
        while (i < networkSegmentCount) {
            Integer prefix = IPAddressSection.getSegmentPrefixLength(bitsPerSegment, IPAddressSection.cacheBits(networkPrefixLength), i);
            result[i] = (IPAddressSegment)segProducer.apply(i, prefix);
            ++i;
        }
        return (R)creator.createSectionInternal(result);
    }

    protected int getNetworkSegmentCount(int networkPrefixLength) {
        return IPAddressSection.getNetworkSegmentIndex(networkPrefixLength, this.getBytesPerSegment(), this.getBitsPerSegment()) + 1;
    }

    protected static <T extends IPAddress, R extends IPAddressSection, S extends IPAddressSegment> R getHostSection(R original, int networkPrefixLength, int hostSegmentCount, IPAddressNetwork.IPAddressCreator<T, R, ?, S, ?> creator, BiFunction<Integer, Integer, S> segProducer) {
        if (networkPrefixLength < 0 || networkPrefixLength > original.getBitCount()) {
            throw new PrefixLenException(original, networkPrefixLength);
        }
        if (original.isHostSection(networkPrefixLength)) {
            return original;
        }
        int segmentCount = original.getSegmentCount();
        IPAddressSegment[] result = (IPAddressSegment[])creator.createSegmentArray(hostSegmentCount);
        if (hostSegmentCount > 0) {
            int bitsPerSegment = original.getBitsPerSegment();
            int i = hostSegmentCount - 1;
            int j = segmentCount - 1;
            while (i >= 0) {
                Integer prefix = IPAddressSection.getSegmentPrefixLength(bitsPerSegment, networkPrefixLength, j);
                result[i] = (IPAddressSegment)segProducer.apply(j, prefix);
                --i;
                --j;
            }
        }
        return (R)creator.createSectionInternal(result);
    }

    protected int getHostSegmentCount(int networkPrefixLength) {
        return this.getSegmentCount() - IPAddressSection.getHostSegmentIndex(networkPrefixLength, this.getBytesPerSegment(), this.getBitsPerSegment());
    }

    protected static Integer cacheBits(int i) {
        return AddressDivisionGrouping.cacheBits(i);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static <R extends IPAddressSection, S extends IPAddressSegment> R setPrefixLength(R original, IPAddressNetwork.IPAddressCreator<?, R, ?, S, ?> creator, int networkPrefixLength, boolean withZeros, boolean noShrink, SegFunction<R, S> segProducer) throws IncompatibleAddressException {
        int maskBits;
        Integer existingPrefixLength = original.getNetworkPrefixLength();
        if (existingPrefixLength != null) {
            if (networkPrefixLength == existingPrefixLength) {
                return original;
            }
            if (noShrink && networkPrefixLength > existingPrefixLength) {
                original.checkSubnet(networkPrefixLength);
                return original;
            }
        }
        original.checkSubnet(networkPrefixLength);
        AddressNetwork network = creator.getNetwork();
        if (network.getPrefixConfiguration().allPrefixedAddressesAreSubnets()) {
            if (existingPrefixLength != null) {
                if (networkPrefixLength > existingPrefixLength) {
                    maskBits = withZeros ? existingPrefixLength : networkPrefixLength;
                } else {
                    if (networkPrefixLength >= existingPrefixLength) return original;
                    maskBits = networkPrefixLength;
                }
            } else {
                maskBits = networkPrefixLength;
            }
        } else {
            if (existingPrefixLength != null) {
                if (networkPrefixLength == existingPrefixLength) {
                    return original;
                }
                if (withZeros) {
                    Object rightMask;
                    Object leftMask;
                    if (networkPrefixLength > existingPrefixLength) {
                        leftMask = ((IPAddressNetwork)network).getNetworkMaskSection(existingPrefixLength);
                        rightMask = ((IPAddressNetwork)network).getHostMaskSection(networkPrefixLength);
                        return IPAddressSection.getSubnetSegments(original, IPAddressSection.cacheBits(networkPrefixLength), creator, true, i -> (IPAddressSegment)segProducer.apply(original, i), i -> {
                            int val1 = ((IPAddressSegment)segProducer.apply(leftMask, i)).getLowerSegmentValue();
                            int val2 = ((IPAddressSegment)segProducer.apply(rightMask, i)).getLowerSegmentValue();
                            return val1 | val2;
                        }, false);
                    } else {
                        leftMask = ((IPAddressNetwork)network).getNetworkMaskSection(networkPrefixLength);
                        rightMask = ((IPAddressNetwork)network).getHostMaskSection(existingPrefixLength);
                    }
                    return IPAddressSection.getSubnetSegments(original, IPAddressSection.cacheBits(networkPrefixLength), creator, true, i -> (IPAddressSegment)segProducer.apply(original, i), i -> {
                        int val1 = ((IPAddressSegment)segProducer.apply(leftMask, i)).getLowerSegmentValue();
                        int val2 = ((IPAddressSegment)segProducer.apply(rightMask, i)).getLowerSegmentValue();
                        return val1 | val2;
                    }, false);
                }
            }
            maskBits = original.getBitCount();
        }
        Object mask = ((IPAddressNetwork)network).getNetworkMaskSection(maskBits);
        return IPAddressSection.getSubnetSegments(original, IPAddressSection.cacheBits(networkPrefixLength), creator, true, i -> (IPAddressSegment)segProducer.apply(original, i), i -> ((IPAddressSegment)segProducer.apply(mask, i)).getLowerSegmentValue(), false);
    }

    protected static <R extends IPAddressSection, S extends IPAddressSegment> R getSubnetSegments(R original, Integer networkPrefixLength, IPAddressNetwork.IPAddressCreator<?, R, ?, S, ?> creator, boolean verifyMask, IntFunction<S> segProducer, IntUnaryOperator segmentMaskProducer, boolean singleOnly) {
        if (networkPrefixLength != null && (networkPrefixLength < 0 || networkPrefixLength > original.getBitCount())) {
            throw new PrefixLenException(original, networkPrefixLength);
        }
        int bitsPerSegment = original.getBitsPerSegment();
        int count = original.getSegmentCount();
        int i = 0;
        while (i < count) {
            int maskValue;
            Integer segmentPrefixLength = IPAddressSection.getSegmentPrefixLength(bitsPerSegment, networkPrefixLength, i);
            IPAddressSegment seg = (IPAddressSegment)segProducer.apply(i);
            if (seg.isChangedByMask(maskValue = segmentMaskProducer.applyAsInt(i), segmentPrefixLength)) {
                boolean isAllSubnets;
                if (verifyMask && !seg.isMaskCompatibleWithRange(maskValue, segmentPrefixLength)) {
                    throw new IncompatibleAddressException(seg, "ipaddress.error.maskMismatch");
                }
                Object[] newSegments = (IPAddressSegment[])creator.createSegmentArray(original.getSegmentCount());
                original.getSegments(0, i, (AddressSegment[])newSegments, 0);
                newSegments[i] = (IPAddressSegment)creator.createSegment(seg.getLowerSegmentValue() & maskValue, seg.getUpperSegmentValue() & maskValue, segmentPrefixLength);
                boolean bl = isAllSubnets = original.getNetwork().getPrefixConfiguration().allPrefixedAddressesAreSubnets() && !singleOnly;
                if (isAllSubnets && segmentPrefixLength != null) {
                    if (++i < count) {
                        IPAddressSegment zeroSeg = (IPAddressSegment)creator.createSegment(0, 0);
                        Arrays.fill(newSegments, i, count, zeroSeg);
                    }
                } else {
                    ++i;
                    while (i < count) {
                        segmentPrefixLength = IPAddressSection.getSegmentPrefixLength(bitsPerSegment, networkPrefixLength, i);
                        seg = (IPAddressSegment)segProducer.apply(i);
                        if (seg.isChangedByMask(maskValue = segmentMaskProducer.applyAsInt(i), segmentPrefixLength)) {
                            if (verifyMask && !seg.isMaskCompatibleWithRange(maskValue, segmentPrefixLength)) {
                                throw new IncompatibleAddressException(seg, "ipaddress.error.maskMismatch");
                            }
                            newSegments[i] = (IPAddressSegment)creator.createSegment(seg.getLowerSegmentValue() & maskValue, seg.getUpperSegmentValue() & maskValue, segmentPrefixLength);
                        } else {
                            newSegments[i] = seg;
                        }
                        if (isAllSubnets && segmentPrefixLength != null) {
                            if (++i >= count) break;
                            IPAddressSegment zeroSeg = (IPAddressSegment)creator.createSegment(0, 0);
                            Arrays.fill(newSegments, i, count, zeroSeg);
                            break;
                        }
                        ++i;
                    }
                }
                return (R)creator.createPrefixedSectionInternal((IPAddressSegment[])newSegments, networkPrefixLength, singleOnly);
            }
            ++i;
        }
        return original;
    }

    protected static <R extends IPAddressSection, S extends IPAddressSegment> R getOredSegments(R original, Integer networkPrefixLength, IPAddressNetwork.IPAddressCreator<?, R, ?, S, ?> creator, boolean verifyMask, IntFunction<S> segProducer, IntUnaryOperator segmentMaskProducer) {
        if (networkPrefixLength != null && (networkPrefixLength < 0 || networkPrefixLength > original.getBitCount())) {
            throw new PrefixLenException(original, networkPrefixLength);
        }
        int bitsPerSegment = original.getBitsPerSegment();
        int count = original.getSegmentCount();
        int i = 0;
        while (i < count) {
            int maskValue;
            Integer segmentPrefixLength = IPAddressSection.getSegmentPrefixLength(bitsPerSegment, networkPrefixLength, i);
            IPAddressSegment seg = (IPAddressSegment)segProducer.apply(i);
            if (seg.isChangedByOr(maskValue = segmentMaskProducer.applyAsInt(i), segmentPrefixLength)) {
                if (verifyMask && !seg.isBitwiseOrCompatibleWithRange(maskValue, segmentPrefixLength)) {
                    throw new IncompatibleAddressException(seg, "ipaddress.error.maskMismatch");
                }
                Object[] newSegments = (IPAddressSegment[])creator.createSegmentArray(original.getSegmentCount());
                original.getSegments(0, i, (AddressSegment[])newSegments, 0);
                newSegments[i] = (IPAddressSegment)creator.createSegment(seg.getLowerSegmentValue() | maskValue, seg.getUpperSegmentValue() | maskValue, segmentPrefixLength);
                boolean isAllSubnets = original.getNetwork().getPrefixConfiguration().allPrefixedAddressesAreSubnets();
                if (isAllSubnets && segmentPrefixLength != null) {
                    if (++i < count) {
                        IPAddressSegment zeroSeg = (IPAddressSegment)creator.createSegment(0, 0);
                        Arrays.fill(newSegments, i, count, zeroSeg);
                    }
                } else {
                    ++i;
                    while (i < count) {
                        segmentPrefixLength = IPAddressSection.getSegmentPrefixLength(bitsPerSegment, networkPrefixLength, i);
                        seg = (IPAddressSegment)segProducer.apply(i);
                        if (seg.isChangedByOr(maskValue = segmentMaskProducer.applyAsInt(i), segmentPrefixLength)) {
                            if (verifyMask && !seg.isBitwiseOrCompatibleWithRange(maskValue, segmentPrefixLength)) {
                                throw new IncompatibleAddressException(seg, "ipaddress.error.maskMismatch");
                            }
                            newSegments[i] = (IPAddressSegment)creator.createSegment(seg.getLowerSegmentValue() | maskValue, seg.getUpperSegmentValue() | maskValue, segmentPrefixLength);
                        } else {
                            newSegments[i] = seg;
                        }
                        if (isAllSubnets && segmentPrefixLength != null) {
                            if (++i >= count) break;
                            IPAddressSegment zeroSeg = (IPAddressSegment)creator.createSegment(0, 0);
                            Arrays.fill(newSegments, i, count, zeroSeg);
                            break;
                        }
                        ++i;
                    }
                }
                return (R)creator.createPrefixedSectionInternal((IPAddressSegment[])newSegments, networkPrefixLength);
            }
            ++i;
        }
        return original;
    }

    protected static Integer getSegmentPrefixLength(int bitsPerSegment, Integer prefixLength, int segmentIndex) {
        return ParsedAddressGrouping.getSegmentPrefixLength(bitsPerSegment, prefixLength, segmentIndex);
    }

    protected static Integer getSegmentPrefixLength(int bitsPerSegment, int segmentPrefixedBits) {
        return ParsedAddressGrouping.getSegmentPrefixLength(bitsPerSegment, segmentPrefixedBits);
    }

    protected static <R extends IPAddressSection, S extends IPAddressSegment> R getLowestOrHighestSection(R section, IPAddressNetwork.IPAddressCreator<?, R, ?, S, ?> creator, Supplier<Iterator<S[]>> nonZeroHostIteratorSupplier, IntFunction<S> segProducer, boolean lowest, boolean excludeZeroHost) {
        boolean create = true;
        IPAddressSection result = null;
        IPAddressSegment[] segs = null;
        if (lowest && excludeZeroHost && section.includesZeroHost()) {
            Iterator<S[]> it = nonZeroHostIteratorSupplier.get();
            if (!it.hasNext()) {
                create = false;
            } else {
                segs = (IPAddressSegment[])it.next();
            }
        } else {
            segs = (IPAddressSegment[])IPAddressSection.createSingle(section, creator, segProducer);
        }
        if (create) {
            Integer prefLength;
            result = section.getNetwork().getPrefixConfiguration().allPrefixedAddressesAreSubnets() || (prefLength = section.getNetworkPrefixLength()) == null ? creator.createSectionInternal(segs) : creator.createPrefixedSectionInternal(segs, prefLength, true);
        }
        return (R)result;
    }

    @Override
    public int getSegmentCount() {
        return this.getDivisionCount();
    }

    @Override
    public IPAddressSegment getSegment(int index) {
        return this.getSegmentsInternal()[index];
    }

    @Override
    public IPAddressSegment getDivision(int index) {
        return this.getSegmentsInternal()[index];
    }

    @Override
    public boolean containsPrefixBlock(int prefixLength) {
        this.checkSubnet(prefixLength);
        boolean isAllSubnets = this.getNetwork().getPrefixConfiguration().allPrefixedAddressesAreSubnets();
        if (isAllSubnets && this.isPrefixed() && this.getNetworkPrefixLength() <= prefixLength) {
            return true;
        }
        int divCount = this.getDivisionCount();
        int bitsPerSegment = this.getBitsPerSegment();
        int i = IPAddressSection.getHostSegmentIndex(prefixLength, this.getBytesPerSegment(), bitsPerSegment);
        if (i < divCount) {
            int segmentPrefixLength;
            IPAddressSegment div = this.getDivision(i);
            if (!div.isPrefixBlock(segmentPrefixLength = IPAddressSection.getPrefixedSegmentPrefixLength(bitsPerSegment, prefixLength, i).intValue())) {
                return false;
            }
            if (isAllSubnets && div.isPrefixed()) {
                return true;
            }
            ++i;
            while (i < divCount) {
                div = this.getDivision(i);
                if (!div.isFullRange()) {
                    return false;
                }
                if (isAllSubnets && div.isPrefixed()) {
                    return true;
                }
                ++i;
            }
        }
        return true;
    }

    @Override
    public boolean contains(AddressSection other) {
        int endIndex;
        int count = this.getSegmentCount();
        if (count != other.getSegmentCount()) {
            return false;
        }
        boolean prefixIsSubnet = this.isPrefixed() && this.getNetwork().getPrefixConfiguration().allPrefixedAddressesAreSubnets();
        int i = endIndex = prefixIsSubnet ? IPAddressSection.getNetworkSegmentIndex(this.getNetworkPrefixLength(), this.getBytesPerSegment(), this.getBitsPerSegment()) : count - 1;
        while (i >= 0) {
            IPAddressSegment seg = this.getSegment(i);
            if (!seg.contains(other.getSegment(i))) {
                return false;
            }
            --i;
        }
        return true;
    }

    @Override
    public boolean isFullRange() {
        int divCount = this.getDivisionCount();
        boolean allPrefixedAddressesAreSubnets = this.getNetwork().getPrefixConfiguration().allPrefixedAddressesAreSubnets();
        if (allPrefixedAddressesAreSubnets) {
            int i = 0;
            while (i < divCount) {
                IPAddressSegment div = this.getSegment(i);
                if (!div.isFullRange()) {
                    return false;
                }
                Integer prefix = div.getSegmentPrefixLength();
                if (prefix == null) {
                    ++i;
                    continue;
                }
                break;
            }
        } else {
            int i = 0;
            while (i < divCount) {
                IPAddressSegment div = this.getSegment(i);
                if (!div.isFullRange()) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    protected static <T extends IPAddress, R extends IPAddressSection, S extends IPAddressSegment> R intersect(R first, R other, IPAddressNetwork.IPAddressCreator<T, R, ?, S, ?> addrCreator, IntFunction<S> segProducer, IntFunction<S> otherSegProducer) {
        first.checkSectionCount(other);
        Integer pref = first.getNetworkPrefixLength();
        Integer otherPref = other.getNetworkPrefixLength();
        if (pref != null) {
            pref = otherPref != null ? Integer.valueOf(Math.max(pref, otherPref)) : null;
        }
        if (other.contains(first)) {
            if (Objects.equals(pref, first.getNetworkPrefixLength())) {
                return first;
            }
        } else if (!first.isMultiple()) {
            return null;
        }
        if (first.contains(other)) {
            if (Objects.equals(pref, other.getNetworkPrefixLength())) {
                return other;
            }
        } else if (!other.isMultiple()) {
            return null;
        }
        int segCount = first.getSegmentCount();
        int i = 0;
        while (i < segCount) {
            IPAddressSegment seg = first.getSegment(i);
            IPAddressSegment otherSeg = other.getSegment(i);
            int lower = seg.getLowerSegmentValue();
            int higher = seg.getUpperSegmentValue();
            int otherLower = otherSeg.getLowerSegmentValue();
            int otherHigher = otherSeg.getUpperSegmentValue();
            if (otherLower > higher || lower > otherHigher) {
                return null;
            }
            ++i;
        }
        IPAddressSegment[] segs = (IPAddressSegment[])addrCreator.createSegmentArray(segCount);
        int i2 = 0;
        while (i2 < segCount) {
            IPAddressSegment seg = (IPAddressSegment)segProducer.apply(i2);
            IPAddressSegment otherSeg = (IPAddressSegment)otherSegProducer.apply(i2);
            Integer segPref = IPAddressSection.getSegmentPrefixLength(seg.getBitCount(), pref, i2);
            if (seg.contains(otherSeg) && !otherSeg.isChangedByPrefix(segPref, false)) {
                segs[i2] = otherSeg;
            } else if (otherSeg.contains(seg) && !seg.isChangedByPrefix(segPref, false)) {
                segs[i2] = seg;
            } else {
                int lower = seg.getLowerSegmentValue();
                int higher = seg.getUpperSegmentValue();
                int otherLower = otherSeg.getLowerSegmentValue();
                int otherHigher = otherSeg.getUpperSegmentValue();
                int newLower = Math.max(lower, otherLower);
                int newHigher = Math.min(higher, otherHigher);
                segs[i2] = (IPAddressSegment)addrCreator.createSegment(newLower, newHigher, segPref);
            }
            ++i2;
        }
        IPAddressSection result = addrCreator.createSection(segs);
        return (R)result;
    }

    protected static <R extends IPAddressSection> R[] getSpanningPrefixBlocks(R first, R other, UnaryOperator<R> getLower, UnaryOperator<R> getUpper, Comparator<R> comparator, Function<R, R> prefixRemover, IntFunction<R[]> arrayProducer) {
        first.checkSectionCount(other);
        boolean f = first.contains(other);
        if (f || other.contains((AddressSection)first)) {
            if (!f) {
                R tmp = first;
                first = other;
                other = tmp;
            }
            IPAddressSection[] result = (IPAddressSection[])arrayProducer.apply(1);
            if (first.isPrefixed() && first.getPrefixLength() >= first.getBitCount()) {
                first = (IPAddressSection)prefixRemover.apply(first);
            }
            result[0] = first;
            return result;
        }
        ArrayList<IPAddressSegmentSeries> blocks = new ArrayList<IPAddressSegmentSeries>();
        IPAddressSection.getSpanningSeriesPrefixBlocks(first, other, getLower, getUpper, comparator, prefixRemover, blocks);
        IPAddressSection[] result = blocks.toArray((IPAddressSection[])arrayProducer.apply(blocks.size()));
        return result;
    }

    static <R extends IPAddressSegmentSeries> void getSpanningSeriesPrefixBlocks(R first, R other, UnaryOperator<R> getLower, UnaryOperator<R> getUpper, Comparator<R> comparator, Function<R, R> prefixRemover, ArrayList<IPAddressSegmentSeries> blocks) {
        IPAddressSegmentSeries firstLower = (IPAddressSegmentSeries)getLower.apply(first);
        IPAddressSegmentSeries otherLower = (IPAddressSegmentSeries)getLower.apply(other);
        IPAddressSegmentSeries firstUpper = (IPAddressSegmentSeries)getUpper.apply(first);
        IPAddressSegmentSeries otherUpper = (IPAddressSegmentSeries)getUpper.apply(other);
        IPAddressSegmentSeries lower = comparator.compare(firstLower, otherLower) > 0 ? otherLower : firstLower;
        IPAddressSegmentSeries upper = comparator.compare(firstUpper, otherUpper) < 0 ? otherUpper : firstUpper;
        lower = (IPAddressSegmentSeries)prefixRemover.apply(lower);
        upper = (IPAddressSegmentSeries)prefixRemover.apply(upper);
        IPAddressSection.splitRange(lower, upper, 0, 0, blocks);
    }

    private static void splitRange(IPAddressSegmentSeries lower, IPAddressSegmentSeries upper, int previousSegmentBits, int currentSegment, List<IPAddressSegmentSeries> blocks) {
        boolean differingIsLowestBit;
        long differing = 0L;
        int segCount = lower.getSegmentCount();
        int bitsPerSegment = lower.getBitsPerSegment();
        while (currentSegment < segCount) {
            int upperValue;
            IPAddressSegment lowerSeg = lower.getSegment(currentSegment);
            IPAddressSegment upperSeg = upper.getSegment(currentSegment);
            int lowerValue = lowerSeg.getLowerSegmentValue();
            differing = lowerValue ^ (upperValue = upperSeg.getLowerSegmentValue());
            if (differing != 0L) break;
            previousSegmentBits += bitsPerSegment;
            ++currentSegment;
        }
        if (differing == 0L) {
            blocks.add(lower);
            return;
        }
        boolean bl = differingIsLowestBit = differing == 1L;
        if (differingIsLowestBit && currentSegment + 1 == segCount) {
            blocks.add(lower.toPrefixBlock(lower.getBitCount() - 1));
            return;
        }
        int highestDifferingBitInRange = Long.numberOfLeadingZeros(differing) - (64 - bitsPerSegment);
        int differingBitPrefixLen = highestDifferingBitInRange + previousSegmentBits;
        if (lower.includesZeroHost(differingBitPrefixLen) && upper.includesMaxHost(differingBitPrefixLen)) {
            blocks.add(lower.toPrefixBlock(differingBitPrefixLen));
            return;
        }
        IPAddressSegmentSeries lowerTop = upper.toZeroHost(differingBitPrefixLen + 1);
        IPAddressSegmentSeries upperBottom = lowerTop.increment(-1L);
        if (differingIsLowestBit) {
            previousSegmentBits += bitsPerSegment;
            ++currentSegment;
        }
        IPAddressSection.splitRange(lower, upperBottom, previousSegmentBits, currentSegment, blocks);
        IPAddressSection.splitRange(lowerTop, upper, previousSegmentBits, currentSegment, blocks);
    }

    protected static List<IPAddressSegmentSeries> getMergedBlocks(IPAddressSegmentSeries first, IPAddressSegmentSeries[] sections, boolean checkSize) {
        boolean addedFirst;
        int bitCount = first.getBitCount();
        int bitsPerSegment = first.getBitsPerSegment();
        int bytesPerSegment = first.getBytesPerSegment();
        if (first.isMultiple()) {
            IPAddressSegmentSeries block = first.assignMinPrefixForBlock();
            if (block.getPrefixLength() < bitCount) {
                first = block;
            }
        } else {
            first = first.removePrefixLength(false);
        }
        int firstSectionCount = first.getSegmentCount();
        int i = 0;
        while (i < sections.length) {
            IPAddressSegmentSeries section = sections[i];
            if (checkSize && section.getSegmentCount() != firstSectionCount) {
                throw new SizeMismatchException(first, section);
            }
            if (section.isMultiple()) {
                IPAddressSegmentSeries block = section.assignMinPrefixForBlock();
                if (block.getPrefixLength() < bitCount) {
                    sections[i] = block;
                }
            } else {
                sections[i] = section.removePrefixLength(false);
            }
            ++i;
        }
        AddressComparator.ValueComparator valueComparator = new AddressComparator.ValueComparator(false);
        Arrays.sort(sections, (o1, o2) -> {
            int compare;
            Integer prefix2;
            Integer prefix1 = o1.getPrefixLength();
            int n = prefix1 == (prefix2 = o2.getPrefixLength()) ? 0 : (prefix1 == null ? -1 : (compare = prefix2 == null ? 1 : prefix2.compareTo(prefix1)));
            if (compare == 0) {
                compare = valueComparator.compareSegmentLowValues((AddressSegmentSeries)o1, (AddressSegmentSeries)o2);
            }
            return compare;
        });
        ArrayList<IPAddressSegmentSeries> list = new ArrayList<IPAddressSegmentSeries>();
        Integer firstPrefixLength = first.getPrefixLength();
        if (firstPrefixLength == null) {
            addedFirst = true;
            list.add(first);
        } else if (firstPrefixLength >= bitCount) {
            addedFirst = true;
            list.add(first.removePrefixLength());
        } else {
            addedFirst = false;
        }
        int i2 = 0;
        while (i2 < sections.length) {
            IPAddressSegmentSeries section = sections[i2];
            Integer sectionPrefixLength = section.getNetworkPrefixLength();
            if (sectionPrefixLength == null) {
                list.add(section);
            } else if (sectionPrefixLength >= bitCount) {
                list.add(section.removePrefixLength());
            } else {
                Iterator<? extends IPAddressSegmentSeries> iterator;
                if (!addedFirst && firstPrefixLength > sectionPrefixLength) {
                    addedFirst = true;
                    iterator = first.prefixBlockIterator();
                    iterator.forEachRemaining(list::add);
                }
                iterator = section.prefixBlockIterator();
                iterator.forEachRemaining(list::add);
            }
            ++i2;
        }
        if (!addedFirst) {
            addedFirst = true;
            Iterator<? extends IPAddressSegmentSeries> iterator = first.prefixBlockIterator();
            iterator.forEachRemaining(list::add);
        }
        i = 0;
        block2: while (i < list.size()) {
            IPAddressSegmentSeries item = (IPAddressSegmentSeries)list.get(i);
            Integer prefixLen = item.getPrefixLength();
            int bitToCheck = prefixLen == null ? bitCount - 1 : prefixLen - 1;
            int j = i + 1;
            while (true) {
                block34: {
                    IPAddressSegment otherItemSegment;
                    IPAddressSegment itemSegment;
                    int lastMatchSegmentIndex;
                    boolean checkLastBit;
                    IPAddressSegmentSeries otherItem;
                    block37: {
                        Integer otherPrefixLen;
                        block35: {
                            int otherItemSegmentValue;
                            block36: {
                                if (j == list.size()) {
                                    ++i;
                                    continue block2;
                                }
                                otherItem = (IPAddressSegmentSeries)list.get(j);
                                otherPrefixLen = otherItem.getPrefixLength();
                                checkLastBit = otherPrefixLen == null || otherPrefixLen >= bitCount || prefixLen != null && otherPrefixLen >= prefixLen;
                                int matchBitIndex = checkLastBit ? bitToCheck : otherPrefixLen;
                                lastMatchSegmentIndex = IPAddressSection.getNetworkSegmentIndex(matchBitIndex, bytesPerSegment, bitsPerSegment);
                                int lastBitSegmentIndex = IPAddressSection.getHostSegmentIndex(matchBitIndex, bytesPerSegment, bitsPerSegment);
                                itemSegment = item.getSegment(lastMatchSegmentIndex);
                                otherItemSegment = otherItem.getSegment(lastMatchSegmentIndex);
                                int itemSegmentValue = itemSegment.getLowerSegmentValue();
                                otherItemSegmentValue = otherItemSegment.getLowerSegmentValue();
                                if (!checkLastBit) break block35;
                                int segmentLastBitIndex = bitsPerSegment - 1;
                                if (lastBitSegmentIndex == lastMatchSegmentIndex) {
                                    int segmentBitToCheck = bitToCheck % bitsPerSegment;
                                    int shift = segmentLastBitIndex - segmentBitToCheck;
                                    itemSegmentValue >>>= shift;
                                    otherItemSegmentValue >>>= shift;
                                } else {
                                    int itemBitValue = item.getSegment(lastBitSegmentIndex).getLowerSegmentValue();
                                    int otherItemBitalue = otherItem.getSegment(lastBitSegmentIndex).getLowerSegmentValue();
                                    itemSegmentValue = itemSegmentValue << 1 | itemBitValue >>> segmentLastBitIndex;
                                    otherItemSegmentValue = otherItemSegmentValue << 1 | otherItemBitalue >>> segmentLastBitIndex;
                                }
                                if (itemSegmentValue != otherItemSegmentValue) break block36;
                                checkLastBit = false;
                                break block37;
                            }
                            if ((itemSegmentValue ^= 1) == otherItemSegmentValue) break block37;
                            break block34;
                        }
                        int otherSegmentPrefixLen = IPAddressSection.getSegmentPrefixLength(otherItem.getBitsPerSegment(), otherPrefixLen, lastMatchSegmentIndex);
                        int shift = bitsPerSegment - otherSegmentPrefixLen;
                        if ((itemSegmentValue >>>= shift) != (otherItemSegmentValue >>>= shift)) break block34;
                    }
                    int k = lastMatchSegmentIndex - 1;
                    while (k >= 0) {
                        int otherVal;
                        itemSegment = item.getSegment(k);
                        otherItemSegment = otherItem.getSegment(k);
                        int val = itemSegment.getLowerSegmentValue();
                        if (val == (otherVal = otherItemSegment.getLowerSegmentValue())) {
                            --k;
                            continue;
                        }
                        break block34;
                    }
                    if (checkLastBit) {
                        IPAddressSegmentSeries joinedItem = otherItem.toPrefixBlock(bitToCheck);
                        if (j == list.size() - 1) {
                            list.set(j, joinedItem);
                        } else {
                            int k2 = j + 1;
                            while (k2 < list.size()) {
                                int compare;
                                IPAddressSegmentSeries furtherItem = (IPAddressSegmentSeries)list.get(k2);
                                Integer furtherPrefixLen = furtherItem.getPrefixLength();
                                int n = compare = furtherPrefixLen == null ? -1 : bitToCheck - furtherPrefixLen;
                                if (compare == 0) {
                                    compare = valueComparator.compareSegmentLowValues(joinedItem, furtherItem);
                                }
                                if (compare >= 0) {
                                    list.set(k2 - 1, joinedItem);
                                    break;
                                }
                                list.set(k2 - 1, furtherItem);
                                ++k2;
                            }
                            if (k2 == list.size()) {
                                list.set(k2 - 1, joinedItem);
                            }
                        }
                    }
                    list.remove(i);
                    continue block2;
                }
                ++j;
            }
        }
        return list;
    }

    protected static <T extends IPAddress, R extends IPAddressSection, S extends IPAddressSegment> R[] subtract(R first, R other, IPAddressNetwork.IPAddressCreator<T, R, ?, S, ?> addrCreator, IntFunction<S> segProducer, BiFunction<R, Integer, R> prefixApplier) {
        first.checkSectionCount(other);
        if (!first.isMultiple()) {
            if (other.contains(first)) {
                return null;
            }
            IPAddressSection[] result = addrCreator.createSectionArray(1);
            result[0] = first;
            return result;
        }
        int segCount = first.getSegmentCount();
        int i = 0;
        while (i < segCount) {
            IPAddressSegment seg = first.getSegment(i);
            IPAddressSegment otherSeg = other.getSegment(i);
            int lower = seg.getLowerSegmentValue();
            int higher = seg.getUpperSegmentValue();
            int otherLower = otherSeg.getLowerSegmentValue();
            int otherHigher = otherSeg.getUpperSegmentValue();
            if (otherLower > higher || lower > otherHigher) {
                IPAddressSection[] result = addrCreator.createSectionArray(1);
                result[0] = first;
                return result;
            }
            ++i;
        }
        IPAddressSegment[] intersections = (IPAddressSegment[])addrCreator.createSegmentArray(segCount);
        ArrayList<IPAddressSection> sections = new ArrayList<IPAddressSection>();
        int i2 = 0;
        while (i2 < segCount) {
            IPAddressSection section;
            IPAddressSegment seg = (IPAddressSegment)segProducer.apply(i2);
            IPAddressSegment otherSeg = other.getSegment(i2);
            int lower = seg.getLowerSegmentValue();
            int higher = seg.getUpperSegmentValue();
            int otherLower = otherSeg.getLowerSegmentValue();
            int otherHigher = otherSeg.getUpperSegmentValue();
            if (lower >= otherLower) {
                if (higher <= otherHigher) {
                    intersections[i2] = seg.isPrefixed() ? (IPAddressSegment)addrCreator.createSegment(lower, higher, null) : seg;
                } else {
                    intersections[i2] = (IPAddressSegment)addrCreator.createSegment(lower, otherHigher, null);
                    section = IPAddressSection.createDiffSection(first, (int)(otherHigher + 1), (int)higher, (int)i2, addrCreator, segProducer, (IPAddressSegment[])intersections);
                    sections.add(section);
                }
            } else {
                section = IPAddressSection.createDiffSection(first, (int)lower, (int)(otherLower - 1), (int)i2, addrCreator, segProducer, (IPAddressSegment[])intersections);
                sections.add(section);
                if (higher <= otherHigher) {
                    intersections[i2] = (IPAddressSegment)addrCreator.createSegment(otherLower, higher, null);
                } else {
                    intersections[i2] = (IPAddressSegment)addrCreator.createSegment(otherLower, otherHigher, null);
                    section = IPAddressSection.createDiffSection(first, (int)(otherHigher + 1), (int)higher, (int)i2, addrCreator, segProducer, (IPAddressSegment[])intersections);
                    sections.add(section);
                }
            }
            ++i2;
        }
        if (first.isPrefixed()) {
            int thisPrefix = first.getNetworkPrefixLength();
            int i3 = 0;
            while (i3 < sections.size()) {
                int bitCount;
                IPAddressSection section = (IPAddressSection)sections.get(i3);
                int totalPrefix = bitCount = section.getBitCount();
                int j = first.getSegmentCount() - 1;
                while (j >= 0) {
                    IPAddressSegment seg = section.getSegment(j);
                    int segBitCount = seg.getBitCount();
                    int segPrefix = seg.getMinPrefixLengthForBlock();
                    if (segPrefix == segBitCount) break;
                    totalPrefix -= segBitCount;
                    if (segPrefix != 0) {
                        totalPrefix += segPrefix;
                        break;
                    }
                    --j;
                }
                if (totalPrefix != bitCount) {
                    if (totalPrefix < thisPrefix) {
                        totalPrefix = thisPrefix;
                    }
                    section = (IPAddressSection)prefixApplier.apply(section, totalPrefix);
                    sections.set(i3, section);
                }
                ++i3;
            }
        }
        if (sections.size() == 0) {
            return null;
        }
        IPAddressSection[] result = addrCreator.createSectionArray(sections.size());
        sections.toArray(result);
        return result;
    }

    private static <T extends IPAddress, R extends IPAddressSection, S extends IPAddressSegment> R createDiffSection(R original, int lower, int upper, int diffIndex, IPAddressNetwork.IPAddressCreator<T, R, ?, S, ?> addrCreator, IntFunction<S> segProducer, S[] intersectingValues) {
        IPAddressSegment diff;
        int segCount = original.getSegmentCount();
        IPAddressSegment[] segments = (IPAddressSegment[])addrCreator.createSegmentArray(segCount);
        int j = 0;
        while (j < diffIndex) {
            segments[j] = intersectingValues[j];
            ++j;
        }
        segments[diffIndex] = diff = (IPAddressSegment)addrCreator.createSegment(lower, upper, null);
        int j2 = diffIndex + 1;
        while (j2 < segCount) {
            segments[j2] = (IPAddressSegment)segProducer.apply(j2);
            ++j2;
        }
        IPAddressSection section = addrCreator.createSectionInternal(segments);
        return (R)section;
    }

    @Override
    public abstract IPAddressSection toZeroHost();

    @Override
    public abstract IPAddressSection toZeroHost(int var1);

    @Override
    public abstract IPAddressSection toZeroNetwork();

    @Override
    public abstract IPAddressSection toMaxHost();

    @Override
    public abstract IPAddressSection toMaxHost(int var1);

    @Override
    public abstract IPAddressSection applyPrefixLength(int var1) throws PrefixLenException;

    protected void checkSectionCount(IPAddressSection sec) throws SizeMismatchException {
        if (sec.getSegmentCount() != this.getSegmentCount()) {
            throw new SizeMismatchException(this, sec);
        }
    }

    protected void checkMaskSectionCount(IPAddressSection mask) throws SizeMismatchException {
        if (mask.getSegmentCount() < this.getSegmentCount()) {
            throw new SizeMismatchException(this, mask);
        }
    }

    @Override
    public abstract IPAddressSection toPrefixBlock();

    @Override
    public abstract IPAddressSection toPrefixBlock(int var1);

    @Override
    public IPAddressSection getHostMask() {
        Integer prefLen = this.getNetworkPrefixLength();
        return ((IPAddress)((IPAddressNetwork)this.getNetwork()).getHostMask(prefLen == null ? 0 : this.getNetworkPrefixLength())).getSection(0, this.getSegmentCount());
    }

    @Override
    public IPAddressSection getNetworkMask() {
        Integer prefLen = this.getNetworkPrefixLength();
        return ((IPAddress)((IPAddressNetwork)this.getNetwork()).getHostMask(prefLen == null ? this.getBitCount() : this.getNetworkPrefixLength().intValue())).getSection(0, this.getSegmentCount());
    }

    @Override
    public IPAddressSection assignPrefixForSingleBlock() {
        if (!this.isMultiple()) {
            return this;
        }
        Integer newPrefix = this.getPrefixLengthForSingleBlock();
        return newPrefix == null ? null : this.setPrefixLength(newPrefix, false);
    }

    @Override
    public IPAddressSection assignMinPrefixForBlock() {
        return this.setPrefixLength(this.getMinPrefixLengthForBlock(), false);
    }

    @Override
    public boolean includesZeroHost() {
        Integer networkPrefixLength = this.getNetworkPrefixLength();
        if (networkPrefixLength == null || networkPrefixLength >= this.getBitCount()) {
            return false;
        }
        return this.includesZeroHost(networkPrefixLength);
    }

    @Override
    public boolean includesZeroHost(int networkPrefixLength) {
        if (this.getNetwork().getPrefixConfiguration().allPrefixedAddressesAreSubnets() && this.isPrefixed() && this.getNetworkPrefixLength() <= networkPrefixLength) {
            return true;
        }
        int bitsPerSegment = this.getBitsPerSegment();
        int bytesPerSegment = this.getBytesPerSegment();
        int prefixedSegmentIndex = IPAddressSection.getHostSegmentIndex(networkPrefixLength, bytesPerSegment, bitsPerSegment);
        int divCount = this.getSegmentCount();
        int i = prefixedSegmentIndex;
        while (i < divCount) {
            IPAddressSegment div = this.getSegment(i);
            Integer segmentPrefixLength = IPAddressSection.getPrefixedSegmentPrefixLength(bitsPerSegment, networkPrefixLength, i);
            if (segmentPrefixLength != null) {
                int mask = div.getSegmentHostMask(segmentPrefixLength);
                if (((long)mask & div.getLowerValue()) != 0L) {
                    return false;
                }
                ++i;
                while (i < divCount) {
                    div = this.getSegment(i);
                    if (!div.includesZero()) {
                        return false;
                    }
                    ++i;
                }
            }
            ++i;
        }
        return true;
    }

    @Override
    public boolean includesMaxHost() {
        Integer networkPrefixLength = this.getNetworkPrefixLength();
        if (networkPrefixLength == null || networkPrefixLength >= this.getBitCount()) {
            return false;
        }
        return this.includesMaxHost(networkPrefixLength);
    }

    @Override
    public boolean includesMaxHost(int networkPrefixLength) {
        if (this.getNetwork().getPrefixConfiguration().allPrefixedAddressesAreSubnets() && this.isPrefixed() && this.getNetworkPrefixLength() <= networkPrefixLength) {
            return true;
        }
        int bitsPerSegment = this.getBitsPerSegment();
        int bytesPerSegment = this.getBytesPerSegment();
        int prefixedSegmentIndex = IPAddressSection.getHostSegmentIndex(networkPrefixLength, bytesPerSegment, bitsPerSegment);
        int divCount = this.getSegmentCount();
        int i = prefixedSegmentIndex;
        while (i < divCount) {
            IPAddressSegment div = this.getSegment(i);
            Integer segmentPrefixLength = IPAddressSection.getPrefixedSegmentPrefixLength(bitsPerSegment, networkPrefixLength, i);
            if (segmentPrefixLength != null) {
                int mask = div.getSegmentHostMask(segmentPrefixLength);
                if ((mask & div.getUpperSegmentValue()) != mask) {
                    return false;
                }
                ++i;
                while (i < divCount) {
                    div = this.getSegment(i);
                    if (!div.includesMax()) {
                        return false;
                    }
                    ++i;
                }
            }
            ++i;
        }
        return true;
    }

    public boolean isSingleNetwork() {
        Integer networkPrefixLength = this.getNetworkPrefixLength();
        if (networkPrefixLength == null || networkPrefixLength >= this.getBitCount()) {
            return !this.isMultiple();
        }
        int prefixedSegmentIndex = IPAddressSection.getNetworkSegmentIndex(networkPrefixLength, this.getBytesPerSegment(), this.getBitsPerSegment());
        if (prefixedSegmentIndex < 0) {
            return true;
        }
        int i = 0;
        while (i < prefixedSegmentIndex) {
            IPAddressSegment div = this.getSegment(i);
            if (div.isMultiple()) {
                return false;
            }
            ++i;
        }
        IPAddressSegment div = this.getSegment(prefixedSegmentIndex);
        int differing = div.getLowerSegmentValue() ^ div.getUpperSegmentValue();
        if (differing == 0) {
            return true;
        }
        int bitsPerSegment = div.getBitCount();
        int highestDifferingBitInRange = Integer.numberOfLeadingZeros(differing) - (32 - bitsPerSegment);
        return IPAddressSection.getSegmentPrefixLength(bitsPerSegment, networkPrefixLength, prefixedSegmentIndex) <= highestDifferingBitInRange;
    }

    public boolean matchesWithMask(IPAddressSection other, IPAddressSection mask) {
        this.checkMaskSectionCount(mask);
        this.checkSectionCount(other);
        int divCount = this.getSegmentCount();
        int i = 0;
        while (i < divCount) {
            IPAddressSegment div = this.getSegment(i);
            IPAddressSegment maskSegment = mask.getSegment(i);
            IPAddressSegment otherSegment = other.getSegment(i);
            if (!div.matchesWithMask(otherSegment.getLowerSegmentValue(), otherSegment.getUpperSegmentValue(), maskSegment.getLowerSegmentValue())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public abstract IPAddressSection removePrefixLength(boolean var1);

    @Override
    public abstract IPAddressSection removePrefixLength();

    protected static <T extends IPAddress, R extends IPAddressSection, S extends IPAddressSegment> R toPrefixBlock(R original, int networkPrefixLength, IPAddressNetwork.IPAddressCreator<T, R, ?, S, ?> creator, BiFunction<Integer, Integer, S> segProducer) {
        if (networkPrefixLength < 0 || networkPrefixLength > original.getBitCount()) {
            throw new PrefixLenException(original, networkPrefixLength);
        }
        if (original.isNetworkSubnet(networkPrefixLength)) {
            return original;
        }
        int bitsPerSegment = original.getBitsPerSegment();
        int segmentCount = original.getSegmentCount();
        IPAddressSegment[] result = (IPAddressSegment[])creator.createSegmentArray(segmentCount);
        int i = 0;
        while (i < segmentCount) {
            Integer prefix = IPAddressSection.getSegmentPrefixLength(bitsPerSegment, networkPrefixLength, i);
            result[i] = (IPAddressSegment)segProducer.apply(i, prefix);
            ++i;
        }
        return (R)creator.createSectionInternal(result);
    }

    protected boolean isNetworkSubnet(int networkPrefixLength) {
        int segmentCount = this.getSegmentCount();
        if (segmentCount == 0) {
            return true;
        }
        int bitsPerSegment = this.getBitsPerSegment();
        int prefixedSegmentIndex = IPAddressSection.getHostSegmentIndex(networkPrefixLength, this.getBytesPerSegment(), bitsPerSegment);
        if (prefixedSegmentIndex >= segmentCount) {
            return true;
        }
        int segPrefLength = IPAddressSection.getPrefixedSegmentPrefixLength(bitsPerSegment, networkPrefixLength, prefixedSegmentIndex);
        if (this.getSegment(prefixedSegmentIndex).isNetworkChangedByPrefix(segPrefLength, true)) {
            return false;
        }
        if (!this.getNetwork().getPrefixConfiguration().allPrefixedAddressesAreSubnets()) {
            int i = prefixedSegmentIndex + 1;
            while (i < segmentCount) {
                if (!this.getSegment(i).isFullRange()) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    protected static <R extends IPAddressSection, S extends IPAddressSegment> R removePrefixLength(R original, boolean zeroed, IPAddressNetwork.IPAddressCreator<?, R, ?, S, ?> creator, SegFunction<R, S> segProducer) throws IncompatibleAddressException {
        if (!original.isPrefixed()) {
            return original;
        }
        AddressNetwork network = creator.getNetwork();
        Object mask = ((IPAddressNetwork)network).getNetworkMaskSection(zeroed ? original.getPrefixLength().intValue() : original.getBitCount());
        return IPAddressSection.getSubnetSegments(original, null, creator, zeroed, i -> (IPAddressSegment)segProducer.apply(original, i), i -> ((IPAddressSegment)segProducer.apply(mask, i)).getLowerSegmentValue(), false);
    }

    @Override
    public IPAddressSection adjustPrefixBySegment(boolean nextSegment, boolean zeroed) {
        int prefix = this.getAdjustedPrefix(nextSegment, this.getBitsPerSegment(), false);
        Integer existing = this.getNetworkPrefixLength();
        if (existing == null) {
            if (nextSegment ? prefix == this.getBitCount() : prefix == 0) {
                return this;
            }
        } else if (existing != null && existing == prefix && prefix != 0) {
            return this.removePrefixLength(zeroed);
        }
        return this.setPrefixLength(prefix, zeroed);
    }

    @Override
    public abstract IPAddressSection adjustPrefixBySegment(boolean var1);

    @Override
    public abstract IPAddressSection adjustPrefixLength(int var1);

    @Override
    public abstract IPAddressSection adjustPrefixLength(int var1, boolean var2);

    protected static <R extends IPAddressSection, S extends IPAddressSegment> IPAddressSection adjustPrefixLength(R original, int adjustment, boolean withZeros, IPAddressNetwork.IPAddressCreator<?, R, ?, S, ?> creator, SegFunction<R, S> segProducer) throws IncompatibleAddressException {
        if (adjustment == 0) {
            return original;
        }
        int prefix = original.getAdjustedPrefix(adjustment, false, false);
        if (prefix > original.getBitCount()) {
            if (!original.isPrefixed()) {
                return original;
            }
            AddressNetwork network = creator.getNetwork();
            Object mask = ((IPAddressNetwork)network).getNetworkMaskSection(withZeros ? original.getPrefixLength().intValue() : original.getBitCount());
            return IPAddressSection.getSubnetSegments(original, null, creator, withZeros, i -> (IPAddressSegment)segProducer.apply(original, i), i -> ((IPAddressSegment)segProducer.apply(mask, i)).getLowerSegmentValue(), false);
        }
        if (prefix < 0) {
            prefix = 0;
        }
        return original.setPrefixLength(prefix, withZeros);
    }

    @Override
    public abstract IPAddressSection setPrefixLength(int var1);

    @Override
    public abstract IPAddressSection setPrefixLength(int var1, boolean var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasNoPrefixCache() {
        if (this.prefixCache == null) {
            IPAddressSection iPAddressSection = this;
            synchronized (iPAddressSection) {
                block5: {
                    if (this.prefixCache != null) break block5;
                    this.prefixCache = new PrefixCache();
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public int getMinPrefixLengthForBlock() {
        Integer result;
        if (this.hasNoPrefixCache() || (result = this.prefixCache.cachedMinPrefix) == null) {
            result = IPAddressSection.cacheBits(super.getMinPrefixLengthForBlock());
            this.prefixCache.cachedMinPrefix = result;
        }
        return result;
    }

    @Override
    public Integer getPrefixLengthForSingleBlock() {
        Integer result;
        if (!this.hasNoPrefixCache() && (result = this.prefixCache.cachedEquivalentPrefix) != null) {
            if (result < 0) {
                return null;
            }
            return result;
        }
        Integer res = super.getPrefixLengthForSingleBlock();
        if (res == null) {
            this.prefixCache.cachedEquivalentPrefix = IPAddressSection.NO_PREFIX_LENGTH;
            return null;
        }
        Integer n = res;
        this.prefixCache.cachedEquivalentPrefix = n;
        return n;
    }

    @Override
    public abstract IPAddressSection getLowerNonZeroHost();

    @Override
    public abstract IPAddressSection getLower();

    @Override
    public abstract IPAddressSection getUpper();

    @Override
    public abstract IPAddressSection reverseSegments();

    @Override
    public abstract IPAddressSection reverseBits(boolean var1);

    @Override
    public abstract IPAddressSection reverseBytes();

    @Override
    public abstract IPAddressSection reverseBytesPerSegment();

    protected IPAddressSegment[] getSegmentsInternal() {
        return (IPAddressSegment[])this.getDivisionsInternal();
    }

    @Override
    public abstract IPAddressSection getSection(int var1);

    @Override
    public abstract IPAddressSection getSection(int var1, int var2);

    @Override
    public void getSegments(AddressSegment[] segs) {
        this.getSegments(0, this.getDivisionCount(), segs, 0);
    }

    @Override
    public void getSegments(int start, int end, AddressSegment[] segs, int destIndex) {
        System.arraycopy(this.getDivisionsInternal(), start, segs, destIndex, end - start);
    }

    protected static <T extends IPAddress, R extends IPAddressSection, S extends IPAddressSegment> R createEmbeddedSection(IPAddressNetwork.IPAddressCreator<T, R, ?, S, ?> creator, S[] segs, IPAddressSection encompassingSection) {
        return (R)creator.createEmbeddedSectionInternal(encompassingSection, (IPAddressSegment[])segs);
    }

    public abstract Iterable<? extends IPAddressSection> getIterable();

    public abstract Iterator<? extends IPAddressSection> nonZeroHostIterator();

    public abstract Iterator<? extends IPAddressSection> iterator();

    public abstract Iterator<? extends IPAddressSection> prefixBlockIterator();

    @Override
    public abstract IPAddressSection increment(long var1);

    @Override
    public abstract IPAddressSection incrementBoundary(long var1);

    public boolean isEntireAddress() {
        return this.getSegmentCount() == IPAddress.getSegmentCount(this.getIPVersion());
    }

    protected <S extends IPAddressSegment> boolean isZeroHost(S[] segments) {
        if (segments.length == 0 || !this.isPrefixed()) {
            return false;
        }
        int prefLen = this.getNetworkPrefixLength();
        if (prefLen >= this.getBitCount()) {
            return false;
        }
        int bitsPerSegment = this.getBitsPerSegment();
        int prefixedSegmentIndex = IPAddressSection.getHostSegmentIndex(prefLen, this.getBytesPerSegment(), bitsPerSegment);
        int divCount = segments.length;
        int i = prefixedSegmentIndex;
        while (i < divCount) {
            Integer segmentPrefixLength = IPAddressSection.getPrefixedSegmentPrefixLength(bitsPerSegment, prefLen, prefixedSegmentIndex);
            S div = segments[i];
            if (segmentPrefixLength != null) {
                int mask = ((IPAddressSegment)div).getSegmentHostMask(segmentPrefixLength);
                if ((mask & ((IPAddressSegment)div).getLowerSegmentValue()) != 0) {
                    return false;
                }
                ++i;
                while (i < divCount) {
                    div = segments[i];
                    if (((IPAddressSegment)div).getLowerSegmentValue() != 0) {
                        return false;
                    }
                    ++i;
                }
            }
            ++i;
        }
        return true;
    }

    InetAddress toInetAddress(IPAddress address) {
        InetAddress result;
        if (this.hasNoValueCache() || (result = this.valueCache.inetAddress) == null) {
            this.valueCache.inetAddress = result = address.toInetAddressImpl(this.getBytes());
        }
        return result;
    }

    InetAddress toUpperInetAddress(IPAddress address) {
        InetAddress result;
        if (this.hasNoValueCache() || (result = this.valueCache.upperInetAddress) == null) {
            this.valueCache.upperInetAddress = result = address.toInetAddressImpl(this.getUpperBytes());
        }
        return result;
    }

    static void checkLengths(int length, StringBuilder builder) {
        IPAddressDivisionGrouping.IPAddressStringParams.checkLengths(length, builder);
    }

    @Override
    public String toString() {
        return this.toNormalizedString();
    }

    @Override
    public String[] getSegmentStrings() {
        return this.getDivisionStrings();
    }

    protected abstract void cacheNormalizedString(String var1);

    protected abstract IPStringCache getStringCache();

    protected abstract boolean hasNoStringCache();

    @Override
    public String toBinaryString() {
        String result;
        if (this.hasNoStringCache() || (result = this.getStringCache().binaryString) == null) {
            IPStringCache stringCache = this.getStringCache();
            stringCache.binaryString = result = this.toBinaryString(null);
        }
        return result;
    }

    protected String toBinaryString(CharSequence zone) {
        if (this.isDualString()) {
            return IPAddressSection.toNormalizedStringRange(IPAddressSection.toIPParams(IPStringCache.binaryParams), this.getLower(), this.getUpper(), zone);
        }
        return IPAddressSection.toIPParams(IPStringCache.binaryParams).toString((IPAddressStringDivisionSeries)this, zone);
    }

    @Override
    public String toOctalString(boolean with0Prefix) {
        String result;
        if (this.hasNoStringCache() || (result = with0Prefix ? this.getStringCache().octalStringPrefixed : this.getStringCache().octalString) == null) {
            IPStringCache stringCache = this.getStringCache();
            result = this.toOctalString(with0Prefix, null);
            if (with0Prefix) {
                stringCache.octalStringPrefixed = result;
            } else {
                stringCache.octalString = result;
            }
        }
        return result;
    }

    protected String toOctalString(boolean with0Prefix, CharSequence zone) {
        if (this.isDualString()) {
            IPAddressSection lower = this.getLower();
            IPAddressSection upper = this.getUpper();
            IPAddressDivision[] lowerDivs = (IPAddressBitsDivision[])lower.createNewDivisions(3, IPAddressBitsDivision::new, IPAddressBitsDivision[]::new);
            IPAddressDivisionGrouping lowerPart = new IPAddressDivisionGrouping(lowerDivs, (IPAddressNetwork<?, ?, ?, ?, ?>)this.getNetwork());
            IPAddressDivision[] upperDivs = (IPAddressBitsDivision[])upper.createNewDivisions(3, IPAddressBitsDivision::new, IPAddressBitsDivision[]::new);
            IPAddressDivisionGrouping upperPart = new IPAddressDivisionGrouping(upperDivs, (IPAddressNetwork<?, ?, ?, ?, ?>)this.getNetwork());
            return IPAddressSection.toNormalizedStringRange(IPAddressSection.toIPParams(with0Prefix ? IPStringCache.octalPrefixedParams : IPStringCache.octalParams), lowerPart, upperPart, zone);
        }
        IPAddressDivision[] divs = (IPAddressBitsDivision[])this.createNewPrefixedDivisions(3, null, null, IPAddressBitsDivision::new, IPAddressBitsDivision[]::new);
        IPAddressDivisionGrouping part = new IPAddressDivisionGrouping(divs, (IPAddressNetwork<?, ?, ?, ?, ?>)this.getNetwork());
        return IPAddressSection.toIPParams(with0Prefix ? IPStringCache.octalPrefixedParams : IPStringCache.octalParams).toString((IPAddressStringDivisionSeries)part, zone);
    }

    @Override
    public String toHexString(boolean with0xPrefix) {
        String result;
        if (this.hasNoStringCache() || (result = with0xPrefix ? this.getStringCache().hexStringPrefixed : this.getStringCache().hexString) == null) {
            IPStringCache stringCache = this.getStringCache();
            result = this.toHexString(with0xPrefix, null);
            if (with0xPrefix) {
                stringCache.hexStringPrefixed = result;
            } else {
                stringCache.hexString = result;
            }
        }
        return result;
    }

    protected String toHexString(boolean with0xPrefix, CharSequence zone) {
        if (this.isDualString()) {
            return IPAddressSection.toNormalizedStringRange(IPAddressSection.toIPParams(with0xPrefix ? IPStringCache.hexPrefixedParams : IPStringCache.hexParams), this.getLower(), this.getUpper(), zone);
        }
        return IPAddressSection.toIPParams(with0xPrefix ? IPStringCache.hexPrefixedParams : IPStringCache.hexParams).toString((IPAddressStringDivisionSeries)this, zone);
    }

    @Override
    public String toNormalizedString(IPStringOptions stringOptions) {
        return IPAddressSection.toNormalizedString(stringOptions, this);
    }

    public static String toNormalizedString(IPStringOptions opts, IPAddressStringDivisionSeries section) {
        return IPAddressSection.toIPParams(opts).toString(section);
    }

    protected static AddressDivisionGrouping.AddressStringParams<IPAddressStringDivisionSeries> toParams(IPStringOptions opts) {
        IPAddressDivisionGrouping.IPAddressStringParams result = (IPAddressDivisionGrouping.IPAddressStringParams)IPAddressSection.getCachedParams(opts);
        if (result == null) {
            result = new IPAddressDivisionGrouping.IPAddressStringParams(opts.base, opts.separator, opts.uppercase);
            result.expandSegments(opts.expandSegments);
            result.setWildcards(opts.wildcards);
            result.setSegmentStrPrefix(opts.segmentStrPrefix);
            result.setAddressLabel(opts.addrLabel);
            result.setReverse(opts.reverse);
            result.setSplitDigits(opts.splitDigits);
            result.setRadix(opts.base);
            result.setUppercase(opts.uppercase);
            result.setSeparator(opts.separator);
            result.setZoneSeparator(opts.zoneSeparator);
            IPAddressSection.setCachedParams(opts, result);
        }
        return result;
    }

    protected static IPAddressDivisionGrouping.IPAddressStringParams<IPAddressStringDivisionSeries> toIPParams(IPStringOptions opts) {
        IPAddressDivisionGrouping.IPAddressStringParams result = (IPAddressDivisionGrouping.IPAddressStringParams)IPAddressSection.getCachedParams(opts);
        if (result == null) {
            result = new IPAddressDivisionGrouping.IPAddressStringParams(opts.base, opts.separator, opts.uppercase);
            result.expandSegments(opts.expandSegments);
            result.setWildcards(opts.wildcards);
            result.setWildcardOption(opts.wildcardOption);
            result.setSegmentStrPrefix(opts.segmentStrPrefix);
            result.setAddressSuffix(opts.addrSuffix);
            result.setAddressLabel(opts.addrLabel);
            result.setReverse(opts.reverse);
            result.setSplitDigits(opts.splitDigits);
            result.setZoneSeparator(opts.zoneSeparator);
            IPAddressSection.setCachedParams(opts, result);
        }
        return result;
    }

    public IPAddressPartStringCollection toStandardStringCollection() {
        return this.toStringCollection(new IPStringBuilderOptions(16));
    }

    public IPAddressPartStringCollection toAllStringCollection() {
        return this.toStringCollection(new IPStringBuilderOptions(48));
    }

    public IPAddressPartStringCollection toDatabaseSearchStringCollection() {
        return this.toStringCollection(new IPStringBuilderOptions());
    }

    public IPAddressStringDivisionSeries[] getParts(IPStringBuilderOptions options) {
        if (options.includes(1)) {
            return new IPAddressStringDivisionSeries[]{this};
        }
        return EMPTY_PARTS;
    }

    public void getStartsWithSQLClause(StringBuilder builder, String expression) {
        this.getStartsWithSQLClause(builder, expression, new MySQLTranslator());
    }

    public void getStartsWithSQLClause(StringBuilder builder, String expression, IPAddressSQLTranslator translator) {
        this.getStartsWithSQLClause(builder, expression, true, translator);
    }

    private void getStartsWithSQLClause(StringBuilder builder, String expression, boolean isFirstCall, IPAddressSQLTranslator translator) {
        if (isFirstCall && this.isMultiple()) {
            Iterator<? extends IPAddressSection> sectionIterator = this.iterator();
            builder.append('(');
            boolean isNotFirst = false;
            while (sectionIterator.hasNext()) {
                if (isNotFirst) {
                    builder.append(" OR ");
                } else {
                    isNotFirst = true;
                }
                IPAddressSection next = sectionIterator.next();
                next.getStartsWithSQLClause(builder, expression, false, translator);
            }
            builder.append(')');
        } else if (this.getSegmentCount() > 0) {
            IPAddressPartStringCollection createdStringCollection = this.toDatabaseSearchStringCollection();
            boolean isNotFirst = false;
            if (createdStringCollection.size() > 1) {
                builder.append('(');
            }
            boolean isEntireAddress = this.isEntireAddress();
            for (IPAddressPartConfiguredString<?, ?> createdStr : createdStringCollection) {
                if (isNotFirst) {
                    builder.append(" OR ");
                } else {
                    isNotFirst = true;
                }
                SQLStringMatcher matcher = createdStr.getNetworkStringMatcher(isEntireAddress, translator);
                matcher.getSQLCondition(builder.append('('), expression).append(')');
            }
            if (createdStringCollection.size() > 1) {
                builder.append(')');
            }
        }
    }

    public static class IPStringBuilderOptions {
        public static final int BASIC = 1;
        public static final int LEADING_ZEROS_FULL_ALL_SEGMENTS = 16;
        public static final int LEADING_ZEROS_FULL_SOME_SEGMENTS = 48;
        public static final int LEADING_ZEROS_PARTIAL_SOME_SEGMENTS = 112;
        public final int options;

        public IPStringBuilderOptions() {
            this(1);
        }

        public IPStringBuilderOptions(int options) {
            this.options = options;
        }

        public boolean includes(int option) {
            return (option & this.options) == option;
        }

        public boolean includesAny(int option) {
            return (option & this.options) != 0;
        }

        public String toString() {
            TreeMap<Integer, String> options = new TreeMap<Integer, String>();
            Field[] fields = this.getClass().getFields();
            Field[] fieldArray = fields;
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                int modifiers = field.getModifiers();
                if (Modifier.isFinal(modifiers) && Modifier.isStatic(modifiers)) {
                    try {
                        int constant = field.getInt(null);
                        String option = String.valueOf(field.getName()) + ": " + this.includes(constant) + System.lineSeparator();
                        options.put(constant, option);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                }
                ++n2;
            }
            Collection values = options.values();
            StringBuilder builder = new StringBuilder();
            for (String val : values) {
                builder.append(val);
            }
            return builder.toString();
        }
    }

    protected static class IPStringCache
    extends AddressDivisionGrouping.StringCache {
        public static final IPStringOptions hexParams;
        public static final IPStringOptions hexPrefixedParams;
        public static final IPStringOptions octalParams;
        public static final IPStringOptions octalPrefixedParams;
        public static final IPStringOptions binaryParams;
        public static final IPStringOptions canonicalSegmentParams;
        public String normalizedWildcardString;
        public String fullString;
        public String sqlWildcardString;
        public String reverseDNSString;
        public String octalStringPrefixed;
        public String octalString;
        public String binaryString;

        static {
            WildcardOptions allWildcards = new WildcardOptions(WildcardOptions.WildcardOption.ALL);
            hexParams = new IPStringOptions.Builder(16).setSeparator(null).setExpandedSegments(true).setWildcardOptions(allWildcards).toOptions();
            hexPrefixedParams = new IPStringOptions.Builder(16).setSeparator(null).setExpandedSegments(true).setWildcardOptions(allWildcards).setAddressLabel("0x").toOptions();
            octalParams = new IPStringOptions.Builder(8).setSeparator(null).setExpandedSegments(true).setWildcardOptions(allWildcards).toOptions();
            octalPrefixedParams = new IPStringOptions.Builder(8).setSeparator(null).setExpandedSegments(true).setWildcardOptions(allWildcards).setAddressLabel("0").toOptions();
            binaryParams = new IPStringOptions.Builder(2).setSeparator(null).setExpandedSegments(true).setWildcardOptions(allWildcards).toOptions();
            canonicalSegmentParams = new IPStringOptions.Builder(10, ' ').toOptions();
        }

        protected IPStringCache() {
        }
    }

    public static class IPStringOptions
    extends AddressDivisionGrouping.StringOptions {
        public final String addrSuffix;
        public final WildcardOptions.WildcardOption wildcardOption;
        public final char zoneSeparator;

        protected IPStringOptions(int base, boolean expandSegments, WildcardOptions.WildcardOption wildcardOption, AddressDivisionGrouping.StringOptions.Wildcards wildcards, String segmentStrPrefix, Character separator, char zoneSeparator, String label, String suffix, boolean reverse, boolean splitDigits, boolean uppercase) {
            super(base, expandSegments, wildcards, segmentStrPrefix, separator, label, reverse, splitDigits, uppercase);
            this.addrSuffix = suffix;
            this.wildcardOption = wildcardOption;
            this.zoneSeparator = zoneSeparator;
        }

        public static class Builder
        extends AddressDivisionGrouping.StringOptions.Builder {
            protected String addrSuffix = "";
            protected WildcardOptions.WildcardOption wildcardOption = WildcardOptions.WildcardOption.NETWORK_ONLY;
            protected char zoneSeparator = (char)37;

            public Builder(int base) {
                this(base, ' ');
            }

            protected Builder(int base, char separator) {
                super(base, separator);
            }

            @Override
            public Builder setWildcards(AddressDivisionGrouping.StringOptions.Wildcards wildcards) {
                return (Builder)super.setWildcards(wildcards);
            }

            public Builder setAddressSuffix(String suffix) {
                this.addrSuffix = suffix;
                return this;
            }

            public Builder setWildcardOptions(WildcardOptions wildcardOptions) {
                this.setWildcardOption(wildcardOptions.wildcardOption);
                return this.setWildcards(wildcardOptions.wildcards);
            }

            public Builder setWildcardOption(WildcardOptions.WildcardOption wildcardOption) {
                this.wildcardOption = wildcardOption;
                return this;
            }

            @Override
            public Builder setReverse(boolean reverse) {
                return (Builder)super.setReverse(reverse);
            }

            @Override
            public Builder setUppercase(boolean uppercase) {
                return (Builder)super.setUppercase(uppercase);
            }

            @Override
            public Builder setSplitDigits(boolean splitDigits) {
                return (Builder)super.setSplitDigits(splitDigits);
            }

            @Override
            public Builder setExpandedSegments(boolean expandSegments) {
                return (Builder)super.setExpandedSegments(expandSegments);
            }

            @Override
            public Builder setRadix(int base) {
                return (Builder)super.setRadix(base);
            }

            @Override
            public Builder setSeparator(Character separator) {
                return (Builder)super.setSeparator(separator);
            }

            public Builder setZoneSeparator(char separator) {
                this.zoneSeparator = separator;
                return this;
            }

            @Override
            public Builder setAddressLabel(String label) {
                return (Builder)super.setAddressLabel(label);
            }

            @Override
            public Builder setSegmentStrPrefix(String prefix) {
                return (Builder)super.setSegmentStrPrefix(prefix);
            }

            @Override
            public IPStringOptions toOptions() {
                return new IPStringOptions(this.base, this.expandSegments, this.wildcardOption, this.wildcards, this.segmentStrPrefix, this.separator, this.zoneSeparator, this.addrLabel, this.addrSuffix, this.reverse, this.splitDigits, this.uppercase);
            }
        }
    }

    protected static class PrefixCache {
        private Integer networkMaskPrefixLen;
        private Integer hostMaskPrefixLen;
        private Integer cachedMinPrefix;
        private Integer cachedEquivalentPrefix;

        protected PrefixCache() {
        }
    }

    @FunctionalInterface
    public static interface SegFunction<R, S> {
        public S apply(R var1, int var2);
    }

    public static class WildcardOptions {
        public final WildcardOption wildcardOption;
        public final AddressDivisionGrouping.StringOptions.Wildcards wildcards;

        public WildcardOptions() {
            this(WildcardOption.NETWORK_ONLY);
        }

        public WildcardOptions(WildcardOption wildcardOption) {
            this(wildcardOption, new AddressDivisionGrouping.StringOptions.Wildcards());
        }

        public WildcardOptions(WildcardOption wildcardOption, AddressDivisionGrouping.StringOptions.Wildcards wildcards) {
            this.wildcardOption = wildcardOption;
            this.wildcards = wildcards;
        }

        public static enum WildcardOption {
            NETWORK_ONLY,
            ALL;

        }
    }
}

