/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr;

import inet.ipaddr.Address;
import inet.ipaddr.AddressConversionException;
import inet.ipaddr.AddressNetwork;
import inet.ipaddr.AddressSection;
import inet.ipaddr.HostIdentifierString;
import inet.ipaddr.HostName;
import inet.ipaddr.IPAddressConverter;
import inet.ipaddr.IPAddressNetwork;
import inet.ipaddr.IPAddressSection;
import inet.ipaddr.IPAddressSegment;
import inet.ipaddr.IPAddressSegmentSeries;
import inet.ipaddr.IPAddressString;
import inet.ipaddr.IPAddressStringParameters;
import inet.ipaddr.IncompatibleAddressException;
import inet.ipaddr.PrefixLenException;
import inet.ipaddr.format.IPAddressStringDivisionSeries;
import inet.ipaddr.format.util.IPAddressPartStringCollection;
import inet.ipaddr.format.util.sql.IPAddressSQLTranslator;
import inet.ipaddr.format.validate.IPAddressProvider;
import inet.ipaddr.format.validate.ParsedAddressGrouping;
import inet.ipaddr.format.validate.ParsedHost;
import inet.ipaddr.ipv4.IPv4Address;
import inet.ipaddr.ipv6.IPv6Address;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.UnaryOperator;

public abstract class IPAddress
extends Address
implements IPAddressSegmentSeries {
    private static final long serialVersionUID = 4L;
    public static final char PREFIX_LEN_SEPARATOR = '/';
    public static final IPAddressConverter DEFAULT_ADDRESS_CONVERTER = new IPAddressConverter.DefaultAddressConverter();
    HostName fromHost;
    private HostName canonicalHost;

    protected IPAddress(IPAddressSection section) {
        super(section);
    }

    protected IPAddress(Function<Address, AddressSection> supplier) {
        super(supplier);
    }

    public HostName toHostName() {
        HostName host = this.fromHost;
        if (host == null) {
            this.fromHost = host = this.toCanonicalHostName();
        }
        return host;
    }

    void cache(HostIdentifierString string) {
        if (string instanceof HostName) {
            this.fromHost = (HostName)string;
        } else if (string instanceof IPAddressString) {
            this.fromString = (IPAddressString)string;
        }
    }

    protected IPAddressProvider getProvider() {
        if (this.isPrefixed()) {
            if (this.getNetwork().getPrefixConfiguration().prefixedSubnetsAreExplicit() || !this.isPrefixBlock()) {
                return IPAddressProvider.getProviderFor(this, this.removePrefixLength(false));
            }
            return IPAddressProvider.getProviderFor(this, this.toZeroHost());
        }
        return IPAddressProvider.getProviderFor(this, this);
    }

    public HostName toCanonicalHostName() {
        HostName host = this.canonicalHost;
        if (host == null) {
            if (this.isMultiple()) {
                throw new IncompatibleAddressException(this, "ipaddress.error.unavailable.numeric");
            }
            InetAddress inetAddress = this.toInetAddress();
            String hostStr = inetAddress.getCanonicalHostName();
            if (hostStr.equals(inetAddress.getHostAddress())) {
                host = new HostName(hostStr, new ParsedHost(hostStr, this.getProvider()));
                host.resolvedAddress = this;
            } else {
                host = new HostName(hostStr);
            }
        }
        return host;
    }

    @Override
    public abstract IPAddressNetwork<?, ?, ?, ?, ?> getNetwork();

    @Override
    public IPAddressSection getSection() {
        return (IPAddressSection)super.getSection();
    }

    @Override
    public IPAddressSection getSection(int index) {
        return this.getSection().getSection(index);
    }

    @Override
    public IPAddressSection getSection(int index, int endIndex) {
        return this.getSection().getSection(index, endIndex);
    }

    public IPAddressStringDivisionSeries[] getParts(IPAddressSection.IPStringBuilderOptions options) {
        return new IPAddressStringDivisionSeries[]{this.getSection()};
    }

    @Override
    public int getMaxSegmentValue() {
        return IPAddressSegment.getMaxSegmentValue(this.getIPVersion());
    }

    static int getMaxSegmentValue(IPVersion version) {
        return IPAddressSegment.getMaxSegmentValue(version);
    }

    @Override
    public BigInteger getNonZeroHostCount() {
        return this.getSection().getNonZeroHostCount();
    }

    @Override
    public int getBytesPerSegment() {
        return IPAddressSegment.getByteCount(this.getIPVersion());
    }

    static int getBytesPerSegment(IPVersion version) {
        return IPAddressSegment.getByteCount(version);
    }

    @Override
    public int getBitsPerSegment() {
        return IPAddressSegment.getBitCount(this.getIPVersion());
    }

    static int getBitsPerSegment(IPVersion version) {
        return IPAddressSegment.getBitCount(version);
    }

    @Override
    public int getByteCount() {
        return this.getSection().getByteCount();
    }

    public static int getByteCount(IPVersion version) {
        return version.isIPv4() ? 4 : 16;
    }

    public static int getSegmentCount(IPVersion version) {
        return version.isIPv4() ? 4 : 8;
    }

    public static int getBitCount(IPVersion version) {
        return version.isIPv4() ? 32 : 128;
    }

    @Override
    public abstract IPAddress getLowerNonZeroHost();

    @Override
    public abstract IPAddress getLower();

    @Override
    public abstract IPAddress getUpper();

    @Override
    public abstract IPAddress reverseBits(boolean var1);

    @Override
    public abstract IPAddress reverseBytes();

    @Override
    public abstract IPAddress reverseBytesPerSegment();

    @Override
    public abstract IPAddress reverseSegments();

    public abstract Iterator<? extends IPAddress> iterator();

    public abstract Iterator<? extends IPAddress> nonZeroHostIterator();

    public abstract Iterator<? extends IPAddress> prefixBlockIterator();

    public abstract Iterable<? extends IPAddress> getIterable();

    @Override
    public abstract IPAddress increment(long var1);

    @Override
    public abstract IPAddress incrementBoundary(long var1);

    public boolean isIPv4() {
        return this.getSection().isIPv4();
    }

    public boolean isIPv6() {
        return this.getSection().isIPv6();
    }

    @Override
    public IPVersion getIPVersion() {
        return this.getSection().getIPVersion();
    }

    public IPv4Address toIPv4() {
        return null;
    }

    public IPv6Address toIPv6() {
        return null;
    }

    public abstract boolean isIPv4Convertible();

    public abstract boolean isIPv6Convertible();

    public abstract boolean isLinkLocal();

    @Override
    public abstract boolean isLocal();

    public boolean isUnspecified() {
        return this.isZero();
    }

    public boolean isAnyLocal() {
        return this.isZero();
    }

    public abstract boolean isLoopback();

    public InetAddress toUpperInetAddress() {
        return this.getSection().toUpperInetAddress(this);
    }

    public InetAddress toInetAddress() {
        return this.getSection().toInetAddress(this);
    }

    protected InetAddress toInetAddressImpl(byte[] bytes) {
        try {
            return InetAddress.getByAddress(bytes);
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    public boolean matches(IPAddressString otherString) {
        if (this.isFromSameString(otherString)) {
            return true;
        }
        IPAddress otherAddr = otherString.getAddress();
        return otherAddr != null && this.isSameAddress(otherAddr);
    }

    @Override
    protected boolean isFromSameString(HostIdentifierString other) {
        if (this.fromString != null && other instanceof IPAddressString) {
            IPAddressString fromString = (IPAddressString)this.fromString;
            IPAddressString otherString = (IPAddressString)other;
            return fromString == otherString || fromString.fullAddr.equals(otherString.fullAddr) && Objects.equals(fromString.validationOptions, otherString.validationOptions);
        }
        return false;
    }

    public boolean isSameAddress(IPAddress other) {
        return other == this || this.getSection().equals(other.getSection());
    }

    public boolean matchesWithMask(IPAddress other, IPAddress mask) {
        return this.getSection().matchesWithMask(other.getSection(), mask.getSection());
    }

    @Override
    public boolean contains(Address other) {
        if (other == this) {
            return true;
        }
        return this.getSection().contains(other.getSection());
    }

    protected static String toNormalizedString(AddressNetwork.PrefixConfiguration prefixConfiguration, Address.SegmentValueProvider lowerValueProvider, Address.SegmentValueProvider upperValueProvider, Integer prefixLength, int segmentCount, int bytesPerSegment, int bitsPerSegment, int segmentMaxValue, char separator, int radix, CharSequence zone) {
        int length = IPAddress.toNormalizedString(prefixConfiguration, lowerValueProvider, upperValueProvider, prefixLength, segmentCount, bytesPerSegment, bitsPerSegment, segmentMaxValue, separator, radix, zone, null);
        StringBuilder builder = new StringBuilder(length);
        IPAddress.toNormalizedString(prefixConfiguration, lowerValueProvider, upperValueProvider, prefixLength, segmentCount, bytesPerSegment, bitsPerSegment, segmentMaxValue, separator, radix, zone, builder);
        IPAddressSection.checkLengths(length, builder);
        return builder.toString();
    }

    private static int toNormalizedString(AddressNetwork.PrefixConfiguration prefixConfiguration, Address.SegmentValueProvider lowerValueProvider, Address.SegmentValueProvider upperValueProvider, Integer prefixLength, int segmentCount, int bytesPerSegment, int bitsPerSegment, int segmentMaxValue, char separator, int radix, CharSequence zone, StringBuilder builder) {
        int count = 0;
        int segmentIndex = 0;
        boolean isPrefixSubnet = ParsedAddressGrouping.isPrefixSubnet(lowerValueProvider, upperValueProvider, segmentCount, bytesPerSegment, bitsPerSegment, segmentMaxValue, prefixLength, prefixConfiguration, false);
        while (true) {
            Integer segmentPrefixLength = IPAddressSection.getSegmentPrefixLength(bitsPerSegment, prefixLength, segmentIndex);
            if (isPrefixSubnet && segmentPrefixLength != null && segmentPrefixLength == 0) {
                if (builder == null) {
                    ++count;
                } else {
                    builder.append('0');
                }
            } else {
                int value = 0;
                int value2 = 0;
                if (lowerValueProvider == null) {
                    value = upperValueProvider.getValue(segmentIndex);
                } else {
                    value = lowerValueProvider.getValue(segmentIndex);
                    if (upperValueProvider != null) {
                        value2 = upperValueProvider.getValue(segmentIndex);
                    }
                }
                if (lowerValueProvider == null || upperValueProvider == null) {
                    if (isPrefixSubnet && segmentPrefixLength != null) {
                        value &= -1 << bitsPerSegment - segmentPrefixLength;
                    }
                    if (builder == null) {
                        count += IPAddressSegment.toUnsignedStringLength(value, radix);
                    } else {
                        IPAddressSegment.toUnsignedString(value, radix, builder);
                    }
                } else {
                    if (isPrefixSubnet && segmentPrefixLength != null) {
                        int mask = -1 << bitsPerSegment - segmentPrefixLength;
                        value &= mask;
                        value2 &= mask;
                    }
                    if (value == value2) {
                        if (builder == null) {
                            count += IPAddressSegment.toUnsignedStringLength(value, radix);
                        } else {
                            IPAddressSegment.toUnsignedString(value, radix, builder);
                        }
                    } else {
                        if (value > value2) {
                            int tmp = value2;
                            value2 = value;
                            value = tmp;
                        }
                        if (value == 0 && value2 == segmentMaxValue) {
                            if (builder == null) {
                                count += SEGMENT_WILDCARD_STR.length();
                            } else {
                                builder.append(SEGMENT_WILDCARD_STR);
                            }
                        } else if (builder == null) {
                            count += IPAddressSegment.toUnsignedStringLength(value, radix) + IPAddressSegment.toUnsignedStringLength(value2, radix) + RANGE_SEPARATOR_STR.length();
                        } else {
                            IPAddressSegment.toUnsignedString(value2, radix, IPAddressSegment.toUnsignedString(value, radix, builder).append(RANGE_SEPARATOR_STR));
                        }
                    }
                }
            }
            if (++segmentIndex >= segmentCount) break;
            if (builder == null) continue;
            builder.append(separator);
        }
        if (builder == null) {
            count += segmentCount - 1;
        }
        if (zone != null && zone.length() > 0) {
            if (builder == null) {
                count += zone.length() + 1;
            } else {
                builder.append('%').append(zone);
            }
        }
        if (prefixLength != null) {
            if (builder == null) {
                count += IPAddressSegment.toUnsignedStringLength(prefixLength, 10) + 1;
            } else {
                builder.append('/').append(prefixLength);
            }
        }
        return count;
    }

    @Override
    public String toFullString() {
        return this.getSection().toFullString();
    }

    protected void cacheNormalizedString(String str) {
        this.getSection().cacheNormalizedString(str);
    }

    @Override
    public String toSubnetString() {
        return this.getSection().toSubnetString();
    }

    @Override
    public String toNormalizedWildcardString() {
        return this.getSection().toNormalizedWildcardString();
    }

    @Override
    public String toCanonicalWildcardString() {
        return this.getSection().toCanonicalWildcardString();
    }

    @Override
    public String toCompressedWildcardString() {
        return this.getSection().toCompressedWildcardString();
    }

    @Override
    public String toSQLWildcardString() {
        return this.getSection().toSQLWildcardString();
    }

    @Override
    public String toPrefixLengthString() {
        return this.getSection().toPrefixLengthString();
    }

    public String toConvertedString() {
        return this.toNormalizedString();
    }

    public abstract String toUNCHostName();

    @Override
    public String toReverseDNSLookupString() {
        return this.getSection().toReverseDNSLookupString();
    }

    @Override
    public String toBinaryString() {
        return this.getSection().toBinaryString();
    }

    @Override
    public String toOctalString(boolean with0Prefix) {
        return this.getSection().toOctalString(with0Prefix);
    }

    @Override
    public String toNormalizedString(IPAddressSection.IPStringOptions params) {
        return this.getSection().toNormalizedString(params);
    }

    public String[] toStandardStrings() {
        return this.toStandardStringCollection().toStrings();
    }

    public String[] toAllStrings() {
        return this.toAllStringCollection().toStrings();
    }

    public String[] toStrings(IPAddressSection.IPStringBuilderOptions options) {
        return this.toStringCollection(options).toStrings();
    }

    public IPAddressPartStringCollection toStandardStringCollection() {
        return this.getSection().toStandardStringCollection();
    }

    public IPAddressPartStringCollection toAllStringCollection() {
        return this.getSection().toAllStringCollection();
    }

    @Override
    public IPAddressPartStringCollection toStringCollection(IPAddressSection.IPStringBuilderOptions options) {
        return this.getSection().toStringCollection(options);
    }

    @Override
    public IPAddressString toAddressString() {
        if (this.fromString == null) {
            IPAddressStringParameters params = this.createFromStringParams();
            this.fromString = new IPAddressString(this, params);
        }
        return this.getAddressfromString();
    }

    protected abstract IPAddressStringParameters createFromStringParams();

    protected IPAddressString getAddressfromString() {
        return (IPAddressString)this.fromString;
    }

    public static String toDelimitedSQLStrs(String[] strs) {
        if (strs.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        String[] stringArray = strs;
        int n = strs.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            builder.append('\'').append(str).append('\'').append(',');
            ++n2;
        }
        return builder.substring(0, builder.length() - 1);
    }

    @Override
    public Integer getNetworkPrefixLength() {
        return this.getSection().getNetworkPrefixLength();
    }

    @Override
    public boolean includesZeroHost() {
        return this.getSection().includesZeroHost();
    }

    @Override
    public boolean includesZeroHost(int networkPrefixLength) {
        return this.getSection().includesZeroHost(networkPrefixLength);
    }

    @Override
    public abstract IPAddress toZeroHost(int var1);

    @Override
    public abstract IPAddress toZeroHost();

    @Override
    public abstract IPAddress toMaxHost(int var1);

    @Override
    public abstract IPAddress toMaxHost();

    @Override
    public boolean includesMaxHost() {
        return this.getSection().includesMaxHost();
    }

    @Override
    public boolean includesMaxHost(int networkPrefixLength) {
        return this.getSection().includesMaxHost(networkPrefixLength);
    }

    public boolean isSingleNetwork() {
        return this.getSection().isSingleNetwork();
    }

    protected static <T extends IPAddress> T[] getSpanningPrefixBlocks(T first, T other, UnaryOperator<T> getLower, UnaryOperator<T> getUpper, Comparator<T> comparator, Function<T, T> prefixRemover, IntFunction<T[]> arrayProducer) {
        boolean f = first.contains(other);
        if (f || other.contains((Address)first)) {
            if (!f) {
                T tmp = first;
                first = other;
                other = tmp;
            }
            if (first.isPrefixed() && first.getPrefixLength().intValue() == first.getBitCount()) {
                first = (IPAddress)prefixRemover.apply(first);
            }
            IPAddress[] result = (IPAddress[])arrayProducer.apply(1);
            result[0] = first;
            return result;
        }
        ArrayList<IPAddressSegmentSeries> blocks = new ArrayList<IPAddressSegmentSeries>();
        IPAddressSection.getSpanningSeriesPrefixBlocks(first, other, getLower, getUpper, comparator, prefixRemover, blocks);
        return blocks.toArray((IPAddress[])arrayProducer.apply(blocks.size()));
    }

    @Override
    public abstract IPAddress toPrefixBlock();

    @Override
    public abstract IPAddress toPrefixBlock(int var1) throws PrefixLenException;

    @Override
    public IPAddress assignPrefixForSingleBlock() {
        Integer newPrefix = this.getPrefixLengthForSingleBlock();
        return newPrefix == null ? null : this.setPrefixLength(newPrefix, false);
    }

    @Override
    public IPAddress assignMinPrefixForBlock() {
        return this.setPrefixLength(this.getMinPrefixLengthForBlock(), false);
    }

    public Integer getBlockMaskPrefixLength(boolean network) {
        return this.getSection().getBlockMaskPrefixLength(network);
    }

    public abstract IPAddress[] spanWithPrefixBlocks(IPAddress var1) throws AddressConversionException;

    public abstract IPAddress[] mergePrefixBlocks(IPAddress ... var1) throws AddressConversionException;

    protected static List<IPAddressSegmentSeries> getMergedBlocks(IPAddressSegmentSeries first, IPAddressSegmentSeries[] sections) {
        return IPAddressSection.getMergedBlocks(first, sections, false);
    }

    public abstract IPAddress intersect(IPAddress var1) throws AddressConversionException;

    public abstract IPAddress[] subtract(IPAddress var1) throws AddressConversionException;

    public abstract IPAddress mask(IPAddress var1) throws AddressConversionException, IncompatibleAddressException;

    public abstract IPAddress mask(IPAddress var1, boolean var2) throws AddressConversionException, IncompatibleAddressException;

    public abstract IPAddress maskNetwork(IPAddress var1, int var2) throws AddressConversionException, IncompatibleAddressException;

    public abstract IPAddress bitwiseOr(IPAddress var1) throws AddressConversionException, IncompatibleAddressException;

    public abstract IPAddress bitwiseOr(IPAddress var1, boolean var2) throws AddressConversionException, IncompatibleAddressException;

    public abstract IPAddress bitwiseOrNetwork(IPAddress var1, int var2) throws AddressConversionException, IncompatibleAddressException;

    @Override
    public abstract IPAddress removePrefixLength();

    @Override
    public abstract IPAddress removePrefixLength(boolean var1);

    @Override
    public abstract IPAddress adjustPrefixBySegment(boolean var1);

    @Override
    public abstract IPAddress adjustPrefixBySegment(boolean var1, boolean var2);

    @Override
    public abstract IPAddress adjustPrefixLength(int var1);

    @Override
    public abstract IPAddress adjustPrefixLength(int var1, boolean var2);

    @Override
    public abstract IPAddress setPrefixLength(int var1);

    @Override
    public abstract IPAddress setPrefixLength(int var1, boolean var2);

    @Override
    public abstract IPAddress applyPrefixLength(int var1);

    public void getMatchesSQLClause(StringBuilder builder, String sqlExpression) {
        this.getSection().getStartsWithSQLClause(builder, sqlExpression);
    }

    public void getMatchesSQLClause(StringBuilder builder, String sqlExpression, IPAddressSQLTranslator translator) {
        this.getSection().getStartsWithSQLClause(builder, sqlExpression, translator);
    }

    public static enum IPVersion {
        IPV4,
        IPV6;


        public boolean isIPv4() {
            return this == IPV4;
        }

        public boolean isIPv6() {
            return this == IPV6;
        }
    }
}

