/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.format.validate;

import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressStringParameters;
import inet.ipaddr.format.validate.ParsedIPAddress;
import java.io.Serializable;

class ParsedHostIdentifierStringQualifier
implements Serializable {
    private static final long serialVersionUID = 4L;
    private final Integer networkPrefixLength;
    private final Integer port;
    private final ParsedIPAddress mask;
    private final CharSequence zone;

    ParsedHostIdentifierStringQualifier() {
        this(null, null, null, null);
    }

    ParsedHostIdentifierStringQualifier(Integer networkPrefixLength, Integer port) {
        this(networkPrefixLength, null, null, port);
    }

    ParsedHostIdentifierStringQualifier(ParsedIPAddress mask) {
        this(null, mask, null, null);
    }

    ParsedHostIdentifierStringQualifier(CharSequence zone) {
        this(null, null, zone, null);
    }

    private ParsedHostIdentifierStringQualifier(Integer networkPrefixLength, ParsedIPAddress mask, CharSequence zone, Integer port) {
        this.networkPrefixLength = networkPrefixLength;
        this.mask = mask;
        this.zone = zone;
        this.port = port;
    }

    IPAddress getMask() {
        if (this.mask != null) {
            return this.mask.createAddresses().getAddress();
        }
        return null;
    }

    CharSequence getZone() {
        return this.zone;
    }

    Integer getNetworkPrefixLength() {
        return this.networkPrefixLength;
    }

    Integer getPort() {
        return this.port;
    }

    IPAddress.IPVersion inferVersion(IPAddressStringParameters validationOptions) {
        if (this.networkPrefixLength != null) {
            if (this.networkPrefixLength > IPAddress.getBitCount(IPAddress.IPVersion.IPV4) && !validationOptions.getIPv4Parameters().allowPrefixesBeyondAddressSize) {
                return IPAddress.IPVersion.IPV6;
            }
        } else if (this.mask != null) {
            if (this.mask.isIPv6()) {
                return IPAddress.IPVersion.IPV6;
            }
            if (this.mask.isIPv4()) {
                return IPAddress.IPVersion.IPV4;
            }
        } else if (this.zone != null) {
            return IPAddress.IPVersion.IPV6;
        }
        return null;
    }

    public String toString() {
        return "network prefix length: " + this.networkPrefixLength + " mask: " + this.mask + " zone: " + this.zone + " port: " + this.port;
    }
}

