/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.format;

import inet.ipaddr.IPAddress;
import inet.ipaddr.PrefixLenException;
import inet.ipaddr.format.AddressDivision;
import inet.ipaddr.format.AddressItem;
import inet.ipaddr.format.IPAddressStringDivision;
import inet.ipaddr.format.util.AddressSegmentParams;

public abstract class IPAddressDivision
extends AddressDivision
implements IPAddressStringDivision {
    private static final long serialVersionUID = 4L;
    private final Integer divisionNetworkPrefix;
    protected transient String cachedWildcardString;
    private transient Boolean isSinglePrefixBlock;

    protected IPAddressDivision() {
        this(null);
    }

    protected IPAddressDivision(Integer networkPrefixLength) {
        if (networkPrefixLength != null && networkPrefixLength < 0) {
            throw new PrefixLenException(networkPrefixLength);
        }
        this.divisionNetworkPrefix = networkPrefixLength;
    }

    public boolean isPrefixed() {
        return this.divisionNetworkPrefix != null;
    }

    @Override
    public Integer getDivisionPrefixLength() {
        return this.divisionNetworkPrefix;
    }

    public boolean matchesWithPrefixMask(long value, Integer divisionPrefixLen) {
        if (divisionPrefixLen == null) {
            return this.matches(value);
        }
        long mask = this.getDivisionNetworkMask(divisionPrefixLen);
        long matchingValue = value & mask;
        return matchingValue == (this.getLowerValue() & mask) && matchingValue == (this.getUpperValue() & mask);
    }

    protected abstract long getDivisionNetworkMask(int var1);

    protected abstract long getDivisionHostMask(int var1);

    public Integer getBlockMaskPrefixLength(boolean network) {
        long invertedVal;
        long val;
        if (network) {
            val = this.getLowerValue();
            invertedVal = (val ^ 0xFFFFFFFFFFFFFFFFL) & this.getMaxValue();
        } else {
            invertedVal = this.getLowerValue();
            val = (invertedVal ^ 0xFFFFFFFFFFFFFFFFL) & this.getMaxValue();
        }
        int bitCount = this.getBitCount();
        int hostLength = Math.min(Long.numberOfTrailingZeros(val), bitCount);
        long shifted = invertedVal >>> hostLength;
        return shifted == 0L ? Integer.valueOf(bitCount - hostLength) : null;
    }

    private static boolean testRange(long lowerValue, long upperValue, long finalUpperValue, long networkMask, long hostMask) {
        return lowerValue == (lowerValue & networkMask) && finalUpperValue == (upperValue | hostMask);
    }

    private boolean isPrefixBlock(long segmentValue, long upperValue, Integer divisionPrefixLen) {
        if (divisionPrefixLen == null) {
            return false;
        }
        if (divisionPrefixLen == 0) {
            return this.isFullRange();
        }
        return IPAddressDivision.testRange(segmentValue, upperValue, upperValue, this.getDivisionNetworkMask(divisionPrefixLen), this.getDivisionHostMask(divisionPrefixLen));
    }

    private boolean isSinglePrefixBlock(long segmentValue, long upperValue, Integer divisionPrefixLen) {
        if (divisionPrefixLen == null) {
            return false;
        }
        return IPAddressDivision.testRange(segmentValue, segmentValue, upperValue, this.getDivisionNetworkMask(divisionPrefixLen), this.getDivisionHostMask(divisionPrefixLen));
    }

    boolean isSinglePrefixBlock(long segmentValue, Integer divisionPrefixLen) {
        return this.isSinglePrefixBlock(segmentValue, this.getUpperValue(), divisionPrefixLen);
    }

    @Override
    public boolean isPrefixBlock(Integer divisionPrefixLen) {
        return this.isPrefixBlock(this.getLowerValue(), this.getUpperValue(), divisionPrefixLen);
    }

    public boolean isPrefixBlock() {
        return this.isPrefixBlock(this.getDivisionPrefixLength());
    }

    public boolean isSinglePrefixBlock(Integer divisionPrefixLen) {
        return this.isSinglePrefixBlock(this.getLowerValue(), this.getUpperValue(), divisionPrefixLen);
    }

    @Override
    public boolean isSinglePrefixBlock() {
        if (this.isSinglePrefixBlock == null) {
            this.isSinglePrefixBlock = this.isSinglePrefixBlock(this.getDivisionPrefixLength());
        }
        return this.isSinglePrefixBlock;
    }

    protected boolean isBitwiseOrCompatibleWithRange(long maskValue, Integer divisionPrefixLen, boolean isAutoSubnets) {
        boolean differingIsLowestBit;
        int divPrefLen;
        boolean hasBits;
        boolean bl = hasBits = divisionPrefixLen != null;
        if (hasBits) {
            divPrefLen = divisionPrefixLen;
            if (divPrefLen < 0 || divPrefLen > this.getBitCount()) {
                throw new PrefixLenException((AddressItem)this, divisionPrefixLen);
            }
        } else {
            divPrefLen = this.getBitCount();
        }
        if (!this.isMultiple() || maskValue == this.getMaxValue() || maskValue == 0L) {
            return true;
        }
        long networkMask = 0L;
        if (isAutoSubnets) {
            networkMask = this.getDivisionNetworkMask(divPrefLen);
            if (hasBits && (networkMask & maskValue) == networkMask) {
                return true;
            }
        }
        long value = this.getLowerValue();
        long upperValue = this.getUpperValue();
        long differing = value ^ upperValue;
        if (isAutoSubnets) {
            differing &= networkMask;
        }
        boolean foundDiffering = differing != 0L;
        boolean bl2 = differingIsLowestBit = differing == 1L;
        if (foundDiffering && !differingIsLowestBit) {
            int highestDifferingBitInRange = Long.numberOfLeadingZeros(differing);
            long maskMask = -1L >>> highestDifferingBitInRange;
            long differingMasked = maskValue & maskMask;
            foundDiffering = differingMasked != maskMask;
            boolean bl3 = differingIsLowestBit = (differingMasked | 1L) == maskMask;
            if (foundDiffering && !differingIsLowestBit) {
                int highestDifferingBitMasked = Long.numberOfLeadingZeros((differingMasked ^ 0xFFFFFFFFFFFFFFFFL) & maskMask);
                long hostMask = -1L >>> highestDifferingBitMasked + 1;
                if (isAutoSubnets) {
                    maskValue &= this.getDivisionNetworkMask(divPrefLen);
                }
                if ((maskValue & hostMask) != 0L) {
                    return false;
                }
            }
        }
        return true;
    }

    protected boolean isMaskCompatibleWithRange(long maskValue, Integer divisionPrefixLen, boolean isAutoSubnets) {
        boolean differingIsLowestBit;
        int divPrefLen;
        boolean hasBits;
        boolean bl = hasBits = divisionPrefixLen != null;
        if (hasBits) {
            divPrefLen = divisionPrefixLen;
            if (divPrefLen < 0 || divPrefLen > this.getBitCount()) {
                throw new PrefixLenException((AddressItem)this, divisionPrefixLen);
            }
        } else {
            divPrefLen = this.getBitCount();
        }
        if (!this.isMultiple() || maskValue == this.getMaxValue() || maskValue == 0L) {
            return true;
        }
        long networkMask = 0L;
        if (isAutoSubnets) {
            networkMask = this.getDivisionNetworkMask(divPrefLen);
            if (hasBits && (networkMask & maskValue) == 0L) {
                return true;
            }
        }
        long value = this.getLowerValue();
        long upperValue = this.getUpperValue();
        long differing = value ^ upperValue;
        if (isAutoSubnets) {
            differing &= networkMask;
        }
        boolean foundDiffering = differing != 0L;
        boolean bl2 = differingIsLowestBit = differing == 1L;
        if (foundDiffering && !differingIsLowestBit) {
            int highestDifferingBitInRange = Long.numberOfLeadingZeros(differing);
            long maskMask = -1L >>> highestDifferingBitInRange;
            long differingMasked = maskValue & maskMask;
            foundDiffering = differingMasked != 0L;
            boolean bl3 = differingIsLowestBit = differingMasked == 1L;
            if (foundDiffering && !differingIsLowestBit) {
                int highestDifferingBitMasked = Long.numberOfLeadingZeros(differingMasked);
                long hostMask = -1L >>> highestDifferingBitMasked + 1;
                if (isAutoSubnets) {
                    maskValue |= this.getDivisionHostMask(divPrefLen);
                }
                if ((maskValue & hostMask) != hostMask) {
                    return false;
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getString() {
        String result = this.cachedString;
        if (result == null) {
            IPAddressDivision iPAddressDivision = this;
            synchronized (iPAddressDivision) {
                result = this.cachedString;
                if (result == null) {
                    if (this.isSinglePrefixBlock() || !this.isMultiple()) {
                        result = this.getDefaultString();
                    } else if (this.isFullRange()) {
                        result = IPAddress.SEGMENT_WILDCARD_STR;
                    } else {
                        long upperValue = this.getUpperValue();
                        if (this.isPrefixBlock()) {
                            upperValue &= this.getDivisionNetworkMask(this.getDivisionPrefixLength());
                        }
                        result = this.getDefaultRangeString(this.getLowerValue(), upperValue, this.getDefaultTextualRadix());
                    }
                    this.cachedString = result;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getWildcardString() {
        String result = this.cachedWildcardString;
        if (result == null) {
            IPAddressDivision iPAddressDivision = this;
            synchronized (iPAddressDivision) {
                result = this.cachedWildcardString;
                if (result == null) {
                    result = !this.isPrefixed() || !this.isMultiple() ? this.getString() : (this.isFullRange() ? IPAddress.SEGMENT_WILDCARD_STR : this.getDefaultRangeString());
                    this.cachedWildcardString = result;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void setDefaultAsFullRangeWildcardString() {
        if (this.cachedWildcardString == null) {
            IPAddressDivision iPAddressDivision = this;
            synchronized (iPAddressDivision) {
                this.cachedWildcardString = IPAddress.SEGMENT_WILDCARD_STR;
            }
        }
    }

    @Override
    protected void getUpperStringMasked(int radix, boolean uppercase, StringBuilder appendable) {
        long upperValue = this.getUpperValue();
        long mask = this.getDivisionNetworkMask(this.getDivisionPrefixLength());
        IPAddressDivision.toUnsignedString(upperValue &= mask, radix, 0, uppercase, uppercase ? UPPERCASE_DIGITS : DIGITS, appendable);
    }

    @Override
    public int getPrefixAdjustedRangeString(int segmentIndex, AddressSegmentParams params, StringBuilder appendable) {
        return super.getPrefixAdjustedRangeString(segmentIndex, params, appendable);
    }
}

