/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.ipv6;

import inet.ipaddr.Address;
import inet.ipaddr.AddressNetwork;
import inet.ipaddr.AddressSection;
import inet.ipaddr.AddressSegment;
import inet.ipaddr.AddressTypeException;
import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressConverter;
import inet.ipaddr.IPAddressSection;
import inet.ipaddr.IPAddressSegment;
import inet.ipaddr.IPAddressTypeNetwork;
import inet.ipaddr.format.AddressCreator;
import inet.ipaddr.format.AddressDivisionBase;
import inet.ipaddr.format.AddressDivisionGrouping;
import inet.ipaddr.format.AddressLargeDivision;
import inet.ipaddr.format.AddressStringDivision;
import inet.ipaddr.format.IPAddressBitsDivision;
import inet.ipaddr.format.IPAddressDivision;
import inet.ipaddr.format.IPAddressDivisionGrouping;
import inet.ipaddr.format.IPAddressStringDivisionGrouping;
import inet.ipaddr.format.IPAddressStringDivisionSeries;
import inet.ipaddr.format.util.IPAddressPartConfiguredString;
import inet.ipaddr.format.util.IPAddressPartStringCollection;
import inet.ipaddr.format.util.IPAddressPartStringSubCollection;
import inet.ipaddr.format.util.IPAddressStringWriter;
import inet.ipaddr.format.util.sql.IPAddressSQLTranslator;
import inet.ipaddr.format.util.sql.SQLStringMatcher;
import inet.ipaddr.ipv4.IPv4Address;
import inet.ipaddr.ipv4.IPv4AddressNetwork;
import inet.ipaddr.ipv4.IPv4AddressSection;
import inet.ipaddr.ipv6.IPv6Address;
import inet.ipaddr.ipv6.IPv6AddressNetwork;
import inet.ipaddr.ipv6.IPv6AddressSegment;
import inet.ipaddr.mac.MACAddress;
import inet.ipaddr.mac.MACAddressNetwork;
import inet.ipaddr.mac.MACAddressSection;
import inet.ipaddr.mac.MACAddressSegment;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class IPv6AddressSection
extends IPAddressSection
implements Iterable<IPv6AddressSection> {
    private static final long serialVersionUID = 3L;
    private static IPv6AddressNetwork.IPv6AddressCreator[] creators = new IPv6AddressNetwork.IPv6AddressCreator[9];
    public static final IPv6AddressSection LINK_LOCAL_PREFIX = IPv6AddressSection.getAddressCreator(0).createSection(new IPv6AddressSegment[]{IPv6AddressSection.getIPv6SegmentCreator().createSegment(65152), IPv6AddressSegment.ZERO_SEGMENT, IPv6AddressSegment.ZERO_SEGMENT, IPv6AddressSegment.ZERO_SEGMENT});
    private transient IPv6StringCache stringCache;
    private transient AddressDivisionGrouping.SectionCache<IPv6AddressSection> sectionCache;
    transient IPv4AddressSection embeddedIPv4Section;
    transient IPv6v4MixedAddressSection defaultMixedAddressSection;
    public final int startIndex;
    private transient IPAddressDivisionGrouping.RangeList zeroSegments;
    private transient IPAddressDivisionGrouping.RangeList zeroRanges;

    public IPv6AddressSection(IPv6AddressSegment segment) {
        this(new IPv6AddressSegment[]{segment}, 0, false);
    }

    public IPv6AddressSection(IPv6AddressSegment segment, int startIndex) {
        this(new IPv6AddressSegment[]{segment}, startIndex, false);
    }

    public IPv6AddressSection(IPv6AddressSegment[] segments) {
        this(segments, 0, true);
    }

    public IPv6AddressSection(IPv6AddressSegment[] segments, Integer networkPrefixLength) {
        this(segments, 0, networkPrefixLength);
    }

    public IPv6AddressSection(IPv6AddressSegment[] segments, int startIndex, Integer networkPrefixLength) {
        this((IPv6AddressSegment[])IPv6AddressSection.toPrefixedSegments((Integer)networkPrefixLength, (AddressSegment[])segments, (int)16, IPv6AddressSection.getIPv6SegmentCreator(), IPv6AddressSegment::toNetworkSegment, (boolean)true), startIndex, false);
    }

    IPv6AddressSection(IPv6AddressSegment[] segments, int startIndex, boolean cloneSegments) {
        super(segments, null, cloneSegments, false);
        if (startIndex < 0) {
            throw new IllegalArgumentException();
        }
        if (startIndex + segments.length > 8) {
            throw new IllegalArgumentException(IPv6AddressSection.getMessage("ipaddress.error.exceeds.size"));
        }
        this.startIndex = startIndex;
    }

    IPv6AddressSection(Address.SegmentValueProvider lowerValueProvider, Address.SegmentValueProvider upperValueProvider, Integer prefix) {
        super((IPAddressSegment[])IPv6AddressSection.toSegments((Address.SegmentValueProvider)lowerValueProvider, (Address.SegmentValueProvider)upperValueProvider, (int)8, (int)2, (int)16, (int)65535, IPv6AddressSection.getIPv6SegmentCreator(), (Integer)prefix), null, false, false);
        this.startIndex = 0;
    }

    IPv6AddressSection(byte[] bytes, Integer prefix, boolean cloneBytes) {
        super((IPAddressSegment[])IPv6AddressSection.toSegments((byte[])bytes, (int)8, (int)2, (int)16, (int)65535, IPv6AddressSection.getIPv6SegmentCreator(), (Integer)prefix), bytes, false, cloneBytes);
        if (bytes.length > 16) {
            throw new IllegalArgumentException(String.valueOf(IPv6AddressSection.getMessage("ipaddress.error.exceeds.size")) + ' ' + bytes.length);
        }
        this.startIndex = 0;
    }

    public IPv6AddressSection(byte[] bytes, Integer prefix) {
        this(bytes, prefix, true);
    }

    public IPv6AddressSection(MACAddress eui) {
        this(eui.getSection(), 4, 4);
    }

    public IPv6AddressSection(MACAddressSection eui) {
        this(eui, IPv6AddressSection.getIPv6StartIndex(eui), IPv6AddressSection.getIPv6SegmentCount(eui));
    }

    private IPv6AddressSection(MACAddressSection eui, int ipv6StartIndex, int ipv6SegmentCount) {
        super(IPv6Address.toEUI64Segments(IPv6AddressSection.getAddressCreator(ipv6StartIndex).createSegmentArray(ipv6SegmentCount), 0, eui, eui.startIndex, eui.isExtended()), eui.getSegmentCount() == 8 ? AddressDivisionGrouping.getCachedBytes(eui) : null, false, false);
        this.startIndex = ipv6StartIndex;
    }

    private static int getIPv6SegmentCount(MACAddressSection eui) {
        int euiStartIndex = eui.startIndex;
        int euiEndIndex = euiStartIndex + eui.getSegmentCount();
        int result = euiEndIndex + 1 >> 1;
        result -= euiStartIndex >> 1;
        if (!eui.isExtended() && euiStartIndex <= 2 && euiEndIndex >= 4) {
            ++result;
        }
        return result;
    }

    private static int getIPv6StartIndex(MACAddressSection eui) {
        int euiStartIndex = eui.startIndex;
        int result = 4 + (euiStartIndex >> 1);
        if (!eui.isExtended() && euiStartIndex >= 3) {
            ++result;
        }
        return result;
    }

    @Override
    protected void initCachedValues(Integer prefixLen, boolean network, Integer cachedNetworkPrefix, Integer cachedMinPrefix, Integer cachedEquivalentPrefix, BigInteger cachedCount, IPAddressDivisionGrouping.RangeList zeroSegments, IPAddressDivisionGrouping.RangeList zeroRanges) {
        super.initCachedValues(prefixLen, network, cachedNetworkPrefix, cachedMinPrefix, cachedEquivalentPrefix, cachedCount, zeroSegments, zeroRanges);
        this.zeroSegments = zeroSegments;
        this.zeroRanges = zeroRanges;
    }

    @Override
    public IPv6AddressSection getSection(int index) {
        return this.getSection(index, this.getSegmentCount());
    }

    @Override
    public IPv6AddressSection getSection(int index, int endIndex) {
        return IPv6AddressSection.getSection(index, endIndex, this, IPv6AddressSection.getAddressCreator(this.startIndex + index));
    }

    public IPv6AddressSegment[] getSegments() {
        return (IPv6AddressSegment[])this.divisions.clone();
    }

    private IPv6AddressSection getLowestOrHighestSection(boolean lowest) {
        return IPv6AddressSection.getLowestOrHighestSection(this, this.getAddressCreator(), lowest, i -> lowest ? this.getSegment(i).getLower() : this.getSegment(i).getUpper(), () -> IPv6AddressSection.getSectionCache(this, () -> this.sectionCache, () -> {
            this.sectionCache = new AddressDivisionGrouping.SectionCache();
            return this.sectionCache;
        }));
    }

    IPv6Address getLowestOrHighest(IPv6AddressNetwork.IPv6AddressCreator creator, IPv6Address addr, boolean lowest) {
        return IPv6AddressSection.getLowestOrHighestAddress(addr, creator, lowest, () -> this.getLowestOrHighestSection(lowest), () -> IPv6AddressSection.getSectionCache(addr, () -> iPv6Address.sectionCache, () -> {
            iPv6Address.sectionCache = new AddressCache();
            return iPv6Address.sectionCache;
        }));
    }

    @Override
    public IPv6AddressSection getLower() {
        return this.getLowestOrHighestSection(true);
    }

    @Override
    public IPv6AddressSection getUpper() {
        return this.getLowestOrHighestSection(false);
    }

    @Override
    public IPv6AddressSection reverseBits(boolean perByte) {
        return IPv6AddressSection.reverseBits(perByte, this, this.getAddressCreator(), i -> this.getSegment(i).reverseBits(perByte), true);
    }

    @Override
    public IPv6AddressSection reverseBytes() {
        return this.reverseBytes(false);
    }

    @Override
    public IPv6AddressSection reverseBytesPerSegment() {
        return this.reverseBytes(true);
    }

    private IPv6AddressSection reverseBytes(boolean perSegment) {
        return IPv6AddressSection.reverseBytes(perSegment, this, this.getAddressCreator(), i -> this.getSegment(i).reverseBytes(), true);
    }

    @Override
    public IPv6AddressSection reverseSegments() {
        if (this.getSegmentCount() <= 1) {
            return this;
        }
        return IPv6AddressSection.reverseSegments(this, this.getAddressCreator(), i -> this.getSegment(i).removePrefixLength(false), true);
    }

    public Iterable<IPv6AddressSection> getIterable() {
        return this;
    }

    @Override
    public Iterator<IPv6AddressSection> iterator() {
        boolean useOriginal = !this.isMultiple() && !this.isPrefixed();
        return IPv6AddressSection.iterator(useOriginal, this, this.getAddressCreator(), useOriginal ? null : this.segmentsIterator());
    }

    public Iterator<IPv6AddressSegment[]> segmentsIterator() {
        return super.iterator(this.getSegmentCreator(), () -> this.getLower().getSegments(), index -> this.getSegment(index).iterator());
    }

    protected Iterator<IPv6Address> iterator(IPv6Address original, AddressCreator<IPv6Address, ?, ?, IPv6AddressSegment> creator) {
        boolean useOriginal = !this.isMultiple() && !this.isPrefixed();
        return IPv6AddressSection.iterator(original, creator, useOriginal, useOriginal ? null : this.iterator(creator, () -> (IPv6AddressSegment[])this.getLower().divisions, index -> this.getSegment(index).iterator()));
    }

    @Override
    protected BigInteger getCountImpl() {
        long otherValue;
        int segCount = this.getSegmentCount();
        if (!this.isMultiple()) {
            return BigInteger.ONE;
        }
        long result1 = this.getSegment(0).getValueCount();
        BigInteger big1 = null;
        int limit = Math.min(segCount, 3);
        int i = 1;
        while (i < limit) {
            result1 *= (long)this.getSegment(i).getValueCount();
            ++i;
        }
        if (segCount > 3 && (otherValue = (long)this.getSegment(3).getValueCount()) != 1L) {
            if (result1 <= 0x7FFFFFFFFFFFL) {
                result1 *= otherValue;
            } else {
                big1 = BigInteger.valueOf(result1).multiply(BigInteger.valueOf(otherValue));
            }
        }
        if (segCount > 4) {
            long otherValue2;
            long result2 = this.getSegment(4).getValueCount();
            BigInteger big2 = null;
            limit = Math.min(segCount, 7);
            int i2 = 5;
            while (i2 < limit) {
                result2 *= (long)this.getSegment(i2).getValueCount();
                ++i2;
            }
            if (segCount > 7 && (otherValue2 = (long)this.getSegment(7).getValueCount()) != 1L) {
                if (result2 <= 0x7FFFFFFFFFFFL) {
                    result2 *= otherValue2;
                } else {
                    big2 = BigInteger.valueOf(result2).multiply(BigInteger.valueOf(otherValue2));
                }
            }
            if (big1 == null) {
                if (big2 == null) {
                    if (result1 <= -1257966797L && result2 <= -1257966797L) {
                        return BigInteger.valueOf(result1 * result2);
                    }
                    big2 = BigInteger.valueOf(result2);
                }
                big1 = BigInteger.valueOf(result1);
            } else if (big2 == null) {
                big2 = BigInteger.valueOf(result2);
            }
            return big1.multiply(big2);
        }
        if (big1 != null) {
            return big1;
        }
        return BigInteger.valueOf(result1);
    }

    private AddressNetwork.AddressSegmentCreator<IPv6AddressSegment> getSegmentCreator() {
        return IPv6AddressSection.getIPv6SegmentCreator();
    }

    private static AddressNetwork.AddressSegmentCreator<IPv6AddressSegment> getIPv6SegmentCreator() {
        return IPv6Address.network().getAddressCreator();
    }

    private IPv6AddressNetwork.IPv6AddressCreator getAddressCreator() {
        return IPv6AddressSection.getAddressCreator(this.startIndex);
    }

    protected static IPv6AddressNetwork.IPv6AddressCreator getAddressCreator(final int startIndex) {
        IPv6AddressNetwork.IPv6AddressCreator result = creators[startIndex];
        if (result == null) {
            IPv6AddressSection.creators[startIndex] = result = new IPv6AddressNetwork.IPv6AddressCreator(){

                @Override
                protected IPv6AddressSection createSectionInternal(IPv6AddressSegment[] segments) {
                    return IPv6Address.network().getAddressCreator().createSectionInternal(segments, startIndex);
                }
            };
        }
        return result;
    }

    @Override
    public IPv6AddressSegment getSegment(int index) {
        return (IPv6AddressSegment)super.getSegment(index);
    }

    public void getSegments(Collection<? super IPv6AddressSegment> segs) {
        this.getSegments(0, this.getSegmentCount(), segs);
    }

    public void getSegments(int start, int end, Collection<? super IPv6AddressSegment> segs) {
        int i = start;
        while (i < end) {
            segs.add(this.getSegment(i));
            ++i;
        }
    }

    public boolean isEUI64() {
        return this.isEUI64(false);
    }

    public boolean isEUI64(boolean partial) {
        int segmentCount = this.getSegmentCount();
        int endIndex = this.startIndex + segmentCount;
        if (this.startIndex <= 5) {
            if (endIndex > 6) {
                int index3 = 5 - this.startIndex;
                IPv6AddressSegment seg3 = this.getSegment(index3);
                IPv6AddressSegment seg4 = this.getSegment(index3 + 1);
                return seg4.matchesWithMask(65024, 65280) && seg3.matchesWithMask(255, 255);
            }
            if (partial && endIndex == 6) {
                IPv6AddressSegment seg3 = this.getSegment(5 - this.startIndex);
                return seg3.matchesWithMask(255, 255);
            }
        } else if (partial && this.startIndex == 6 && endIndex > 6) {
            IPv6AddressSegment seg4 = this.getSegment(6 - this.startIndex);
            return seg4.matchesWithMask(65024, 65280);
        }
        return partial;
    }

    public MACAddressSection toEUI(boolean extended) {
        MACAddressSegment[] segs = this.toEUISegments(extended);
        if (segs == null) {
            return null;
        }
        MACAddressNetwork.MACAddressCreator creator = MACAddress.getAddressCreator();
        return IPv6AddressSection.createSectionInternal(creator, segs, Math.max(0, this.startIndex - 4) << 1, extended);
    }

    protected static MACAddressSection createSectionInternal(MACAddressNetwork.MACAddressCreator creator, MACAddressSegment[] segments, int startIndex, boolean extended) {
        return (MACAddressSection)AddressDivisionGrouping.createSectionInternal((AddressCreator)creator, (AddressSegment[])segments, (int)startIndex, (boolean)extended);
    }

    MACAddressSegment[] toEUISegments(boolean extended) {
        int segmentIndex;
        int start = this.startIndex;
        int segmentCount = this.getSegmentCount();
        if (start < 4) {
            start = 0;
            segmentIndex = 4 - start;
        } else {
            start -= 4;
            segmentIndex = 0;
        }
        int originalSegmentIndex = segmentIndex;
        IPv6AddressSegment seg0 = start == 0 && segmentIndex < segmentCount ? this.getSegment(segmentIndex++) : null;
        IPv6AddressSegment seg1 = start <= 1 && segmentIndex < segmentCount ? this.getSegment(segmentIndex++) : null;
        IPv6AddressSegment seg2 = start <= 2 && segmentIndex < segmentCount ? this.getSegment(segmentIndex++) : null;
        IPv6AddressSegment seg3 = start <= 3 && segmentIndex < segmentCount ? this.getSegment(segmentIndex++) : null;
        int macSegCount = segmentIndex - originalSegmentIndex << 1;
        if (!extended) {
            macSegCount -= 2;
        }
        if (seg1 != null && !seg1.matchesWithMask(255, 255) || seg2 != null && !seg2.matchesWithMask(65024, 65280) || macSegCount == 0) {
            return null;
        }
        MACAddressNetwork.MACAddressCreator creator = MACAddress.getAddressCreator();
        AddressSegment[] newSegs = creator.createSegmentArray(macSegCount);
        int macStartIndex = 0;
        if (seg0 != null) {
            seg0.getSplitSegments(newSegs, macStartIndex, creator);
            AddressSegment macSegment0 = newSegs[0];
            int lower0 = ((MACAddressSegment)macSegment0).getLowerSegmentValue();
            int upper0 = ((MACAddressSegment)macSegment0).getUpperSegmentValue();
            int mask2ndBit = 2;
            if (!((MACAddressSegment)macSegment0).matchesWithMask(mask2ndBit & lower0, mask2ndBit)) {
                return null;
            }
            newSegs[0] = creator.createSegment(lower0 ^= mask2ndBit, upper0 ^= mask2ndBit, null);
            macStartIndex += 2;
        }
        if (seg1 != null) {
            seg1.getSplitSegments(newSegs, macStartIndex, creator);
            if (!extended) {
                newSegs[macStartIndex + 1] = MACAddressSegment.ZERO_SEGMENT;
            }
            macStartIndex += 2;
        }
        if (seg2 != null) {
            if (!extended) {
                if (seg1 != null) {
                    AddressSegment first = newSegs[macStartIndex -= 2];
                    seg2.getSplitSegments(newSegs, macStartIndex, creator);
                    newSegs[macStartIndex] = first;
                } else {
                    seg2.getSplitSegments(newSegs, macStartIndex, creator);
                    newSegs[macStartIndex] = MACAddressSegment.ZERO_SEGMENT;
                }
            } else {
                seg2.getSplitSegments(newSegs, macStartIndex, creator);
            }
            macStartIndex += 2;
        }
        if (seg3 != null) {
            seg3.getSplitSegments(newSegs, macStartIndex, creator);
        }
        return newSegs;
    }

    public IPv4AddressSection getEmbeddedIPv4AddressSection(int startIndex, int endIndex) {
        IPv6AddressSegment ipv6Segment;
        if (startIndex == 6 - this.startIndex << 1 && endIndex == this.getSegmentCount() << 1) {
            return this.getEmbeddedIPv4AddressSection();
        }
        IPv4AddressNetwork.IPv4AddressCreator creator = IPv4Address.network().getAddressCreator();
        AddressSegment[] segments = creator.createSegmentArray(endIndex - startIndex >> 1);
        int i = startIndex;
        int j = 0;
        if (i % 2 == 1) {
            ipv6Segment = this.getSegment(i++ / 2);
            ipv6Segment.getSplitSegments(segments, j++ - 1, creator);
        }
        while (i < endIndex) {
            ipv6Segment = this.getSegment(i / 2);
            ipv6Segment.getSplitSegments(segments, j, creator);
            i <<= 1;
            j <<= 1;
        }
        return (IPv4AddressSection)IPv6AddressSection.createSection((IPAddressTypeNetwork.IPAddressCreator)creator, (IPAddressSegment[])segments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPv4AddressSection getEmbeddedIPv4AddressSection() {
        if (this.embeddedIPv4Section == null) {
            IPv6AddressSection iPv6AddressSection = this;
            synchronized (iPv6AddressSection) {
                if (this.embeddedIPv4Section == null) {
                    int mixedCount = this.getSegmentCount() - Math.max(6 - this.startIndex, 0);
                    int lastIndex = this.getSegmentCount() - 1;
                    IPv4AddressNetwork.IPv4AddressCreator creator = IPv4Address.network().getAddressCreator();
                    IPAddressSegment[] mixed = mixedCount == 0 ? creator.createSegmentArray(0) : (mixedCount == 1 ? this.getSegment(lastIndex).split() : IPv6AddressSegment.split(this.getSegment(lastIndex - 1), this.getSegment(lastIndex)));
                    this.embeddedIPv4Section = (IPv4AddressSection)IPv6AddressSection.createSection((IPAddressTypeNetwork.IPAddressCreator)creator, (IPAddressSegment[])mixed);
                }
            }
        }
        return this.embeddedIPv4Section;
    }

    public IPv6AddressSection createNonMixedSection() {
        int mixedCount = this.getSegmentCount() - Math.max(6 - this.startIndex, 0);
        if (mixedCount <= 0) {
            return this;
        }
        int nonMixedCount = Math.max(0, this.getSegmentCount() - mixedCount);
        IPv6AddressNetwork.IPv6AddressCreator creator = IPv6Address.network().getAddressCreator();
        AddressSegment[] nonMixed = creator.createSegmentArray(nonMixedCount);
        this.getSegments(0, nonMixedCount, nonMixed, 0);
        return creator.createSectionInternal((IPv6AddressSegment[])nonMixed, this.startIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPv6v4MixedAddressSection getMixedAddressSection() {
        if (this.defaultMixedAddressSection == null) {
            IPv6AddressSection iPv6AddressSection = this;
            synchronized (iPv6AddressSection) {
                if (this.defaultMixedAddressSection == null) {
                    this.defaultMixedAddressSection = new IPv6v4MixedAddressSection(this.createNonMixedSection(), this.getEmbeddedIPv4AddressSection());
                }
            }
        }
        return this.defaultMixedAddressSection;
    }

    @Override
    public int getBitsPerSegment() {
        return 16;
    }

    @Override
    public int getBytesPerSegment() {
        return 2;
    }

    @Override
    protected byte[] getBytesImpl(boolean low) {
        byte[] bytes = new byte[this.getBitCount() + 7 >> 3];
        int segmentCount = this.getSegmentCount();
        int i = 0;
        while (i < segmentCount) {
            IPv6AddressSegment seg = this.getSegment(i);
            int byteIndex = i << 1;
            int val = low ? seg.getLowerSegmentValue() : seg.getUpperSegmentValue();
            bytes[byteIndex] = (byte)(val >> 8);
            bytes[byteIndex + 1] = (byte)val;
            ++i;
        }
        return bytes;
    }

    public boolean hasUppercaseVariations(int base, boolean lowerOnly) {
        if (base > 10) {
            int count = this.getSegmentCount();
            int i = 0;
            while (i < count) {
                IPv6AddressSegment seg = this.getSegment(i);
                if (seg.hasUppercaseVariations(base, lowerOnly)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    @Override
    public boolean isIPv6() {
        return true;
    }

    @Override
    public IPAddress.IPVersion getIPVersion() {
        return IPAddress.IPVersion.IPV6;
    }

    public IPv6AddressSection replace(IPv6AddressSection other, int index) {
        if (index > 0 && this.getSegment(index - 1).isPrefixed()) {
            throw new AddressTypeException(this, "ipaddress.error.index.exceeds.prefix.length");
        }
        IPv6AddressSection result = IPv6AddressSection.replace(this, other, this.getAddressCreator(), index, true);
        return result;
    }

    public IPv6AddressSection prepend(IPv6AddressSection other) {
        int otherSegmentCount = other.getSegmentCount();
        int newStartIndex = this.startIndex - otherSegmentCount;
        if (newStartIndex < 0) {
            throw new AddressTypeException((AddressSection)this, other, "ipaddress.error.exceeds.size");
        }
        if (otherSegmentCount == 0) {
            return this;
        }
        int segmentCount = this.getSegmentCount();
        if (this.startIndex == other.startIndex + otherSegmentCount && segmentCount == 0) {
            return other;
        }
        return IPv6AddressSection.append(other, this, IPv6AddressSection.getAddressCreator(newStartIndex), true);
    }

    public IPv6AddressSection append(IPv6AddressSection other) {
        int otherSegmentCount;
        int segmentCount = this.getSegmentCount();
        if (this.startIndex + segmentCount + (otherSegmentCount = other.getSegmentCount()) > 8) {
            throw new AddressTypeException((AddressSection)this, other, "ipaddress.error.exceeds.size");
        }
        if (otherSegmentCount == 0) {
            return this;
        }
        if (this.startIndex == other.startIndex && segmentCount == 0) {
            return other;
        }
        return IPv6AddressSection.append(this, other, this.getAddressCreator(), true);
    }

    @Override
    public boolean contains(AddressSection other) {
        return other instanceof IPv6AddressSection && this.startIndex == ((IPv6AddressSection)other).startIndex && super.contains((IPAddressSection)other);
    }

    @Override
    protected boolean isSameGrouping(AddressDivisionGrouping other) {
        return other instanceof IPv6AddressSection && this.startIndex == ((IPv6AddressSection)other).startIndex && super.isSameGrouping(other);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof IPv6AddressSection) {
            IPv6AddressSection other = (IPv6AddressSection)o;
            return this.startIndex == other.startIndex && super.isSameGrouping(other);
        }
        return false;
    }

    public IPv6AddressSection[] subtract(IPv6AddressSection other) {
        return (IPv6AddressSection[])IPv6AddressSection.subtract((IPAddressSection)this, (IPAddressSection)other, (IPAddressTypeNetwork.IPAddressCreator)this.getAddressCreator(), this::getSegment, (T section, U prefix) -> section.applyPrefixLength((int)prefix));
    }

    @Override
    public int getByteIndex(int networkPrefixLength) {
        return IPv6AddressSection.getByteIndex(networkPrefixLength, 16);
    }

    @Override
    public int getSegmentIndex(int networkPrefixLength) {
        return IPv6AddressSection.getSegmentIndex(networkPrefixLength, 16, 2);
    }

    @Override
    public IPv6AddressNetwork getNetwork() {
        return IPv6Address.network();
    }

    @Override
    public IPv6AddressSection adjustPrefixBySegment(boolean nextSegment) {
        return (IPv6AddressSection)super.adjustPrefixBySegment(nextSegment);
    }

    @Override
    public IPv6AddressSection adjustPrefixLength(int adjustment) {
        return (IPv6AddressSection)IPv6AddressSection.adjustPrefixLength(this, adjustment, this.getAddressCreator(), this.getNetwork(), (section, i) -> section.getSegment(i));
    }

    @Override
    public IPv6AddressSection applyPrefixLength(int networkPrefixLength) {
        return this.setPrefixLength(networkPrefixLength, false, true);
    }

    @Override
    public IPv6AddressSection setPrefixLength(int networkPrefixLength) {
        return this.setPrefixLength(networkPrefixLength, true, false);
    }

    @Override
    public IPv6AddressSection setPrefixLength(int networkPrefixLength, boolean withZeros) {
        return this.setPrefixLength(networkPrefixLength, withZeros, false);
    }

    private IPv6AddressSection setPrefixLength(int networkPrefixLength, boolean withZeros, boolean noShrink) {
        return IPv6AddressSection.setPrefixLength(this, this.getAddressCreator(), networkPrefixLength, withZeros, noShrink, this.getNetwork(), (section, i) -> section.getSegment(i));
    }

    public IPv6AddressSection mask(IPv6AddressSection mask) throws AddressTypeException {
        super.checkSectionCount(mask);
        return IPv6AddressSection.getSubnetSegments(this, null, this.getAddressCreator(), true, this::getSegment, mask::getSegment);
    }

    @Override
    public IPv6AddressSection removePrefixLength() {
        return this.removePrefixLength(true);
    }

    @Override
    public IPv6AddressSection removePrefixLength(boolean zeroed) {
        return this.removePrefixLength(zeroed, true);
    }

    protected IPv6AddressSection removePrefixLength(boolean zeroed, boolean onlyPrefixZeroed) {
        return IPv6AddressSection.removePrefixLength(this, zeroed, onlyPrefixZeroed, this.getAddressCreator(), this.getNetwork(), (section, i) -> section.getSegment(i));
    }

    public IPv6AddressSection maskNetwork(IPv6AddressSection mask, int networkPrefixLength) throws AddressTypeException {
        super.checkSectionCount(mask);
        return IPv6AddressSection.getSubnetSegments(this, networkPrefixLength, this.getAddressCreator(), true, this::getSegment, mask::getSegment);
    }

    public IPv6AddressSection bitwiseOr(IPv6AddressSection mask) throws AddressTypeException {
        super.checkSectionCount(mask);
        return IPv6AddressSection.getOredSegments(this, null, this.getAddressCreator(), this::getSegment, mask::getSegment);
    }

    public IPv6AddressSection bitwiseOrNetwork(IPv6AddressSection mask, int networkPrefixLength) throws AddressTypeException {
        super.checkSectionCount(mask);
        return IPv6AddressSection.getOredSegments(this, networkPrefixLength, this.getAddressCreator(), this::getSegment, mask::getSegment);
    }

    @Override
    public IPv6AddressSection getNetworkSection(int networkPrefixLength) {
        return this.getNetworkSection(networkPrefixLength, true);
    }

    @Override
    public IPv6AddressSection getNetworkSection(int networkPrefixLength, boolean withPrefixLength) {
        int cidrSegmentCount = this.getNetworkSegmentCount(networkPrefixLength);
        return IPv6AddressSection.getNetworkSection(this, networkPrefixLength, cidrSegmentCount, withPrefixLength, this.getAddressCreator(), (i, prefix) -> this.getSegment((int)i).toNetworkSegment((Integer)prefix, withPrefixLength));
    }

    @Override
    public IPv6AddressSection getHostSection(int networkPrefixLength) {
        int cidrSegmentCount = this.getHostSegmentCount(networkPrefixLength);
        IPv6AddressNetwork.IPv6AddressCreator creator = IPv6AddressSection.getAddressCreator(this.startIndex + (this.getSegmentCount() - cidrSegmentCount));
        return IPv6AddressSection.getHostSection(this, networkPrefixLength, cidrSegmentCount, creator, (i, prefix) -> this.getSegment((int)i).toHostSegment((Integer)prefix));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean hasNoStringCache() {
        if (this.stringCache == null) {
            IPv6AddressSection iPv6AddressSection = this;
            synchronized (iPv6AddressSection) {
                block5: {
                    if (this.stringCache != null) break block5;
                    this.stringCache = new IPv6StringCache();
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    protected IPv6StringCache getStringCache() {
        return this.stringCache;
    }

    @Override
    public String toCompressedString() {
        String result;
        if (this.hasNoStringCache() || (result = this.getStringCache().compressedString) == null) {
            this.getStringCache().compressedString = result = this.toNormalizedString(IPv6StringCache.compressedParams);
        }
        return result;
    }

    @Override
    public String toCanonicalString() {
        String result;
        if (this.hasNoStringCache() || (result = this.stringCache.canonicalString) == null) {
            this.stringCache.canonicalString = result = this.toNormalizedString(IPv6StringCache.canonicalParams);
        }
        return result;
    }

    public String toMixedString() {
        String result;
        if (this.hasNoStringCache() || (result = this.getStringCache().mixedString) == null) {
            this.getStringCache().mixedString = result = this.toNormalizedString(IPv6StringCache.mixedParams);
        }
        return result;
    }

    @Override
    public String toFullString() {
        String result;
        if (this.hasNoStringCache() || (result = this.getStringCache().fullString) == null) {
            this.getStringCache().fullString = result = this.toNormalizedString(IPv6StringCache.fullParams);
        }
        return result;
    }

    @Override
    public String toCompressedWildcardString() {
        String result;
        if (this.hasNoStringCache() || (result = this.getStringCache().compressedWildcardString) == null) {
            this.getStringCache().compressedWildcardString = result = this.toNormalizedString(IPv6StringCache.wildcardCompressedParams);
        }
        return result;
    }

    @Override
    public String toPrefixLengthString() {
        String result;
        if (this.hasNoStringCache() || (result = this.getStringCache().networkPrefixLengthString) == null) {
            this.getStringCache().networkPrefixLengthString = result = this.toNormalizedString(IPv6StringCache.networkPrefixLengthParams);
        }
        return result;
    }

    @Override
    public String toSubnetString() {
        return this.toPrefixLengthString();
    }

    @Override
    public String toCanonicalWildcardString() {
        String result;
        if (this.hasNoStringCache() || (result = this.getStringCache().canonicalWildcardString) == null) {
            this.getStringCache().canonicalWildcardString = result = this.toNormalizedString(IPv6StringCache.wildcardCanonicalParams);
        }
        return result;
    }

    @Override
    public String toNormalizedWildcardString() {
        String result;
        if (this.hasNoStringCache() || (result = this.getStringCache().normalizedWildcardString) == null) {
            this.getStringCache().normalizedWildcardString = result = this.toNormalizedString(IPv6StringCache.wildcardNormalizedParams);
        }
        return result;
    }

    @Override
    public String toSQLWildcardString() {
        String result;
        if (this.hasNoStringCache() || (result = this.getStringCache().sqlWildcardString) == null) {
            this.getStringCache().sqlWildcardString = result = this.toNormalizedString(IPv6StringCache.sqlWildcardParams);
        }
        return result;
    }

    @Override
    public String toNormalizedString() {
        String result;
        if (this.hasNoStringCache() || (result = this.getStringCache().normalizedString) == null) {
            this.getStringCache().normalizedString = result = this.toNormalizedString(IPv6StringCache.normalizedParams);
        }
        return result;
    }

    public String toBase85String() {
        String result;
        if (this.hasNoStringCache() || (result = this.getStringCache().base85String) == null) {
            this.getStringCache().base85String = result = this.toBase85String(null);
        }
        return result;
    }

    String toBase85String(String zone) {
        Integer prefixLength = this.getNetworkPrefixLength();
        AddressLargeDivision largeDiv = this.isDualString() ? new AddressLargeDivision(this.getBytes(), this.getUpperBytes(), this.getBitCount(), 85, prefixLength) : new AddressLargeDivision(this.getBytes(), this.getBitCount(), 85, prefixLength);
        IPAddressStringDivisionGrouping part = new IPAddressStringDivisionGrouping(new AddressDivisionBase[]{largeDiv}, prefixLength);
        return IPv6AddressSection.toNormalizedString(IPv6StringCache.base85Params, zone, part);
    }

    @Override
    protected void cacheNormalizedString(String str) {
        if (this.hasNoStringCache() || this.getStringCache().normalizedString == null) {
            this.getStringCache().normalizedString = str;
        }
    }

    @Override
    public String toReverseDNSLookupString() {
        String result;
        if (this.hasNoStringCache() || (result = this.getStringCache().reverseDNSString) == null) {
            IPv6StringCache stringCache = this.getStringCache();
            stringCache.reverseDNSString = result = this.toNormalizedString(IPv6StringCache.reverseDNSParams, (CharSequence)"");
        }
        return result;
    }

    @Override
    protected String toBinaryString(CharSequence zone) {
        if (this.isDualString()) {
            IPAddressDivisionGrouping.IPAddressStringParams<IPAddressStringDivisionSeries> params = IPv6AddressSection.toIPParams(IPAddressSection.IPStringCache.binaryParams);
            return IPv6AddressSection.toNormalizedStringRange(params, this.getLower(), this.getUpper(), zone);
        }
        return this.toNormalizedString(IPAddressSection.IPStringCache.binaryParams, zone);
    }

    @Override
    protected String toHexString(boolean with0xPrefix, CharSequence zone) {
        if (this.isDualString()) {
            IPAddressDivisionGrouping.IPAddressStringParams<IPAddressStringDivisionSeries> params = IPv6AddressSection.toIPParams(with0xPrefix ? IPAddressSection.IPStringCache.hexPrefixedParams : IPAddressSection.IPStringCache.hexParams);
            return IPv6AddressSection.toNormalizedStringRange(params, this.getLower(), this.getUpper(), zone);
        }
        return this.toNormalizedString(with0xPrefix ? IPAddressSection.IPStringCache.hexPrefixedParams : IPAddressSection.IPStringCache.hexParams, zone);
    }

    @Override
    protected String toOctalString(boolean with0Prefix, CharSequence zone) {
        if (zone == null) {
            return super.toOctalString(with0Prefix, null);
        }
        IPAddressDivisionGrouping.IPAddressStringParams<IPAddressStringDivisionSeries> params = IPv6AddressSection.toIPParams(with0Prefix ? IPAddressSection.IPStringCache.octalPrefixedParams : IPAddressSection.IPStringCache.octalParams);
        if (this.isDualString()) {
            IPv6AddressSection lower = this.getLower();
            IPv6AddressSection upper = this.getUpper();
            IPAddressDivision[] lowerDivs = (IPAddressBitsDivision[])lower.createNewDivisions(3, IPAddressBitsDivision::new, IPAddressBitsDivision[]::new);
            IPAddressDivisionGrouping lowerPart = new IPAddressDivisionGrouping(lowerDivs);
            IPAddressDivision[] upperDivs = (IPAddressBitsDivision[])upper.createNewDivisions(3, IPAddressBitsDivision::new, IPAddressBitsDivision[]::new);
            IPAddressDivisionGrouping upperPart = new IPAddressDivisionGrouping(upperDivs);
            return IPv6AddressSection.toNormalizedStringRange(params, lowerPart, upperPart, zone);
        }
        IPAddressDivision[] divs = (IPAddressBitsDivision[])this.createNewPrefixedDivisions(3, this.getNetworkPrefixLength(), IPAddressBitsDivision::new, IPAddressBitsDivision[]::new);
        IPAddressDivisionGrouping part = new IPAddressDivisionGrouping(divs);
        return params.toString((IPAddressStringDivisionSeries)part, zone);
    }

    @Override
    public String toNormalizedString(IPAddressSection.IPStringOptions options) {
        if (options instanceof IPv6StringOptions) {
            return this.toNormalizedString((IPv6StringOptions)options);
        }
        return super.toNormalizedString(options);
    }

    public String toNormalizedString(IPv6StringOptions options) {
        return this.toNormalizedString(options, null);
    }

    private String toNormalizedMixedString(IPv6v4MixedParams mixedParams, CharSequence zone) {
        IPv6v4MixedAddressSection mixed = this.getMixedAddressSection();
        String result = mixedParams.toString(mixed, zone);
        return result;
    }

    String toNormalizedString(IPAddressSection.IPStringOptions options, CharSequence zone) {
        if (zone == null) {
            return this.toNormalizedString(options);
        }
        if (options instanceof IPv6StringOptions) {
            return this.toNormalizedString((IPv6StringOptions)options, zone);
        }
        IPAddressDivisionGrouping.IPAddressStringParams<IPAddressStringDivisionSeries> params = IPv6AddressSection.toIPParams(options);
        return params.toString((IPAddressStringDivisionSeries)this, zone);
    }

    public String toNormalizedString(IPv6StringOptions options, CharSequence zone) {
        IPv6StringParams stringParams;
        if (options.compressOptions == null) {
            IPAddressStringWriter cachedParams = (IPAddressStringWriter)IPv6AddressSection.getCachedParams(options);
            if (cachedParams == null) {
                stringParams = options.from(this);
                if (options.makeMixed()) {
                    IPv6v4MixedParams mixedParams = new IPv6v4MixedParams(stringParams, options.ipv4Opts);
                    IPv6AddressSection.setCachedParams(options, mixedParams);
                    return this.toNormalizedMixedString(mixedParams, zone);
                }
                IPv6AddressSection.setCachedParams(options, stringParams);
            } else {
                if (cachedParams instanceof IPv6v4MixedParams) {
                    return this.toNormalizedMixedString((IPv6v4MixedParams)cachedParams, zone);
                }
                stringParams = (IPv6StringParams)cachedParams;
            }
        } else {
            stringParams = options.from(this);
            if (options.makeMixed() && stringParams.nextUncompressedIndex <= 6 - this.startIndex) {
                return this.toNormalizedMixedString(new IPv6v4MixedParams(stringParams, options.ipv4Opts), zone);
            }
        }
        return stringParams.toString(this, zone);
    }

    public static String toNormalizedString(IPAddressSection.IPStringOptions options, CharSequence zone, IPAddressStringDivisionSeries part) {
        AddressDivisionGrouping.AddressStringParams<IPAddressStringDivisionSeries> params = IPv6AddressSection.toParams(options);
        String result = params.toString(part, zone);
        return result;
    }

    @Override
    public IPAddressPartStringCollection toStandardStringCollection() {
        return this.toStringCollection(IPv6StringBuilderOptions.STANDARD_OPTS);
    }

    @Override
    public IPAddressPartStringCollection toAllStringCollection() {
        return this.toStringCollection(IPv6StringBuilderOptions.ALL_OPTS);
    }

    @Override
    public IPAddressPartStringCollection toDatabaseSearchStringCollection() {
        return this.toStringCollection(IPv6StringBuilderOptions.DATABASE_SEARCH_OPTS);
    }

    @Override
    public IPAddressPartStringCollection toStringCollection(IPAddressSection.IPStringBuilderOptions options) {
        return this.toStringCollection(IPv6StringBuilderOptions.from(options));
    }

    public IPAddressPartStringCollection toStringCollection(IPv6StringBuilderOptions opts) {
        return this.toStringCollection(opts, null);
    }

    IPv6StringCollection toStringCollection(IPv6StringBuilderOptions opts, CharSequence zone) {
        IPv6StringCollection collection = new IPv6StringCollection();
        int mixedCount = this.getSegmentCount() - Math.max(6 - this.startIndex, 0);
        if (mixedCount > 0 && opts.includes(2)) {
            IPv6v4MixedAddressSection mixed = this.getMixedAddressSection();
            IPv6StringCollection.IPv6v4MixedStringBuilder mixedBuilder = new IPv6StringCollection.IPv6v4MixedStringBuilder(mixed, opts, zone);
            IPv6v4MixedStringCollection mixedCollection = (IPv6v4MixedStringCollection)mixedBuilder.getVariations();
            collection.add((IPAddressPartStringSubCollection<?, ?, ?>)mixedCollection);
        }
        if (opts.includes(1)) {
            IPv6StringCollection.IPv6StringBuilder ipv6Builder = new IPv6StringCollection.IPv6StringBuilder(this, opts, zone);
            IPv6AddressSectionStringCollection ipv6Collection = (IPv6AddressSectionStringCollection)ipv6Builder.getVariations();
            collection.add((IPAddressPartStringSubCollection<?, ?, ?>)ipv6Collection);
        }
        return collection;
    }

    @Override
    public IPAddressStringDivisionSeries[] getParts(IPAddressSection.IPStringBuilderOptions opts) {
        return this.getParts(IPv6StringBuilderOptions.from(opts));
    }

    public IPAddressStringDivisionSeries[] getParts(IPv6StringBuilderOptions opts) {
        if (opts.includes(2)) {
            if (opts.includes(1)) {
                return new IPAddressStringDivisionSeries[]{this, this.getMixedAddressSection()};
            }
            return new IPAddressStringDivisionSeries[]{this.getMixedAddressSection()};
        }
        return super.getParts(opts);
    }

    @Override
    public IPAddressDivisionGrouping.RangeList getZeroSegments() {
        if (this.zeroSegments == null) {
            this.zeroSegments = super.getZeroSegments();
        }
        return this.zeroSegments;
    }

    @Override
    public IPAddressDivisionGrouping.RangeList getZeroRangeSegments() {
        if (this.zeroRanges == null) {
            this.zeroRanges = super.getZeroRangeSegments();
        }
        return this.zeroRanges;
    }

    @Override
    public boolean isZero() {
        IPAddressDivisionGrouping.RangeList ranges = this.getZeroSegments();
        return ranges.size() == 1 && ranges.getRange((int)0).length == this.getSegmentCount();
    }

    private int[] getCompressIndexAndCount(CompressOptions options) {
        return this.getCompressIndexAndCount(options, false);
    }

    private int[] getCompressIndexAndCount(CompressOptions options, boolean createMixed) {
        if (options != null) {
            CompressOptions.CompressionChoiceOptions rangeSelection = options.rangeSelection;
            IPAddressDivisionGrouping.RangeList compressibleSegs = rangeSelection.compressHost() ? this.getZeroRangeSegments() : this.getZeroSegments();
            int maxIndex = -1;
            int maxCount = 0;
            int segmentCount = this.getSegmentCount();
            boolean compressMixed = createMixed && options.compressMixedOptions.compressMixed(this);
            boolean preferHost = rangeSelection == CompressOptions.CompressionChoiceOptions.HOST_PREFERRED;
            boolean preferMixed = createMixed && rangeSelection == CompressOptions.CompressionChoiceOptions.MIXED_PREFERRED;
            int i = compressibleSegs.size() - 1;
            while (i >= 0) {
                IPAddressDivisionGrouping.Range range = compressibleSegs.getRange(i);
                int index = range.index;
                int count = range.length;
                if (createMixed) {
                    int mixedIndex = 6 - this.startIndex;
                    if (!compressMixed || index > mixedIndex || index + count < segmentCount) {
                        count = Math.min(count, mixedIndex - index);
                    }
                }
                if (count > 0 && count >= maxCount && (options.compressSingle || count > 1)) {
                    maxIndex = index;
                    maxCount = count;
                }
                if (preferHost && this.isPrefixed() && (index + count) * 16 > this.getNetworkPrefixLength() || preferMixed && index + count >= segmentCount) break;
                --i;
            }
            if (maxIndex >= 0) {
                return new int[]{maxIndex, maxCount};
            }
        }
        return null;
    }

    static class AddressCache
    extends AddressDivisionGrouping.SectionCache<IPv6Address> {
        AddressCache() {
        }
    }

    public static class CompressOptions {
        public final boolean compressSingle;
        public final CompressionChoiceOptions rangeSelection;
        public final MixedCompressionOptions compressMixedOptions;

        public CompressOptions(boolean compressSingle, CompressionChoiceOptions rangeSelection) {
            this(compressSingle, rangeSelection, MixedCompressionOptions.YES);
        }

        public CompressOptions(boolean compressSingle, CompressionChoiceOptions rangeSelection, MixedCompressionOptions compressMixedOptions) {
            this.compressSingle = compressSingle;
            this.rangeSelection = rangeSelection;
            this.compressMixedOptions = compressMixedOptions == null ? MixedCompressionOptions.YES : compressMixedOptions;
        }

        public static enum CompressionChoiceOptions {
            HOST_PREFERRED,
            MIXED_PREFERRED,
            ZEROS_OR_HOST,
            ZEROS;


            boolean compressHost() {
                return this != ZEROS;
            }
        }

        public static enum MixedCompressionOptions {
            NO,
            NO_HOST,
            COVERED_BY_HOST,
            YES;


            boolean compressMixed(IPv6AddressSection addressSection) {
                switch (this) {
                    default: {
                        return true;
                    }
                    case NO: {
                        return false;
                    }
                    case NO_HOST: {
                        return !addressSection.isPrefixed();
                    }
                    case COVERED_BY_HOST: 
                }
                if (addressSection.isPrefixed()) {
                    int mixedDistance = 6 - addressSection.startIndex;
                    int mixedCount = addressSection.getSegmentCount() - Math.max(mixedDistance, 0);
                    if (mixedCount > 0) {
                        return mixedDistance * addressSection.getBitsPerSegment() >= addressSection.getNetworkPrefixLength();
                    }
                }
                return true;
            }
        }
    }

    private static class IPv6AddressSectionString
    extends IPAddressPartConfiguredString<IPv6AddressSection, IPv6StringParams> {
        private final CharSequence zone;

        IPv6AddressSectionString(IPv6AddressSection addr, IPv6StringParams stringParams, CharSequence zone) {
            super(addr, stringParams);
            this.zone = zone;
        }

        public IPv6StringMatcher getNetworkStringMatcher(boolean isEntireAddress, IPAddressSQLTranslator translator) {
            return new IPv6StringMatcher(this, translator);
        }

        public boolean endIsCompressed() {
            return ((IPv6StringParams)this.stringParams).endIsCompressed(this.addr);
        }

        public boolean isCompressed() {
            return ((IPv6StringParams)this.stringParams).isCompressed(this.addr);
        }

        @Override
        public String getString() {
            if (this.string == null) {
                this.string = ((IPv6StringParams)this.stringParams).toString((IPv6AddressSection)this.addr, this.zone);
            }
            return this.string;
        }
    }

    static class IPv6AddressSectionStringCollection
    extends IPAddressPartStringSubCollection<IPv6AddressSection, IPv6StringParams, IPv6AddressSectionString> {
        private final CharSequence zone;

        IPv6AddressSectionStringCollection(IPv6AddressSection addr, CharSequence zone) {
            super(addr);
            this.zone = zone;
        }

        @Override
        public Iterator<IPv6AddressSectionString> iterator() {
            return new IPAddressPartStringSubCollection.IPAddressConfigurableStringIterator(this){

                @Override
                public IPv6AddressSectionString next() {
                    return new IPv6AddressSectionString((IPv6AddressSection)part, (IPv6StringParams)this.iterator.next(), zone);
                }
            };
        }
    }

    public static class IPv6StringBuilderOptions
    extends IPAddressSection.IPStringBuilderOptions {
        public static final int MIXED = 2;
        public static final int UPPERCASE = 4;
        public static final int COMPRESSION_CANONICAL = 256;
        public static final int COMPRESSION_SINGLE = 768;
        public static final int COMPRESSION_LARGEST = 1792;
        public static final int COMPRESSION_ALL_FULL = 3840;
        public static final int COMPRESSION_ALL_PARTIAL = 7936;
        public static final int IPV4_CONVERSIONS = 65536;
        public final IPv4AddressSection.IPv4StringBuilderOptions mixedOptions;
        public final IPv4AddressSection.IPv4StringBuilderOptions ipv4ConverterOptions;
        public final IPv4Address.IPv4AddressConverter converter;
        public static final IPv6StringBuilderOptions STANDARD_OPTS = new IPv6StringBuilderOptions(3861, new IPv4AddressSection.IPv4StringBuilderOptions(17));
        public static final IPv6StringBuilderOptions ALL_OPTS = new IPv6StringBuilderOptions(69431, new IPv4AddressSection.IPv4StringBuilderOptions(49), null, new IPv4AddressSection.IPv4StringBuilderOptions(831));
        public static final IPv6StringBuilderOptions DATABASE_SEARCH_OPTS = new IPv6StringBuilderOptions(1793);

        public IPv6StringBuilderOptions(int options) {
            this(options, null, null, null);
        }

        public IPv6StringBuilderOptions(int options, IPv4AddressSection.IPv4StringBuilderOptions mixedOptions) {
            this(options, mixedOptions, null, null);
        }

        public IPv6StringBuilderOptions(int options, IPv4AddressSection.IPv4StringBuilderOptions mixedOptions, IPv4Address.IPv4AddressConverter ipv4AddressConverter, IPv4AddressSection.IPv4StringBuilderOptions ipv4ConverterOptions) {
            super(options | (mixedOptions == null ? 0 : 2) | (ipv4ConverterOptions == null ? 0 : 65536));
            if (this.includes(2) && mixedOptions == null) {
                mixedOptions = new IPv4AddressSection.IPv4StringBuilderOptions();
            }
            this.mixedOptions = mixedOptions;
            if (this.includes(65536)) {
                if (ipv4ConverterOptions == null) {
                    ipv4ConverterOptions = new IPv4AddressSection.IPv4StringBuilderOptions();
                }
                if (ipv4AddressConverter == null && (ipv4AddressConverter = IPAddress.addressConverter) == null) {
                    ipv4AddressConverter = new IPAddressConverter.DefaultAddressConverter();
                }
            }
            this.ipv4ConverterOptions = ipv4ConverterOptions;
            this.converter = ipv4AddressConverter;
        }

        public static IPv6StringBuilderOptions from(IPAddressSection.IPStringBuilderOptions opts) {
            if (opts instanceof IPv6StringBuilderOptions) {
                return (IPv6StringBuilderOptions)opts;
            }
            return new IPv6StringBuilderOptions(opts.options & 0xFFFEE0F9);
        }
    }

    static class IPv6StringCache
    extends IPAddressSection.IPStringCache {
        static final IPv6StringOptions mixedParams;
        static final IPv6StringOptions fullParams;
        static final IPv6StringOptions normalizedParams;
        static final IPv6StringOptions canonicalParams;
        static final IPv6StringOptions uncParams;
        static final IPv6StringOptions compressedParams;
        static final IPv6StringOptions wildcardNormalizedParams;
        static final IPv6StringOptions wildcardCanonicalParams;
        static final IPv6StringOptions sqlWildcardParams;
        static final IPv6StringOptions wildcardCompressedParams;
        static final IPv6StringOptions networkPrefixLengthParams;
        static final IPv6StringOptions reverseDNSParams;
        static final IPAddressSection.IPStringOptions base85Params;
        public String normalizedString;
        public String compressedString;
        public String mixedString;
        public String compressedWildcardString;
        public String canonicalWildcardString;
        public String networkPrefixLengthString;
        public String base85String;
        public String uncString;

        static {
            CompressOptions compressAll = new CompressOptions(true, CompressOptions.CompressionChoiceOptions.ZEROS_OR_HOST);
            CompressOptions compressMixed = new CompressOptions(true, CompressOptions.CompressionChoiceOptions.MIXED_PREFERRED);
            CompressOptions compressAllNoSingles = new CompressOptions(false, CompressOptions.CompressionChoiceOptions.ZEROS_OR_HOST);
            CompressOptions compressHostPreferred = new CompressOptions(true, CompressOptions.CompressionChoiceOptions.HOST_PREFERRED);
            CompressOptions compressZeros = new CompressOptions(true, CompressOptions.CompressionChoiceOptions.ZEROS);
            CompressOptions compressZerosNoSingles = new CompressOptions(false, CompressOptions.CompressionChoiceOptions.ZEROS);
            mixedParams = new IPv6StringOptions.Builder().setMakeMixed(true).setCompressOptions(compressMixed).toParams();
            fullParams = new IPv6StringOptions.Builder().setExpandedSegments(true).setWildcardOptions(new IPAddressSection.WildcardOptions(IPAddressSection.WildcardOptions.WildcardOption.NETWORK_ONLY, new AddressDivisionGrouping.StringOptions.Wildcards(IPAddress.RANGE_SEPARATOR_STR))).toParams();
            canonicalParams = new IPv6StringOptions.Builder().setCompressOptions(compressAllNoSingles).toParams();
            uncParams = new IPv6StringOptions.Builder().setSeparator(Character.valueOf('-')).setZoneSeparator('s').setAddressSuffix(".ipv6-literal.net").setWildcardOptions(new IPAddressSection.WildcardOptions(IPAddressSection.WildcardOptions.WildcardOption.NETWORK_ONLY, new AddressDivisionGrouping.StringOptions.Wildcards(IPv6Address.UNC_RANGE_SEPARATOR_STR, IPAddress.SEGMENT_WILDCARD_STR, null))).toParams();
            compressedParams = new IPv6StringOptions.Builder().setCompressOptions(compressAll).toParams();
            normalizedParams = new IPv6StringOptions.Builder().toParams();
            IPAddressSection.WildcardOptions allWildcards = new IPAddressSection.WildcardOptions(IPAddressSection.WildcardOptions.WildcardOption.ALL);
            IPAddressSection.WildcardOptions allSQLWildcards = new IPAddressSection.WildcardOptions(IPAddressSection.WildcardOptions.WildcardOption.ALL, new AddressDivisionGrouping.StringOptions.Wildcards(IPAddress.SEGMENT_SQL_WILDCARD_STR, IPAddress.SEGMENT_SQL_SINGLE_WILDCARD_STR));
            wildcardCanonicalParams = new IPv6StringOptions.Builder().setWildcardOptions(allWildcards).setCompressOptions(compressZerosNoSingles).toParams();
            wildcardNormalizedParams = new IPv6StringOptions.Builder().setWildcardOptions(allWildcards).toParams();
            sqlWildcardParams = new IPv6StringOptions.Builder().setWildcardOptions(allSQLWildcards).toParams();
            wildcardCompressedParams = new IPv6StringOptions.Builder().setWildcardOptions(allWildcards).setCompressOptions(compressZeros).toParams();
            networkPrefixLengthParams = new IPv6StringOptions.Builder().setCompressOptions(compressHostPreferred).toParams();
            reverseDNSParams = new IPv6StringOptions.Builder().setReverse(true).setAddressSuffix(".ip6.arpa").setSplitDigits(true).setExpandedSegments(true).setSeparator(Character.valueOf('.')).toParams();
            base85Params = new IPAddressSection.IPStringOptions.Builder(85).setExpandedSegments(true).setWildcards(new AddressDivisionGrouping.StringOptions.Wildcards(Address.ALTERNATIVE_RANGE_SEPARATOR_STR)).setZoneSeparator('\u00a7').toParams();
        }

        IPv6StringCache() {
        }
    }

    static class IPv6StringCollection
    extends IPAddressPartStringCollection {
        IPv6StringCollection() {
        }

        protected void add(IPAddressPartStringSubCollection<?, ?, ?> collection) {
            super.add(collection);
        }

        @Override
        protected void addAll(IPAddressPartStringCollection collections) {
            super.addAll(collections);
        }

        static class IPv6StringBuilder
        extends IPAddressPartStringCollection.AddressPartStringBuilder<IPv6AddressSection, IPv6StringParams, IPv6AddressSectionString, IPv6AddressSectionStringCollection, IPv6StringBuilderOptions> {
            IPv6StringBuilder(IPv6AddressSection address, IPv6StringBuilderOptions opts, CharSequence zone) {
                super(address, opts, new IPv6AddressSectionStringCollection(address, zone));
            }

            private void addUppercaseVariations(ArrayList<IPv6StringParams> allParams, int base) {
                boolean lowerOnly = true;
                if (((IPv6StringBuilderOptions)this.options).includes(4) && ((IPv6AddressSection)this.addressSection).hasUppercaseVariations(base, lowerOnly)) {
                    int len = allParams.size();
                    int j = 0;
                    while (j < len) {
                        IPv6StringParams clone = allParams.get(j);
                        clone = clone.clone();
                        clone.setUppercase(true);
                        allParams.add(clone);
                        ++j;
                    }
                }
            }

            private void addAllExpansions(int firstCompressedIndex, int count, int segmentCount) {
                boolean isExpandable;
                IPv6StringParams stringParams = new IPv6StringParams(firstCompressedIndex, count);
                int base = stringParams.getRadix();
                ArrayList<IPv6StringParams> allParams = new ArrayList<IPv6StringParams>();
                allParams.add(stringParams);
                int radix = 16;
                if (((IPv6StringBuilderOptions)this.options).includes(48)) {
                    int[] expandables = this.getExpandableSegments(radix);
                    int nextUncompressedIndex = firstCompressedIndex + count;
                    int ipv6SegmentEnd = ((IPv6AddressSection)this.addressSection).getSegmentCount();
                    int i = 0;
                    while (i < ipv6SegmentEnd) {
                        if (i < firstCompressedIndex || i >= nextUncompressedIndex) {
                            int expansionLength = expandables[i];
                            int len = allParams.size();
                            while (expansionLength > 0) {
                                int j = 0;
                                while (j < len) {
                                    IPv6StringParams clone = allParams.get(j);
                                    clone = clone.clone();
                                    clone.expandSegment(i, expansionLength, ((IPv6AddressSection)this.addressSection).getSegmentCount());
                                    allParams.add(clone);
                                    ++j;
                                }
                                if (!((IPv6StringBuilderOptions)this.options).includes(112)) break;
                                --expansionLength;
                            }
                        }
                        ++i;
                    }
                } else if (((IPv6StringBuilderOptions)this.options).includes(16) && (isExpandable = this.isExpandableOutsideRange(radix, firstCompressedIndex, count))) {
                    int len = allParams.size();
                    int j = 0;
                    while (j < len) {
                        IPv6StringParams clone = allParams.get(j);
                        clone = clone.clone();
                        clone.expandSegments(true);
                        allParams.add(clone);
                        ++j;
                    }
                }
                this.addUppercaseVariations(allParams, base);
                int i = 0;
                while (i < allParams.size()) {
                    IPv6StringParams param = allParams.get(i);
                    this.addStringParam(param);
                    ++i;
                }
            }

            private void addAllCompressedStrings(int zeroStartIndex, int count, boolean partial, int segmentCount) {
                int end = zeroStartIndex + count;
                if (partial) {
                    int i = zeroStartIndex;
                    while (i < end) {
                        int j = i + 1;
                        while (j <= end) {
                            this.addAllExpansions(i, j - i, segmentCount);
                            ++j;
                        }
                        ++i;
                    }
                } else {
                    int len = end - zeroStartIndex;
                    if (len > 0) {
                        this.addAllExpansions(zeroStartIndex, len, segmentCount);
                    }
                }
            }

            @Override
            protected void addAllVariations() {
                CompressOptions opts;
                int[] indexes;
                int segmentCount = ((IPv6AddressSection)this.addressSection).getSegmentCount();
                this.addAllExpansions(-1, 0, segmentCount);
                if (((IPv6StringBuilderOptions)this.options).includes(3840)) {
                    IPAddressDivisionGrouping.RangeList zeroSegs = ((IPv6AddressSection)this.addressSection).getZeroSegments();
                    int i = 0;
                    while (i < zeroSegs.size()) {
                        IPAddressDivisionGrouping.Range range = zeroSegs.getRange(i);
                        this.addAllCompressedStrings(range.index, range.length, ((IPv6StringBuilderOptions)this.options).includes(7936), segmentCount);
                        ++i;
                    }
                } else if (((IPv6StringBuilderOptions)this.options).includes(256) && (indexes = ((IPv6AddressSection)this.addressSection).getCompressIndexAndCount(opts = new CompressOptions(((IPv6StringBuilderOptions)this.options).includes(768), CompressOptions.CompressionChoiceOptions.ZEROS))) != null) {
                    if (((IPv6StringBuilderOptions)this.options).includes(1792)) {
                        int maxCount = indexes[1];
                        IPAddressDivisionGrouping.RangeList zeroSegs = ((IPv6AddressSection)this.addressSection).getZeroSegments();
                        int i = 0;
                        while (i < zeroSegs.size()) {
                            IPAddressDivisionGrouping.Range range = zeroSegs.getRange(i);
                            int count = range.length;
                            if (count == maxCount) {
                                this.addAllCompressedStrings(range.index, count, ((IPv6StringBuilderOptions)this.options).includes(7936), segmentCount);
                            }
                            ++i;
                        }
                    } else {
                        int maxIndex = indexes[0];
                        int maxCount = indexes[1];
                        this.addAllCompressedStrings(maxIndex, maxCount, false, segmentCount);
                    }
                }
            }
        }

        static class IPv6v4MixedStringBuilder
        extends IPAddressPartStringCollection.AddressPartStringBuilder<IPv6v4MixedAddressSection, IPv6v4MixedParams, IPAddressPartConfiguredString<IPv6v4MixedAddressSection, IPv6v4MixedParams>, IPv6v4MixedStringCollection, IPv6StringBuilderOptions> {
            private final CharSequence zone;

            IPv6v4MixedStringBuilder(IPv6v4MixedAddressSection address, IPv6StringBuilderOptions opts, CharSequence zone) {
                super(address, opts, new IPv6v4MixedStringCollection(address, zone));
                this.zone = zone;
            }

            @Override
            protected void addAllVariations() {
                IPv6StringBuilder ipv6Builder = new IPv6StringBuilder(((IPv6v4MixedAddressSection)this.addressSection).ipv6Section, (IPv6StringBuilderOptions)this.options, this.zone);
                IPv6AddressSectionStringCollection ipv6Variations = (IPv6AddressSectionStringCollection)ipv6Builder.getVariations();
                IPAddressPartStringCollection ipv4Collection = ((IPv6v4MixedAddressSection)this.addressSection).ipv4Section.toStringCollection(((IPv6StringBuilderOptions)this.options).mixedOptions);
                for (IPv6AddressSectionString ipv6Variation : ipv6Variations) {
                    for (IPAddressPartConfiguredString<?, ?> ipv4Variation : ipv4Collection) {
                        IPv6v4MixedParams mixed = new IPv6v4MixedParams(ipv6Variation, ipv4Variation);
                        this.addStringParam(mixed);
                    }
                }
            }
        }
    }

    private static class IPv6StringMatcher
    extends SQLStringMatcher<IPv6AddressSection, IPv6StringParams, IPv6AddressSectionString> {
        IPv6StringMatcher(IPv6AddressSectionString networkString, IPAddressSQLTranslator translator) {
            super(networkString, ((IPv6AddressSection)networkString.addr).isEntireAddress(), translator);
        }

        @Override
        public StringBuilder getSQLCondition(StringBuilder builder, String columnName) {
            if (((IPv6AddressSection)((IPv6AddressSectionString)this.networkString).addr).isEntireAddress()) {
                this.matchString(builder, columnName, ((IPv6AddressSectionString)this.networkString).getString());
            } else if (((IPv6AddressSectionString)this.networkString).endIsCompressed()) {
                char sep = ((IPv6AddressSectionString)this.networkString).getTrailingSegmentSeparator();
                String searchStr = ((IPv6AddressSectionString)this.networkString).getString().substring(0, ((IPv6AddressSectionString)this.networkString).getString().length() - 1);
                builder.append('(');
                this.matchSubString(builder, columnName, sep, ((IPv6AddressSectionString)this.networkString).getTrailingSeparatorCount(), searchStr);
                int extraSeparatorCountMax = 7 - ((IPv6AddressSection)((IPv6AddressSectionString)this.networkString).addr).getSegmentCount();
                builder.append(") AND (");
                this.boundSeparatorCount(builder, columnName, sep, extraSeparatorCountMax + ((IPv6AddressSectionString)this.networkString).getTrailingSeparatorCount());
                builder.append(')');
            } else if (((IPv6AddressSectionString)this.networkString).isCompressed()) {
                char sep = ((IPv6AddressSectionString)this.networkString).getTrailingSegmentSeparator();
                builder.append('(');
                this.matchSubString(builder, columnName, sep, ((IPv6AddressSectionString)this.networkString).getTrailingSeparatorCount() + 1, ((IPv6AddressSectionString)this.networkString).getString());
                int extraSeparatorCount = 8 - ((IPv6AddressSection)((IPv6AddressSectionString)this.networkString).addr).getSegmentCount();
                builder.append(") AND (");
                this.matchSeparatorCount(builder, columnName, sep, extraSeparatorCount + ((IPv6AddressSectionString)this.networkString).getTrailingSeparatorCount());
                builder.append(')');
            } else {
                this.matchSubString(builder, columnName, ((IPv6AddressSectionString)this.networkString).getTrailingSegmentSeparator(), ((IPv6AddressSectionString)this.networkString).getTrailingSeparatorCount() + 1, ((IPv6AddressSectionString)this.networkString).getString());
            }
            return builder;
        }
    }

    public static class IPv6StringOptions
    extends IPAddressSection.IPStringOptions {
        public final IPAddressSection.IPStringOptions ipv4Opts;
        public final CompressOptions compressOptions;

        IPv6StringOptions(int base, boolean expandSegments, IPAddressSection.WildcardOptions.WildcardOption wildcardOption, AddressDivisionGrouping.StringOptions.Wildcards wildcards, String segmentStrPrefix, boolean makeMixed, IPAddressSection.IPStringOptions ipv4Opts, CompressOptions compressOptions, Character separator, char zoneSeparator, String addressPrefix, String addressSuffix, boolean reverse, boolean splitDigits, boolean uppercase) {
            super(base, expandSegments, wildcardOption, wildcards, segmentStrPrefix, separator, zoneSeparator, addressPrefix, addressSuffix, reverse, splitDigits, uppercase);
            this.compressOptions = compressOptions;
            if (makeMixed) {
                if (ipv4Opts == null) {
                    ipv4Opts = new IPv4AddressSection.IPv4StringOptions.Builder().setExpandedSegments(expandSegments).setWildcardOption(wildcardOption).setWildcards(wildcards).toParams();
                }
                this.ipv4Opts = ipv4Opts;
            } else {
                this.ipv4Opts = null;
            }
        }

        boolean makeMixed() {
            return this.ipv4Opts != null;
        }

        private IPv6StringParams from(IPv6AddressSection addr) {
            boolean makeMixed;
            int[] vals;
            IPv6StringParams result = new IPv6StringParams();
            if (this.compressOptions != null && (vals = addr.getCompressIndexAndCount(this.compressOptions, makeMixed = this.makeMixed())) != null) {
                int maxIndex = vals[0];
                int maxCount = vals[1];
                result.firstCompressedSegmentIndex = maxIndex;
                result.nextUncompressedIndex = maxIndex + maxCount;
                result.hostCompressed = this.compressOptions.rangeSelection.compressHost() && result.nextUncompressedIndex > IPv6AddressSection.getSegmentIndex(addr.getNetworkPrefixLength(), 16, 2);
            }
            result.expandSegments(this.expandSegments);
            result.setWildcardOption(this.wildcardOption);
            result.setWildcards(this.wildcards);
            result.setSeparator(this.separator);
            result.setAddressSuffix(this.addrSuffix);
            result.setAddressLabel(this.addrLabel);
            result.setReverse(this.reverse);
            result.setSplitDigits(this.splitDigits);
            result.setZoneSeparator(this.zoneSeparator);
            result.setUppercase(this.uppercase);
            result.setRadix(this.base);
            result.setSegmentStrPrefix(this.segmentStrPrefix);
            return result;
        }

        public static IPv6StringOptions from(IPAddressSection.IPStringOptions opts) {
            if (opts instanceof IPv6StringOptions) {
                return (IPv6StringOptions)opts;
            }
            return new IPv6StringOptions(opts.base, opts.expandSegments, opts.wildcardOption, opts.wildcards, opts.segmentStrPrefix, false, null, null, opts.separator, '%', opts.addrLabel, opts.addrSuffix, opts.reverse, opts.splitDigits, opts.uppercase);
        }

        public static class Builder
        extends IPAddressSection.IPStringOptions.Builder {
            private boolean makeMixed;
            private IPAddressSection.IPStringOptions ipv4Options;
            private CompressOptions compressOptions;

            public Builder() {
                super(16, ':');
            }

            public Builder setCompressOptions(CompressOptions compressOptions) {
                this.compressOptions = compressOptions;
                return this;
            }

            public Builder setMakeMixed(boolean makeMixed) {
                this.makeMixed = makeMixed;
                return this;
            }

            public Builder setMakeMixed(IPAddressSection.IPStringOptions ipv4Options) {
                this.makeMixed = true;
                this.ipv4Options = ipv4Options;
                return this;
            }

            @Override
            public Builder setWildcardOptions(IPAddressSection.WildcardOptions wildcardOptions) {
                return (Builder)super.setWildcardOptions(wildcardOptions);
            }

            @Override
            public Builder setExpandedSegments(boolean expandSegments) {
                return (Builder)super.setExpandedSegments(expandSegments);
            }

            @Override
            public Builder setRadix(int base) {
                return (Builder)super.setRadix(base);
            }

            @Override
            public Builder setSeparator(Character separator) {
                return (Builder)super.setSeparator(separator);
            }

            @Override
            public Builder setZoneSeparator(char separator) {
                return (Builder)super.setZoneSeparator(separator);
            }

            @Override
            public Builder setAddressSuffix(String suffix) {
                return (Builder)super.setAddressSuffix(suffix);
            }

            @Override
            public Builder setSegmentStrPrefix(String prefix) {
                return (Builder)super.setSegmentStrPrefix(prefix);
            }

            @Override
            public Builder setReverse(boolean reverse) {
                return (Builder)super.setReverse(reverse);
            }

            @Override
            public Builder setUppercase(boolean upper) {
                return (Builder)super.setUppercase(upper);
            }

            @Override
            public Builder setSplitDigits(boolean splitDigits) {
                return (Builder)super.setSplitDigits(splitDigits);
            }

            @Override
            public IPv6StringOptions toParams() {
                return new IPv6StringOptions(this.base, this.expandSegments, this.wildcardOption, this.wildcards, this.segmentStrPrefix, this.makeMixed, this.ipv4Options, this.compressOptions, this.separator, this.zoneSeparator, this.addrLabel, this.addrSuffix, this.reverse, this.splitDigits, this.uppercase);
            }
        }
    }

    static class IPv6StringParams
    extends IPAddressDivisionGrouping.IPAddressStringParams<IPv6AddressSection> {
        int firstCompressedSegmentIndex;
        int nextUncompressedIndex;
        boolean hostCompressed;

        IPv6StringParams() {
            this(-1, 0);
        }

        IPv6StringParams(int firstCompressedSegmentIndex, int compressedCount) {
            this(false, firstCompressedSegmentIndex, compressedCount, false, ':', '%');
        }

        private IPv6StringParams(boolean expandSegments, int firstCompressedSegmentIndex, int compressedCount, boolean uppercase, char separator, char zoneSeparator) {
            super(16, Character.valueOf(separator), uppercase, zoneSeparator);
            this.expandSegments(expandSegments);
            this.firstCompressedSegmentIndex = firstCompressedSegmentIndex;
            this.nextUncompressedIndex = firstCompressedSegmentIndex + compressedCount;
        }

        public boolean endIsCompressed(IPAddressStringDivisionSeries addr) {
            return this.nextUncompressedIndex >= addr.getDivisionCount();
        }

        public boolean isCompressed(IPAddressStringDivisionSeries addr) {
            return this.firstCompressedSegmentIndex >= 0;
        }

        @Override
        public int getTrailingSeparatorCount(IPv6AddressSection addr) {
            return this.getTrailingSepCount(addr);
        }

        public int getTrailingSepCount(IPAddressStringDivisionSeries addr) {
            int divisionCount = addr.getDivisionCount();
            if (divisionCount == 0) {
                return 0;
            }
            int count = divisionCount - 1;
            if (this.isCompressed(addr)) {
                count -= this.nextUncompressedIndex - this.firstCompressedSegmentIndex - 1;
                if (this.firstCompressedSegmentIndex == 0 || this.nextUncompressedIndex >= divisionCount) {
                    ++count;
                }
            }
            return count;
        }

        @Override
        public int getStringLength(IPv6AddressSection addr) {
            int count = this.getSegmentsStringLength(addr);
            if (!(this.isReverse() || this.preferWildcards() && !this.hostCompressed)) {
                count += IPv6StringParams.getPrefixStringLength(addr);
            }
            count += this.getAddressSuffixLength();
            return count += this.getAddressLabelLength();
        }

        @Override
        public StringBuilder append(StringBuilder builder, IPv6AddressSection addr, CharSequence zone) {
            this.appendLabel(builder);
            this.appendSegments(builder, addr);
            if (zone != null) {
                this.appendZone(builder, zone);
            }
            this.appendSuffix(builder);
            if (!(this.isReverse() || this.preferWildcards() && !this.hostCompressed)) {
                this.appendPrefixIndicator(builder, addr);
            }
            return builder;
        }

        @Override
        public StringBuilder appendSegments(StringBuilder builder, IPv6AddressSection addr) {
            int divisionCount = addr.getDivisionCount();
            if (divisionCount <= 0) {
                return builder;
            }
            int lastIndex = divisionCount - 1;
            Character separator = this.getSeparator();
            boolean reverse = this.isReverse();
            int i = 0;
            while (true) {
                int segIndex;
                int n = segIndex = reverse ? lastIndex - i : i;
                if (segIndex < this.firstCompressedSegmentIndex || segIndex >= this.nextUncompressedIndex) {
                    IPAddressDivision seg = addr.getDivision(segIndex);
                    this.appendSegment(segIndex, seg, builder);
                    if (++i > lastIndex) break;
                    if (separator == null) continue;
                    builder.append(separator);
                    continue;
                }
                if (segIndex == (reverse ? this.nextUncompressedIndex - 1 : this.firstCompressedSegmentIndex) && separator != null) {
                    builder.append(separator);
                    if (i == 0) {
                        builder.append(separator);
                    }
                }
                if (++i > lastIndex) break;
            }
            return builder;
        }

        @Override
        public int getSegmentsStringLength(IPv6AddressSection part) {
            int count = 0;
            int divCount = part.getDivisionCount();
            if (divCount != 0) {
                Character separator = this.getSeparator();
                int i = 0;
                while (true) {
                    if (i < this.firstCompressedSegmentIndex || i >= this.nextUncompressedIndex) {
                        IPAddressDivision seg = part.getDivision(i);
                        count += this.appendSegment(i, seg, null);
                        if (++i >= divCount) break;
                        if (separator == null) continue;
                        ++count;
                        continue;
                    }
                    if (i == this.firstCompressedSegmentIndex && separator != null) {
                        ++count;
                        if (i == 0) {
                            ++count;
                        }
                    }
                    if (++i >= divCount) break;
                }
            }
            return count;
        }

        @Override
        public IPv6StringParams clone() {
            return (IPv6StringParams)super.clone();
        }
    }

    public static class IPv6v4MixedAddressSection
    extends IPAddressDivisionGrouping {
        private static final long serialVersionUID = 3L;
        private final IPv6AddressSection ipv6Section;
        private final IPv4AddressSection ipv4Section;
        private String string;

        private IPv6v4MixedAddressSection(IPv6AddressSection ipv6Section, IPv4AddressSection ipv4Section) {
            super(IPv6v4MixedAddressSection.createSegments(ipv6Section, ipv4Section));
            this.ipv4Section = ipv4Section;
            this.ipv6Section = ipv6Section;
        }

        private static IPAddressDivision[] createSegments(IPv6AddressSection ipv6Section, IPv4AddressSection ipv4Section) {
            int ipv6Len = ipv6Section.getSegmentCount();
            int ipv4Len = ipv4Section.getSegmentCount();
            AddressSegment[] allSegs = new IPAddressSegment[ipv6Len + ipv4Len];
            ipv6Section.getSegments(0, ipv6Len, allSegs, 0);
            ipv4Section.getSegments(0, ipv4Len, allSegs, ipv6Len);
            return allSegs;
        }

        public int getByteCount() {
            return this.ipv6Section.getByteCount() + this.ipv4Section.getByteCount();
        }

        @Override
        public int getBitCount() {
            return this.ipv6Section.getBitCount() + this.ipv4Section.getBitCount();
        }

        @Override
        public String toString() {
            if (this.string == null) {
                IPv6StringOptions mixedParams = IPv6StringCache.mixedParams;
                IPv6StringParams ipv6Params = mixedParams.from(this.ipv6Section);
                IPAddressSection.IPStringOptions ipv4Opts = mixedParams.ipv4Opts;
                IPv6v4MixedParams parms = new IPv6v4MixedParams(ipv6Params, ipv4Opts);
                this.string = parms.toString(this);
            }
            return this.string;
        }

        @Override
        protected boolean isSameGrouping(AddressDivisionGrouping o) {
            if (o instanceof IPv6v4MixedAddressSection) {
                IPv6v4MixedAddressSection other = (IPv6v4MixedAddressSection)o;
                return this.ipv6Section.equals(other.ipv6Section) && this.ipv4Section.equals(other.ipv4Section);
            }
            return false;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof IPv6v4MixedAddressSection) {
                IPv6v4MixedAddressSection other = (IPv6v4MixedAddressSection)o;
                return this.ipv6Section.equals(other.ipv6Section) && this.ipv4Section.equals(other.ipv4Section);
            }
            return false;
        }
    }

    static class IPv6v4MixedParams
    implements IPAddressStringWriter<IPv6v4MixedAddressSection>,
    Cloneable {
        private IPAddressDivisionGrouping.IPAddressStringParams<IPAddressStringDivisionSeries> ipv4Params;
        private IPv6StringParams ipv6Params;

        IPv6v4MixedParams(IPv6AddressSectionString ipv6Variation, IPAddressPartConfiguredString<?, ?> ipv4Variation) {
            this.ipv4Params = (IPAddressDivisionGrouping.IPAddressStringParams)ipv4Variation.stringParams;
            this.ipv6Params = (IPv6StringParams)ipv6Variation.stringParams;
        }

        IPv6v4MixedParams(IPv6StringParams ipv6Params, IPAddressSection.IPStringOptions ipv4Opts) {
            this.ipv4Params = IPv6AddressSection.toIPParams(ipv4Opts);
            this.ipv6Params = ipv6Params;
        }

        @Override
        public char getTrailingSegmentSeparator() {
            return this.ipv4Params.getTrailingSegmentSeparator();
        }

        @Override
        public int getTrailingSeparatorCount(IPv6v4MixedAddressSection addr) {
            return this.ipv4Params.getTrailingSeparatorCount(addr.ipv4Section);
        }

        public int getStringLength(IPv6v4MixedAddressSection addr, CharSequence zone) {
            int ipv6length = this.ipv6Params.getSegmentsStringLength(addr.ipv6Section);
            int ipv4length = this.ipv4Params.getSegmentsStringLength(addr.ipv4Section);
            int length = ipv6length + ipv4length;
            if (this.ipv6Params.nextUncompressedIndex < addr.ipv6Section.getSegmentCount()) {
                ++length;
            }
            length += this.getPrefixStringLength(addr);
            length += this.ipv6Params.getZoneLength(zone);
            length += this.ipv6Params.getAddressSuffixLength();
            return length += this.ipv6Params.getAddressLabelLength();
        }

        @Override
        public String toString(IPv6v4MixedAddressSection addr) {
            return this.toString(addr, (CharSequence)null);
        }

        @Override
        public String toString(IPv6v4MixedAddressSection addr, CharSequence zone) {
            int length = this.getStringLength(addr, zone);
            StringBuilder builder = new StringBuilder(length);
            this.append(builder, addr, zone);
            AddressDivisionGrouping.AddressStringParams.checkLengths(length, builder);
            return builder.toString();
        }

        @Override
        public int getDivisionStringLength(AddressStringDivision seg) {
            return this.ipv6Params.getDivisionStringLength(seg);
        }

        @Override
        public StringBuilder appendDivision(StringBuilder builder, AddressStringDivision seg) {
            return this.ipv6Params.appendDivision(builder, seg);
        }

        public StringBuilder append(StringBuilder builder, IPv6v4MixedAddressSection addr, CharSequence zone) {
            this.ipv6Params.appendLabel(builder);
            this.ipv6Params.appendSegments(builder, addr.ipv6Section);
            if (this.ipv6Params.nextUncompressedIndex < addr.ipv6Section.getSegmentCount()) {
                builder.append(this.ipv6Params.getTrailingSegmentSeparator());
            }
            this.ipv4Params.appendSegments(builder, addr.ipv4Section);
            this.ipv6Params.appendZone(builder, zone);
            this.ipv6Params.appendSuffix(builder);
            this.appendPrefixIndicator(builder, addr);
            return builder;
        }

        protected int getPrefixStringLength(IPv6v4MixedAddressSection addr) {
            if (this.requiresPrefixIndicator(addr.ipv6Section) || this.requiresPrefixIndicator(addr.ipv4Section)) {
                return IPAddressDivisionGrouping.IPAddressStringParams.getPrefixStringLength(addr);
            }
            return 0;
        }

        public void appendPrefixIndicator(StringBuilder builder, IPv6v4MixedAddressSection addr) {
            if (this.requiresPrefixIndicator(addr.ipv6Section) || this.requiresPrefixIndicator(addr.ipv4Section)) {
                this.ipv6Params.appendPrefixIndicator(builder, addr);
            }
        }

        protected boolean requiresPrefixIndicator(IPv4AddressSection ipv4Section) {
            return ipv4Section.isPrefixed() && !this.ipv4Params.preferWildcards();
        }

        protected boolean requiresPrefixIndicator(IPv6AddressSection ipv6Section) {
            return ipv6Section.isPrefixed() && (!this.ipv6Params.preferWildcards() || this.ipv6Params.hostCompressed);
        }

        public IPv6v4MixedParams clone() {
            try {
                IPv6v4MixedParams params = (IPv6v4MixedParams)super.clone();
                params.ipv6Params = this.ipv6Params.clone();
                params.ipv4Params = this.ipv4Params.clone();
                return params;
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }
    }

    static class IPv6v4MixedStringCollection
    extends IPAddressPartStringSubCollection<IPv6v4MixedAddressSection, IPv6v4MixedParams, IPAddressPartConfiguredString<IPv6v4MixedAddressSection, IPv6v4MixedParams>> {
        private final CharSequence zone;

        public IPv6v4MixedStringCollection(IPv6v4MixedAddressSection part, CharSequence zone) {
            super(part);
            this.zone = zone;
        }

        @Override
        public Iterator<IPAddressPartConfiguredString<IPv6v4MixedAddressSection, IPv6v4MixedParams>> iterator() {
            return new IPAddressPartStringSubCollection.IPAddressConfigurableStringIterator(this){

                @Override
                public IPAddressPartConfiguredString<IPv6v4MixedAddressSection, IPv6v4MixedParams> next() {
                    return new IPAddressPartConfiguredString<IPv6v4MixedAddressSection, IPv6v4MixedParams>((IPv6v4MixedAddressSection)part, (IPv6v4MixedParams)this.iterator.next()){

                        @Override
                        public String getString() {
                            if (this.string == null) {
                                this.string = ((IPv6v4MixedParams)this.stringParams).toString((IPv6v4MixedAddressSection)this.addr, zone);
                            }
                            return this.string;
                        }
                    };
                }
            };
        }
    }
}

