/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.format.validate;

import inet.ipaddr.AddressTypeException;
import inet.ipaddr.HostIdentifierString;
import inet.ipaddr.format.validate.AddressParseData;
import inet.ipaddr.format.validate.ParsedAddressCreator;
import inet.ipaddr.mac.MACAddress;
import inet.ipaddr.mac.MACAddressNetwork;
import inet.ipaddr.mac.MACAddressSection;
import inet.ipaddr.mac.MACAddressSegment;
import java.io.Serializable;

class ParsedMACAddress
implements Serializable {
    private static final long serialVersionUID = 3L;
    private final String addressString;
    private final HostIdentifierString originator;
    private final MACAddressParseData parseData;

    ParsedMACAddress(HostIdentifierString from, String addressString, MACAddressParseData parseData) {
        this.parseData = parseData;
        this.addressString = addressString;
        this.originator = from;
    }

    private static MACAddressNetwork.MACAddressCreator getMACAddressCreator() {
        MACAddressNetwork network = MACAddress.network();
        return network.getAddressCreator();
    }

    MACAddress createAddress() {
        MACAddressNetwork.MACAddressCreator creator = ParsedMACAddress.getMACAddressCreator();
        return (MACAddress)creator.createAddressInternal(this.createSection(), this.originator);
    }

    /*
     * Unable to fully structure code
     */
    private MACAddressSection createSection() {
        addressParseData = this.parseData.addressParseData;
        actualInitialSegmentCount = addressParseData.segmentCount;
        creator = ParsedMACAddress.getMACAddressCreator();
        format = this.parseData.format;
        if (format == null) {
            finalSegmentCount = this.parseData.isExtended != false ? 8 : 6;
            initialSegmentCount = finalSegmentCount;
        } else if (format == MACAddressParseData.MACFormat.DOTTED) {
            v0 = initialSegmentCount = this.parseData.isExtended != false ? 4 : 3;
            finalSegmentCount = actualInitialSegmentCount <= 3 && !this.parseData.isExtended ? 6 : 8;
        } else {
            finalSegmentCount = addressParseData.isSingleSegment != false || this.parseData.isDoubleSegment != false ? (this.parseData.isExtended != false ? 8 : 6) : (actualInitialSegmentCount <= 6 && this.parseData.isExtended == false ? 6 : 8);
            initialSegmentCount = finalSegmentCount;
        }
        missingCount = initialSegmentCount - actualInitialSegmentCount;
        expandedSegments = missingCount <= 0;
        segments = creator.createSegmentArray(finalSegmentCount);
        i = 0;
        normalizedSegmentIndex = 0;
        while (i < actualInitialSegmentCount) {
            block22: {
                vals = addressParseData.values[i];
                flags = addressParseData.flags[i];
                indices = addressParseData.indices[i];
                lower = vals[0];
                upper = vals[1];
                if (format != MACAddressParseData.MACFormat.DOTTED) break block22;
                lowerHalfLower = (int)lower >>> 8;
                lowerHalfUpper = (int)upper >>> 8;
                adjustedLower2 = (int)lower & 255;
                adjustedUpper2 = (int)upper & 255;
                if (lowerHalfLower != lowerHalfUpper && adjustedUpper2 - adjustedLower2 != 255) {
                    throw new AddressTypeException((CharSequence)this.addressString, "ipaddress.error.invalid.joined.ranges");
                }
                segments[normalizedSegmentIndex++] = ParsedMACAddress.createSegment(this.addressString, lowerHalfLower, lowerHalfUpper, null, null, creator);
                segments[normalizedSegmentIndex] = ParsedMACAddress.createSegment(this.addressString, adjustedLower2, adjustedUpper2, null, null, creator);
                ** GOTO lbl67
            }
            if (addressParseData.isSingleSegment || this.parseData.isDoubleSegment) {
                count = i == actualInitialSegmentCount - 1 ? missingCount : 2;
                missingCount -= count;
                isRange = lower != upper;
                previousAdjustedWasRange = false;
                while (count >= 0) {
                    segFlags = flags;
                    if (isRange) {
                        segmentMask = 255;
                        shift = 8 * count;
                        newLower = (int)(lower >>> shift) & segmentMask;
                        newUpper = (int)(upper >>> shift) & segmentMask;
                        if (previousAdjustedWasRange && newUpper - newLower != 255) {
                            throw new AddressTypeException((CharSequence)this.addressString, "ipaddress.error.invalid.joined.ranges");
                        }
                        v1 = previousAdjustedWasRange = newLower != newUpper;
                        if (count == 0 && (long)newLower == lower) {
                            if ((long)newUpper != upper) {
                                segFlags[3] = false;
                            }
                        } else {
                            segFlags = null;
                        }
                    } else {
                        newLower = newUpper = (int)(lower >> 8 * count) & 255;
                        if (count != 0 || (long)newLower != lower) {
                            segFlags = null;
                        }
                    }
                    segments[normalizedSegmentIndex] = ParsedMACAddress.createSegment(this.addressString, newLower, newUpper, segFlags, indices, creator);
                    ++normalizedSegmentIndex;
                    --count;
                }
            } else {
                segments[normalizedSegmentIndex] = ParsedMACAddress.createSegment(this.addressString, (int)lower, (int)upper, flags, indices, creator);
lbl67:
                // 2 sources

                if (!expandedSegments && this.parseData.isWildcard(i)) {
                    expandSegments = true;
                    j = i + 1;
                    while (j < actualInitialSegmentCount) {
                        if (this.parseData.isWildcard(j)) {
                            expandSegments = false;
                            break;
                        }
                        ++j;
                    }
                    if (expandSegments) {
                        expandedSegments = true;
                        count = missingCount;
                        while (count-- > 0) {
                            if (format == MACAddressParseData.MACFormat.DOTTED) {
                                seg = ParsedMACAddress.createSegment(this.addressString, 0, 255, null, null, creator);
                                segments[++normalizedSegmentIndex] = seg;
                                segments[++normalizedSegmentIndex] = seg;
                                continue;
                            }
                            segments[++normalizedSegmentIndex] = ParsedMACAddress.createSegment(this.addressString, 0, 255, null, null, creator);
                        }
                    }
                }
                ++normalizedSegmentIndex;
            }
            ++i;
        }
        addressCreator = creator;
        result = (MACAddressSection)addressCreator.createSectionInternal(segments);
        return result;
    }

    private static <S extends MACAddressSegment> S createSegment(String addressString, int val, int upperVal, boolean[] flags, int[] indices, ParsedAddressCreator<?, ?, ?, S> creator) {
        if (val != upperVal) {
            return ParsedMACAddress.createRangeSegment(addressString, val, upperVal, flags, indices, creator);
        }
        MACAddressSegment result = flags == null ? (MACAddressSegment)creator.createSegment(val, val, null) : (MACAddressSegment)creator.createSegmentInternal(val, null, addressString, val, flags[2], indices[3], indices[4]);
        return (S)result;
    }

    private static <S extends MACAddressSegment> S createRangeSegment(String addressString, int lower, int upper, boolean[] flags, int[] indices, ParsedAddressCreator<?, ?, ?, S> creator) {
        MACAddressSegment result = flags == null ? (MACAddressSegment)creator.createSegment(lower, upper, null) : (MACAddressSegment)creator.createSegmentInternal(lower, upper, null, addressString, lower, upper, flags[2], flags[3], indices[3], indices[4], indices[7]);
        return (S)result;
    }

    static class MACAddressParseData
    implements Serializable {
        private static final long serialVersionUID = 3L;
        AddressParseData addressParseData = new AddressParseData();
        boolean isDoubleSegment;
        boolean isExtended;
        MACFormat format;

        MACAddressParseData() {
        }

        void initSegmentData(int segmentCapacity) {
            this.addressParseData.initSegmentData(segmentCapacity);
        }

        boolean isWildcard(int index) {
            return this.addressParseData.isWildcard(index);
        }

        static enum MACFormat {
            DASHED('-'),
            COLON_DELIMITED(':'),
            DOTTED('.'),
            SPACE_DELIMITED(' ');

            private char separator;

            private MACFormat(char separator) {
                this.separator = separator;
            }

            char getSeparator() {
                return this.separator;
            }
        }
    }
}

