/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr;

import inet.ipaddr.Address;
import inet.ipaddr.AddressTypeException;
import inet.ipaddr.HostIdentifierString;
import inet.ipaddr.HostName;
import inet.ipaddr.IPAddressConverter;
import inet.ipaddr.IPAddressNetwork;
import inet.ipaddr.IPAddressSection;
import inet.ipaddr.IPAddressSegment;
import inet.ipaddr.IPAddressString;
import inet.ipaddr.format.IPAddressStringDivisionSeries;
import inet.ipaddr.format.util.IPAddressPartStringCollection;
import inet.ipaddr.format.util.sql.IPAddressSQLTranslator;
import inet.ipaddr.format.validate.IPAddressProvider;
import inet.ipaddr.format.validate.ParsedHost;
import inet.ipaddr.ipv4.IPv4Address;
import inet.ipaddr.ipv4.IPv4AddressNetwork;
import inet.ipaddr.ipv6.IPv6Address;
import inet.ipaddr.ipv6.IPv6AddressNetwork;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.Objects;

public abstract class IPAddress
extends Address {
    private static final long serialVersionUID = 3L;
    public static final char PREFIX_LEN_SEPARATOR = '/';
    public static final IPAddressConverter addressConverter = new IPAddressConverter.DefaultAddressConverter();
    HostName fromHost;
    private HostName canonicalHost;
    protected transient InetAddress inetAddress;

    protected IPAddress(IPAddressSection section) {
        super(section);
    }

    public HostName toHostName() {
        HostName host = this.fromHost;
        if (host == null) {
            this.fromHost = host = this.toCanonicalHostName();
        }
        return host;
    }

    void cache(HostIdentifierString string) {
        if (string instanceof HostName) {
            this.fromHost = (HostName)string;
        } else if (string instanceof IPAddressString) {
            this.fromString = (IPAddressString)string;
        }
    }

    protected IPAddressProvider getProvider() {
        if (this.isPrefixed()) {
            return IPAddressProvider.getProviderFor(this, this.removePrefixLength(true, true));
        }
        return IPAddressProvider.getProviderFor(this, this);
    }

    public HostName toCanonicalHostName() {
        HostName host = this.canonicalHost;
        if (host == null) {
            if (this.isMultiple()) {
                throw new AddressTypeException(this, "ipaddress.error.unavailable.numeric");
            }
            InetAddress inetAddress = this.toInetAddress();
            String hostStr = inetAddress.getCanonicalHostName();
            if (hostStr.equals(inetAddress.getHostAddress())) {
                host = new HostName(hostStr, new ParsedHost(hostStr, this.getProvider()));
                host.resolvedAddress = this;
            } else {
                host = new HostName(hostStr);
            }
        }
        return host;
    }

    public static IPAddress from(byte[] bytes) {
        return IPAddress.from(bytes, null, null);
    }

    public static IPAddress from(byte[] bytes, Integer prefixLength) {
        return IPAddress.from(bytes, prefixLength, null);
    }

    public static IPAddress from(IPVersion version, Address.SegmentValueProvider lowerValueProvider, Address.SegmentValueProvider upperValueProvider, Integer prefixLength) {
        return IPAddress.from(version, lowerValueProvider, upperValueProvider, prefixLength, null);
    }

    protected static IPAddress from(IPVersion version, Address.SegmentValueProvider lowerValueProvider, Address.SegmentValueProvider upperValueProvider, Integer prefixLength, CharSequence zone) {
        if (version == IPVersion.IPV4) {
            if (zone != null) {
                throw new IllegalArgumentException();
            }
            IPv4AddressNetwork.IPv4AddressCreator addressCreator = IPv4Address.network().getAddressCreator();
            return addressCreator.createAddressInternal(lowerValueProvider, upperValueProvider, prefixLength);
        }
        if (version == IPVersion.IPV6) {
            IPv6AddressNetwork.IPv6AddressCreator addressCreator = IPv6Address.network().getAddressCreator();
            return addressCreator.createAddressInternal(lowerValueProvider, upperValueProvider, prefixLength, zone);
        }
        throw new IllegalArgumentException();
    }

    protected static IPAddress from(byte[] lowerBytes, Integer prefixLength, CharSequence zone) {
        if (lowerBytes.length == 4) {
            if (zone != null) {
                throw new IllegalArgumentException();
            }
            IPv4AddressNetwork.IPv4AddressCreator addressCreator = IPv4Address.network().getAddressCreator();
            return addressCreator.createAddressInternal(lowerBytes, prefixLength);
        }
        if (lowerBytes.length == 16) {
            IPv6AddressNetwork.IPv6AddressCreator addressCreator = IPv6Address.network().getAddressCreator();
            return addressCreator.createAddressInternal(lowerBytes, prefixLength, zone);
        }
        throw new IllegalArgumentException();
    }

    protected static String toNormalizedString(IPVersion version, Address.SegmentValueProvider lowerValueProvider, Address.SegmentValueProvider upperValueProvider, Integer prefixLength, CharSequence zone) {
        if (version == IPVersion.IPV4) {
            return IPAddress.toNormalizedString(lowerValueProvider, upperValueProvider, prefixLength, 4, 1, 8, 255, '.', 10, null, IPv4Address.network());
        }
        if (version == IPVersion.IPV6) {
            return IPAddress.toNormalizedString(lowerValueProvider, upperValueProvider, prefixLength, 8, 2, 16, 65535, ':', 16, zone, IPv6Address.network());
        }
        throw new IllegalArgumentException();
    }

    private static String toNormalizedString(Address.SegmentValueProvider lowerValueProvider, Address.SegmentValueProvider upperValueProvider, Integer prefixLength, int segmentCount, int bytesPerSegment, int bitsPerSegment, int segmentMaxValue, char separator, int radix, CharSequence zone, IPAddressNetwork network) {
        int length = IPAddress.toNormalizedString(lowerValueProvider, upperValueProvider, prefixLength, segmentCount, bytesPerSegment, bitsPerSegment, segmentMaxValue, separator, radix, zone, network, null);
        StringBuilder builder = new StringBuilder(length);
        IPAddress.toNormalizedString(lowerValueProvider, upperValueProvider, prefixLength, segmentCount, bytesPerSegment, bitsPerSegment, segmentMaxValue, separator, radix, zone, network, builder);
        IPAddressSection.checkLengths(length, builder);
        return builder.toString();
    }

    private static int toNormalizedString(Address.SegmentValueProvider lowerValueProvider, Address.SegmentValueProvider upperValueProvider, Integer prefixLength, int segmentCount, int bytesPerSegment, int bitsPerSegment, int segmentMaxValue, char separator, int radix, CharSequence zone, IPAddressNetwork network, StringBuilder builder) {
        int segmentIndex = 0;
        int count = 0;
        while (true) {
            Integer segmentPrefixLength;
            if ((segmentPrefixLength = IPAddressSection.getSegmentPrefixLength(bitsPerSegment, prefixLength, segmentIndex)) != null && segmentPrefixLength == 0) {
                if (builder == null) {
                    ++count;
                } else {
                    builder.append('0');
                }
            } else {
                int value = 0;
                int value2 = 0;
                if (lowerValueProvider == null) {
                    value = upperValueProvider.getValue(segmentIndex, bytesPerSegment);
                } else {
                    value = lowerValueProvider.getValue(segmentIndex, bytesPerSegment);
                    if (upperValueProvider != null) {
                        value2 = upperValueProvider.getValue(segmentIndex, bytesPerSegment);
                    }
                }
                if (lowerValueProvider == null || upperValueProvider == null) {
                    if (segmentPrefixLength != null) {
                        value &= network.getSegmentNetworkMask(segmentPrefixLength);
                    }
                    if (builder == null) {
                        count += IPAddressSegment.toUnsignedStringLength(value, radix);
                    } else {
                        IPAddressSegment.toUnsignedString(value, radix, builder);
                    }
                } else {
                    if (segmentPrefixLength != null) {
                        int mask = network.getSegmentNetworkMask(segmentPrefixLength);
                        value &= mask;
                        value2 &= mask;
                    }
                    if (value == value2) {
                        if (builder == null) {
                            count += IPAddressSegment.toUnsignedStringLength(value, radix);
                        } else {
                            IPAddressSegment.toUnsignedString(value, radix, builder);
                        }
                    } else {
                        if (value > value2) {
                            int tmp = value2;
                            value2 = value;
                            value = tmp;
                        }
                        if (value == 0 && value2 == segmentMaxValue) {
                            if (builder == null) {
                                count += SEGMENT_WILDCARD_STR.length();
                            } else {
                                builder.append(SEGMENT_WILDCARD_STR);
                            }
                        } else if (builder == null) {
                            count += IPAddressSegment.toUnsignedStringLength(value, radix) + IPAddressSegment.toUnsignedStringLength(value2, radix) + RANGE_SEPARATOR_STR.length();
                        } else {
                            IPAddressSegment.toUnsignedString(value2, radix, IPAddressSegment.toUnsignedString(value, radix, builder).append(RANGE_SEPARATOR_STR));
                        }
                    }
                }
            }
            if (++segmentIndex >= segmentCount) break;
            if (builder == null) continue;
            builder.append(separator);
        }
        if (builder == null) {
            count += segmentCount - 1;
        }
        if (zone != null && zone.length() > 0) {
            if (builder == null) {
                count += zone.length() + 1;
            } else {
                builder.append('%').append(zone);
            }
        }
        if (prefixLength != null) {
            if (builder == null) {
                count += IPAddressSegment.toUnsignedStringLength(prefixLength, 10) + 1;
            } else {
                builder.append('/').append(prefixLength);
            }
        }
        return count;
    }

    public abstract IPAddressNetwork getNetwork();

    public static IPAddressNetwork network(IPVersion version) {
        return version.isIPv4() ? IPv4Address.network() : IPv6Address.network();
    }

    public static IPAddress getLoopback(IPVersion version) {
        return IPAddress.network(version).getLoopback();
    }

    public static IPAddress getLocalHost() throws UnknownHostException {
        return IPAddress.from(InetAddress.getLocalHost().getAddress());
    }

    public static String[] getStandardLoopbackStrings(IPVersion version) {
        return IPAddress.network(version).getStandardLoopbackStrings();
    }

    @Override
    public IPAddressSection getSection() {
        return (IPAddressSection)super.getSection();
    }

    @Override
    public IPAddressSection getSection(int index) {
        return this.getSection().getSection(index);
    }

    @Override
    public IPAddressSection getSection(int index, int endIndex) {
        return this.getSection().getSection(index, endIndex);
    }

    public IPAddressStringDivisionSeries[] getParts(IPAddressSection.IPStringBuilderOptions options) {
        return new IPAddressStringDivisionSeries[]{this.getSection()};
    }

    @Override
    public int getMaxSegmentValue() {
        return IPAddressSegment.getMaxSegmentValue(this.getIPVersion());
    }

    public static int maxSegmentValue(IPVersion version) {
        return IPAddressSegment.getMaxSegmentValue(version);
    }

    @Override
    public int getBytesPerSegment() {
        return IPAddressSegment.getByteCount(this.getIPVersion());
    }

    @Override
    public int getBitsPerSegment() {
        return IPAddressSegment.getBitCount(this.getIPVersion());
    }

    public static int bitsPerSegment(IPVersion version) {
        return IPAddressSegment.getBitCount(version);
    }

    @Override
    public int getByteCount() {
        return this.getSection().getByteCount();
    }

    public static int byteCount(IPVersion version) {
        return version.isIPv4() ? 4 : 16;
    }

    public static int segmentCount(IPVersion version) {
        return version.isIPv4() ? 4 : 8;
    }

    public static int bitCount(IPVersion version) {
        return version.isIPv4() ? 32 : 128;
    }

    public boolean isMultipleByNetworkPrefix() {
        return this.getSection().isMultipleByNetworkPrefix();
    }

    public Integer getNetworkPrefixLength() {
        return this.getSection().getNetworkPrefixLength();
    }

    @Override
    public IPAddressSegment getSegment(int index) {
        return (IPAddressSegment)super.getSegment(index);
    }

    public IPAddressSegment[] getSegments() {
        return this.getSection().getSegments();
    }

    @Override
    public abstract IPAddress getLower();

    @Override
    public abstract IPAddress getUpper();

    @Override
    public abstract IPAddress reverseBits(boolean var1);

    @Override
    public abstract IPAddress reverseBytes();

    @Override
    public abstract IPAddress reverseBytesPerSegment();

    @Override
    public abstract IPAddress reverseSegments();

    public abstract Iterator<? extends IPAddress> iterator();

    public Iterator<? extends IPAddressSegment[]> segmentsIterator() {
        return this.getSection().segmentsIterator();
    }

    public abstract Iterable<? extends IPAddress> getIterable();

    public boolean isIPv4() {
        return this.getSection().isIPv4();
    }

    public boolean isIPv6() {
        return this.getSection().isIPv6();
    }

    public IPVersion getIPVersion() {
        return this.getSection().getIPVersion();
    }

    public IPv4Address toIPv4() {
        return null;
    }

    public IPv6Address toIPv6() {
        return null;
    }

    public abstract boolean isIPv4Convertible();

    public abstract boolean isIPv6Convertible();

    public abstract boolean isLinkLocal();

    public abstract boolean isSiteLocal();

    @Override
    public boolean isLocal() {
        return this.isLinkLocal() || this.isSiteLocal() || this.isAnyLocal();
    }

    public boolean isAnyLocal() {
        return this.isZero();
    }

    public abstract boolean isLoopback();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InetAddress toInetAddress() {
        if (this.inetAddress == null) {
            IPAddress iPAddress = this;
            synchronized (iPAddress) {
                if (this.inetAddress == null) {
                    byte[] bytes = this.getBytes();
                    try {
                        this.inetAddress = InetAddress.getByAddress(bytes);
                    }
                    catch (UnknownHostException unknownHostException) {
                        // empty catch block
                    }
                }
            }
        }
        return this.inetAddress;
    }

    public boolean matches(IPAddressString otherString) {
        if (this.isFromSameString(otherString)) {
            return true;
        }
        IPAddress otherAddr = otherString.getAddress();
        return otherAddr != null && this.isSameAddress(otherAddr);
    }

    @Override
    protected boolean isFromSameString(HostIdentifierString other) {
        if (this.fromString != null && other instanceof IPAddressString) {
            IPAddressString fromString = (IPAddressString)this.fromString;
            IPAddressString otherString = (IPAddressString)other;
            return fromString == otherString || fromString.fullAddr.equals(otherString.fullAddr) && Objects.equals(fromString.validationOptions, otherString.validationOptions);
        }
        return false;
    }

    public boolean isSameAddress(IPAddress other) {
        return other == this || this.getSection().equals(other.getSection());
    }

    @Override
    public boolean contains(Address other) {
        if (other instanceof IPAddress) {
            return this.contains((IPAddress)other);
        }
        return false;
    }

    public boolean contains(IPAddress other) {
        if (other == this) {
            return true;
        }
        return this.getSection().contains(other.getSection());
    }

    public abstract IPAddress[] subtract(IPAddress var1);

    public static IPAddress from(InetAddress inetAddress) {
        byte[] bytes = inetAddress.getAddress();
        if (bytes.length == 16) {
            Inet6Address inet6Address = (Inet6Address)inetAddress;
            NetworkInterface networkInterface = inet6Address.getScopedInterface();
            String zone = null;
            if (networkInterface == null) {
                int scopeId = inet6Address.getScopeId();
                if (scopeId != 0) {
                    zone = Integer.toString(scopeId);
                }
            } else {
                zone = networkInterface.getName();
            }
            IPv6AddressNetwork.IPv6AddressCreator ipv6Creator = IPv6Address.network().getAddressCreator();
            return ipv6Creator.createAddressInternal(bytes, null, zone);
        }
        IPv4AddressNetwork.IPv4AddressCreator creator = IPv4Address.network().getAddressCreator();
        return creator.createAddressInternal(bytes, (Integer)null);
    }

    public String[] getSegmentStrings() {
        return this.getSection().getSegmentStrings();
    }

    public String toFullString() {
        return this.getSection().toFullString();
    }

    protected void cacheNormalizedString(String str) {
        this.getSection().cacheNormalizedString(str);
    }

    public String toSubnetString() {
        return this.getSection().toSubnetString();
    }

    public String toNormalizedWildcardString() {
        return this.getSection().toNormalizedWildcardString();
    }

    public String toCanonicalWildcardString() {
        return this.getSection().toCanonicalWildcardString();
    }

    public String toCompressedWildcardString() {
        return this.getSection().toCompressedWildcardString();
    }

    public String toSQLWildcardString() {
        return this.getSection().toSQLWildcardString();
    }

    public String toPrefixLengthString() {
        return this.getSection().toPrefixLengthString();
    }

    public String toConvertedString() {
        return this.toNormalizedString();
    }

    public abstract String toUNCHostName();

    public String toReverseDNSLookupString() {
        return this.getSection().toReverseDNSLookupString();
    }

    public String toBinaryString() {
        return this.getSection().toBinaryString();
    }

    public String toOctalString(boolean with0Prefix) {
        return this.getSection().toOctalString(with0Prefix);
    }

    public String toNormalizedString(IPAddressSection.IPStringOptions params) {
        return this.getSection().toNormalizedString(params);
    }

    public String[] toStandardStrings() {
        return this.toStandardStringCollection().toStrings();
    }

    public String[] toAllStrings() {
        return this.toAllStringCollection().toStrings();
    }

    public String[] toStrings(IPAddressSection.IPStringBuilderOptions options) {
        return this.toStringCollection(options).toStrings();
    }

    public IPAddressPartStringCollection toStandardStringCollection() {
        return this.getSection().toStandardStringCollection();
    }

    public IPAddressPartStringCollection toAllStringCollection() {
        return this.getSection().toAllStringCollection();
    }

    public IPAddressPartStringCollection toStringCollection(IPAddressSection.IPStringBuilderOptions options) {
        return this.getSection().toStringCollection(options);
    }

    @Override
    public IPAddressString toAddressString() {
        if (this.fromString == null) {
            this.fromString = new IPAddressString(this);
        }
        return this.getAddressfromString();
    }

    protected IPAddressString getAddressfromString() {
        return (IPAddressString)this.fromString;
    }

    public static String toDelimitedSQLStrs(String[] strs) {
        if (strs.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        String[] stringArray = strs;
        int n = strs.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            builder.append('\'').append(str).append('\'').append(',');
            ++n2;
        }
        return builder.substring(0, builder.length() - 1);
    }

    public IPAddress toPrefixedEquivalent() {
        Integer newPrefix = this.getEquivalentPrefix();
        return newPrefix == null ? null : this.applyPrefixLength(newPrefix);
    }

    public IPAddress toMinPrefixedEquivalent() {
        return this.applyPrefixLength(this.getMinPrefix());
    }

    public Integer getMaskPrefixLength(boolean network) {
        return this.getSection().getMaskPrefixLength(network);
    }

    public abstract IPAddress mask(IPAddress var1) throws AddressTypeException;

    public abstract IPAddress maskNetwork(IPAddress var1, int var2) throws AddressTypeException;

    @Override
    public abstract IPAddress applyPrefixLength(int var1);

    public abstract IPAddress bitwiseOr(IPAddress var1) throws AddressTypeException;

    public abstract IPAddress bitwiseOrNetwork(IPAddress var1, int var2) throws AddressTypeException;

    public abstract IPAddressSection getNetworkSection(int var1, boolean var2);

    public abstract IPAddressSection getNetworkSection(int var1);

    public abstract IPAddressSection getNetworkSection();

    public abstract IPAddressSection getHostSection(int var1);

    public abstract IPAddressSection getHostSection();

    @Override
    public abstract IPAddress removePrefixLength();

    public abstract IPAddress removePrefixLength(boolean var1);

    protected abstract IPAddress removePrefixLength(boolean var1, boolean var2);

    @Override
    public abstract IPAddress adjustPrefixBySegment(boolean var1);

    @Override
    public abstract IPAddress adjustPrefixLength(int var1);

    @Override
    public abstract IPAddress setPrefixLength(int var1);

    public abstract IPAddress setPrefixLength(int var1, boolean var2);

    public void getMatchesSQLClause(StringBuilder builder, String sqlExpression) {
        this.getSection().getStartsWithSQLClause(builder, sqlExpression);
    }

    public void getMatchesSQLClause(StringBuilder builder, String sqlExpression, IPAddressSQLTranslator translator) {
        this.getSection().getStartsWithSQLClause(builder, sqlExpression, translator);
    }

    public static enum IPVersion {
        IPV4,
        IPV6;


        public boolean isIPv4() {
            return this == IPV4;
        }

        public boolean isIPv6() {
            return this == IPV6;
        }

        public static IPVersion fromByteLength(int length) {
            switch (length) {
                case 4: {
                    return IPV4;
                }
                case 16: {
                    return IPV6;
                }
            }
            throw new IllegalArgumentException();
        }
    }
}

