/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.format.validate;

import inet.ipaddr.HostName;
import inet.ipaddr.HostNameException;
import inet.ipaddr.HostNameParameters;
import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressString;
import inet.ipaddr.IPAddressStringException;
import inet.ipaddr.IPAddressStringParameters;
import inet.ipaddr.format.validate.AddressProvider;
import inet.ipaddr.format.validate.HostIdentifierStringValidator;
import inet.ipaddr.format.validate.ParsedAddress;
import inet.ipaddr.format.validate.ParsedAddressQualifier;
import inet.ipaddr.format.validate.ParsedHost;
import inet.ipaddr.ipv4.IPv4AddressStringParameters;
import inet.ipaddr.ipv6.IPv6AddressStringParameters;

public class Validator
implements HostIdentifierStringValidator {
    private static final int[] chars;
    private static final int MAX_HOST_LENGTH = 253;
    private static final int MAX_HOST_SEGMENTS = 127;
    private static final int MAX_LABEL_LENGTH = 63;
    private static final int[] EMPTY_INDICES;
    private static final ParsedAddressQualifier[] PREFIX_CACHE;
    private static final ParsedAddressQualifier NO_QUALIFIER;
    private static final ParsedHost DEFAULT_EMPTY_HOST;
    private static final IPAddressStringParameters DEFAULT_PREFIX_OPTIONS;
    public static final HostIdentifierStringValidator VALIDATOR;

    static {
        int[] charArray = chars = new int[128];
        int i = 0;
        int c = 48;
        while (i < 10) {
            charArray[c] = i++;
            c = (char)(c + 1);
        }
        c = 97;
        int c2 = 65;
        while (i < 16) {
            charArray[c] = charArray[c2] = i++;
            c = (char)(c + 1);
            c2 = (char)(c2 + 1);
        }
        EMPTY_INDICES = new int[0];
        PREFIX_CACHE = new ParsedAddressQualifier[129];
        NO_QUALIFIER = new ParsedAddressQualifier();
        DEFAULT_EMPTY_HOST = new ParsedHost("", EMPTY_INDICES, null, NO_QUALIFIER);
        DEFAULT_PREFIX_OPTIONS = new IPAddressStringParameters.Builder().toParams();
        VALIDATOR = new Validator();
    }

    private Validator() {
    }

    @Override
    public ParsedHost validateHost(HostName fromHost) throws HostNameException {
        return Validator.validateHostImpl(fromHost);
    }

    @Override
    public AddressProvider validateAddress(IPAddressString fromString) throws IPAddressStringException {
        return Validator.validateAddressImpl(fromString);
    }

    @Override
    public int validatePrefix(CharSequence fullAddr, IPAddress.IPVersion version) throws IPAddressStringException {
        return Validator.validatePrefixImpl(fullAddr, version);
    }

    static AddressProvider validateAddressImpl(IPAddressString fromString) throws IPAddressStringException {
        String str = fromString.toString();
        IPAddressStringParameters validationOptions = fromString.getValidationOptions();
        ParsedAddress.ParseData parseData = Validator.validateAddress(validationOptions, str, 0, str.length());
        return Validator.createProvider(null, fromString, str, validationOptions, parseData, Validator.parseQualifier(str, validationOptions, parseData.isPrefixed, parseData.isZoned, parseData.isEmpty, parseData.qualifierIndex, str.length(), parseData.ipVersion));
    }

    private static ParsedAddress.ParseData validateAddress(IPAddressStringParameters validationOptions, String str, int strStartIndex, int strEndIndex) throws IPAddressStringException {
        ParsedAddress.ParseData parseData = new ParsedAddress.ParseData();
        IPv6AddressStringParameters ipv6Options = validationOptions.getIPv6Parameters();
        IPv4AddressStringParameters ipv4Options = validationOptions.getIPv4Parameters();
        int index = strStartIndex;
        int lastSeparatorIndex = -1;
        int digitCount = 0;
        int leadingZeroCount = 0;
        int rangeWildcardIndex = -1;
        int singleWildcardCount = 0;
        int wildcardCount = 0;
        boolean notOctal = false;
        boolean notDecimal = false;
        boolean uppercase = false;
        boolean isIPv4Hex = false;
        int frontDigitCount = 0;
        int frontLeadingZeroCount = 0;
        boolean frontNotOctal = false;
        boolean frontNotDecimal = false;
        boolean frontUppercase = false;
        boolean frontIsIPv4Hex = false;
        while (index <= strEndIndex) {
            boolean isStandard;
            int currentChar;
            if (index == strEndIndex) {
                parseData.addressEndIndex = index;
                IPAddress.IPVersion version = parseData.ipVersion;
                if (version != null) {
                    if (version.isIPv4()) {
                        currentChar = 46;
                    } else {
                        if (index == lastSeparatorIndex + 1) {
                            if (index == parseData.consecutiveIPv6SepIndex + 2) break;
                            throw new IPAddressStringException(str, "ipaddress.error.cannot.end.with.single.separator");
                        }
                        if (parseData.mixedParsedAddress != null) break;
                        currentChar = 58;
                    }
                } else {
                    if (index == strStartIndex) {
                        parseData.isEmpty = true;
                        break;
                    }
                    if (wildcardCount > 0) {
                        if (singleWildcardCount > 0 || rangeWildcardIndex >= 0 || leadingZeroCount > 0 || digitCount > 0 || isIPv4Hex) {
                            throw new IPAddressStringException(str, index, true);
                        }
                        parseData.anyWildcard = true;
                        parseData.isAll = true;
                        break;
                    }
                    currentChar = 46;
                }
            } else {
                currentChar = str.charAt(index);
            }
            if (currentChar >= 49 && currentChar <= 57) {
                ++digitCount;
                ++index;
                notOctal |= currentChar >= 56;
                continue;
            }
            if (currentChar >= 97 && currentChar <= 102) {
                ++digitCount;
                ++index;
                notDecimal = true;
                notOctal = true;
                continue;
            }
            if (currentChar == 48) {
                if (digitCount > 0) {
                    ++digitCount;
                } else {
                    ++leadingZeroCount;
                }
                ++index;
                continue;
            }
            if (currentChar == 46) {
                if (parseData.ipVersion != null && parseData.ipVersion.isIPv6()) {
                    boolean isNotExpandable;
                    int segCount = parseData.segmentCount;
                    if (!ipv6Options.allowMixed) {
                        throw new IPAddressStringException(str, "ipaddress.error.no.mixed");
                    }
                    int totalSegmentCount = parseData.segmentCount + 2;
                    if (totalSegmentCount > 8) {
                        throw new IPAddressStringException(str, "ipaddress.error.ipv6.too.many.segments");
                    }
                    if (wildcardCount > 0) {
                        parseData.anyWildcard = true;
                    }
                    boolean bl = isNotExpandable = wildcardCount > 0 && parseData.consecutiveIPv6SepIndex < 0;
                    if (isNotExpandable && totalSegmentCount < 8 && ipv6Options.allowWildcardedSeparator) {
                        parseData.values[segCount][1] = 65535L;
                        parseData.flags[segCount][0] = true;
                        ++parseData.segmentCount;
                    }
                    IPAddressStringParameters mixedOptions = ipv6Options.getMixedParameters();
                    ParsedAddress.ParseData mixedParseData = Validator.validateAddress(mixedOptions, str, lastSeparatorIndex + 1, strEndIndex);
                    parseData.mixedParsedAddress = Validator.createAddressProvider(null, null, str, mixedOptions, mixedParseData, NO_QUALIFIER);
                    index = mixedParseData.addressEndIndex;
                    continue;
                }
                parseData.ipVersion = IPAddress.IPVersion.IPV4;
                int segCount = parseData.segmentCount;
                if (segCount == 0) {
                    parseData.initSegmentData(4);
                } else if (segCount >= 4) {
                    throw new IPAddressStringException(str, "ipaddress.error.ipv4.too.many.segments");
                }
                long[] vals = parseData.values[segCount];
                int[] indices = parseData.indices[segCount];
                boolean[] flags = parseData.flags[segCount];
                if (wildcardCount > 0) {
                    if (!ipv4Options.rangeOptions.allowsWildcard()) {
                        throw new IPAddressStringException(str, "ipaddress.error.no.wildcard");
                    }
                    if (singleWildcardCount > 0 || rangeWildcardIndex >= 0 || leadingZeroCount > 0 || digitCount > 0 || isIPv4Hex) {
                        throw new IPAddressStringException(str, index, true);
                    }
                    parseData.anyWildcard = true;
                    flags[0] = true;
                    vals[1] = 255L;
                    int startIndex = index - wildcardCount;
                    Validator.assignAttributes(startIndex, index, indices, startIndex);
                } else {
                    int radix;
                    boolean isJustZero;
                    boolean isSingleWildcard;
                    if (leadingZeroCount > 0 && !ipv4Options.allowLeadingZeros && !ipv4Options.inet_aton_octal) {
                        throw new IPAddressStringException(str, "ipaddress.error.ipv4.segment.leading.zeros");
                    }
                    long value = 0L;
                    isStandard = false;
                    int startIndex = index - digitCount;
                    int leadingZeroStartIndex = startIndex - leadingZeroCount;
                    int endIndex = index;
                    int maxChars = Validator.getMaxIPv4StringLength(3, 8);
                    if (digitCount == 0) {
                        if (leadingZeroCount == 0) {
                            throw new IPAddressStringException(str, "ipaddress.error.ipv4.empty.segment");
                        }
                        isSingleWildcard = false;
                        isJustZero = true;
                        --startIndex;
                        ++digitCount;
                        --leadingZeroCount;
                        if (isIPv4Hex) {
                            if (!ipv4Options.inet_aton_hex) {
                                throw new IPAddressStringException(str, "ipaddress.error.ipv4.segment.hex");
                            }
                            radix = 16;
                        } else {
                            radix = leadingZeroCount > 0 && !ipv4Options.allowLeadingZeros && ipv4Options.inet_aton_octal ? 8 : 10;
                        }
                        flags[2] = true;
                        Validator.assignAttributes(startIndex, endIndex, indices, radix, leadingZeroStartIndex);
                    } else {
                        if (digitCount > maxChars + leadingZeroCount) {
                            throw new IPAddressStringException(str, "ipaddress.error.ipv4.segment.too.long");
                        }
                        isJustZero = false;
                        boolean bl = isSingleWildcard = singleWildcardCount > 0;
                        if (isIPv4Hex) {
                            if (!ipv4Options.inet_aton_hex) {
                                throw new IPAddressStringException(str, "ipaddress.error.ipv4.segment.hex");
                            }
                            radix = 16;
                            if (isSingleWildcard) {
                                if (rangeWildcardIndex >= 0) {
                                    throw new IPAddressStringException(str, index, true);
                                }
                                Validator.parseSingleWildcard16(str, startIndex, endIndex, singleWildcardCount, indices, vals, flags, leadingZeroStartIndex, ipv4Options);
                            } else {
                                value = Validator.parseLong16(str, startIndex, endIndex);
                            }
                        } else {
                            boolean isOctal;
                            boolean bl2 = isOctal = leadingZeroCount > 0 && ipv4Options.inet_aton_octal;
                            if (isOctal) {
                                if (notOctal) {
                                    throw new IPAddressStringException(str, "ipaddress.error.ipv4.invalid.octal.digit");
                                }
                                radix = 8;
                                if (isSingleWildcard) {
                                    if (rangeWildcardIndex >= 0) {
                                        throw new IPAddressStringException(str, index, true);
                                    }
                                    Validator.parseSingleWildcard8(str, startIndex, endIndex, singleWildcardCount, indices, vals, flags, leadingZeroStartIndex, ipv4Options);
                                } else {
                                    value = Validator.parseLong8(str, startIndex, endIndex);
                                }
                            } else {
                                if (notDecimal) {
                                    throw new IPAddressStringException(str, "ipaddress.error.ipv4.invalid.decimal.digit");
                                }
                                radix = 10;
                                if (isSingleWildcard) {
                                    if (rangeWildcardIndex >= 0) {
                                        throw new IPAddressStringException(str, index, true);
                                    }
                                    Validator.parseSingleWildcard10(str, startIndex, endIndex, singleWildcardCount, indices, vals, flags, leadingZeroStartIndex, ipv4Options);
                                } else {
                                    value = Validator.parseLong10(str, startIndex, endIndex);
                                    isStandard = true;
                                }
                            }
                        }
                    }
                    if (rangeWildcardIndex >= 0) {
                        int frontRadix;
                        long front;
                        if (!ipv4Options.rangeOptions.allowsRangeSeparator()) {
                            throw new IPAddressStringException(str, "ipaddress.error.no.range");
                        }
                        if (!ipv4Options.allowLeadingZeros && frontLeadingZeroCount > 0) {
                            throw new IPAddressStringException(str, "ipaddress.error.ipv4.segment.leading.zeros");
                        }
                        if (frontDigitCount > maxChars + frontLeadingZeroCount) {
                            throw new IPAddressStringException(str, "ipaddress.error.ipv4.segment.too.long");
                        }
                        int frontStartIndex = rangeWildcardIndex - frontDigitCount;
                        int frontEndIndex = rangeWildcardIndex;
                        int frontLeadingZeroStartIndex = frontStartIndex - frontLeadingZeroCount;
                        if (frontIsIPv4Hex) {
                            if (!ipv4Options.inet_aton_hex) {
                                throw new IPAddressStringException(str, "ipaddress.error.ipv4.segment.hex");
                            }
                            front = Validator.parseLong16(str, frontStartIndex, frontEndIndex);
                            frontRadix = 16;
                        } else {
                            boolean frontIsOctal;
                            boolean bl = frontIsOctal = frontLeadingZeroCount > 0 && !frontIsIPv4Hex && ipv4Options.inet_aton_octal;
                            if (frontIsOctal) {
                                if (frontNotOctal) {
                                    throw new IPAddressStringException(str, "ipaddress.error.ipv4.invalid.octal.digit");
                                }
                                front = Validator.parseLong8(str, frontStartIndex, frontEndIndex);
                                frontRadix = 8;
                            } else {
                                if (frontNotDecimal) {
                                    throw new IPAddressStringException(str, "ipaddress.error.ipv4.invalid.decimal.digit");
                                }
                                if (frontLeadingZeroCount == 0) {
                                    flags[2] = true;
                                    if (isStandard && leadingZeroCount == 0) {
                                        flags[3] = true;
                                    }
                                }
                                front = Validator.parseLong10(str, frontStartIndex, frontEndIndex);
                                frontRadix = 10;
                            }
                        }
                        if (front > value) {
                            throw new IPAddressStringException(str, "ipaddress.error.invalidRange");
                        }
                        if (!isJustZero) {
                            Validator.assignAttributes(frontStartIndex, frontEndIndex, startIndex, endIndex, indices, frontLeadingZeroStartIndex, leadingZeroStartIndex, frontRadix, radix);
                            vals[0] = front;
                            vals[1] = value;
                        }
                        frontLeadingZeroCount = 0;
                        frontDigitCount = 0;
                        frontIsIPv4Hex = false;
                        frontUppercase = false;
                        frontNotDecimal = false;
                        frontNotOctal = false;
                    } else if (!isSingleWildcard && !isJustZero) {
                        if (isStandard) {
                            flags[2] = true;
                        }
                        Validator.assignAttributes(startIndex, endIndex, indices, radix, leadingZeroStartIndex);
                        vals[0] = vals[1] = value;
                    }
                }
                ++parseData.segmentCount;
                lastSeparatorIndex = index++;
                leadingZeroCount = 0;
                wildcardCount = 0;
                singleWildcardCount = 0;
                digitCount = 0;
                rangeWildcardIndex = -1;
                isIPv4Hex = false;
                uppercase = false;
                notDecimal = false;
                notOctal = false;
                continue;
            }
            if (currentChar == 58) {
                if (parseData.ipVersion != null && parseData.ipVersion.isIPv4()) {
                    throw new IPAddressStringException(str, "ipaddress.error.ipv6.separator");
                }
                if (isIPv4Hex) {
                    throw new IPAddressStringException(str, "ipaddress.error.ipv6.character");
                }
                parseData.ipVersion = IPAddress.IPVersion.IPV6;
                int segCount = parseData.segmentCount;
                if (segCount == 0) {
                    parseData.initSegmentData(8);
                } else if (segCount >= 8) {
                    throw new IPAddressStringException(str, "ipaddress.error.ipv6.too.many.segments");
                }
                long[] vals = parseData.values[segCount];
                boolean[] flags = parseData.flags[segCount];
                int[] indices = parseData.indices[segCount];
                if (wildcardCount > 0) {
                    if (!ipv6Options.rangeOptions.allowsWildcard()) {
                        throw new IPAddressStringException(str, "ipaddress.error.no.wildcard");
                    }
                    if (singleWildcardCount > 0 || rangeWildcardIndex >= 0 || leadingZeroCount > 0 || digitCount > 0) {
                        throw new IPAddressStringException(str, index, true);
                    }
                    parseData.anyWildcard = true;
                    flags[0] = true;
                    vals[1] = 65535L;
                    int startIndex = index - wildcardCount;
                    Validator.assignAttributes(startIndex, index, indices, startIndex);
                    ++parseData.segmentCount;
                } else if (index == strStartIndex) {
                    if (index + 1 == strEndIndex) {
                        throw new IPAddressStringException(str, "ipaddress.error.ipv6.too.few.segments");
                    }
                    if (str.charAt(index + 1) != ':') {
                        throw new IPAddressStringException(str, "ipaddress.error.ipv6.cannot.start.with.single.separator");
                    }
                } else if (index == lastSeparatorIndex + 1) {
                    if (parseData.consecutiveIPv6SepIndex >= 0) {
                        throw new IPAddressStringException(str, "ipaddress.error.ipv6.ambiguous");
                    }
                    parseData.consecutiveIPv6SepIndex = index - 1;
                    Validator.assignAttributes(index, index, indices, index);
                    ++parseData.segmentCount;
                } else {
                    if (!ipv6Options.allowLeadingZeros && leadingZeroCount > 0) {
                        throw new IPAddressStringException(str, "ipaddress.error.ipv6.segment.leading.zeros");
                    }
                    if (digitCount > 4) {
                        throw new IPAddressStringException(str, "ipaddress.error.ipv6.segment.too.long");
                    }
                    long value = 0L;
                    isStandard = false;
                    int startIndex = index - digitCount;
                    int leadingZeroStartIndex = startIndex - leadingZeroCount;
                    int endIndex = index;
                    if (!ipv6Options.allowUnlimitedLeadingZeros && endIndex - leadingZeroStartIndex > 4) {
                        throw new IPAddressStringException(str, "ipaddress.error.ipv6.segment.too.long");
                    }
                    boolean isJustZero = false;
                    if (digitCount == 0) {
                        ++digitCount;
                        --leadingZeroCount;
                        isJustZero = true;
                        flags[2] = true;
                        Validator.assignAttributes(--startIndex, endIndex, indices, leadingZeroStartIndex);
                    } else {
                        if (digitCount > 4) {
                            throw new IPAddressStringException(str, "ipaddress.error.ipv6.segment.too.long");
                        }
                        if (singleWildcardCount > 0) {
                            if (rangeWildcardIndex >= 0) {
                                throw new IPAddressStringException(str, index, true);
                            }
                            Validator.parseSingleWildcard16(str, startIndex, endIndex, singleWildcardCount, indices, vals, flags, leadingZeroStartIndex, ipv6Options);
                        } else {
                            value = Validator.parseLong16(str, startIndex, endIndex);
                            boolean bl = isStandard = !uppercase;
                        }
                    }
                    if (rangeWildcardIndex >= 0) {
                        if (!ipv6Options.rangeOptions.allowsRangeSeparator()) {
                            throw new IPAddressStringException(str, "ipaddress.error.no.range");
                        }
                        if (frontIsIPv4Hex) {
                            throw new IPAddressStringException(str, index, false);
                        }
                        if (!ipv6Options.allowLeadingZeros && frontLeadingZeroCount > 0) {
                            throw new IPAddressStringException(str, "ipaddress.error.ipv6.segment.leading.zeros");
                        }
                        if (frontDigitCount > 4) {
                            throw new IPAddressStringException(str, "ipaddress.error.ipv6.segment.too.long");
                        }
                        int frontStartIndex = rangeWildcardIndex - frontDigitCount;
                        int frontEndIndex = rangeWildcardIndex;
                        int frontLeadingZeroStartIndex = frontStartIndex - frontLeadingZeroCount;
                        if (!ipv6Options.allowUnlimitedLeadingZeros && frontEndIndex - frontLeadingZeroStartIndex > 4) {
                            throw new IPAddressStringException(str, "ipaddress.error.ipv6.segment.too.long");
                        }
                        long front = Validator.parseLong16(str, frontStartIndex, frontEndIndex);
                        if (front > value) {
                            throw new IPAddressStringException(str, "ipaddress.error.invalidRange");
                        }
                        if (!isJustZero) {
                            if (frontLeadingZeroCount == 0 && !frontUppercase) {
                                flags[2] = true;
                                if (isStandard && leadingZeroCount == 0) {
                                    flags[3] = true;
                                }
                            }
                            Validator.assignAttributes(frontStartIndex, frontEndIndex, startIndex, endIndex, indices, frontLeadingZeroStartIndex, leadingZeroStartIndex, 16, 16);
                            vals[0] = front;
                            vals[1] = value;
                        }
                        frontLeadingZeroCount = 0;
                        frontDigitCount = 0;
                        frontIsIPv4Hex = false;
                        frontUppercase = false;
                        frontNotDecimal = false;
                        frontNotOctal = false;
                    } else if (singleWildcardCount == 0 && !isJustZero) {
                        if (isStandard) {
                            flags[2] = true;
                        }
                        Validator.assignAttributes(startIndex, endIndex, indices, 16, leadingZeroStartIndex);
                        vals[0] = vals[1] = value;
                    }
                    ++parseData.segmentCount;
                }
                lastSeparatorIndex = index++;
                rangeWildcardIndex = -1;
                leadingZeroCount = 0;
                wildcardCount = 0;
                singleWildcardCount = 0;
                digitCount = 0;
                isIPv4Hex = false;
                uppercase = false;
                notDecimal = false;
                notOctal = false;
                continue;
            }
            if (currentChar >= 65 && currentChar <= 70) {
                ++digitCount;
                ++index;
                uppercase = true;
                notDecimal = true;
                notOctal = true;
                continue;
            }
            if (currentChar == 47) {
                parseData.isPrefixed = true;
                strEndIndex = index;
                parseData.qualifierIndex = index + 1;
                continue;
            }
            boolean b = false;
            if (currentChar == 42 || (b = currentChar == 37)) {
                if (b && ipv6Options.allowZone) {
                    parseData.isZoned = true;
                    strEndIndex = index;
                    parseData.qualifierIndex = index + 1;
                    continue;
                }
                ++wildcardCount;
                ++index;
                continue;
            }
            if (currentChar == 45) {
                if (rangeWildcardIndex >= 0) {
                    throw new IPAddressStringException(str, index, true);
                }
                rangeWildcardIndex = index;
                frontDigitCount = digitCount;
                frontLeadingZeroCount = leadingZeroCount;
                if (frontDigitCount == 0) {
                    if (frontLeadingZeroCount == 0) {
                        throw new IPAddressStringException(str, "ipaddress.error.empty.start.of.range");
                    }
                    ++frontDigitCount;
                    --frontLeadingZeroCount;
                }
                frontNotOctal = notOctal;
                frontNotDecimal = notDecimal;
                frontUppercase = uppercase;
                frontIsIPv4Hex = isIPv4Hex;
                digitCount = 0;
                leadingZeroCount = 0;
                isIPv4Hex = false;
                uppercase = false;
                notDecimal = false;
                notOctal = false;
                ++index;
                continue;
            }
            if (currentChar == 95) {
                ++digitCount;
                ++index;
                ++singleWildcardCount;
                continue;
            }
            if (currentChar == 120) {
                if (digitCount > 0 || leadingZeroCount != 1 || isIPv4Hex || singleWildcardCount > 0) {
                    throw new IPAddressStringException(str, index, true);
                }
                isIPv4Hex = true;
                leadingZeroCount = 0;
                ++index;
                continue;
            }
            throw new IPAddressStringException(str, index, false);
        }
        return parseData;
    }

    private static AddressProvider createProvider(HostName fromHost, IPAddressString fromString, String fullAddr, IPAddressStringParameters validationOptions, ParsedAddress.ParseData parseData, ParsedAddressQualifier qualifier) throws IPAddressStringException {
        if (parseData.ipVersion == null) {
            IPAddress.IPVersion version = qualifier.inferVersion(validationOptions);
            if (parseData.isEmpty) {
                if (qualifier.getNetworkPrefixLength() != null) {
                    if (validationOptions.allowPrefixOnly) {
                        return new AddressProvider.MaskCreator(qualifier, version);
                    }
                    throw new IPAddressStringException(fullAddr, "ipaddress.error.prefix.only");
                }
                if (!validationOptions.allowEmpty) {
                    throw new IPAddressStringException(fullAddr, "ipaddress.error.empty");
                }
                if (validationOptions.emptyIsLoopback) {
                    return AddressProvider.LOOPBACK_CREATOR;
                }
                return AddressProvider.EMPTY_PROVIDER;
            }
            if (validationOptions.allowAll) {
                if (qualifier == NO_QUALIFIER && version == null) {
                    return AddressProvider.ALL_ADDRESSES_CREATOR;
                }
                return new AddressProvider.AllCreator(qualifier, version, fromHost, fromString);
            }
            throw new IPAddressStringException(fullAddr, "ipaddress.error.all");
        }
        ParsedAddress valueCreator = Validator.createAddressProvider(fromHost, fromString, fullAddr, validationOptions, parseData, qualifier);
        return new AddressProvider.ParsedAddressProvider(valueCreator);
    }

    private static ParsedAddress createAddressProvider(HostName fromHost, IPAddressString fromString, String fullAddr, IPAddressStringParameters validationOptions, ParsedAddress.ParseData parseData, ParsedAddressQualifier qualifier) throws IPAddressStringException {
        int segCount = parseData.segmentCount;
        IPAddress.IPVersion version = parseData.ipVersion;
        if (version.isIPv4()) {
            int missingCount = 4 - segCount;
            IPv4AddressStringParameters ipv4Options = validationOptions.getIPv4Parameters();
            if (missingCount > 0 && !parseData.anyWildcard && !ipv4Options.inet_aton_joinedSegments) {
                throw new IPAddressStringException(fullAddr, "ipaddress.error.ipv4.too.few.segments");
            }
            long oneSegmentMax = Validator.getMaxIPv4Value(0);
            int i = 0;
            while (i < segCount) {
                long max = i == segCount - 1 && missingCount > 0 ? Validator.getMaxIPv4Value(missingCount) : oneSegmentMax;
                boolean[] flags = parseData.flags[i];
                long[] values = parseData.values[i];
                int[] indices = parseData.indices[i];
                int lowerRadix = indices[0];
                int maxDigits = Validator.getMaxIPv4StringLength(missingCount, lowerRadix);
                if (flags[1]) {
                    if (values[0] > max) {
                        throw new IPAddressStringException(fullAddr, "ipaddress.error.ipv4.segment.too.large");
                    }
                    if (values[1] > max) {
                        values[1] = max;
                    }
                    if (!ipv4Options.allowUnlimitedLeadingZeros && indices[4] - indices[2] - Validator.getStringPrefixCharCount(lowerRadix) > maxDigits) {
                        throw new IPAddressStringException(fullAddr, "ipaddress.error.ipv4.segment.too.long");
                    }
                } else {
                    if (values[1] > max) {
                        throw new IPAddressStringException(fullAddr, "ipaddress.error.ipv4.segment.too.large");
                    }
                    int upperRadix = indices[1];
                    int maxUpperDigits = Validator.getMaxIPv4StringLength(missingCount, upperRadix);
                    if (!ipv4Options.allowUnlimitedLeadingZeros) {
                        if (indices[4] - indices[2] - Validator.getStringPrefixCharCount(lowerRadix) > maxDigits) {
                            throw new IPAddressStringException(fullAddr, "ipaddress.error.ipv4.segment.too.long");
                        }
                        if (indices[7] - indices[5] - Validator.getStringPrefixCharCount(upperRadix) > maxUpperDigits) {
                            throw new IPAddressStringException(fullAddr, "ipaddress.error.ipv4.segment.too.long");
                        }
                    }
                }
                ++i;
            }
        } else {
            int totalSegmentCount = segCount;
            if (parseData.mixedParsedAddress != null) {
                totalSegmentCount += 2;
            }
            if (totalSegmentCount < 8 && !parseData.anyWildcard && !parseData.isCompressed()) {
                throw new IPAddressStringException(fullAddr, "ipaddress.error.ipv6.too.few.segments");
            }
        }
        ParsedAddress valueCreator = new ParsedAddress(fromHost, fromString, fullAddr, parseData, version, qualifier);
        return valueCreator;
    }

    static int validatePrefixImpl(CharSequence fullAddr, IPAddress.IPVersion version) throws IPAddressStringException {
        ParsedAddressQualifier qualifier = Validator.validatePrefix(fullAddr, DEFAULT_PREFIX_OPTIONS, 0, fullAddr.length(), version);
        if (qualifier == null) {
            throw new IPAddressStringException(fullAddr.toString(), "ipaddress.error.invalidCIDRPrefix");
        }
        return qualifier.getNetworkPrefixLength();
    }

    private static ParsedAddressQualifier validatePrefix(CharSequence fullAddr, IPAddressStringParameters validationOptions, int index, int endIndex, IPAddress.IPVersion ipVersion) throws IPAddressStringException {
        if (index == fullAddr.length()) {
            return null;
        }
        boolean isPrefix = true;
        int leadingZeros = 0;
        int digitCount = 0;
        int i = index;
        while (isPrefix && i < endIndex) {
            char c = fullAddr.charAt(i);
            if (c >= '1' && c <= '9') {
                ++digitCount;
            } else if (c == '0') {
                if (digitCount > 0) {
                    ++digitCount;
                } else {
                    ++leadingZeros;
                }
            } else {
                isPrefix = false;
            }
            ++i;
        }
        if (isPrefix) {
            boolean allowPrefixesBeyondAddressSize;
            boolean asIPv4;
            boolean bl = asIPv4 = ipVersion != null && ipVersion.isIPv4();
            if (digitCount == 0) {
                --leadingZeros;
                ++digitCount;
            }
            if (leadingZeros > 0) {
                if (asIPv4) {
                    if (!validationOptions.getIPv4Parameters().allowPrefixLengthLeadingZeros) {
                        throw new IPAddressStringException(fullAddr.toString(), "ipaddress.error.ipv4.prefix.leading.zeros");
                    }
                } else if (!validationOptions.getIPv6Parameters().allowPrefixLengthLeadingZeros) {
                    throw new IPAddressStringException(fullAddr.toString(), "ipaddress.error.ipv6.prefix.leading.zeros");
                }
            }
            if (!(allowPrefixesBeyondAddressSize = (asIPv4 ? validationOptions.getIPv4Parameters() : validationOptions.getIPv6Parameters()).allowPrefixesBeyondAddressSize) && digitCount > (asIPv4 ? 2 : 3)) {
                if (asIPv4 && validationOptions.getIPv4Parameters().inet_aton_joinedSegments && validationOptions.getIPv4Parameters().inet_aton_single_segment_mask) {
                    return null;
                }
                throw new IPAddressStringException(fullAddr.toString(), "ipaddress.error.prefixSize");
            }
            int result = Validator.parse10(fullAddr, index, endIndex);
            if (!allowPrefixesBeyondAddressSize && result > (asIPv4 ? 32 : 128)) {
                if (asIPv4 && validationOptions.getIPv4Parameters().inet_aton_joinedSegments && validationOptions.getIPv4Parameters().inet_aton_single_segment_mask) {
                    return null;
                }
                throw new IPAddressStringException(fullAddr.toString(), "ipaddress.error.prefixSize");
            }
            if (result < PREFIX_CACHE.length) {
                ParsedAddressQualifier qual = PREFIX_CACHE[result];
                if (qual == null) {
                    qual = Validator.PREFIX_CACHE[result] = new ParsedAddressQualifier(result);
                }
                return qual;
            }
            return new ParsedAddressQualifier(result);
        }
        return null;
    }

    private static ParsedAddressQualifier parseQualifier(String fullAddr, IPAddressStringParameters validationOptions, boolean isPrefixed, boolean isZoned, boolean addressIsEmpty, int index, int endIndex, IPAddress.IPVersion ipVersion) throws IPAddressStringException {
        if (isPrefixed) {
            ParsedAddressQualifier qualifier;
            if (validationOptions.allowPrefix && (qualifier = Validator.validatePrefix(fullAddr, validationOptions, index, fullAddr.length(), ipVersion)) != null) {
                return qualifier;
            }
            if (addressIsEmpty) {
                throw new IPAddressStringException(fullAddr, "ipaddress.error.invalidCIDRPrefix");
            }
            if (validationOptions.allowMask) {
                try {
                    IPAddressStringParameters maskOptions = Validator.toMaskOptions(validationOptions, ipVersion);
                    ParsedAddress.ParseData maskParseData = Validator.validateAddress(maskOptions, fullAddr, index, endIndex);
                    if (maskParseData.isEmpty || maskParseData.isAll) {
                        throw new IPAddressStringException(fullAddr, "ipaddress.error.invalidCIDRPrefixOrMask");
                    }
                    ParsedAddress maskAddress = Validator.createAddressProvider(null, null, fullAddr, maskOptions, maskParseData, NO_QUALIFIER);
                    if (maskParseData.addressEndIndex != fullAddr.length()) {
                        throw new IPAddressStringException(fullAddr, "ipaddress.error.invalidCIDRPrefixOrMask");
                    }
                    IPAddress.IPVersion maskVersion = maskParseData.ipVersion;
                    if (maskVersion.isIPv4() && maskParseData.segmentCount == 1 && !maskParseData.anyWildcard && !validationOptions.getIPv4Parameters().inet_aton_single_segment_mask) {
                        throw new IPAddressStringException(fullAddr, "ipaddress.error.mask.single.segment");
                    }
                    if (ipVersion != null && (maskVersion.isIPv4() != ipVersion.isIPv4() || maskVersion.isIPv6() != ipVersion.isIPv6())) {
                        throw new IPAddressStringException(fullAddr, "ipaddress.error.ipMismatch");
                    }
                    return new ParsedAddressQualifier(maskAddress);
                }
                catch (IPAddressStringException e) {
                    throw new IPAddressStringException(fullAddr, "ipaddress.error.invalidCIDRPrefixOrMask", e);
                }
            }
            throw new IPAddressStringException(fullAddr, "ipaddress.error.CIDRNotAllowed");
        }
        if (isZoned) {
            if (addressIsEmpty) {
                throw new IPAddressStringException(fullAddr, "ipaddress.error.only.zone");
            }
            String zone = fullAddr.substring(index, endIndex);
            return new ParsedAddressQualifier(zone);
        }
        return NO_QUALIFIER;
    }

    private static IPAddressStringParameters toMaskOptions(IPAddressStringParameters validationOptions, IPAddress.IPVersion ipVersion) {
        IPAddressStringParameters.Builder builder = null;
        if (ipVersion == null || ipVersion.isIPv6()) {
            IPv6AddressStringParameters ipv6Options = validationOptions.getIPv6Parameters();
            if (!ipv6Options.rangeOptions.isNoRange()) {
                builder = validationOptions.toBuilder();
                builder.getIPv6AddressParametersBuilder().setRangeOptions(IPAddressStringParameters.RangeParameters.NO_RANGE);
            }
            if (ipv6Options.allowMixed && !ipv6Options.getMixedParameters().getIPv4Parameters().rangeOptions.isNoRange()) {
                if (builder == null) {
                    builder = validationOptions.toBuilder();
                }
                builder.getIPv6AddressParametersBuilder().setRangeOptions(IPAddressStringParameters.RangeParameters.NO_RANGE);
            }
        }
        if (ipVersion == null || ipVersion.isIPv4()) {
            IPv4AddressStringParameters ipv4Options = validationOptions.getIPv4Parameters();
            if (!ipv4Options.rangeOptions.isNoRange()) {
                if (builder == null) {
                    builder = validationOptions.toBuilder();
                }
                builder.getIPv4AddressParametersBuilder().setRangeOptions(IPAddressStringParameters.RangeParameters.NO_RANGE);
            }
        }
        if (validationOptions.allowAll) {
            if (builder == null) {
                builder = validationOptions.toBuilder();
            }
            builder.allowAll(false);
        }
        IPAddressStringParameters maskOptions = builder == null ? validationOptions : builder.toParams();
        return maskOptions;
    }

    private static void assignAttributes(int frontStart, int frontEnd, int start, int end, int[] indices, int frontLeadingZeroStartIndex, int leadingZeroStartIndex) {
        indices[2] = frontLeadingZeroStartIndex;
        indices[3] = frontStart;
        indices[4] = frontEnd;
        indices[5] = leadingZeroStartIndex;
        indices[6] = start;
        indices[7] = end;
    }

    private static void assignAttributes(int frontStart, int frontEnd, int start, int end, int[] indices, int frontLeadingZeroStartIndex, int leadingZeroStartIndex, int frontRadix, int radix) {
        indices[0] = frontRadix;
        indices[1] = radix;
        Validator.assignAttributes(frontStart, frontEnd, start, end, indices, frontLeadingZeroStartIndex, leadingZeroStartIndex);
    }

    private static void assignAttributes(int start, int end, int[] indices, int leadingZeroStartIndex) {
        indices[5] = indices[2] = leadingZeroStartIndex;
        indices[6] = indices[3] = start;
        indices[7] = indices[4] = end;
    }

    private static void assignAttributes(int start, int end, int[] indices, int radix, int leadingZeroStartIndex) {
        indices[1] = indices[0] = radix;
        Validator.assignAttributes(start, end, indices, leadingZeroStartIndex);
    }

    private static void assignSingleWildcardAttributes(String str, int start, int end, int digitsEnd, int numSingleWildcards, int[] indices, boolean[] flags, int radix, int leadingZeroStartIndex, IPAddressStringParameters.IPVersionAddressStringParameters options) throws IPAddressStringException {
        if (!options.rangeOptions.allowsSingleWildcard()) {
            throw new IPAddressStringException(str, "ipaddress.error.no.single.wildcard");
        }
        int k = digitsEnd;
        while (k < end) {
            if (str.charAt(k) != '_') {
                throw new IPAddressStringException(str, "ipaddress.error.single.wildcard.order");
            }
            ++k;
        }
        flags[1] = true;
        Validator.assignAttributes(start, end, indices, radix, leadingZeroStartIndex);
    }

    private static void parseSingleWildcard10(String s, int start, int end, int numSingleWildcards, int[] indices, long[] vals, boolean[] flags, int leadingZeroStartIndex, IPAddressStringParameters.IPVersionAddressStringParameters options) throws IPAddressStringException {
        long upper;
        int digitsEnd = end - numSingleWildcards;
        Validator.assignSingleWildcardAttributes(s, start, end, digitsEnd, numSingleWildcards, indices, flags, 10, leadingZeroStartIndex, options);
        long lower = start < digitsEnd ? Validator.parseLong10(s, start, digitsEnd) : 0L;
        switch (numSingleWildcards) {
            case 1: {
                upper = (lower *= 10L) + 9L;
                break;
            }
            case 2: {
                upper = (lower *= 100L) + 99L;
                break;
            }
            case 3: {
                upper = (lower *= 1000L) + 999L;
                break;
            }
            default: {
                long power = (long)Math.pow(10.0, numSingleWildcards);
                upper = (lower *= power) + power - 1L;
            }
        }
        vals[0] = lower;
        vals[1] = upper;
    }

    private static void parseSingleWildcard8(String s, int start, int end, int numSingleWildcards, int[] indices, long[] vals, boolean[] flags, int leadingZeroStartIndex, IPAddressStringParameters.IPVersionAddressStringParameters options) throws IPAddressStringException {
        long upper;
        int digitsEnd = end - numSingleWildcards;
        Validator.assignSingleWildcardAttributes(s, start, end, digitsEnd, numSingleWildcards, indices, flags, 8, leadingZeroStartIndex, options);
        long lower = start < digitsEnd ? Validator.parseLong8(s, start, digitsEnd) : 0L;
        switch (numSingleWildcards) {
            case 1: {
                upper = (lower <<= 3) + 7L;
                break;
            }
            case 2: {
                upper = (lower <<= 6) + 63L;
                break;
            }
            case 3: {
                upper = (lower <<= 9) + 511L;
                break;
            }
            default: {
                long power = (long)Math.pow(8.0, numSingleWildcards);
                upper = (lower *= power) + (power * 8L - 1L);
            }
        }
        vals[0] = lower;
        vals[1] = upper;
    }

    private static void parseSingleWildcard16(String s, int start, int end, int numSingleWildcards, int[] indices, long[] vals, boolean[] flags, int leadingZeroStartIndex, IPAddressStringParameters.IPVersionAddressStringParameters options) throws IPAddressStringException {
        long upper;
        int digitsEnd = end - numSingleWildcards;
        Validator.assignSingleWildcardAttributes(s, start, end, digitsEnd, numSingleWildcards, indices, flags, 16, leadingZeroStartIndex, options);
        long lower = start < digitsEnd ? Validator.parseLong16(s, start, digitsEnd) : 0L;
        switch (numSingleWildcards) {
            case 1: {
                upper = (lower <<= 4) + 15L;
                break;
            }
            case 2: {
                upper = (lower <<= 8) + 255L;
                break;
            }
            case 3: {
                upper = (lower <<= 12) + 4095L;
                break;
            }
            case 4: {
                upper = (lower <<= 16) + 65535L;
                break;
            }
            default: {
                long power = (long)Math.pow(16.0, numSingleWildcards);
                upper = (lower *= power) + power - 1L;
            }
        }
        vals[0] = lower;
        vals[1] = upper;
    }

    private static long getMaxIPv4Value(int additionalSegmentsCovered) {
        if (additionalSegmentsCovered == 0) {
            return 255L;
        }
        if (additionalSegmentsCovered == 1) {
            return 65535L;
        }
        if (additionalSegmentsCovered == 2) {
            return 0xFFFFFFL;
        }
        return 0xFFFFFFFFL;
    }

    private static int getStringPrefixCharCount(int radix) {
        if (radix == 10) {
            return 0;
        }
        if (radix == 16) {
            return 2;
        }
        return 1;
    }

    private static int getMaxIPv4StringLength(int additionalSegmentsCovered, int radix) {
        if (radix == 10) {
            if (additionalSegmentsCovered == 0) {
                return 3;
            }
            if (additionalSegmentsCovered == 1) {
                return 5;
            }
            if (additionalSegmentsCovered == 2) {
                return 8;
            }
            return 10;
        }
        if (radix == 16) {
            if (additionalSegmentsCovered == 0) {
                return 2;
            }
            if (additionalSegmentsCovered == 1) {
                return 4;
            }
            if (additionalSegmentsCovered == 2) {
                return 6;
            }
            return 8;
        }
        if (additionalSegmentsCovered == 0) {
            return 3;
        }
        if (additionalSegmentsCovered == 1) {
            return 6;
        }
        if (additionalSegmentsCovered == 2) {
            return 8;
        }
        return 11;
    }

    private static int parse8(CharSequence s, int start, int end) {
        int[] charArray = chars;
        int result = charArray[s.charAt(start)];
        while (++start < end) {
            result = (result << 3) + charArray[s.charAt(start)];
        }
        return result;
    }

    private static long parseLong8(CharSequence s, int start, int end) {
        if (end - start <= 10) {
            return Validator.parse8(s, start, end);
        }
        int[] charArray = chars;
        long result = charArray[s.charAt(start)];
        while (++start < end) {
            result = (result << 3) + (long)charArray[s.charAt(start)];
        }
        return result;
    }

    private static int parse10(CharSequence s, int start, int end) {
        int[] charArray = chars;
        int result = charArray[s.charAt(start)];
        while (++start < end) {
            result = result * 10 + charArray[s.charAt(start)];
        }
        return result;
    }

    private static long parseLong10(CharSequence s, int start, int end) {
        if (end - start <= 9) {
            return Validator.parse10(s, start, end);
        }
        int[] charArray = chars;
        long result = charArray[s.charAt(start)];
        while (++start < end) {
            result = result * 10L + (long)charArray[s.charAt(start)];
        }
        return result;
    }

    private static int parse16(CharSequence s, int start, int end) {
        int[] charArray = chars;
        int result = charArray[s.charAt(start)];
        while (++start < end) {
            result = (result << 4) + charArray[s.charAt(start)];
        }
        return result;
    }

    private static long parseLong16(CharSequence s, int start, int end) {
        if (end - start <= 7) {
            return Validator.parse16(s, start, end);
        }
        int[] charArray = chars;
        long result = charArray[s.charAt(start)];
        while (++start < end) {
            result = (result << 4) + (long)charArray[s.charAt(start)];
        }
        return result;
    }

    static ParsedHost validateHostImpl(HostName fromHost) throws HostNameException {
        String str = fromHost.toString();
        HostNameParameters validationOptions = fromHost.getValidationOptions();
        return Validator.validateHost(fromHost, str, validationOptions);
    }

    private static ParsedHost validateHost(HostName fromHost, String str, HostNameParameters validationOptions) throws HostNameException {
        int addrLen = str.length();
        if (addrLen > 253) {
            throw new HostNameException(str, "ipaddress.host.error.invalid.length");
        }
        int labelCount = 0;
        boolean segmentUppercase = false;
        boolean isNotNormalized = false;
        boolean squareBracketed = false;
        boolean isAllDigits = true;
        boolean isPossiblyIPv6 = true;
        boolean isPossiblyIPv4 = true;
        boolean tryIPv6 = false;
        boolean tryIPv4 = false;
        boolean isPrefixed = false;
        boolean addressIsEmpty = false;
        int lastSeparatorIndex = -1;
        int index = -1;
        int maxLocalLabels = 6;
        int[] separatorIndices = null;
        boolean[] normalizedFlags = null;
        int sep5 = -1;
        int sep4 = -1;
        int sep3 = -1;
        int sep2 = -1;
        int sep1 = -1;
        int sep0 = -1;
        boolean upper5 = false;
        boolean upper4 = false;
        boolean upper3 = false;
        boolean upper2 = false;
        boolean upper1 = false;
        boolean upper0 = false;
        int qualifierIndex = -1;
        while (++index <= addrLen) {
            int currentChar;
            if (index == addrLen) {
                boolean segmentCountMatches;
                if (index == 0) {
                    addressIsEmpty = true;
                    break;
                }
                boolean bl = segmentCountMatches = labelCount + 1 == 4 || labelCount + 1 < 4 && validationOptions.addressOptions.getIPv4Parameters().inet_aton_joinedSegments;
                if (isAllDigits) {
                    if (segmentCountMatches) {
                        tryIPv4 = true;
                        break;
                    }
                    throw new HostNameException(str, "ipaddress.host.error.invalid");
                }
                isPossiblyIPv4 &= segmentCountMatches;
                currentChar = 46;
            } else {
                currentChar = str.charAt(index);
            }
            if (currentChar >= 97 && currentChar <= 122) {
                if (currentChar > 102) {
                    isPossiblyIPv6 = false;
                    isPossiblyIPv4 &= currentChar == 120 && validationOptions.addressOptions.getIPv4Parameters().inet_aton_hex;
                } else {
                    isPossiblyIPv4 = false;
                }
                isAllDigits = false;
                continue;
            }
            if (currentChar >= 48 && currentChar <= 57) continue;
            if (currentChar >= 65 && currentChar <= 90) {
                if (currentChar > 70) {
                    isPossiblyIPv6 = false;
                }
                segmentUppercase = true;
                isPossiblyIPv4 = false;
                isAllDigits = false;
                continue;
            }
            if (currentChar == 46) {
                int len = index - lastSeparatorIndex - 1;
                if (len > 63) {
                    throw new HostNameException(str, "ipaddress.host.error.segment.too.long");
                }
                if (len == 0) {
                    throw new HostNameException(str, "ipaddress.host.error.segment.too.short");
                }
                if (labelCount < maxLocalLabels) {
                    if (labelCount < 3) {
                        if (labelCount == 0) {
                            sep0 = index;
                            upper0 = segmentUppercase;
                        } else if (labelCount == 1) {
                            sep1 = index;
                            upper1 = segmentUppercase;
                        } else {
                            sep2 = index;
                            upper2 = segmentUppercase;
                        }
                    } else if (labelCount == 3) {
                        sep3 = index;
                        upper3 = segmentUppercase;
                    } else if (labelCount == 4) {
                        sep4 = index;
                        upper4 = segmentUppercase;
                    } else {
                        sep5 = index;
                        upper5 = segmentUppercase;
                    }
                    ++labelCount;
                } else if (labelCount == maxLocalLabels) {
                    separatorIndices = new int[128];
                    separatorIndices[labelCount] = index;
                    if (validationOptions.normalizeToLowercase) {
                        normalizedFlags = new boolean[128];
                        normalizedFlags[labelCount] = !segmentUppercase;
                        isNotNormalized |= segmentUppercase;
                    }
                    ++labelCount;
                } else {
                    separatorIndices[labelCount] = index;
                    if (normalizedFlags != null) {
                        normalizedFlags[labelCount] = !segmentUppercase;
                        isNotNormalized |= segmentUppercase;
                    }
                    if (++labelCount > 127) {
                        throw new HostNameException(str, "ipaddress.host.error.too.many.segments");
                    }
                }
                lastSeparatorIndex = index;
                segmentUppercase = false;
                continue;
            }
            if (currentChar == 95) {
                isAllDigits = false;
                continue;
            }
            if (currentChar == 45) {
                if (index == lastSeparatorIndex + 1 || index == addrLen - 1 || str.charAt(index + 1) == '.') {
                    throw new HostNameException(str, index);
                }
                isAllDigits = false;
                continue;
            }
            if (currentChar == 91) {
                if (index == 0 && labelCount == 0 && addrLen > 2) {
                    squareBracketed = true;
                    break;
                }
                throw new HostNameException(str, index);
            }
            if (currentChar == 47) {
                isPrefixed = true;
                qualifierIndex = index + 1;
                addrLen = index--;
                isNotNormalized = true;
                continue;
            }
            boolean b = false;
            if (currentChar == 42 || (b = currentChar == 37)) {
                IPAddressStringParameters addressOptions = validationOptions.addressOptions;
                if (b && addressOptions.getIPv6Parameters().allowZone) {
                    if (isPossiblyIPv6 && labelCount < 8) {
                        tryIPv6 = true;
                        break;
                    }
                } else {
                    if (isPossiblyIPv4 && labelCount < 4 && addressOptions.getIPv4Parameters().rangeOptions.allowsWildcard()) {
                        tryIPv4 = true;
                        break;
                    }
                    if (isPossiblyIPv6 && labelCount < 8 && addressOptions.getIPv6Parameters().rangeOptions.allowsWildcard()) {
                        tryIPv6 = true;
                        break;
                    }
                }
                throw new HostNameException(str, index);
            }
            if (currentChar == 58 && labelCount < 8) {
                if (isPossiblyIPv6) {
                    tryIPv6 = true;
                    break;
                }
                throw new HostNameException(str, index);
            }
            throw new HostNameException(str, index);
        }
        try {
            ParsedHost parsedHost;
            block86: {
                boolean isIPAddress;
                boolean bl = isIPAddress = squareBracketed || tryIPv4 || tryIPv6;
                if (!validationOptions.allowIPAddress) {
                    if (isIPAddress) {
                        throw new HostNameException(str, "ipaddress.host.error.ipaddress");
                    }
                } else if (isIPAddress || isPossiblyIPv4) {
                    try {
                        ParsedAddressQualifier qualifier;
                        ParsedAddress.ParseData addressData;
                        int endIndex;
                        IPAddressStringParameters addressOptions = validationOptions.addressOptions;
                        if (squareBracketed) {
                            boolean endsWithPrefix;
                            endIndex = addrLen - 1;
                            boolean bl2 = endsWithPrefix = str.charAt(endIndex) != ']';
                            if (endsWithPrefix) {
                                while (str.charAt(--endIndex) != ']') {
                                    if (endIndex != 1) continue;
                                    throw new HostNameException(str, "ipaddress.host.error.bracketed.missing.end");
                                }
                            }
                            int startIndex = 1;
                            if (str.startsWith("IPv6:", 1)) {
                                startIndex = 6;
                            }
                            addressData = Validator.validateAddress(addressOptions, str, startIndex, endIndex);
                            if (endsWithPrefix) {
                                if (addressData.addressEndIndex != endIndex || addressData.isZoned) {
                                    throw new HostNameException(str, "ipaddress.error.zoneAndCIDRPrefix");
                                }
                                int prefixIndex = endIndex + 1;
                                if (str.charAt(prefixIndex) != '/') {
                                    throw new HostNameException(str, prefixIndex);
                                }
                                qualifierIndex = prefixIndex + 1;
                                endIndex = addrLen;
                                isPrefixed = true;
                            } else {
                                qualifierIndex = addressData.qualifierIndex;
                                isPrefixed = addressData.isPrefixed;
                                if (addressData.isZoned && str.charAt(addressData.qualifierIndex) == '2' && str.charAt(addressData.qualifierIndex + 1) == '5') {
                                    qualifierIndex += 2;
                                }
                            }
                            IPAddress.IPVersion version = addressData.ipVersion;
                            if (version != IPAddress.IPVersion.IPV6 && !validationOptions.allowBracketedIPv4) {
                                throw new HostNameException(str, "ipaddress.host.error.bracketed.not.ipv6");
                            }
                            qualifier = Validator.parseQualifier(str, validationOptions.addressOptions, isPrefixed, addressData.isZoned, addressData.isEmpty, qualifierIndex, endIndex, version);
                        } else {
                            endIndex = str.length();
                            addressData = Validator.validateAddress(addressOptions, str, 0, endIndex);
                            qualifier = Validator.parseQualifier(str, addressOptions, addressData.isPrefixed, addressData.isZoned, addressData.isEmpty, addressData.qualifierIndex, endIndex, addressData.ipVersion);
                        }
                        AddressProvider provider = Validator.createProvider(fromHost, null, str, addressOptions, addressData, qualifier);
                        return new ParsedHost(str, provider);
                    }
                    catch (IPAddressStringException e) {
                        if (!isIPAddress) break block86;
                        throw e;
                    }
                }
            }
            ParsedAddressQualifier qualifier = Validator.parseQualifier(str, validationOptions.addressOptions, isPrefixed, false, addressIsEmpty, qualifierIndex, str.length(), null);
            if (addressIsEmpty) {
                if (!validationOptions.allowEmpty) {
                    throw new HostNameException(str, "ipaddress.host.error.empty");
                }
                parsedHost = qualifier == NO_QUALIFIER ? DEFAULT_EMPTY_HOST : new ParsedHost(str, EMPTY_INDICES, null, qualifier);
            } else {
                if (labelCount <= maxLocalLabels) {
                    maxLocalLabels = labelCount;
                    separatorIndices = new int[maxLocalLabels];
                    if (validationOptions.normalizeToLowercase) {
                        normalizedFlags = new boolean[labelCount];
                    }
                } else if (labelCount != separatorIndices.length) {
                    int[] trimmedSeparatorIndices = new int[labelCount];
                    System.arraycopy(separatorIndices, maxLocalLabels, trimmedSeparatorIndices, maxLocalLabels, labelCount - maxLocalLabels);
                    separatorIndices = trimmedSeparatorIndices;
                    if (normalizedFlags != null) {
                        boolean[] trimmedNormalizedFlags = new boolean[labelCount];
                        System.arraycopy(normalizedFlags, maxLocalLabels, trimmedNormalizedFlags, maxLocalLabels, labelCount - maxLocalLabels);
                        normalizedFlags = trimmedNormalizedFlags;
                    }
                }
                int i = 0;
                while (i < maxLocalLabels) {
                    boolean isUpper;
                    int nextSep;
                    if (i < 2) {
                        if (i == 0) {
                            nextSep = sep0;
                            isUpper = upper0;
                        } else {
                            nextSep = sep1;
                            isUpper = upper1;
                        }
                    } else if (i < 4) {
                        if (i == 2) {
                            nextSep = sep2;
                            isUpper = upper2;
                        } else {
                            nextSep = sep3;
                            isUpper = upper3;
                        }
                    } else if (i == 4) {
                        nextSep = sep4;
                        isUpper = upper4;
                    } else {
                        nextSep = sep5;
                        isUpper = upper5;
                    }
                    separatorIndices[i] = nextSep;
                    if (normalizedFlags != null) {
                        normalizedFlags[i] = !isUpper;
                        isNotNormalized |= isUpper;
                    }
                    ++i;
                }
                parsedHost = new ParsedHost(str, separatorIndices, normalizedFlags, qualifier);
                if (!isNotNormalized) {
                    parsedHost.host = str;
                }
            }
            return parsedHost;
        }
        catch (IPAddressStringException e) {
            throw new HostNameException(str, e, "ipaddress.host.error.invalid");
        }
    }
}

