/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr;

import inet.ipaddr.HostIdentifierString;
import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressNetwork;
import inet.ipaddr.IPAddressStringException;
import inet.ipaddr.IPAddressStringParameters;
import inet.ipaddr.IPAddressTypeException;
import inet.ipaddr.format.validate.AddressProvider;
import inet.ipaddr.format.validate.HostIdentifierStringValidator;
import inet.ipaddr.format.validate.Validator;
import java.io.Serializable;

public class IPAddressString
implements HostIdentifierString,
Comparable<IPAddressString>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final IPAddressStringParameters DEFAULT_BASIC_VALIDATION_OPTIONS = new IPAddressStringParameters.Builder().toParams();
    private static final IPAddressStringException IS_IPV6_EXCEPTION = new IPAddressStringException("ipaddress.error.address.is.ipv6");
    private static final IPAddressStringException IS_IPV4_EXCEPTION = new IPAddressStringException("ipaddress.error.address.is.ipv4");
    public static final IPAddressString EMPTY_ADDRESS = new IPAddressString("");
    public static final IPAddressString ALL_ADDRESSES = new IPAddressString(IPAddress.SEGMENT_WILDCARD_STR);
    final IPAddressStringParameters validationOptions;
    final String fullAddr;
    private IPAddressStringException ipv6Exception;
    private IPAddressStringException ipv4Exception;
    private AddressProvider addressProvider = AddressProvider.NO_TYPE_PROVIDER;

    public IPAddressString(String addr) {
        this(addr, DEFAULT_BASIC_VALIDATION_OPTIONS);
    }

    public IPAddressString(String addr, IPAddressStringParameters valOptions) {
        if (addr == null) {
            addr = "";
            this.fullAddr = "";
        } else {
            this.fullAddr = addr = addr.trim();
        }
        this.validationOptions = valOptions;
    }

    IPAddressString(IPAddress address) {
        this.validationOptions = null;
        this.fullAddr = address.toNormalizedString();
        this.initByAddress(address);
    }

    void cacheAddress(IPAddress address) {
        if (this.addressProvider == AddressProvider.NO_TYPE_PROVIDER) {
            this.initByAddress(address);
        }
    }

    void initByAddress(IPAddress address) {
        AddressProvider provider = AddressProvider.getProviderFor(address);
        if (provider.isIPv4()) {
            this.ipv6Exception = IS_IPV4_EXCEPTION;
        } else if (provider.isIPv6()) {
            this.ipv4Exception = IS_IPV6_EXCEPTION;
        }
        this.addressProvider = provider;
    }

    public IPAddressStringParameters getValidationOptions() {
        return this.validationOptions;
    }

    public boolean isPrefixed() {
        return this.isValid() && this.addressProvider.isPrefixed();
    }

    public Integer getNetworkPrefixLength() {
        if (this.isValid()) {
            return this.addressProvider.getNetworkPrefixLength();
        }
        return null;
    }

    public boolean isValid() {
        if (this.addressProvider.isUninitialized()) {
            try {
                this.validate();
                return true;
            }
            catch (IPAddressStringException e) {
                return false;
            }
        }
        return !this.addressProvider.isInvalid();
    }

    public boolean isIPAddress() {
        return this.isValid() && this.addressProvider.isIPAddress();
    }

    public boolean isAllAddresses() {
        return this.isValid() && this.addressProvider.isAllAddresses();
    }

    public boolean isPrefixOnly() {
        return this.isValid() && this.addressProvider.isPrefixOnly();
    }

    public boolean isEmpty() {
        return this.isValid() && this.addressProvider.isEmpty();
    }

    public boolean isIPv4() {
        return this.isValid() && this.addressProvider.isIPv4();
    }

    public boolean isIPv6() {
        return this.isValid() && this.addressProvider.isIPv6();
    }

    public boolean isMixedIPv6() {
        return this.isIPv6() && this.addressProvider.isMixedIPv6();
    }

    public IPAddress.IPVersion getIPVersion() {
        if (this.isValid()) {
            return this.addressProvider.getIPVersion();
        }
        return null;
    }

    public boolean isLoopback() {
        IPAddress val = this.getAddress();
        return val != null && val.isLoopback();
    }

    public boolean isZero() {
        IPAddress value = this.getAddress();
        return value != null && value.isZero();
    }

    public void validateIPv4() throws IPAddressStringException {
        this.validate(IPAddress.IPVersion.IPV4);
        this.checkIPv4Exception();
    }

    public void validateIPv6() throws IPAddressStringException {
        this.validate(IPAddress.IPVersion.IPV6);
        this.checkIPv6Exception();
    }

    public void validate() throws IPAddressStringException {
        this.validate(null);
    }

    private void checkIPv4Exception() throws IPAddressStringException {
        if (this.ipv4Exception != null) {
            if (this.ipv4Exception == IS_IPV6_EXCEPTION) {
                this.ipv4Exception = new IPAddressStringException("ipaddress.error.address.is.ipv6");
            }
            throw this.ipv4Exception;
        }
    }

    private void checkIPv6Exception() throws IPAddressStringException {
        if (this.ipv6Exception != null) {
            if (this.ipv6Exception == IS_IPV4_EXCEPTION) {
                this.ipv6Exception = new IPAddressStringException("ipaddress.error.address.is.ipv4");
            }
            throw this.ipv6Exception;
        }
    }

    private boolean isValidated(IPAddress.IPVersion version) throws IPAddressStringException {
        if (this.addressProvider != AddressProvider.NO_TYPE_PROVIDER) {
            if (version == null) {
                if (this.ipv6Exception != null && this.ipv4Exception != null) {
                    throw this.ipv4Exception;
                }
            } else if (version.isIPv4()) {
                this.checkIPv4Exception();
            } else if (version.isIPv6()) {
                this.checkIPv6Exception();
            }
            return true;
        }
        return false;
    }

    protected HostIdentifierStringValidator getValidator() {
        return Validator.VALIDATOR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validate(IPAddress.IPVersion version) throws IPAddressStringException {
        if (this.isValidated(version)) {
            return;
        }
        IPAddressString iPAddressString = this;
        synchronized (iPAddressString) {
            if (this.isValidated(version)) {
                return;
            }
            try {
                AddressProvider valueCreator = this.getValidator().validateAddress(this);
                IPAddress.IPVersion createdVersion = valueCreator.getIPVersion();
                if (createdVersion != null) {
                    if (createdVersion.isIPv4()) {
                        this.ipv6Exception = IS_IPV4_EXCEPTION;
                    } else if (createdVersion.isIPv6()) {
                        this.ipv4Exception = IS_IPV6_EXCEPTION;
                    }
                }
                this.addressProvider = valueCreator;
            }
            catch (IPAddressStringException e) {
                this.ipv6Exception = this.ipv4Exception = e;
                this.addressProvider = AddressProvider.INVALID_PROVIDER;
                throw e;
            }
        }
    }

    public static int validateNetworkPrefixLength(IPAddress.IPVersion ipVersion, CharSequence networkPrefixLength) throws IPAddressTypeException {
        try {
            return Validator.VALIDATOR.validatePrefix(networkPrefixLength, ipVersion);
        }
        catch (IPAddressStringException e) {
            throw new IPAddressTypeException(networkPrefixLength, ipVersion, "ipaddress.error.invalidCIDRPrefix", e);
        }
    }

    public static void validateNetworkPrefix(IPAddress.IPVersion ipVersion, int networkPrefixLength, boolean allowPrefixesBeyondAddressSize) throws IPAddressTypeException {
        boolean asIPv4 = ipVersion != null && ipVersion.isIPv4();
        if (networkPrefixLength > (asIPv4 ? 32 : 128)) {
            throw new IPAddressTypeException(networkPrefixLength, ipVersion, "ipaddress.error.prefixSize");
        }
    }

    public int hashCode() {
        if (this.isValid()) {
            return this.addressProvider.hashCode();
        }
        return this.toString().hashCode();
    }

    @Override
    public int compareTo(IPAddressString other) {
        if (this == other) {
            return 0;
        }
        boolean isValid = this.isValid();
        boolean otherIsValid = other.isValid();
        if (!isValid && !otherIsValid) {
            return this.toString().compareTo(other.toString());
        }
        return this.addressProvider.compareTo(other.addressProvider);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof IPAddressString) {
            IPAddressString other = (IPAddressString)o;
            if (this.toString().equals(other.toString())) {
                return true;
            }
            if (this.isValid() && other.isValid()) {
                return this.addressProvider.equals(other.addressProvider);
            }
        }
        return false;
    }

    public IPAddress getAddress(IPAddress.IPVersion version) {
        if (!this.addressProvider.isInvalid()) {
            try {
                return this.toAddress(version);
            }
            catch (IPAddressStringException iPAddressStringException) {
                // empty catch block
            }
        }
        return null;
    }

    public IPAddress getAddress() {
        if (!this.addressProvider.isInvalid()) {
            try {
                return this.toAddress();
            }
            catch (IPAddressStringException iPAddressStringException) {
                // empty catch block
            }
        }
        return null;
    }

    public IPAddress toAddress(IPAddress.IPVersion version) throws IPAddressStringException, IPAddressTypeException {
        this.validate();
        return this.addressProvider.getAddress(version);
    }

    public IPAddress toAddress() throws IPAddressStringException, IPAddressTypeException {
        this.validate();
        return this.addressProvider.getAddress();
    }

    public IPAddressString toSupernet(Integer prefixLengthDecrement) {
        if (this.isPrefixOnly()) {
            int bits;
            if (prefixLengthDecrement == null) {
                int bitsPerSegment = 8;
                int adjustment = this.getNetworkPrefixLength() % bitsPerSegment;
                bits = adjustment > 0 ? adjustment : bitsPerSegment;
            } else {
                bits = prefixLengthDecrement;
            }
            int newBits = Math.max(0, this.getNetworkPrefixLength() - bits);
            return IPAddressNetwork.getPrefix(newBits);
        }
        IPAddress address = this.getAddress();
        if (address == null) {
            return null;
        }
        Integer prefix = address.getNetworkPrefixLength();
        if (prefix != null && prefix == 0) {
            return ALL_ADDRESSES;
        }
        return address.toSupernet(prefixLengthDecrement).toAddressString();
    }

    public IPAddressString toSupernet() {
        return this.toSupernet(null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String convertToPrefixLength() throws IPAddressStringException {
        Integer prefix;
        IPAddress address = this.toAddress();
        if (address == null) {
            if (!this.isPrefixOnly()) return null;
            prefix = this.getNetworkPrefixLength();
        } else {
            prefix = address.getMaskPrefixLength(true);
            if (prefix == null) {
                return null;
            }
        }
        StringBuilder builder = new StringBuilder(HostIdentifierStringValidator.MAX_PREFIX_CHARS + 1);
        return builder.append('/').append(prefix).toString();
    }

    static String toNormalizedString(AddressProvider addressProvider) {
        String result = addressProvider.isAllAddresses() ? IPAddress.SEGMENT_WILDCARD_STR : (addressProvider.isEmpty() ? "" : (addressProvider.isPrefixOnly() ? IPAddressNetwork.getPrefix(addressProvider.getNetworkPrefixLength()).toString() : (addressProvider.isIPAddress() ? addressProvider.getAddress().toNormalizedString() : null)));
        return result;
    }

    @Override
    public String toNormalizedString() {
        String result = this.isValid() ? IPAddressString.toNormalizedString(this.addressProvider) : this.toString();
        return result;
    }

    public String toString() {
        return this.fullAddr;
    }
}

