/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.format;

import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressSection;
import inet.ipaddr.IPAddressTypeException;
import java.io.Serializable;

public abstract class IPAddressDivision
implements Comparable<IPAddressDivision>,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final boolean ADJUST_RANGES_BY_PREFIX = true;
    private static final String[] zeroes = new String[]{"", "0", "00", "000", "0000"};
    private static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    private static final char[] upperDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    private final Integer divisionNetworkPrefix;
    protected transient String cachedString;
    protected transient String cachedWildcardString;
    private transient Boolean isRangeEquivalentToPrefix;

    protected IPAddressDivision() {
        this(null);
    }

    protected IPAddressDivision(Integer networkPrefixLength) {
        this.divisionNetworkPrefix = networkPrefixLength;
    }

    public boolean isMultiple() {
        return this.getLowerValue() != this.getUpperValue();
    }

    public abstract int getBitCount();

    public abstract int getByteCount();

    public boolean isPrefixed() {
        return this.divisionNetworkPrefix != null;
    }

    public Integer getDivisionPrefixLength() {
        return this.divisionNetworkPrefix;
    }

    protected abstract long getMaxValue();

    public boolean isZero() {
        return !this.isMultiple() && this.getLowerValue() == 0L;
    }

    public abstract long getLowerValue();

    public abstract long getUpperValue();

    public long getCount() {
        return this.getUpperValue() - this.getLowerValue() + 1L;
    }

    public boolean rangeIsWithin(long lower, long upper) {
        return this.getLowerValue() >= lower && this.getUpperValue() <= upper;
    }

    public boolean valueIsWithin(long lower, long upper) {
        long value = this.getLowerValue();
        return value >= lower && value <= upper;
    }

    public boolean matches(long value) {
        return !this.isMultiple() && value == this.getLowerValue();
    }

    public boolean matchesWithPrefix(long value, Integer divisionPrefixLen) {
        if (divisionPrefixLen == null) {
            return this.matches(value);
        }
        long mask = this.getDivisionNetworkMask(divisionPrefixLen);
        long matchingValue = value & mask;
        return matchingValue == (this.getLowerValue() & mask) && matchingValue == (this.getUpperValue() & mask);
    }

    public boolean matchesWithMask(int value, long mask) {
        long diffBits;
        int leadingZeros;
        if (this.isMultiple() && (this.getDivisionHostMask(leadingZeros = Long.numberOfLeadingZeros(diffBits = this.getLowerValue() ^ this.getUpperValue()) - this.getLeadingZerosAdjustment()) & mask) != 0L) {
            return false;
        }
        return ((long)value & mask) == (this.getLowerValue() & mask);
    }

    protected abstract long getDivisionNetworkMask(int var1);

    protected abstract long getDivisionHostMask(int var1);

    public Integer getMaskPrefixLength(boolean network) {
        long invertedVal;
        long val;
        if (network) {
            val = this.getLowerValue();
            invertedVal = (val ^ 0xFFFFFFFFFFFFFFFFL) & this.getMaxValue();
        } else {
            invertedVal = this.getLowerValue();
            val = (invertedVal ^ 0xFFFFFFFFFFFFFFFFL) & this.getMaxValue();
        }
        int bitCount = this.getBitCount();
        int hostLength = Math.min(Long.numberOfTrailingZeros(val), bitCount);
        long shifted = invertedVal >>> hostLength;
        return shifted == 0L ? Integer.valueOf(bitCount - hostLength) : null;
    }

    protected abstract boolean isSameValues(IPAddressDivision var1);

    public boolean isSamePrefixedRange(long lowerValue) {
        return this.isPrefixed() ? this.isSamePrefixedRange(lowerValue, this.getDivisionPrefixLength()) : lowerValue == this.getLowerValue() && !this.isMultiple();
    }

    private boolean isSamePrefixedRange(long lowerValue, int divisionPrefixLen) {
        long mask = this.getDivisionNetworkMask(divisionPrefixLen);
        long expectedValue = lowerValue & mask;
        return this.getLowerValue() == expectedValue && this.getUpperValue() == (lowerValue | this.getDivisionHostMask(divisionPrefixLen));
    }

    private static boolean testRange(long lowerValue, long upperValue, long finalUpperValue, long networkMask, long hostMask) {
        return lowerValue == (lowerValue & networkMask) && finalUpperValue == (upperValue | hostMask);
    }

    private boolean isRangeUnchanged(long segmentValue, long upperValue, int divisionPrefixLen) {
        return IPAddressDivision.testRange(segmentValue, upperValue, upperValue, this.getDivisionNetworkMask(divisionPrefixLen), this.getDivisionHostMask(divisionPrefixLen));
    }

    protected boolean isRangeEquivalent(long segmentValue, long upperValue, int divisionPrefixLen) {
        return IPAddressDivision.testRange(segmentValue, segmentValue, upperValue, this.getDivisionNetworkMask(divisionPrefixLen), this.getDivisionHostMask(divisionPrefixLen));
    }

    public boolean isRangeEquivalent(Integer divisionPrefixLen) {
        if (divisionPrefixLen == null) {
            return !this.isMultiple();
        }
        if (divisionPrefixLen == 0) {
            return true;
        }
        return this.isRangeEquivalent(this.getLowerValue(), this.getUpperValue(), divisionPrefixLen);
    }

    public boolean isRangeUnchanged(Integer divisionPrefixLen) {
        if (divisionPrefixLen == null) {
            return true;
        }
        if (divisionPrefixLen == 0) {
            return this.isFullRange();
        }
        return this.isRangeUnchanged(this.getLowerValue(), this.getUpperValue(), divisionPrefixLen);
    }

    public boolean isRangeEquivalentToPrefix() {
        if (this.isRangeEquivalentToPrefix == null) {
            this.isRangeEquivalentToPrefix = this.isRangeEquivalent(this.getDivisionPrefixLength());
        }
        return this.isRangeEquivalentToPrefix;
    }

    public boolean isFullRange() {
        return this.getLowerValue() == 0L && this.getUpperValue() == this.getMaxValue();
    }

    public boolean isMaskCompatibleWithRange(long maskValue, Integer divisionPrefixLen) {
        long upperValue;
        boolean hasBits;
        boolean bl = hasBits = divisionPrefixLen != null;
        if (hasBits && (divisionPrefixLen < 0 || divisionPrefixLen > this.getBitCount())) {
            throw new IPAddressTypeException(this, (int)divisionPrefixLen, "ipaddress.error.prefixSize");
        }
        if (!this.isMultiple()) {
            return true;
        }
        if (!hasBits) {
            divisionPrefixLen = this.getBitCount();
        }
        long networkMask = this.getDivisionNetworkMask(divisionPrefixLen);
        long value = this.getLowerValue();
        long differing = (value ^ (upperValue = this.getUpperValue())) & networkMask;
        if (differing != 0L && differing != 1L) {
            boolean foundDiffering;
            int leadingZerosAdjustment = this.getLeadingZerosAdjustment();
            int highestDifferingBitInRange = Long.numberOfLeadingZeros(differing) - leadingZerosAdjustment;
            long maskMask = this.getDivisionHostMask(highestDifferingBitInRange);
            long differingMasked = maskValue & maskMask;
            boolean bl2 = foundDiffering = differingMasked != 0L && differingMasked != 1L;
            if (foundDiffering) {
                long hostMask;
                int highestDifferingBitMasked = Long.numberOfLeadingZeros(differingMasked) - leadingZerosAdjustment;
                if (((maskValue |= this.getDivisionHostMask(divisionPrefixLen)) & (hostMask = this.getDivisionHostMask(highestDifferingBitMasked + 1))) != hostMask) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public int compareTo(IPAddressDivision other) {
        return IPAddress.addressComparator.compare(this, other);
    }

    protected abstract int getLeadingZerosAdjustment();

    public abstract int getDefaultTextualRadix();

    public abstract int getDefaultMaxChars();

    private static boolean isAlphabetic(long i) {
        return i >= 10L;
    }

    public boolean hasAlphabeticDigits(int base, boolean lowerOnly) {
        boolean isPowerOfTwo;
        if (base <= 1) {
            throw new IllegalArgumentException();
        }
        if (base <= 10) {
            return false;
        }
        int shift = 0;
        long mask = 0L;
        switch (base) {
            case 16: {
                isPowerOfTwo = true;
                shift = 4;
                mask = 15L;
                break;
            }
            default: {
                boolean bl = isPowerOfTwo = (base & base - 1) == 0;
                if (!isPowerOfTwo) break;
                shift = Integer.numberOfTrailingZeros(base);
                mask = -1L << shift ^ 0xFFFFFFFFFFFFFFFFL;
            }
        }
        boolean handledUpper = false;
        long value = this.getLowerValue();
        while (true) {
            if (value > 0L) {
                if (IPAddressDivision.isAlphabetic(isPowerOfTwo ? mask & value : value % (long)base)) {
                    return true;
                }
                long l = value = isPowerOfTwo ? value >> shift : value / (long)base;
                continue;
            }
            if (handledUpper || lowerOnly) break;
            value = this.getUpperValue();
            handledUpper = true;
        }
        return false;
    }

    public static int defaultMaxCharsPerSegment(IPAddress.IPVersion version) {
        return version.isIPv4() ? 3 : 4;
    }

    public int getDefaultMaxChars(int radix) {
        int defaultRadix = this.getDefaultTextualRadix();
        if (radix == defaultRadix) {
            return this.getDefaultMaxChars();
        }
        return IPAddressDivision.getCharWidth(this.getMaxValue(), radix);
    }

    public static int getCharWidth(long value, int radix) {
        int result = 1;
        if (radix == 16) {
            while ((value >>>= 4) != 0L) {
                ++result;
            }
        } else {
            if (radix == 10) {
                if (value < 10L) {
                    return 1;
                }
                if (value < 100L) {
                    return 2;
                }
                if (value < 1000L) {
                    return 3;
                }
            }
            while ((value /= (long)radix) != 0L) {
                ++result;
            }
        }
        return result;
    }

    public int getMaxLeadingZeros(int radix) {
        if (!this.isRangeEquivalentToPrefix()) {
            return 0;
        }
        int width = IPAddressDivision.getCharWidth(this.getLowerValue(), radix);
        return Math.max(0, this.getDefaultMaxChars(radix) - width);
    }

    private int adjustLeadingZeroCount(int leadingZeroCount, long value, int radix) {
        if (leadingZeroCount < 0) {
            int width = IPAddressDivision.getCharWidth(value, radix);
            return Math.max(0, this.getDefaultMaxChars(radix) - width);
        }
        return leadingZeroCount;
    }

    private static void getSplitChar(int count, char splitDigitSeparator, String characters, String stringPrefix, StringBuilder builder) {
        while (count-- > 0) {
            if (stringPrefix != null) {
                builder.append(stringPrefix);
            }
            builder.append(characters);
            builder.append(splitDigitSeparator);
        }
        builder.setLength(builder.length() - 1);
    }

    private static void getSplitChar(int count, char splitDigitSeparator, char character, String stringPrefix, StringBuilder builder) {
        while (count-- > 0) {
            if (stringPrefix != null) {
                builder.append(stringPrefix);
            }
            builder.append(character);
            builder.append(splitDigitSeparator);
        }
        builder.setLength(builder.length() - 1);
    }

    private static void getSplitLeadingZeros(int leadingZeroCount, char splitDigitSeparator, String stringPrefix, StringBuilder builder) {
        IPAddressDivision.getSplitChar(leadingZeroCount, splitDigitSeparator, '0', stringPrefix, builder);
    }

    private static void getLeadingZeros(int leadingZeroCount, StringBuilder builder) {
        String[] stringArray = zeroes;
        if (leadingZeroCount >= stringArray.length) {
            int increment = stringArray.length - 1;
            String incrementStr = stringArray[increment];
            while (leadingZeroCount >= increment) {
                builder.append(incrementStr);
                leadingZeroCount -= increment;
            }
            builder.append(stringArray[leadingZeroCount]);
            return;
        }
        builder.append(stringArray[leadingZeroCount]);
    }

    public String toString() {
        return this.getString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString() {
        String result = this.cachedString;
        if (result == null) {
            IPAddressDivision iPAddressDivision = this;
            synchronized (iPAddressDivision) {
                result = this.cachedString;
                if (result == null) {
                    if (this.isRangeEquivalentToPrefix()) {
                        result = IPAddressDivision.toDefaultString(this.getLowerValue(), this.getDefaultTextualRadix());
                    } else if (this.isFullRange()) {
                        result = IPAddress.SEGMENT_WILDCARD_STR;
                    } else {
                        long upperValue = this.getUpperValue();
                        if (this.isPrefixed()) {
                            long mask = this.getDivisionNetworkMask(this.getDivisionPrefixLength());
                            upperValue &= mask;
                        }
                        result = IPAddressDivision.getDefaultRangeString(this.getLowerValue(), upperValue, this.getDefaultTextualRadix());
                    }
                    this.cachedString = result;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getWildcardString() {
        String result = this.cachedWildcardString;
        if (result == null) {
            IPAddressDivision iPAddressDivision = this;
            synchronized (iPAddressDivision) {
                result = this.cachedWildcardString;
                if (result == null) {
                    result = !this.isPrefixed() ? this.getString() : (this.isFullRange() ? IPAddress.SEGMENT_WILDCARD_STR : IPAddressDivision.getDefaultRangeString(this.getLowerValue(), this.getUpperValue(), this.getDefaultTextualRadix()));
                    this.cachedWildcardString = result;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getCachedString(long lowerValue, int radix) {
        String result = this.cachedString;
        if (result == null) {
            IPAddressDivision iPAddressDivision = this;
            synchronized (iPAddressDivision) {
                result = this.cachedString;
                if (result == null) {
                    this.cachedString = result = IPAddressDivision.toDefaultString(lowerValue, radix);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getCachedWildcardString(long lowerValue, int radix) {
        String result = this.cachedWildcardString;
        if (result == null) {
            IPAddressDivision iPAddressDivision = this;
            synchronized (iPAddressDivision) {
                result = this.cachedWildcardString;
                if (result == null) {
                    result = this.cachedString;
                    if (result == null) {
                        this.cachedString = result = IPAddressDivision.toDefaultString(lowerValue, radix);
                    }
                    this.cachedWildcardString = result;
                }
            }
        }
        return result;
    }

    public int getWildcardString(IPAddressSection.WildcardOptions.Wildcards wildcards, int leadingZeroCount, String stringPrefix, int radix, boolean uppercase, boolean splitDigits, char splitDigitSeparator, boolean reverseSplitDigits, StringBuilder appendable) {
        int rangeDigitCount;
        String wildcard;
        if (!this.isMultiple()) {
            long lowerValue = this.getLowerValue();
            leadingZeroCount = this.adjustLeadingZeroCount(leadingZeroCount, lowerValue, radix);
            if (splitDigits) {
                if (appendable == null) {
                    int len = leadingZeroCount != 0 ? (leadingZeroCount < 0 ? this.getDefaultMaxChars(radix) : IPAddressDivision.toUnsignedStringLength(lowerValue, radix) + leadingZeroCount) : IPAddressDivision.toUnsignedStringLength(lowerValue, radix);
                    int count = (len << 1) - 1;
                    if (stringPrefix != null) {
                        count += len * stringPrefix.length();
                    }
                    return count;
                }
                if (reverseSplitDigits) {
                    IPAddressDivision.toSplitUnsignedString(lowerValue, radix, 0, uppercase, splitDigitSeparator, reverseSplitDigits, stringPrefix, appendable);
                    if (leadingZeroCount != 0) {
                        appendable.append(splitDigitSeparator);
                        IPAddressDivision.getSplitLeadingZeros(leadingZeroCount, splitDigitSeparator, stringPrefix, appendable);
                    }
                } else {
                    if (leadingZeroCount != 0) {
                        IPAddressDivision.getSplitLeadingZeros(leadingZeroCount, splitDigitSeparator, stringPrefix, appendable);
                        appendable.append(splitDigitSeparator);
                    }
                    IPAddressDivision.toSplitUnsignedString(lowerValue, radix, 0, uppercase, splitDigitSeparator, reverseSplitDigits, stringPrefix, appendable);
                }
                return 0;
            }
            int count = 0;
            if (stringPrefix != null) {
                if (appendable == null) {
                    count += stringPrefix.length();
                } else {
                    appendable.append(stringPrefix);
                }
            }
            if (leadingZeroCount != 0) {
                if (appendable == null) {
                    if (leadingZeroCount < 0) {
                        return count + this.getDefaultMaxChars(radix);
                    }
                    count += leadingZeroCount;
                } else {
                    leadingZeroCount = this.adjustLeadingZeroCount(leadingZeroCount, lowerValue, radix);
                    IPAddressDivision.getLeadingZeros(leadingZeroCount, appendable);
                }
            }
            if (radix == this.getDefaultTextualRadix()) {
                String str = this.getCachedWildcardString(lowerValue, radix);
                if (appendable == null) {
                    return count + str.length();
                }
                if (uppercase && radix > 10) {
                    int i = 0;
                    while (i < str.length()) {
                        char c = str.charAt(i);
                        if (c >= 'a' && c <= 'z') {
                            c = (char)(c + -32);
                        }
                        appendable.append(c);
                        ++i;
                    }
                } else {
                    appendable.append(str);
                }
            } else {
                if (appendable == null) {
                    return count + IPAddressDivision.toUnsignedStringLength(lowerValue, radix);
                }
                IPAddressDivision.toUnsignedString(lowerValue, radix, uppercase, appendable);
            }
            return 0;
        }
        if (this.isFullRange() && (wildcard = wildcards.wildcard) != null) {
            if (splitDigits) {
                if (appendable == null) {
                    int len = this.getDefaultMaxChars(radix);
                    int count = len * (wildcard.length() + 1) - 1;
                    return count;
                }
                IPAddressDivision.getSplitChar(this.getDefaultMaxChars(radix), splitDigitSeparator, wildcard, null, appendable);
            } else {
                if (appendable == null) {
                    return wildcard.length();
                }
                if (wildcard.equals(IPAddress.SEGMENT_WILDCARD_STR)) {
                    this.cachedWildcardString = wildcard;
                    appendable.append(this.cachedWildcardString);
                } else {
                    appendable.append(wildcard);
                }
            }
            return 0;
        }
        String rangeSeparator = wildcards.rangeSeparator;
        int n = rangeDigitCount = wildcards.singleWildcard == null ? 0 : this.getRangeDigitCount(radix);
        if (leadingZeroCount == 0 && rangeSeparator.equals(IPAddress.RANGE_SEPARATOR_STR) && rangeDigitCount == 0 && radix == this.getDefaultTextualRadix() && !splitDigits && stringPrefix == null) {
            String str = this.getWildcardString();
            if (appendable == null) {
                return str.length();
            }
            appendable.append(str);
            return 0;
        }
        long lower = this.getLowerValue();
        rangeDigitCount = this.adjustRangeDigits(lower, rangeDigitCount);
        if (!splitDigits && leadingZeroCount < 0 && appendable == null) {
            int charLength = this.getDefaultMaxChars(radix);
            if (rangeDigitCount != 0) {
                int count = charLength;
                if (stringPrefix != null) {
                    count += stringPrefix.length();
                }
                return count;
            }
            int count = charLength << 1;
            if (stringPrefix != null) {
                count += stringPrefix.length() << 1;
            }
            return count += rangeSeparator.length();
        }
        int lowerLeadingZeroCount = this.adjustLeadingZeroCount(leadingZeroCount, lower, radix);
        if (rangeDigitCount != 0) {
            if (splitDigits) {
                return IPAddressDivision.getSplitRangeDigitString(lower, wildcards, lowerLeadingZeroCount, stringPrefix, radix, rangeDigitCount, uppercase, splitDigitSeparator, reverseSplitDigits, appendable);
            }
            return IPAddressDivision.getRangeDigitString(lower, wildcards.singleWildcard, lowerLeadingZeroCount, stringPrefix, radix, rangeDigitCount, uppercase, appendable);
        }
        long upperVal = this.getUpperValue();
        int upperLeading = this.adjustLeadingZeroCount(leadingZeroCount, upperVal, radix);
        if (splitDigits) {
            return IPAddressDivision.getSplitRangeString(lower, upperVal, wildcards, upperLeading, stringPrefix, radix, uppercase, splitDigitSeparator, reverseSplitDigits, appendable);
        }
        return IPAddressDivision.getRangeString(lower, upperVal, wildcards.rangeSeparator, lowerLeadingZeroCount, upperLeading, stringPrefix, radix, uppercase, appendable);
    }

    public int getPrefixAdjustedWildcardString(IPAddressSection.WildcardOptions.Wildcards wildcards, int leadingZeroCount, String stringPrefix, int radix, boolean uppercase, StringBuilder appendable) {
        int rangeDigitCount;
        String wildcard;
        if (this.isRangeEquivalentToPrefix()) {
            int count = 0;
            long lowerValue = this.getLowerValue();
            if (stringPrefix != null) {
                if (appendable == null) {
                    count += stringPrefix.length();
                } else {
                    appendable.append(stringPrefix);
                }
            }
            if (leadingZeroCount != 0) {
                if (appendable == null) {
                    if (leadingZeroCount < 0) {
                        return count += this.getDefaultMaxChars(radix);
                    }
                    count += leadingZeroCount;
                } else {
                    leadingZeroCount = this.adjustLeadingZeroCount(leadingZeroCount, lowerValue, radix);
                    IPAddressDivision.getLeadingZeros(leadingZeroCount, appendable);
                }
            }
            if (radix == this.getDefaultTextualRadix()) {
                String str = this.getCachedString(lowerValue, radix);
                if (appendable == null) {
                    return count + str.length();
                }
                if (uppercase && radix > 10) {
                    int i = 0;
                    while (i < str.length()) {
                        char c = str.charAt(i);
                        if (c >= 'a' && c <= 'z') {
                            c = (char)(c + -32);
                        }
                        appendable.append(c);
                        ++i;
                    }
                } else {
                    appendable.append(str);
                }
            } else {
                if (appendable == null) {
                    return count + IPAddressDivision.toUnsignedStringLength(lowerValue, radix);
                }
                IPAddressDivision.toUnsignedString(lowerValue, radix, uppercase, appendable);
            }
            return 0;
        }
        if (this.isFullRange() && (wildcard = wildcards.wildcard) != null) {
            if (appendable == null) {
                return wildcard.length();
            }
            if (wildcard.equals(IPAddress.SEGMENT_WILDCARD_STR)) {
                this.cachedString = this.cachedWildcardString = wildcard;
                appendable.append(this.cachedWildcardString);
            } else {
                appendable.append(wildcard);
            }
            return 0;
        }
        if (!this.isPrefixed()) {
            return this.getWildcardString(wildcards, leadingZeroCount, stringPrefix, radix, uppercase, false, '\u0000', false, appendable);
        }
        String rangeSeparator = wildcards.rangeSeparator;
        int n = rangeDigitCount = wildcards.singleWildcard == null ? 0 : this.getRangeDigitCount(radix);
        if (leadingZeroCount == 0 && IPAddress.RANGE_SEPARATOR_STR.equals(rangeSeparator) && rangeDigitCount == 0 && radix == this.getDefaultTextualRadix() && stringPrefix == null) {
            String str = this.getString();
            if (appendable == null) {
                return str.length();
            }
            if (uppercase) {
                int i = 0;
                while (i < str.length()) {
                    char c = str.charAt(i);
                    if (c >= 'a' && c <= 'z') {
                        c = (char)(c + -32);
                    }
                    appendable.append(c);
                    ++i;
                }
            } else {
                appendable.append(str);
            }
            return 0;
        }
        long lower = this.getLowerValue();
        rangeDigitCount = this.adjustRangeDigits(lower, rangeDigitCount);
        if (leadingZeroCount < 0 && appendable == null) {
            int charLength = this.getDefaultMaxChars(radix);
            if (rangeDigitCount != 0) {
                int count = charLength;
                if (stringPrefix != null) {
                    count += stringPrefix.length();
                }
                return count;
            }
            int count = charLength << 1;
            if (stringPrefix != null) {
                count += stringPrefix.length() << 1;
            }
            return count += rangeSeparator.length();
        }
        int lowerLeadingZeroCount = this.adjustLeadingZeroCount(leadingZeroCount, lower, radix);
        if (rangeDigitCount != 0) {
            return IPAddressDivision.getRangeDigitString(lower, wildcards.singleWildcard, lowerLeadingZeroCount, stringPrefix, radix, rangeDigitCount, uppercase, appendable);
        }
        long upper = this.getUpperValue();
        if (appendable != null) {
            long mask = this.getDivisionNetworkMask(this.getDivisionPrefixLength());
            lower &= mask;
            upper &= mask;
        }
        int upperLeadingZeroCount = this.adjustLeadingZeroCount(leadingZeroCount, upper, radix);
        return IPAddressDivision.getRangeString(lower, upper, rangeSeparator, lowerLeadingZeroCount, upperLeadingZeroCount, stringPrefix, radix, uppercase, appendable);
    }

    int adjustRangeDigits(long lower, int rangeDigits) {
        if (rangeDigits != 0 && (lower != 0L || rangeDigits == 1)) {
            return rangeDigits;
        }
        return 0;
    }

    protected static int getSplitRangeDigitString(long lower, IPAddressSection.WildcardOptions.Wildcards wildcards, int leadingZerosCount, String stringPrefix, int radix, int rangeDigits, boolean uppercase, char splitDigitSeparator, boolean reverseSplitDigits, StringBuilder appendable) {
        if (appendable == null) {
            int len = IPAddressDivision.toUnsignedStringLength(lower, radix) + leadingZerosCount;
            int count = (len << 1) - 1;
            if (stringPrefix != null) {
                count += len * stringPrefix.length();
            }
            return count;
        }
        if (reverseSplitDigits) {
            IPAddressDivision.getSplitChar(rangeDigits, splitDigitSeparator, wildcards.singleWildcard, stringPrefix, appendable);
            appendable.append(splitDigitSeparator);
            IPAddressDivision.toSplitUnsignedString(lower, radix, rangeDigits, uppercase, splitDigitSeparator, reverseSplitDigits, stringPrefix, appendable);
            if (leadingZerosCount > 0) {
                appendable.append(splitDigitSeparator);
                IPAddressDivision.getSplitLeadingZeros(leadingZerosCount, splitDigitSeparator, stringPrefix, appendable);
            }
        } else {
            if (leadingZerosCount != 0) {
                IPAddressDivision.getSplitLeadingZeros(leadingZerosCount, splitDigitSeparator, stringPrefix, appendable);
                appendable.append(splitDigitSeparator);
            }
            IPAddressDivision.toSplitUnsignedString(lower, radix, rangeDigits, uppercase, splitDigitSeparator, reverseSplitDigits, stringPrefix, appendable);
            appendable.append(splitDigitSeparator);
            IPAddressDivision.getSplitChar(rangeDigits, splitDigitSeparator, wildcards.singleWildcard, stringPrefix, appendable);
        }
        return 0;
    }

    protected static int getRangeDigitString(long lower, String singleWildcard, int lowerLeadingZerosCount, String stringPrefix, int radix, int rangeDigits, boolean uppercase, StringBuilder appendable) {
        if (appendable == null) {
            int count = IPAddressDivision.toUnsignedStringLength(lower, radix) + lowerLeadingZerosCount;
            if (stringPrefix != null) {
                count += stringPrefix.length();
            }
            return count;
        }
        if (stringPrefix != null) {
            appendable.append(stringPrefix);
        }
        if (lowerLeadingZerosCount > 0) {
            IPAddressDivision.getLeadingZeros(lowerLeadingZerosCount, appendable);
        }
        IPAddressDivision.toUnsignedString(lower, radix, rangeDigits, uppercase, appendable);
        int i = 0;
        while (i < rangeDigits) {
            appendable.append(singleWildcard);
            ++i;
        }
        return 0;
    }

    private static String getDefaultRangeString(long val1, long val2, int radix) {
        if (radix == 10) {
            int remainder;
            int quotient;
            int len2;
            int len1;
            if (val1 < 10L) {
                len1 = 1;
            } else if (val1 < 100L) {
                len1 = 2;
            } else if (val1 < 1000L) {
                len1 = 3;
            } else {
                return IPAddressDivision.buildDefaultRangeString(val1, val2, radix);
            }
            int value1 = (int)val1;
            if (val2 < 10L) {
                len2 = 1;
            } else if (val2 < 100L) {
                len2 = 2;
            } else if (val2 < 1000L) {
                len2 = 3;
            } else {
                return IPAddressDivision.buildDefaultRangeString(val1, val2, radix);
            }
            int value2 = (int)val2;
            char[] chars = new char[len2 += len1 + 1];
            chars[len1] = 45;
            char[] dig = digits;
            do {
                quotient = value1 * 52429 >>> 19;
                remainder = value1 - ((quotient << 3) + (quotient << 1));
                chars[--len1] = dig[remainder];
            } while ((value1 = quotient) != 0);
            do {
                quotient = value2 * 52429 >>> 19;
                remainder = value2 - ((quotient << 3) + (quotient << 1));
                chars[--len2] = dig[remainder];
            } while ((value2 = quotient) != 0);
            return new String(chars);
        }
        if (radix == 16) {
            int remainder;
            int quotient;
            int len2;
            int len1;
            if (val1 < 16L) {
                len1 = 1;
            } else if (val1 < 256L) {
                len1 = 2;
            } else if (val1 < 4096L) {
                len1 = 3;
            } else if (val1 < 65536L) {
                len1 = 4;
            } else {
                return IPAddressDivision.buildDefaultRangeString(val1, val2, radix);
            }
            int value1 = (int)val1;
            if (val2 < 16L) {
                len2 = 1;
            } else if (val2 < 256L) {
                len2 = 2;
            } else if (val2 < 4096L) {
                len2 = 3;
            } else if (val2 < 65536L) {
                len2 = 4;
            } else {
                return IPAddressDivision.buildDefaultRangeString(val1, val2, radix);
            }
            int value2 = (int)val2;
            char[] chars = new char[len2 += len1 + 1];
            chars[len1] = 45;
            char[] dig = digits;
            do {
                quotient = value1 >>> 4;
                remainder = value1 - (quotient << 4);
                chars[--len1] = dig[remainder];
            } while ((value1 = quotient) != 0);
            do {
                quotient = value2 >>> 4;
                remainder = value2 - (quotient << 4);
                chars[--len2] = dig[remainder];
            } while ((value2 = quotient) != 0);
            return new String(chars);
        }
        return IPAddressDivision.buildDefaultRangeString(val1, val2, radix);
    }

    private static String buildDefaultRangeString(long lower, long upper, int radix) {
        StringBuilder builder = new StringBuilder(20);
        IPAddressDivision.getRangeString(lower, upper, IPAddress.RANGE_SEPARATOR_STR, 0, 0, null, radix, false, builder);
        return builder.toString();
    }

    private static String toDefaultString(long val, int radix) {
        switch ((int)val) {
            case 0: {
                return "0";
            }
            case 1: {
                return "1";
            }
        }
        if (radix == 10) {
            int quotient;
            int value;
            int len;
            if (val < 10L) {
                return String.valueOf(digits, (int)val, 1);
            }
            if (val < 100L) {
                len = 2;
                value = (int)val;
            } else if (val < 1000L) {
                len = 3;
                value = (int)val;
            } else {
                return Long.toString(val, radix);
            }
            char[] chars = new char[len];
            char[] dig = digits;
            do {
                quotient = value * 52429 >>> 19;
                int remainder = value - ((quotient << 3) + (quotient << 1));
                chars[--len] = dig[remainder];
            } while ((value = quotient) != 0);
            return new String(chars);
        }
        if (radix == 16) {
            int quotient;
            int value;
            int len;
            if (val < 16L) {
                return String.valueOf(digits, (int)val, 1);
            }
            if (val < 256L) {
                len = 2;
                value = (int)val;
            } else if (val < 4096L) {
                len = 3;
                value = (int)val;
            } else if (val < 65536L) {
                if (val == 65535L) {
                    return "ffff";
                }
                value = (int)val;
                len = 4;
            } else {
                return Long.toString(val, radix);
            }
            char[] chars = new char[len];
            char[] dig = digits;
            do {
                quotient = value >>> 4;
                int remainder = value - (quotient << 4);
                chars[--len] = dig[remainder];
            } while ((value = quotient) != 0);
            return new String(chars);
        }
        return Long.toString(val, radix);
    }

    protected static boolean toUnsignedStringFast(int value, int radix, boolean uppercase, StringBuilder appendable) {
        if (value <= 1) {
            if (value == 0) {
                appendable.append('0');
            } else {
                appendable.append('1');
            }
            return true;
        }
        if (radix == 10) {
            int quotient;
            if (value < 10) {
                appendable.append(digits[value]);
                return true;
            }
            if (value < 100) {
                appendable.append("  ");
            } else if (value < 1000) {
                if (value == 127) {
                    appendable.append("127");
                    return true;
                }
                if (value == 255) {
                    appendable.append("255");
                    return true;
                }
                appendable.append("   ");
            } else if (value < 10000) {
                appendable.append("    ");
            } else {
                appendable.append("     ");
            }
            char[] dig = digits;
            int index = appendable.length();
            do {
                quotient = value * 52429 >>> 19;
                int remainder = value - ((quotient << 3) + (quotient << 1));
                appendable.setCharAt(--index, dig[remainder]);
            } while ((value = quotient) != 0);
            return true;
        }
        if (radix == 16) {
            int quotient;
            if (value < 10) {
                appendable.append(digits[value]);
                return true;
            }
            if (value < 16) {
                appendable.append((uppercase ? upperDigits : digits)[value]);
                return true;
            }
            if (value < 256) {
                appendable.append("  ");
            } else if (value < 4096) {
                appendable.append("   ");
            } else {
                if (value == 65535) {
                    appendable.append(uppercase ? "FFFF" : "ffff");
                    return true;
                }
                appendable.append("    ");
            }
            int index = appendable.length();
            char[] dig = uppercase ? upperDigits : digits;
            do {
                quotient = value >>> 4;
                int remainder = value - (quotient << 4);
                appendable.setCharAt(--index, dig[remainder]);
            } while ((value = quotient) != 0);
            return true;
        }
        if (radix == 8) {
            int quotient;
            char[] dig = digits;
            if (value < 8) {
                appendable.append(dig[value]);
                return true;
            }
            if (value < 64) {
                appendable.append("  ");
            } else if (value < 512) {
                appendable.append("   ");
            } else if (value < 4096) {
                appendable.append("    ");
            } else if (value < 32768) {
                appendable.append("     ");
            } else {
                appendable.append("      ");
            }
            int index = appendable.length();
            do {
                quotient = value >>> 3;
                int remainder = value - (quotient << 3);
                appendable.setCharAt(--index, dig[remainder]);
            } while ((value = quotient) != 0);
            return true;
        }
        if (radix == 2) {
            int digitCount = 15;
            int val = value;
            if (val >>> 8 == 0) {
                digitCount -= 8;
            } else {
                val >>>= 8;
            }
            if (val >>> 4 == 0) {
                digitCount -= 4;
            } else {
                val >>>= 4;
            }
            if (val >>> 2 == 0) {
                digitCount -= 2;
            } else {
                val >>>= 2;
            }
            if ((val & 2) == 0) {
                --digitCount;
            }
            appendable.append('1');
            char[] dig = digits;
            while (digitCount > 0) {
                char c = dig[value >>> --digitCount & 1];
                appendable.append(c);
            }
            return true;
        }
        return false;
    }

    private static void toUnsignedString(long value, int radix, boolean uppercase, StringBuilder appendable) {
        if (value > 65535L || !IPAddressDivision.toUnsignedStringFast((int)value, radix, uppercase, appendable)) {
            IPAddressDivision.toUnsignedString(value, radix, 0, uppercase, appendable);
        }
    }

    private static void appendDigits(long value, int radix, int choppedDigits, boolean uppercase, StringBuilder appendable) {
        boolean useInts = value <= Integer.MAX_VALUE;
        int value2 = useInts ? (int)value : radix;
        char[] dig = uppercase ? upperDigits : digits;
        while (value2 >= radix) {
            int index;
            if (useInts) {
                int val2 = value2;
                value2 /= radix;
                if (choppedDigits > 0) {
                    --choppedDigits;
                    continue;
                }
                index = val2 % radix;
            } else {
                long val = value;
                if ((value /= (long)radix) <= Integer.MAX_VALUE) {
                    useInts = true;
                    value2 = (int)value;
                }
                if (choppedDigits > 0) {
                    --choppedDigits;
                    continue;
                }
                index = (int)(val % (long)radix);
            }
            appendable.append(dig[index]);
        }
        if (choppedDigits == 0) {
            appendable.append(dig[value2]);
        }
    }

    private static void appendDigits(long value, int radix, int choppedDigits, boolean uppercase, char splitDigitSeparator, String stringPrefix, StringBuilder appendable) {
        boolean useInts = value <= Integer.MAX_VALUE;
        int value2 = useInts ? (int)value : radix;
        char[] dig = uppercase ? upperDigits : digits;
        while (value2 >= radix) {
            int index;
            if (useInts) {
                int val = value2;
                value2 /= radix;
                if (choppedDigits > 0) {
                    --choppedDigits;
                    continue;
                }
                index = val % radix;
            } else {
                long val = value;
                if ((value /= (long)radix) <= Integer.MAX_VALUE) {
                    useInts = true;
                    value2 = (int)value;
                }
                if (choppedDigits > 0) {
                    --choppedDigits;
                    continue;
                }
                index = (int)(val % (long)radix);
            }
            if (stringPrefix != null) {
                appendable.append(stringPrefix);
            }
            appendable.append(dig[index]);
            appendable.append(splitDigitSeparator);
        }
        if (choppedDigits == 0) {
            if (stringPrefix != null) {
                appendable.append(stringPrefix);
            }
            appendable.append(dig[value2]);
        }
    }

    private static void appendDigits(long lower, long upper, String rangeSeparator, String wildcard, int radix, boolean uppercase, char splitDigitSeparator, boolean reverseSplitDigits, String stringPrefix, StringBuilder appendable) {
        int lowerInt;
        int upperInt;
        boolean useInts;
        char[] dig = uppercase ? upperDigits : digits;
        boolean isFull = true;
        boolean bl = useInts = upper <= Integer.MAX_VALUE;
        if (useInts) {
            upperInt = (int)upper;
            lowerInt = (int)lower;
        } else {
            upperInt = lowerInt = radix;
        }
        while (true) {
            int k;
            int lowerDigit;
            int upperDigit;
            if (useInts) {
                int ud = upperInt;
                upperDigit = upperInt % radix;
                upperInt /= radix;
                if (ud == lowerInt) {
                    lowerInt = upperInt;
                    lowerDigit = upperDigit;
                } else {
                    lowerDigit = lowerInt % radix;
                    lowerInt /= radix;
                }
            } else {
                long ud = upper;
                upperDigit = (int)(upper % (long)radix);
                upper /= (long)radix;
                if (ud == lower) {
                    lower = upper;
                    lowerDigit = upperDigit;
                } else {
                    lowerDigit = (int)(lower % (long)radix);
                    lower /= (long)radix;
                }
                if (upper <= Integer.MAX_VALUE) {
                    useInts = true;
                    upperInt = (int)upper;
                    lowerInt = (int)lower;
                }
            }
            if (!isFull && lowerDigit != upperDigit) {
                throw new IPAddressTypeException(lower, upper, "ipaddress.error.splitMismatch");
            }
            if (lowerDigit == upperDigit) {
                isFull = false;
                if (reverseSplitDigits) {
                    if (stringPrefix != null) {
                        appendable.append(stringPrefix);
                    }
                    appendable.append(dig[lowerDigit]);
                } else {
                    appendable.append(dig[lowerDigit]);
                    if (stringPrefix != null) {
                        k = stringPrefix.length() - 1;
                        while (k >= 0) {
                            appendable.append(stringPrefix.charAt(k));
                            --k;
                        }
                    }
                }
            } else {
                boolean bl2 = isFull = lowerDigit == 0 && upperDigit == radix - 1;
                if (isFull && wildcard != null) {
                    if (reverseSplitDigits) {
                        appendable.append(wildcard);
                    } else {
                        k = wildcard.length() - 1;
                        while (k >= 0) {
                            appendable.append(wildcard.charAt(k));
                            --k;
                        }
                    }
                } else if (reverseSplitDigits) {
                    if (stringPrefix != null) {
                        appendable.append(stringPrefix);
                    }
                    appendable.append(dig[lowerDigit]);
                    appendable.append(rangeSeparator);
                    appendable.append(dig[upperDigit]);
                } else {
                    appendable.append(dig[upperDigit]);
                    appendable.append(rangeSeparator);
                    appendable.append(dig[lowerDigit]);
                    if (stringPrefix != null) {
                        k = stringPrefix.length() - 1;
                        while (k >= 0) {
                            appendable.append(stringPrefix.charAt(k));
                            --k;
                        }
                    }
                }
            }
            if (upperInt == 0) break;
            appendable.append(splitDigitSeparator);
        }
    }

    private static int toUnsignedSplitRangeStringLength(long lower, long upper, String rangeSeparator, String wildcard, int leadingZerosCount, int radix, boolean uppercase, char splitDigitSeparator, boolean reverseSplitDigits, String stringPrefix) {
        int remaining;
        int digitsLength = -1;
        int stringPrefixLength = stringPrefix == null ? 0 : stringPrefix.length();
        do {
            boolean isFull;
            int upperDigit = (int)(upper % (long)radix);
            int lowerDigit = (int)(lower % (long)radix);
            boolean bl = isFull = lowerDigit == 0 && upperDigit == radix - 1;
            if (isFull) {
                digitsLength += wildcard.length() + 1;
                continue;
            }
            digitsLength += (stringPrefixLength << 1) + 4;
        } while ((upper /= (long)radix) != (lower /= (long)radix));
        int n = remaining = upper == 0L ? 0 : IPAddressDivision.toUnsignedStringLength(upper, radix);
        if ((remaining += leadingZerosCount) > 0) {
            digitsLength += remaining * (stringPrefixLength + 2);
        }
        return digitsLength;
    }

    private static int toUnsignedStringLength(long value, int radix) {
        int result;
        if (value > 65535L || (result = IPAddressDivision.toUnsignedStringLength((int)value, radix)) < 0) {
            result = IPAddressDivision.toUnsignedStringLengthSlow(value, radix);
        }
        return result;
    }

    private static int toUnsignedStringLengthSlow(long value, int radix) {
        int count = 1;
        boolean useInts = value <= Integer.MAX_VALUE;
        int value2 = useInts ? (int)value : radix;
        while (value2 >= radix) {
            if (useInts) {
                value2 /= radix;
            } else if ((value /= (long)radix) <= Integer.MAX_VALUE) {
                useInts = true;
                value2 = (int)value;
            }
            ++count;
        }
        return count;
    }

    protected static int toUnsignedStringLength(int value, int radix) {
        if (value <= 1) {
            return 1;
        }
        if (radix == 10) {
            if (value < 10) {
                return 1;
            }
            if (value < 100) {
                return 2;
            }
            if (value < 1000) {
                return 3;
            }
            if (value < 10000) {
                return 4;
            }
            return 5;
        }
        if (radix == 16) {
            if (value < 16) {
                return 1;
            }
            if (value < 256) {
                return 2;
            }
            if (value < 4096) {
                return 3;
            }
            return 4;
        }
        if (radix == 8) {
            if (value < 8) {
                return 1;
            }
            if (value < 64) {
                return 2;
            }
            if (value < 512) {
                return 3;
            }
            if (value < 4096) {
                return 4;
            }
            if (value < 32768) {
                return 5;
            }
            return 6;
        }
        if (radix == 2) {
            int digitCount = 15;
            int val = value;
            if (val >>> 8 == 0) {
                digitCount -= 8;
            } else {
                val >>>= 8;
            }
            if (val >>> 4 == 0) {
                digitCount -= 4;
            } else {
                val >>>= 4;
            }
            if (val >>> 2 == 0) {
                digitCount -= 2;
            } else {
                val >>>= 2;
            }
            if ((val & 2) != 0) {
                ++digitCount;
            }
            return digitCount;
        }
        return -1;
    }

    private static void toUnsignedString(long value, int radix, int choppedDigits, boolean uppercase, StringBuilder appendable) {
        int front = appendable.length();
        IPAddressDivision.appendDigits(value, radix, choppedDigits, uppercase, appendable);
        int back = appendable.length() - 1;
        while (front < back) {
            char frontChar = appendable.charAt(front);
            appendable.setCharAt(front++, appendable.charAt(back));
            appendable.setCharAt(back--, frontChar);
        }
    }

    private static void toSplitUnsignedString(long value, int radix, int choppedDigits, boolean uppercase, char splitDigitSeparator, boolean reverseSplitDigits, String stringPrefix, StringBuilder appendable) {
        int front = appendable.length();
        IPAddressDivision.appendDigits(value, radix, choppedDigits, uppercase, splitDigitSeparator, stringPrefix, appendable);
        if (!reverseSplitDigits) {
            int back = appendable.length() - 1;
            int stringPrefixLen = 0;
            if (stringPrefix != null) {
                stringPrefixLen = stringPrefix.length();
                front += stringPrefixLen;
            }
            while (front < back) {
                char frontChar = appendable.charAt(front);
                appendable.setCharAt(front, appendable.charAt(back));
                appendable.setCharAt(back, frontChar);
                front += 2;
                back -= 2;
                if (stringPrefix == null) continue;
                front += stringPrefixLen;
                back -= stringPrefixLen;
            }
        }
    }

    private static void toUnsignedSplitRangeString(long lower, long upper, String rangeSeparator, String wildcard, int radix, boolean uppercase, char splitDigitSeparator, boolean reverseSplitDigits, String stringPrefix, StringBuilder appendable) {
        int front = appendable.length();
        IPAddressDivision.appendDigits(lower, upper, rangeSeparator, wildcard, radix, uppercase, splitDigitSeparator, reverseSplitDigits, stringPrefix, appendable);
        if (!reverseSplitDigits) {
            int back = appendable.length() - 1;
            while (front < back) {
                char frontChar = appendable.charAt(front);
                appendable.setCharAt(front++, appendable.charAt(back));
                appendable.setCharAt(back--, frontChar);
            }
        }
    }

    private int getRangeDigitCount(int radix) {
        if (!this.isMultiple()) {
            return 0;
        }
        if (radix == this.getDefaultTextualRadix()) {
            return this.getRangeDigitCountImpl();
        }
        return IPAddressDivision.calculateRangeDigitCount(radix, this.getLowerValue(), this.getUpperValue(), this.getMaxValue());
    }

    protected int getRangeDigitCountImpl() {
        return IPAddressDivision.calculateRangeDigitCount(this.getDefaultTextualRadix(), this.getLowerValue(), this.getUpperValue(), this.getMaxValue());
    }

    private static int calculateRangeDigitCount(int radix, long value, long upperValue, long maxValue) {
        long max;
        long upperRemainder;
        long lowerRemainder;
        int factor = radix;
        int numDigits = 1;
        while ((lowerRemainder = value % (long)factor) == 0L && (upperRemainder = upperValue % (long)factor) == (max = maxValue / (long)factor == upperValue / (long)factor ? maxValue % (long)factor : (long)(factor - 1))) {
            if (upperValue - upperRemainder == value) {
                return numDigits;
            }
            ++numDigits;
            factor *= radix;
        }
        return 0;
    }

    protected static int getRangeString(long lower, long upper, String rangeSeparator, int lowerLeadingZerosCount, int upperLeadingZerosCount, String stringPrefix, int radix, boolean uppercase, StringBuilder appendable) {
        boolean hasStringPrefix;
        boolean bl = hasStringPrefix = stringPrefix != null;
        if (appendable == null) {
            int count = lowerLeadingZerosCount + upperLeadingZerosCount + IPAddressDivision.toUnsignedStringLength(lower, radix) + IPAddressDivision.toUnsignedStringLength(upper, radix) + rangeSeparator.length();
            if (hasStringPrefix) {
                count += stringPrefix.length() << 1;
            }
            return count;
        }
        if (hasStringPrefix) {
            appendable.append(stringPrefix);
        }
        if (lowerLeadingZerosCount > 0) {
            IPAddressDivision.getLeadingZeros(lowerLeadingZerosCount, appendable);
        }
        IPAddressDivision.toUnsignedString(lower, radix, uppercase, appendable);
        appendable.append(rangeSeparator);
        if (hasStringPrefix) {
            appendable.append(stringPrefix);
        }
        if (upperLeadingZerosCount > 0) {
            IPAddressDivision.getLeadingZeros(upperLeadingZerosCount, appendable);
        }
        IPAddressDivision.toUnsignedString(upper, radix, uppercase, appendable);
        return 0;
    }

    protected static int getSplitRangeString(long lower, long upper, IPAddressSection.WildcardOptions.Wildcards wildcards, int leadingZerosCount, String stringPrefix, int radix, boolean uppercase, char splitDigitSeparator, boolean reverseSplitDigits, StringBuilder appendable) {
        boolean hasLeadingZeros;
        String rangeSeparator = wildcards.rangeSeparator;
        if (appendable == null) {
            return IPAddressDivision.toUnsignedSplitRangeStringLength(lower, upper, rangeSeparator, wildcards.wildcard, leadingZerosCount, radix, uppercase, splitDigitSeparator, reverseSplitDigits, stringPrefix);
        }
        boolean bl = hasLeadingZeros = leadingZerosCount != 0;
        if (hasLeadingZeros && !reverseSplitDigits) {
            IPAddressDivision.getSplitLeadingZeros(leadingZerosCount, splitDigitSeparator, stringPrefix, appendable);
            appendable.append(splitDigitSeparator);
            hasLeadingZeros = false;
        }
        IPAddressDivision.toUnsignedSplitRangeString(lower, upper, rangeSeparator, wildcards.wildcard, radix, uppercase, splitDigitSeparator, reverseSplitDigits, stringPrefix, appendable);
        if (hasLeadingZeros) {
            appendable.append(splitDigitSeparator);
            IPAddressDivision.getSplitLeadingZeros(leadingZerosCount, splitDigitSeparator, stringPrefix, appendable);
        }
        return 0;
    }
}

