/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.httpclient.ning;

import com.github.scribejava.core.model.HttpClient;
import com.github.scribejava.core.model.OAuthAsyncRequestCallback;
import com.github.scribejava.core.model.OAuthRequestAsync;
import com.github.scribejava.core.model.Verb;
import com.github.scribejava.httpclient.ning.NingHttpClientConfig;
import com.github.scribejava.httpclient.ning.OAuthAsyncCompletionHandler;
import com.ning.http.client.AsyncHttpClient;
import java.util.Map;
import java.util.concurrent.Future;

public class NingHttpClient
implements HttpClient {
    private final AsyncHttpClient client;

    public NingHttpClient(NingHttpClientConfig ningConfig) {
        String ningAsyncHttpProviderClassName = ningConfig.getNingAsyncHttpProviderClassName();
        this.client = ningAsyncHttpProviderClassName == null ? new AsyncHttpClient(ningConfig.getConfig()) : new AsyncHttpClient(ningAsyncHttpProviderClassName, ningConfig.getConfig());
    }

    public NingHttpClient(AsyncHttpClient client) {
        this.client = client;
    }

    public void close() {
        this.client.close();
    }

    public <T> Future<T> executeAsync(String userAgent, Map<String, String> headers, Verb httpVerb, String completeUrl, String bodyContents, OAuthAsyncRequestCallback<T> callback, OAuthRequestAsync.ResponseConverter<T> converter) {
        AsyncHttpClient.BoundRequestBuilder boundRequestBuilder;
        switch (httpVerb) {
            case GET: {
                boundRequestBuilder = this.client.prepareGet(completeUrl);
                break;
            }
            case POST: {
                AsyncHttpClient.BoundRequestBuilder requestBuilder = this.client.preparePost(completeUrl);
                if (!headers.containsKey("Content-Type")) {
                    requestBuilder = requestBuilder.addHeader("Content-Type", "application/x-www-form-urlencoded");
                }
                boundRequestBuilder = requestBuilder.setBody(bodyContents);
                break;
            }
            default: {
                throw new IllegalArgumentException("message build error: unknown verb type");
            }
        }
        for (Map.Entry<String, String> header : headers.entrySet()) {
            boundRequestBuilder.addHeader(header.getKey(), header.getValue());
        }
        if (userAgent != null) {
            boundRequestBuilder.setHeader("User-Agent", userAgent);
        }
        return boundRequestBuilder.execute(new OAuthAsyncCompletionHandler<T>(callback, converter));
    }
}

