/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.httpclient.apache;

import com.github.scribejava.core.model.OAuthAsyncRequestCallback;
import com.github.scribejava.core.model.OAuthRequest;
import com.github.scribejava.core.model.Response;
import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.concurrent.FutureCallback;

public class OAuthAsyncCompletionHandler<T>
implements FutureCallback<HttpResponse> {
    private final OAuthAsyncRequestCallback<T> callback;
    private final OAuthRequest.ResponseConverter<T> converter;
    private final CountDownLatch latch;
    private T result;
    private Exception exception;

    public OAuthAsyncCompletionHandler(OAuthAsyncRequestCallback<T> callback, OAuthRequest.ResponseConverter<T> converter) {
        this.callback = callback;
        this.converter = converter;
        this.latch = new CountDownLatch(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void completed(HttpResponse httpResponse) {
        try {
            HashMap<String, String> headersMap = new HashMap<String, String>();
            for (Header header : httpResponse.getAllHeaders()) {
                headersMap.put(header.getName(), header.getValue());
            }
            StatusLine statusLine = httpResponse.getStatusLine();
            HttpEntity httpEntity = httpResponse.getEntity();
            Response response = new Response(statusLine.getStatusCode(), statusLine.getReasonPhrase(), headersMap, httpEntity == null ? null : httpEntity.getContent());
            Response t = this.converter == null ? response : this.converter.convert(response);
            this.result = t;
            if (this.callback != null) {
                this.callback.onCompleted(this.result);
            }
        }
        catch (IOException | RuntimeException e) {
            this.exception = e;
            if (this.callback != null) {
                this.callback.onThrowable((Throwable)e);
            }
        }
        finally {
            this.latch.countDown();
        }
    }

    public void failed(Exception e) {
        this.exception = e;
        try {
            if (this.callback != null) {
                this.callback.onThrowable((Throwable)e);
            }
        }
        finally {
            this.latch.countDown();
        }
    }

    public void cancelled() {
        this.exception = new CancellationException();
        try {
            if (this.callback != null) {
                this.callback.onThrowable((Throwable)this.exception);
            }
        }
        finally {
            this.latch.countDown();
        }
    }

    public T getResult() throws InterruptedException, ExecutionException {
        this.latch.await();
        if (this.exception != null) {
            throw new ExecutionException(this.exception);
        }
        return this.result;
    }

    public T getResult(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (!this.latch.await(timeout, unit)) {
            throw new TimeoutException();
        }
        if (this.exception != null) {
            throw new ExecutionException(this.exception);
        }
        return this.result;
    }
}

