/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.httpclient.ahc;

import com.github.scribejava.core.httpclient.AbstractAsyncOnlyHttpClient;
import com.github.scribejava.core.httpclient.multipart.MultipartPayload;
import com.github.scribejava.core.java8.Consumer;
import com.github.scribejava.core.model.OAuthAsyncRequestCallback;
import com.github.scribejava.core.model.OAuthRequest;
import com.github.scribejava.core.model.Verb;
import com.github.scribejava.httpclient.ahc.AhcHttpClientConfig;
import com.github.scribejava.httpclient.ahc.OAuthAsyncCompletionHandler;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.Future;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.DefaultAsyncHttpClient;

public class AhcHttpClient
extends AbstractAsyncOnlyHttpClient {
    private final AsyncHttpClient client;

    public AhcHttpClient() {
        this(AhcHttpClientConfig.defaultConfig());
    }

    public AhcHttpClient(AhcHttpClientConfig ahcConfig) {
        AsyncHttpClientConfig clientConfig = ahcConfig.getClientConfig();
        this.client = clientConfig == null ? new DefaultAsyncHttpClient() : new DefaultAsyncHttpClient(clientConfig);
    }

    public AhcHttpClient(AsyncHttpClient ahcClient) {
        this.client = ahcClient;
    }

    public void close() throws IOException {
        this.client.close();
    }

    public <T> Future<T> executeAsync(String userAgent, Map<String, String> headers, Verb httpVerb, String completeUrl, byte[] bodyContents, OAuthAsyncRequestCallback<T> callback, OAuthRequest.ResponseConverter<T> converter) {
        return this.doExecuteAsync(userAgent, headers, httpVerb, completeUrl, new ByteArrayConsumer(bodyContents), callback, converter);
    }

    public <T> Future<T> executeAsync(String userAgent, Map<String, String> headers, Verb httpVerb, String completeUrl, MultipartPayload bodyContents, OAuthAsyncRequestCallback<T> callback, OAuthRequest.ResponseConverter<T> converter) {
        throw new UnsupportedOperationException("AhcHttpClient does not support MultipartPayload yet.");
    }

    public <T> Future<T> executeAsync(String userAgent, Map<String, String> headers, Verb httpVerb, String completeUrl, String bodyContents, OAuthAsyncRequestCallback<T> callback, OAuthRequest.ResponseConverter<T> converter) {
        return this.doExecuteAsync(userAgent, headers, httpVerb, completeUrl, new StringConsumer(bodyContents), callback, converter);
    }

    public <T> Future<T> executeAsync(String userAgent, Map<String, String> headers, Verb httpVerb, String completeUrl, File bodyContents, OAuthAsyncRequestCallback<T> callback, OAuthRequest.ResponseConverter<T> converter) {
        return this.doExecuteAsync(userAgent, headers, httpVerb, completeUrl, new FileConsumer(bodyContents), callback, converter);
    }

    private <T> Future<T> doExecuteAsync(String userAgent, Map<String, String> headers, Verb httpVerb, String completeUrl, Consumer<BoundRequestBuilder> bodySetter, OAuthAsyncRequestCallback<T> callback, OAuthRequest.ResponseConverter<T> converter) {
        BoundRequestBuilder boundRequestBuilder;
        switch (httpVerb) {
            case GET: {
                boundRequestBuilder = this.client.prepareGet(completeUrl);
                break;
            }
            case POST: {
                boundRequestBuilder = this.client.preparePost(completeUrl);
                break;
            }
            case PUT: {
                boundRequestBuilder = this.client.preparePut(completeUrl);
                break;
            }
            case DELETE: {
                boundRequestBuilder = this.client.prepareDelete(completeUrl);
                break;
            }
            default: {
                throw new IllegalArgumentException("message build error: unknown verb type");
            }
        }
        if (httpVerb.isPermitBody()) {
            if (!headers.containsKey("Content-Type")) {
                boundRequestBuilder.addHeader((CharSequence)"Content-Type", "application/x-www-form-urlencoded");
            }
            bodySetter.accept((Object)boundRequestBuilder);
        }
        for (Map.Entry<String, String> header : headers.entrySet()) {
            boundRequestBuilder.addHeader((CharSequence)header.getKey(), header.getValue());
        }
        if (userAgent != null) {
            boundRequestBuilder.setHeader((CharSequence)"User-Agent", userAgent);
        }
        return boundRequestBuilder.execute(new OAuthAsyncCompletionHandler<T>(callback, converter));
    }

    private static class FileConsumer
    implements Consumer<BoundRequestBuilder> {
        private final File bodyContents;

        private FileConsumer(File bodyContents) {
            this.bodyContents = bodyContents;
        }

        public void accept(BoundRequestBuilder requestBuilder) {
            requestBuilder.setBody(this.bodyContents);
        }
    }

    private static class StringConsumer
    implements Consumer<BoundRequestBuilder> {
        private final String bodyContents;

        private StringConsumer(String bodyContents) {
            this.bodyContents = bodyContents;
        }

        public void accept(BoundRequestBuilder requestBuilder) {
            requestBuilder.setBody(this.bodyContents);
        }
    }

    private static class ByteArrayConsumer
    implements Consumer<BoundRequestBuilder> {
        private final byte[] bodyContents;

        private ByteArrayConsumer(byte[] bodyContents) {
            this.bodyContents = bodyContents;
        }

        public void accept(BoundRequestBuilder requestBuilder) {
            requestBuilder.setBody(this.bodyContents);
        }
    }
}

