/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.apis;

import com.github.scribejava.core.builder.api.DefaultApi10a;
import com.github.scribejava.core.model.OAuth1RequestToken;

public class FlickrApi
extends DefaultApi10a {
    private static final String AUTHORIZE_URL = "https://www.flickr.com/services/oauth/authorize?oauth_token=%s";
    private final String permString;

    protected FlickrApi() {
        this.permString = null;
    }

    protected FlickrApi(FlickrPerm perm) {
        this.permString = perm.name().toLowerCase();
    }

    public static FlickrApi instance() {
        return InstanceHolder.INSTANCE;
    }

    public static FlickrApi instance(FlickrPerm perm) {
        return perm == null ? FlickrApi.instance() : new FlickrApi(perm);
    }

    public String getAccessTokenEndpoint() {
        return "https://www.flickr.com/services/oauth/access_token";
    }

    public String getAuthorizationUrl(OAuth1RequestToken requestToken) {
        String authUrl = String.format(AUTHORIZE_URL, requestToken.getToken());
        if (this.permString != null) {
            authUrl = authUrl + "&perms=" + this.permString;
        }
        return authUrl;
    }

    public String getRequestTokenEndpoint() {
        return "https://www.flickr.com/services/oauth/request_token";
    }

    private static class InstanceHolder {
        private static final FlickrApi INSTANCE = new FlickrApi();

        private InstanceHolder() {
        }
    }

    public static enum FlickrPerm {
        READ,
        WRITE,
        DELETE;

    }
}

