/*
 * Decompiled with CFR 0.152.
 */
package com.orm;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.util.Log;
import com.orm.SchemaGenerator;
import com.orm.util.ManifestHelper;
import com.orm.util.SugarCursorFactory;

public class SugarDb
extends SQLiteOpenHelper {
    private final SchemaGenerator schemaGenerator;
    private SQLiteDatabase sqLiteDatabase;
    private int openedConnections = 0;

    public SugarDb(Context context) {
        super(context, ManifestHelper.getDatabaseName(context), (SQLiteDatabase.CursorFactory)new SugarCursorFactory(ManifestHelper.getDebugEnabled(context)), ManifestHelper.getDatabaseVersion(context));
        this.schemaGenerator = new SchemaGenerator(context);
    }

    public void onCreate(SQLiteDatabase sqLiteDatabase) {
        this.schemaGenerator.createDatabase(sqLiteDatabase);
    }

    public void onUpgrade(SQLiteDatabase sqLiteDatabase, int oldVersion, int newVersion) {
        this.schemaGenerator.doUpgrade(sqLiteDatabase, oldVersion, newVersion);
    }

    public synchronized SQLiteDatabase getDB() {
        if (this.sqLiteDatabase == null) {
            this.sqLiteDatabase = this.getWritableDatabase();
        }
        return this.sqLiteDatabase;
    }

    public synchronized SQLiteDatabase getReadableDatabase() {
        Log.d((String)"SUGAR", (String)"getReadableDatabase");
        ++this.openedConnections;
        return super.getReadableDatabase();
    }

    public synchronized void close() {
        Log.d((String)"SUGAR", (String)"getReadableDatabase");
        --this.openedConnections;
        if (this.openedConnections == 0) {
            Log.d((String)"SUGAR", (String)"closing");
            super.close();
        }
    }
}

