/*
 * Decompiled with CFR 0.152.
 */
package com.orm.query;

import com.orm.SugarRecord;

public class Condition {
    private String property;
    private Object value;
    private Check check;

    public Condition(String property) {
        this.property = property;
    }

    public static Condition prop(String property) {
        return new Condition(property);
    }

    public Condition eq(Object value) {
        if (value == null) {
            return this.isNull();
        }
        this.setValue(value);
        this.check = Check.EQUALS;
        return this;
    }

    public Condition like(Object value) {
        this.setValue(value);
        this.check = Check.LIKE;
        return this;
    }

    public Condition notLike(Object value) {
        this.setValue(value);
        this.check = Check.NOT_LIKE;
        return this;
    }

    public Condition notEq(Object value) {
        if (value == null) {
            return this.isNotNull();
        }
        this.setValue(value);
        this.check = Check.NOT_EQUALS;
        return this;
    }

    public Condition gt(Object value) {
        this.setValue(value);
        this.check = Check.GREATER_THAN;
        return this;
    }

    public Condition lt(Object value) {
        this.setValue(value);
        this.check = Check.LESSER_THAN;
        return this;
    }

    public Condition isNull() {
        this.setValue(null);
        this.check = Check.IS_NULL;
        return this;
    }

    public Condition isNotNull() {
        this.setValue(null);
        this.check = Check.IS_NOT_NULL;
        return this;
    }

    public String getProperty() {
        return this.property;
    }

    public Object getValue() {
        return this.value;
    }

    public Check getCheck() {
        return this.check;
    }

    public String getCheckSymbol() {
        return this.check.getSymbol();
    }

    private void setValue(Object value) {
        this.value = value instanceof SugarRecord ? ((SugarRecord)value).getId() : value;
    }

    static enum Type {
        AND,
        OR,
        NOT;

    }

    static enum Check {
        EQUALS(" = "),
        GREATER_THAN(" > "),
        LESSER_THAN(" < "),
        NOT_EQUALS(" != "),
        LIKE(" LIKE "),
        NOT_LIKE(" NOT LIKE "),
        IS_NULL(" IS NULL "),
        IS_NOT_NULL(" IS NOT NULL ");

        private String symbol;

        private Check(String symbol) {
            this.symbol = symbol;
        }

        public String getSymbol() {
            return this.symbol;
        }
    }
}

