/*
 * Decompiled with CFR 0.152.
 */
package com.orm;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteStatement;
import android.text.TextUtils;
import android.util.Log;
import com.orm.Database;
import com.orm.StringUtil;
import com.orm.SugarApp;
import com.orm.SugarConfig;
import com.orm.dsl.Ignore;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class SugarRecord<T> {
    @Ignore
    String tableName = this.getSqlName();
    protected Long id = null;

    public void delete() {
        SQLiteDatabase db = SugarApp.getSugarContext().getDatabase().getDB();
        db.delete(this.tableName, "Id=?", new String[]{this.getId().toString()});
    }

    public static <T extends SugarRecord<?>> void deleteAll(Class<T> type) {
        Database db = SugarApp.getSugarContext().getDatabase();
        SQLiteDatabase sqLiteDatabase = db.getDB();
        sqLiteDatabase.delete(SugarRecord.getTableName(type), null, null);
    }

    public static <T extends SugarRecord<?>> void deleteAll(Class<T> type, String whereClause, String ... whereArgs) {
        Database db = SugarApp.getSugarContext().getDatabase();
        SQLiteDatabase sqLiteDatabase = db.getDB();
        sqLiteDatabase.delete(SugarRecord.getTableName(type), whereClause, whereArgs);
    }

    public void save() {
        this.save(SugarApp.getSugarContext().getDatabase().getDB());
    }

    public static <T extends SugarRecord<?>> void saveInTx(T ... objects) {
        SugarRecord.saveInTx(Arrays.asList(objects));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends SugarRecord<?>> void saveInTx(Collection<T> objects) {
        SQLiteDatabase sqLiteDatabase = SugarApp.getSugarContext().getDatabase().getDB();
        try {
            sqLiteDatabase.beginTransaction();
            sqLiteDatabase.setLockingEnabled(false);
            for (SugarRecord object : objects) {
                object.save(sqLiteDatabase);
            }
            sqLiteDatabase.setTransactionSuccessful();
        }
        catch (Exception e) {
            Log.i((String)"Sugar", (String)("Error in saving in transaction " + e.getMessage()));
        }
        finally {
            sqLiteDatabase.endTransaction();
            sqLiteDatabase.setLockingEnabled(true);
        }
    }

    void save(SQLiteDatabase db) {
        List<Field> columns = this.getTableFields();
        ContentValues values = new ContentValues(columns.size());
        for (Field column : columns) {
            column.setAccessible(true);
            Class<?> columnType = column.getType();
            try {
                String columnName = StringUtil.toSQLName(column.getName());
                Object columnValue = column.get(this);
                if (SugarRecord.class.isAssignableFrom(columnType)) {
                    values.put(columnName, columnValue != null ? String.valueOf(((SugarRecord)columnValue).id) : "0");
                    continue;
                }
                if ("id".equalsIgnoreCase(column.getName())) continue;
                if (columnType.equals(Short.class) || columnType.equals(Short.TYPE)) {
                    values.put(columnName, (Short)columnValue);
                    continue;
                }
                if (columnType.equals(Integer.class) || columnType.equals(Integer.TYPE)) {
                    values.put(columnName, (Integer)columnValue);
                    continue;
                }
                if (columnType.equals(Long.class) || columnType.equals(Long.TYPE)) {
                    values.put(columnName, (Long)columnValue);
                    continue;
                }
                if (columnType.equals(Float.class) || columnType.equals(Float.TYPE)) {
                    values.put(columnName, (Float)columnValue);
                    continue;
                }
                if (columnType.equals(Double.class) || columnType.equals(Double.TYPE)) {
                    values.put(columnName, (Double)columnValue);
                    continue;
                }
                if (columnType.equals(Boolean.class) || columnType.equals(Boolean.TYPE)) {
                    values.put(columnName, (Boolean)columnValue);
                    continue;
                }
                if (Date.class.equals(columnType)) {
                    values.put(columnName, Long.valueOf(((Date)column.get(this)).getTime()));
                    continue;
                }
                if (Calendar.class.equals(columnType)) {
                    values.put(columnName, Long.valueOf(((Calendar)column.get(this)).getTimeInMillis()));
                    continue;
                }
                values.put(columnName, String.valueOf(columnValue));
            }
            catch (IllegalAccessException e) {
                Log.e((String)"Sugar", (String)e.getMessage());
            }
        }
        if (this.id == null) {
            this.id = db.insert(this.getSqlName(), null, values);
        } else {
            db.update(this.getSqlName(), values, "ID = ?", new String[]{String.valueOf(this.id)});
        }
        Log.i((String)"Sugar", (String)(this.getClass().getSimpleName() + " saved : " + this.id));
    }

    public static <T extends SugarRecord<?>> List<T> listAll(Class<T> type) {
        return SugarRecord.find(type, null, null, null, null, null);
    }

    public static <T extends SugarRecord<?>> T findById(Class<T> type, Long id) {
        List<T> list = SugarRecord.find(type, "id=?", new String[]{String.valueOf(id)}, null, null, "1");
        if (list.isEmpty()) {
            return null;
        }
        return (T)((SugarRecord)list.get(0));
    }

    public static <T extends SugarRecord<?>> Iterator<T> findAll(Class<T> type) {
        return SugarRecord.findAsIterator(type, null, null, null, null, null);
    }

    public static <T extends SugarRecord<?>> Iterator<T> findAsIterator(Class<T> type, String whereClause, String ... whereArgs) {
        return SugarRecord.findAsIterator(type, whereClause, whereArgs, null, null, null);
    }

    public static <T extends SugarRecord<?>> Iterator<T> findWithQueryAsIterator(Class<T> type, String query, String ... arguments) {
        Database db = SugarApp.getSugarContext().getDatabase();
        SQLiteDatabase sqLiteDatabase = db.getDB();
        Cursor c = sqLiteDatabase.rawQuery(query, arguments);
        return new CursorIterator<T>(type, c);
    }

    public static <T extends SugarRecord<?>> Iterator<T> findAsIterator(Class<T> type, String whereClause, String[] whereArgs, String groupBy, String orderBy, String limit) {
        Database db = SugarApp.getSugarContext().getDatabase();
        SQLiteDatabase sqLiteDatabase = db.getDB();
        Cursor c = sqLiteDatabase.query(SugarRecord.getTableName(type), null, whereClause, whereArgs, groupBy, null, orderBy, limit);
        return new CursorIterator<T>(type, c);
    }

    public static <T extends SugarRecord<?>> List<T> find(Class<T> type, String whereClause, String ... whereArgs) {
        return SugarRecord.find(type, whereClause, whereArgs, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends SugarRecord<?>> List<T> findWithQuery(Class<T> type, String query, String ... arguments) {
        Database db = SugarApp.getSugarContext().getDatabase();
        SQLiteDatabase sqLiteDatabase = db.getDB();
        ArrayList<SugarRecord> toRet = new ArrayList<SugarRecord>();
        Cursor c = sqLiteDatabase.rawQuery(query, arguments);
        try {
            while (c.moveToNext()) {
                SugarRecord entity = (SugarRecord)type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                entity.inflate(c);
                toRet.add(entity);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            c.close();
        }
        return toRet;
    }

    public static void executeQuery(String query, String ... arguments) {
        SugarApp.getSugarContext().getDatabase().getDB().execSQL(query, (Object[])arguments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends SugarRecord<?>> List<T> find(Class<T> type, String whereClause, String[] whereArgs, String groupBy, String orderBy, String limit) {
        Database db = SugarApp.getSugarContext().getDatabase();
        SQLiteDatabase sqLiteDatabase = db.getDB();
        ArrayList<SugarRecord> toRet = new ArrayList<SugarRecord>();
        Cursor c = sqLiteDatabase.query(SugarRecord.getTableName(type), null, whereClause, whereArgs, groupBy, null, orderBy, limit);
        try {
            while (c.moveToNext()) {
                SugarRecord entity = (SugarRecord)type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                entity.inflate(c);
                toRet.add(entity);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            c.close();
        }
        return toRet;
    }

    public static <T extends SugarRecord<?>> long count(Class<?> type, String whereClause, String[] whereArgs) {
        return SugarRecord.count(type, whereClause, whereArgs, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends SugarRecord<?>> long count(Class<?> type, String whereClause, String[] whereArgs, String groupBy, String orderBy, String limit) {
        Database db = SugarApp.getSugarContext().getDatabase();
        SQLiteDatabase sqLiteDatabase = db.getDB();
        long toRet = -1L;
        String filter = !TextUtils.isEmpty((CharSequence)whereClause) ? " where " + whereClause : "";
        SQLiteStatement sqLiteStatament = sqLiteDatabase.compileStatement("SELECT count(*) FROM " + SugarRecord.getTableName(type) + filter);
        if (whereArgs != null) {
            for (int i = whereArgs.length; i != 0; --i) {
                sqLiteStatament.bindString(i, whereArgs[i - 1]);
            }
        }
        try {
            toRet = sqLiteStatament.simpleQueryForLong();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            sqLiteStatament.close();
        }
        return toRet;
    }

    void inflate(Cursor cursor) {
        HashMap<Field, Long> entities = new HashMap<Field, Long>();
        List<Field> columns = this.getTableFields();
        for (Field field : columns) {
            field.setAccessible(true);
            try {
                Class<?> fieldType = field.getType();
                String colName = StringUtil.toSQLName(field.getName());
                int columnIndex = cursor.getColumnIndex(colName);
                if (cursor.isNull(columnIndex)) continue;
                if (colName.equalsIgnoreCase("id")) {
                    long cid = cursor.getLong(columnIndex);
                    field.set(this, cid);
                    continue;
                }
                if (fieldType.equals(Long.TYPE) || fieldType.equals(Long.class)) {
                    field.set(this, cursor.getLong(columnIndex));
                    continue;
                }
                if (fieldType.equals(String.class)) {
                    String val = cursor.getString(columnIndex);
                    field.set(this, val != null && val.equals("null") ? null : val);
                    continue;
                }
                if (fieldType.equals(Double.TYPE) || fieldType.equals(Double.class)) {
                    field.set(this, cursor.getDouble(columnIndex));
                    continue;
                }
                if (fieldType.equals(Boolean.TYPE) || fieldType.equals(Boolean.class)) {
                    field.set(this, cursor.getString(columnIndex).equals("1"));
                    continue;
                }
                if (field.getType().getName().equals("[B")) {
                    field.set(this, cursor.getBlob(columnIndex));
                    continue;
                }
                if (fieldType.equals(Integer.TYPE) || fieldType.equals(Integer.class)) {
                    field.set(this, cursor.getInt(columnIndex));
                    continue;
                }
                if (fieldType.equals(Float.TYPE) || fieldType.equals(Float.class)) {
                    field.set(this, Float.valueOf(cursor.getFloat(columnIndex)));
                    continue;
                }
                if (fieldType.equals(Short.TYPE) || fieldType.equals(Short.class)) {
                    field.set(this, cursor.getShort(columnIndex));
                    continue;
                }
                if (fieldType.equals(Timestamp.class)) {
                    long l = cursor.getLong(columnIndex);
                    field.set(this, new Timestamp(l));
                    continue;
                }
                if (fieldType.equals(Date.class)) {
                    long l = cursor.getLong(columnIndex);
                    field.set(this, new Date(l));
                    continue;
                }
                if (fieldType.equals(Calendar.class)) {
                    long l = cursor.getLong(columnIndex);
                    Calendar c = Calendar.getInstance();
                    c.setTimeInMillis(l);
                    field.set(this, c);
                    continue;
                }
                if (Enum.class.isAssignableFrom(fieldType)) {
                    try {
                        Method valueOf = field.getType().getMethod("valueOf", String.class);
                        String strVal = cursor.getString(columnIndex);
                        Object enumVal = valueOf.invoke(field.getType(), strVal);
                        field.set(this, enumVal);
                    }
                    catch (Exception e) {
                        Log.e((String)"Sugar", (String)("Enum cannot be read from Sqlite3 database. Please check the type of field " + field.getName()));
                    }
                    continue;
                }
                if (SugarRecord.class.isAssignableFrom(fieldType)) {
                    long id = cursor.getLong(columnIndex);
                    if (id > 0L) {
                        entities.put(field, id);
                        continue;
                    }
                    field.set(this, null);
                    continue;
                }
                Log.e((String)"Sugar", (String)("Class cannot be read from Sqlite3 database. Please check the type of field " + field.getName() + "(" + field.getType().getName() + ")"));
            }
            catch (IllegalArgumentException e) {
                Log.e((String)"field set error", (String)e.getMessage());
            }
            catch (IllegalAccessException e) {
                Log.e((String)"field set error", (String)e.getMessage());
            }
        }
        for (Field f : entities.keySet()) {
            try {
                f.set(this, SugarRecord.findById(f.getType(), (Long)entities.get(f)));
            }
            catch (SQLiteException e) {
            }
            catch (IllegalArgumentException e) {
            }
            catch (IllegalAccessException e) {}
        }
    }

    public List<Field> getTableFields() {
        List<Field> fieldList = SugarConfig.getFields(this.getClass());
        if (fieldList != null) {
            return fieldList;
        }
        Log.d((String)"Sugar", (String)"Fetching properties");
        ArrayList<Field> typeFields = new ArrayList<Field>();
        SugarRecord.getAllFields(typeFields, this.getClass());
        ArrayList<Field> toStore = new ArrayList<Field>();
        for (Field field : typeFields) {
            if (field.isAnnotationPresent(Ignore.class) || Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers())) continue;
            toStore.add(field);
        }
        SugarConfig.setFields(this.getClass(), toStore);
        return toStore;
    }

    private static List<Field> getAllFields(List<Field> fields, Class<?> type) {
        Collections.addAll(fields, type.getDeclaredFields());
        if (type.getSuperclass() != null) {
            fields = SugarRecord.getAllFields(fields, type.getSuperclass());
        }
        return fields;
    }

    public String getSqlName() {
        return SugarRecord.getTableName(this.getClass());
    }

    public static String getTableName(Class<?> type) {
        return StringUtil.toSQLName(type.getSimpleName());
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    static class CursorIterator<E extends SugarRecord<?>>
    implements Iterator<E> {
        Class<E> type;
        Cursor cursor;

        public CursorIterator(Class<E> type, Cursor cursor) {
            this.type = type;
            this.cursor = cursor;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != null && !this.cursor.isClosed() && !this.cursor.isAfterLast();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E next() {
            SugarRecord entity = null;
            if (this.cursor == null || this.cursor.isAfterLast()) {
                throw new NoSuchElementException();
            }
            if (this.cursor.isBeforeFirst()) {
                this.cursor.moveToFirst();
            }
            try {
                entity = (SugarRecord)this.type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                entity.inflate(this.cursor);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.cursor.moveToNext();
                if (this.cursor.isAfterLast()) {
                    this.cursor.close();
                }
            }
            return (E)entity;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

