/*
 * Decompiled with CFR 0.152.
 */
package com.orm;

import android.content.Context;
import android.content.pm.PackageManager;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import android.util.Log;
import com.orm.NumberComparator;
import com.orm.QueryBuilder;
import com.orm.StringUtil;
import com.orm.SugarConfig;
import com.orm.SugarCursorFactory;
import com.orm.SugarRecord;
import dalvik.system.DexFile;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;

public class SugarDb
extends SQLiteOpenHelper {
    private Context context;

    public SugarDb(Context context) {
        super(context, SugarConfig.getDatabaseName(context), (SQLiteDatabase.CursorFactory)new SugarCursorFactory(SugarConfig.getDebugEnabled(context)), SugarConfig.getDatabaseVersion(context));
        this.context = context;
    }

    private <T extends SugarRecord<?>> List<T> getDomainClasses(Context context) {
        ArrayList<T> domainClasses = new ArrayList<T>();
        try {
            Enumeration<?> allClasses = this.getAllClasses(context);
            while (allClasses.hasMoreElements()) {
                T domainClass;
                String className = (String)allClasses.nextElement();
                if (!className.startsWith(SugarConfig.getDomainPackageName(context)) || (domainClass = this.getDomainClass(className, context)) == null) continue;
                domainClasses.add(domainClass);
            }
        }
        catch (IOException e) {
            Log.e((String)"Sugar", (String)e.getMessage());
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e((String)"Sugar", (String)e.getMessage());
        }
        return domainClasses;
    }

    private <T extends SugarRecord<?>> T getDomainClass(String className, Context context) {
        Log.i((String)"Sugar", (String)"domain class");
        Class<?> discoveredClass = null;
        try {
            discoveredClass = Class.forName(className, true, context.getClass().getClassLoader());
        }
        catch (ClassNotFoundException e) {
            Log.e((String)"Sugar", (String)e.getMessage());
        }
        if (discoveredClass == null || !SugarRecord.class.isAssignableFrom(discoveredClass) || Modifier.isAbstract(discoveredClass.getModifiers())) {
            return null;
        }
        try {
            return (T)((SugarRecord)discoveredClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (InstantiationException e) {
            Log.e((String)"Sugar", (String)e.getMessage());
        }
        catch (IllegalAccessException e) {
            Log.e((String)"Sugar", (String)e.getMessage());
        }
        catch (NoSuchMethodException e) {
            Log.e((String)"Sugar", (String)e.getMessage());
        }
        catch (InvocationTargetException e) {
            Log.e((String)"Sugar", (String)e.getMessage());
        }
        return null;
    }

    private Enumeration<?> getAllClasses(Context context) throws PackageManager.NameNotFoundException, IOException {
        String path = this.getSourcePath(context);
        DexFile dexfile = new DexFile(path);
        return dexfile.entries();
    }

    private String getSourcePath(Context context) throws PackageManager.NameNotFoundException {
        return context.getPackageManager().getApplicationInfo((String)context.getPackageName(), (int)0).sourceDir;
    }

    public void onCreate(SQLiteDatabase sqLiteDatabase) {
        Log.i((String)"Sugar", (String)"on create");
        this.createDatabase(sqLiteDatabase);
    }

    private <T extends SugarRecord<?>> void createDatabase(SQLiteDatabase sqLiteDatabase) {
        List<T> domainClasses = this.getDomainClasses(this.context);
        for (SugarRecord domain : domainClasses) {
            this.createTable(domain, sqLiteDatabase);
        }
    }

    private <T extends SugarRecord<?>> void createTable(T table, SQLiteDatabase sqLiteDatabase) {
        Log.i((String)"Sugar", (String)"create table");
        List<Field> fields = table.getTableFields();
        StringBuilder sb = new StringBuilder("CREATE TABLE ").append(table.getSqlName()).append(" ( ID INTEGER PRIMARY KEY AUTOINCREMENT ");
        for (Field column : fields) {
            String columnName = StringUtil.toSQLName(column.getName());
            String columnType = QueryBuilder.getColumnType(column.getType());
            if (columnType == null || columnName.equalsIgnoreCase("Id")) continue;
            sb.append(", ").append(columnName).append(" ").append(columnType);
        }
        sb.append(" ) ");
        Log.i((String)"Sugar", (String)("creating table " + table.getSqlName()));
        if (!"".equals(sb.toString())) {
            sqLiteDatabase.execSQL(sb.toString());
        }
    }

    public void onUpgrade(SQLiteDatabase sqLiteDatabase, int oldVersion, int newVersion) {
        Log.i((String)"Sugar", (String)"upgrading sugar");
        this.doUpgrade(sqLiteDatabase);
        if (!this.executeSugarUpgrade(sqLiteDatabase, oldVersion, newVersion)) {
            this.deleteTables(sqLiteDatabase);
            this.onCreate(sqLiteDatabase);
        }
    }

    private <T extends SugarRecord<?>> void doUpgrade(SQLiteDatabase sqLiteDatabase) {
        List<T> domainClasses = this.getDomainClasses(this.context);
        for (SugarRecord domain : domainClasses) {
            try {
                sqLiteDatabase.query(domain.tableName, null, null, null, null, null, null);
            }
            catch (SQLiteException e) {
                Log.i((String)"Sugar", (String)String.format("creating table on update (error was '%s')", e.getMessage()));
                this.createTable(domain, sqLiteDatabase);
            }
        }
    }

    private <T extends SugarRecord<?>> void deleteTables(SQLiteDatabase sqLiteDatabase) {
        List<T> tables = this.getDomainClasses(this.context);
        for (SugarRecord table : tables) {
            sqLiteDatabase.execSQL("DROP TABLE IF EXISTS " + table.getSqlName());
        }
    }

    private boolean executeSugarUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        boolean isSuccess = false;
        try {
            List<String> files = Arrays.asList(this.context.getAssets().list("sugar_upgrades"));
            Collections.sort(files, new NumberComparator());
            for (String file : files) {
                Log.i((String)"Sugar", (String)("filename : " + file));
                try {
                    int version = Integer.valueOf(file.replace(".sql", ""));
                    if (version <= oldVersion || version > newVersion) continue;
                    this.executeScript(db, file);
                    isSuccess = true;
                }
                catch (NumberFormatException e) {
                    Log.i((String)"Sugar", (String)("not a sugar script. ignored." + file));
                }
            }
        }
        catch (IOException e) {
            Log.e((String)"Sugar", (String)e.getMessage());
        }
        return isSuccess;
    }

    private void executeScript(SQLiteDatabase db, String file) {
        try {
            String line;
            InputStream is = this.context.getAssets().open("sugar_upgrades/" + file);
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            while ((line = reader.readLine()) != null) {
                Log.i((String)"Sugar script", (String)line);
                db.execSQL(line.toString());
            }
        }
        catch (IOException e) {
            Log.e((String)"Sugar", (String)e.getMessage());
        }
        Log.i((String)"Sugar", (String)"script executed");
    }
}

