/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.util;

import htsjdk.samtools.AlignmentBlock;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.util.AbstractLocusInfo;
import htsjdk.samtools.util.AbstractLocusIterator;
import htsjdk.samtools.util.EdgingRecordAndOffset;
import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.IntervalCoordinateComparator;
import htsjdk.samtools.util.IntervalList;
import htsjdk.samtools.util.OverlapDetector;
import htsjdk.samtools.util.PeekableIterator;

public class EdgeReadIterator
extends AbstractLocusIterator<EdgingRecordAndOffset, AbstractLocusInfo<EdgingRecordAndOffset>> {
    private Interval currentInterval = null;
    private final PeekableIterator<Interval> intervalListIterator;
    private final IntervalCoordinateComparator intervalCoordinateComparator;
    private final OverlapDetector<Interval> overlapDetector;

    public EdgeReadIterator(SamReader samReader) {
        this(samReader, null);
    }

    public EdgeReadIterator(SamReader samReader, IntervalList intervalList) {
        this(samReader, intervalList, samReader.hasIndex());
    }

    public EdgeReadIterator(SamReader samReader, IntervalList intervalList, boolean useIndex) {
        super(samReader, intervalList, useIndex);
        if (this.getIntervals() == null) {
            this.intervalListIterator = null;
            this.intervalCoordinateComparator = null;
            this.overlapDetector = null;
        } else {
            this.intervalListIterator = new PeekableIterator<Interval>(this.getIntervals().iterator());
            if (this.intervalListIterator.hasNext()) {
                this.currentInterval = this.intervalListIterator.next();
            }
            this.intervalCoordinateComparator = new IntervalCoordinateComparator(this.getHeader());
            this.overlapDetector = OverlapDetector.create(this.getIntervals());
        }
    }

    protected boolean advanceCurrentIntervalAndCheckIfIntervalContainsRead(SAMRecord rec) {
        if (this.currentInterval == null) {
            return false;
        }
        while (this.intervalListIterator.peek() != null && this.intervalCoordinateComparator.compare(new Interval(rec), this.intervalListIterator.peek()) > 0) {
            this.currentInterval = this.intervalListIterator.next();
        }
        return this.currentInterval.contains(rec);
    }

    @Override
    void accumulateSamRecord(SAMRecord rec) {
        boolean needToConsiderIntervals = this.intervals != null && !this.advanceCurrentIntervalAndCheckIfIntervalContainsRead(rec);
        for (AlignmentBlock alignmentBlock : rec.getAlignmentBlocks()) {
            int accumulatorNextPosition;
            int offsetStartOfAlignmentBlockInRead = alignmentBlock.getReadStart() - 1;
            int referencePositionStartOfAlignmentBlock = alignmentBlock.getReferenceStart();
            if (this.accumulator.isEmpty()) {
                this.accumulator.add(this.createLocusInfo(this.getReferenceSequence(rec.getReferenceIndex()), rec.getAlignmentStart()));
            }
            if ((accumulatorNextPosition = ((AbstractLocusInfo)this.accumulator.get(0)).getPosition() + this.accumulator.size()) != ((AbstractLocusInfo)this.accumulator.get(this.accumulator.size() - 1)).getPosition() + 1) {
                throw new IllegalStateException("The accumulator has gotten into a funk. Cannot continue");
            }
            for (int locusPos = accumulatorNextPosition; locusPos <= referencePositionStartOfAlignmentBlock + alignmentBlock.getLength(); ++locusPos) {
                this.accumulator.add(this.createLocusInfo(this.getReferenceSequence(rec.getReferenceIndex()), locusPos));
            }
            int offsetStartOfAlignmentBlockOnReference = referencePositionStartOfAlignmentBlock - rec.getAlignmentStart();
            int offsetEndOfAlignmentBlockOnReference = offsetStartOfAlignmentBlockOnReference + alignmentBlock.getLength();
            if (needToConsiderIntervals) {
                for (Interval interval : this.overlapDetector.getOverlaps(new Interval(rec.getContig(), referencePositionStartOfAlignmentBlock, referencePositionStartOfAlignmentBlock + alignmentBlock.getLength()))) {
                    int offsetStartOfIntervalInAlignmentBlock = referencePositionStartOfAlignmentBlock < interval.getStart() ? interval.getStart() - referencePositionStartOfAlignmentBlock : 0;
                    int offsetStartOfActualSequenceOnReference = offsetStartOfAlignmentBlockOnReference + offsetStartOfIntervalInAlignmentBlock;
                    int referencePositionEndOfAlignmentBlock = referencePositionStartOfAlignmentBlock + alignmentBlock.getLength();
                    int offsetEndOfActualSequenceOnReference = offsetEndOfAlignmentBlockOnReference - (referencePositionEndOfAlignmentBlock > interval.getEnd() ? referencePositionEndOfAlignmentBlock - interval.getEnd() - 1 : 0);
                    int length = offsetEndOfActualSequenceOnReference - offsetStartOfActualSequenceOnReference;
                    EdgingRecordAndOffset recordAndOffset = this.createRecordAndOffset(rec, offsetStartOfAlignmentBlockInRead + offsetStartOfIntervalInAlignmentBlock, length, referencePositionStartOfAlignmentBlock + offsetStartOfIntervalInAlignmentBlock);
                    ((AbstractLocusInfo)this.accumulator.get(offsetStartOfActualSequenceOnReference)).add(recordAndOffset);
                    EdgingRecordAndOffset recordAndOffsetEnd = this.createRecordAndOffset(recordAndOffset);
                    ((AbstractLocusInfo)this.accumulator.get(offsetEndOfActualSequenceOnReference)).add(recordAndOffsetEnd);
                }
                continue;
            }
            int length = offsetEndOfAlignmentBlockOnReference - offsetStartOfAlignmentBlockOnReference;
            EdgingRecordAndOffset recordAndOffset = this.createRecordAndOffset(rec, offsetStartOfAlignmentBlockInRead, length, referencePositionStartOfAlignmentBlock);
            ((AbstractLocusInfo)this.accumulator.get(offsetStartOfAlignmentBlockOnReference)).add(recordAndOffset);
            EdgingRecordAndOffset recordAndOffsetEnd = this.createRecordAndOffset(recordAndOffset);
            ((AbstractLocusInfo)this.accumulator.get(offsetEndOfAlignmentBlockOnReference)).add(recordAndOffsetEnd);
        }
    }

    @Override
    void accumulateIndels(SAMRecord rec) {
        throw new UnsupportedOperationException("Indels accumulation is not supported for " + this.getClass().getSimpleName() + ".");
    }

    @Override
    EdgingRecordAndOffset createRecordAndOffset(SAMRecord rec, int readOffset, int length, int refPos) {
        return EdgingRecordAndOffset.createBeginRecord(rec, readOffset, length, refPos);
    }

    EdgingRecordAndOffset createRecordAndOffset(EdgingRecordAndOffset startRecord) {
        return EdgingRecordAndOffset.createEndRecord(startRecord);
    }

    @Override
    AbstractLocusInfo<EdgingRecordAndOffset> createLocusInfo(SAMSequenceRecord referenceSequence, int lastPosition) {
        return new AbstractLocusInfo<EdgingRecordAndOffset>(referenceSequence, lastPosition);
    }

    @Override
    public void setMaxReadsToAccumulatePerLocus(int maxReadsToAccumulatePerLocus) {
        if (this.getMaxReadsToAccumulatePerLocus() != 0) {
            throw new UnsupportedOperationException("Locus cap is not supported for " + this.getClass().getSimpleName() + ".");
        }
    }

    @Override
    public void setQualityScoreCutoff(int qualityScoreCutoff) {
        throw new UnsupportedOperationException("Quality filtering is not supported for " + this.getClass().getSimpleName() + ".");
    }

    @Override
    public void setEmitUncoveredLoci(boolean emitUncoveredLoci) {
        if (this.isEmitUncoveredLoci() != emitUncoveredLoci) {
            throw new UnsupportedOperationException(this.getClass().getSimpleName() + " doesn't support work with skipping uncovered bases.");
        }
    }

    @Override
    public void setIncludeIndels(boolean includeIndels) {
        if (this.isIncludeIndels() != includeIndels) {
            throw new UnsupportedOperationException("Indels accumulation is not supported for " + this.getClass().getSimpleName() + ".");
        }
    }
}

