/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.util.AbstractAsyncWriter;
import htsjdk.samtools.util.ProgressLoggerInterface;

class AsyncSAMFileWriter
extends AbstractAsyncWriter<SAMRecord>
implements SAMFileWriter {
    private final SAMFileWriter underlyingWriter;

    public AsyncSAMFileWriter(SAMFileWriter out) {
        this(out, 2000);
    }

    public AsyncSAMFileWriter(SAMFileWriter out, int queueSize) {
        super(queueSize);
        this.underlyingWriter = out;
    }

    @Override
    protected void synchronouslyWrite(SAMRecord item) {
        this.underlyingWriter.addAlignment(item);
    }

    @Override
    protected void synchronouslyClose() {
        this.underlyingWriter.close();
    }

    @Override
    protected final String getThreadNamePrefix() {
        return "SAMFileWriterThread-";
    }

    @Override
    public void setProgressLogger(ProgressLoggerInterface progress) {
        this.underlyingWriter.setProgressLogger(progress);
    }

    @Override
    public void setSortOrderChecking(boolean check) {
        this.underlyingWriter.setSortOrderChecking(check);
    }

    @Override
    public void addAlignment(SAMRecord alignment) {
        this.write(alignment);
    }

    @Override
    public SAMFileHeader getFileHeader() {
        return this.underlyingWriter.getFileHeader();
    }
}

