/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.beta.codecs.reads.htsget;

import htsjdk.beta.io.bundle.SignatureStream;
import htsjdk.beta.plugin.HtsVersion;
import htsjdk.beta.plugin.reads.ReadsCodec;
import htsjdk.io.IOPath;
import htsjdk.samtools.util.htsget.HtsgetFormat;
import htsjdk.samtools.util.htsget.HtsgetRequest;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public abstract class HtsgetBAMCodec
implements ReadsCodec {
    public static final HtsVersion HTSGET_VERSION = new HtsVersion(1, 2, 0);
    private final Set<String> extensionMap = new HashSet<String>(Arrays.asList(".bam"));

    @Override
    public HtsVersion getVersion() {
        return HTSGET_VERSION;
    }

    @Override
    public String getFileFormat() {
        return "HTSGET_BAM";
    }

    @Override
    public int getSignatureLength() {
        return 0;
    }

    @Override
    public boolean ownsURI(IOPath ioPath) {
        return this.matchesScheme(ioPath);
    }

    private boolean matchesScheme(IOPath ioPath) {
        String scheme = ioPath.getScheme();
        return scheme.equals("htsget") || scheme.equals("https") || scheme.equals("http");
    }

    public boolean handlesURI(IOPath ioPath) {
        boolean hasExtension = this.extensionMap.stream().anyMatch(ext -> ioPath.hasExtension((String)ext));
        boolean hasScheme = this.matchesScheme(ioPath);
        HtsgetRequest htsgetRequest = new HtsgetRequest(ioPath.getURI());
        boolean matchesRequestType = htsgetRequest.getFormat() == null || htsgetRequest.getFormat() == HtsgetFormat.BAM;
        return hasExtension && hasScheme && matchesRequestType;
    }

    @Override
    public boolean canDecodeURI(IOPath ioPath) {
        return this.handlesURI(ioPath);
    }

    @Override
    public boolean canDecodeSignature(SignatureStream probingInputStream, String sourceName) {
        return false;
    }

    boolean isQueryable() {
        return true;
    }

    boolean hasIndex() {
        return false;
    }

    @Override
    public boolean runVersionUpgrade(HtsVersion sourceCodecVersion, HtsVersion targetCodecVersion) {
        return false;
    }
}

