/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.build;

import htsjdk.samtools.cram.build.CramIO;
import htsjdk.samtools.cram.io.CountingInputStream;
import htsjdk.samtools.cram.structure.Container;
import htsjdk.samtools.cram.structure.ContainerIO;
import htsjdk.samtools.cram.structure.CramHeader;
import java.io.InputStream;
import java.util.Iterator;

public class CramContainerIterator
implements Iterator<Container> {
    private CramHeader cramHeader;
    private CountingInputStream countingInputStream;
    private Container nextContainer;
    private boolean eof = false;

    public CramContainerIterator(InputStream inputStream) {
        this.countingInputStream = new CountingInputStream(inputStream);
        this.cramHeader = CramIO.readCramHeader(this.countingInputStream);
    }

    private void readNextContainer() {
        this.nextContainer = this.containerFromStream(this.countingInputStream);
        if (this.nextContainer.isEOF()) {
            this.eof = true;
            this.nextContainer = null;
        }
    }

    protected Container containerFromStream(CountingInputStream countingStream) {
        return ContainerIO.readContainer(this.cramHeader.getVersion(), countingStream);
    }

    @Override
    public boolean hasNext() {
        if (this.eof) {
            return false;
        }
        if (this.nextContainer == null) {
            this.readNextContainer();
        }
        return !this.eof;
    }

    @Override
    public Container next() {
        Container result = this.nextContainer;
        this.nextContainer = null;
        return result;
    }

    @Override
    public void remove() {
        throw new RuntimeException("Read only iterator.");
    }

    public CramHeader getCramHeader() {
        return this.cramHeader;
    }

    public void close() {
        this.nextContainer = null;
        this.cramHeader = null;
        try {
            this.countingInputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

