/*
 * Decompiled with CFR 0.152.
 */
package com.github.ryanholdren.resourcegzipper;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="gzip", defaultPhase=LifecyclePhase.PROCESS_CLASSES, threadSafe=true)
public class ResourceGZipperMojo
extends AbstractMojo {
    @Parameter(property="resourcedir", required=true)
    private File resourcedir;
    private Log log;

    public void execute() throws MojoExecutionException {
        if (this.resourcedir == null) {
            this.log.error((CharSequence)"resourcedir is null or empty");
            throw new MojoExecutionException("resourcedir is not used.");
        }
        if (!this.resourcedir.exists()) {
            throw new MojoExecutionException("resourcedir '" + this.resourcedir + "' doesn't exist");
        }
        if (!this.resourcedir.isDirectory()) {
            throw new MojoExecutionException("resourcedir '" + this.resourcedir + "' is not a directory");
        }
        FilenameFilter resourceFilenameFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".js") || name.endsWith(".css");
            }
        };
        this.gzipFiles(this.resourcedir, resourceFilenameFilter);
    }

    private void gzipFiles(File resourceDir, FilenameFilter resourceFilenameFilter) {
        File[] resourceFiles = resourceDir.listFiles(resourceFilenameFilter);
        if (resourceFiles.length == 0) {
            this.log.info((CharSequence)(resourceDir + " doesn't have any resource files; skipping..."));
            return;
        }
        for (File resourceFile : resourceFiles) {
            this.log.info((CharSequence)("gzipping " + resourceFile));
            this.gzipFile(resourceFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void gzipFile(File sourceFile) {
        BufferedInputStream bis = null;
        DeflaterOutputStream gzipOut = null;
        try {
            bis = new BufferedInputStream(new FileInputStream(sourceFile));
            File gzippedFile = new File(sourceFile.getAbsolutePath() + ".gz");
            if (gzippedFile.exists()) {
                gzippedFile.delete();
            }
            gzippedFile.createNewFile();
            gzipOut = new GZIPOutputStream(new FileOutputStream(gzippedFile));
            int ch = bis.read();
            while (ch != -1) {
                gzipOut.write(ch);
                ch = bis.read();
            }
            gzipOut.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException e) {
                    this.log.error((CharSequence)"Error while closing the input stream");
                }
            }
            if (gzipOut != null) {
                try {
                    gzipOut.close();
                }
                catch (IOException e) {
                    this.log.error((CharSequence)"Error while closing the gzipped output stream");
                }
            }
        }
    }

    public void setLog(Log log) {
        this.log = log;
    }
}

