/*
 * Decompiled with CFR 0.152.
 */
package com.github.ruifengho.simplesecurity.util;

import com.github.ruifengho.simplesecurity.define.HttpMethod;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.StringUtils;

public class AntPathMatcherUtil {
    private static final Logger logger = LoggerFactory.getLogger(AntPathMatcherUtil.class);
    private static final String MATCH_ALL = "/**";
    private static final AntPathMatcher MATCHER = new AntPathMatcher();

    public static boolean match(HttpServletRequest request, HttpMethod httpMethod, String pattern) {
        boolean methodMatches = AntPathMatcherUtil.matchMethod(request, httpMethod);
        boolean pathMatches = AntPathMatcherUtil.matchPath(request, pattern);
        logger.info("match begins. {} {}, httpMethod = {}, pattern = {}, methodMatch = {}, pathMatches = {}", new Object[]{request.getMethod(), AntPathMatcherUtil.getRequestPath(request), httpMethod, pattern, methodMatches, pathMatches});
        return methodMatches && pathMatches;
    }

    private static boolean matchMethod(HttpServletRequest request, HttpMethod httpMethod) {
        logger.debug("method match begins. {} {}, httpMethod = {}", new Object[]{request.getMethod(), AntPathMatcherUtil.getRequestPath(request), httpMethod});
        if (HttpMethod.ANY == httpMethod) {
            return true;
        }
        String method = request.getMethod();
        HttpMethod sourceHttpMethod = HttpMethod.valueOf(method);
        return httpMethod != null && httpMethod == sourceHttpMethod;
    }

    private static boolean matchPath(HttpServletRequest request, String pattern) {
        String url = AntPathMatcherUtil.getRequestPath(request);
        if (MATCH_ALL.equals(pattern)) {
            return true;
        }
        return MATCHER.match(pattern, url);
    }

    private static String getRequestPath(HttpServletRequest request) {
        String url = request.getServletPath();
        String pathInfo = request.getPathInfo();
        if (null != pathInfo) {
            url = StringUtils.hasLength((String)url) ? url + pathInfo : pathInfo;
        }
        return url;
    }
}

