/*
 * Decompiled with CFR 0.152.
 */
package com.github.ruifengho.simplesecurity.jwt;

import com.github.ruifengho.simplesecurity.autoconfigure.SimpleSecurityProperties;
import com.github.ruifengho.simplesecurity.exception.SimpleSecurityException;
import com.github.ruifengho.simplesecurity.jwt.JwtUser;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.UnsupportedJwtException;
import io.jsonwebtoken.security.Keys;
import io.jsonwebtoken.security.SignatureException;
import java.security.Key;
import java.util.Date;
import java.util.Map;
import javax.crypto.SecretKey;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public abstract class JwtTokenParser<T extends JwtUser> {
    protected static final int SEVEN = 7;
    protected static final String SIMPLE_SECURITY_REQ_ATTR_USER = "simple-security-user";
    private static final Logger logger = LoggerFactory.getLogger(JwtTokenParser.class);
    protected SimpleSecurityProperties simpleSecurityProperties;

    public JwtTokenParser(SimpleSecurityProperties simpleSecurityProperties) {
        this.simpleSecurityProperties = simpleSecurityProperties;
    }

    public final Claims getClaimsFromToken(String token) {
        try {
            return (Claims)Jwts.parser().setSigningKey(this.simpleSecurityProperties.getJwt().getSecret().getBytes()).parseClaimsJws(token).getBody();
        }
        catch (ExpiredJwtException | MalformedJwtException | UnsupportedJwtException | SignatureException | IllegalArgumentException e) {
            logger.error("token\u89e3\u6790\u9519\u8bef", e);
            throw new SimpleSecurityException("Token invalided.", e);
        }
    }

    public final Date getExpirationDateFromToken(String token) {
        return this.getClaimsFromToken(token).getExpiration();
    }

    private Boolean isTokenExpired(String token) {
        return new Date().after(this.getExpirationDateFromToken(token));
    }

    private Date getExpirationTime() {
        return new Date(System.currentTimeMillis() + this.simpleSecurityProperties.getJwt().getExpirationInSecond() * 1000L);
    }

    public final String generateToken(T user) {
        Map<String, Object> claims = this.getClaimsMap(user);
        Date createTime = new Date();
        Date expirationTime = this.getExpirationTime();
        byte[] keyBytes = this.simpleSecurityProperties.getJwt().getSecret().getBytes();
        SecretKey key = Keys.hmacShaKeyFor((byte[])keyBytes);
        return Jwts.builder().setClaims(claims).setIssuedAt(createTime).setExpiration(expirationTime).signWith((Key)key).compact();
    }

    protected abstract Map<String, Object> getClaimsMap(T var1);

    public final Boolean validateToken(String token) {
        return this.isTokenExpired(token) == false;
    }

    public final T getUser() {
        try {
            HttpServletRequest request = this.getRequest();
            String token = this.getTokenFromRequest(request);
            Boolean isValid = this.validateToken(token);
            if (!isValid.booleanValue()) {
                return null;
            }
            Object obj = request.getAttribute(SIMPLE_SECURITY_REQ_ATTR_USER);
            if (obj != null) {
                return (T)((JwtUser)obj);
            }
            T user = this.getUserFromToken(token);
            request.setAttribute(SIMPLE_SECURITY_REQ_ATTR_USER, user);
            return user;
        }
        catch (Exception e) {
            throw new SimpleSecurityException(e);
        }
    }

    public final T getUserFromToken(String token) {
        Claims claims = this.getClaimsFromToken(token);
        return this.getUserFromClaims(claims);
    }

    protected abstract T getUserFromClaims(Claims var1);

    protected abstract String getTokenFromRequest(HttpServletRequest var1);

    protected final HttpServletRequest getRequest() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes == null) {
            throw new SimpleSecurityException("requestAttributes\u4e3anull");
        }
        return ((ServletRequestAttributes)requestAttributes).getRequest();
    }
}

