/*
 * Decompiled with CFR 0.152.
 */
package com.github.ruifengho.simplesecurity.annotation.support;

import com.github.ruifengho.simplesecurity.annotation.PreAuthorize;
import com.github.ruifengho.simplesecurity.define.PermissionExpressionParser;
import com.github.ruifengho.simplesecurity.exception.SimpleSecurityException;
import com.github.ruifengho.simplesecurity.util.SpringElCheckUtil;
import java.lang.reflect.Method;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.support.StandardEvaluationContext;

@Aspect
public class PreAuthorizeAspect {
    private final PermissionExpressionParser permissionExpressionParser;

    public PreAuthorizeAspect(PermissionExpressionParser permissionExpressionParser) {
        this.permissionExpressionParser = permissionExpressionParser;
    }

    @Around(value="@annotation(com.github.ruifengho.simplesecurity.annotation.PreAuthorize) ")
    public Object preAuth(ProceedingJoinPoint point) throws Throwable {
        PreAuthorize preAuthorize;
        String expression;
        boolean check;
        MethodSignature signature = (MethodSignature)point.getSignature();
        Method method = signature.getMethod();
        if (method.isAnnotationPresent(PreAuthorize.class) && !(check = SpringElCheckUtil.check((EvaluationContext)new StandardEvaluationContext((Object)this.permissionExpressionParser), expression = (preAuthorize = method.getAnnotation(PreAuthorize.class)).value()))) {
            throw new SimpleSecurityException("Access Denied.");
        }
        return point.proceed();
    }
}

