/*
 * Decompiled with CFR 0.152.
 */
package com.github.rubensousa.gravitysnaphelper;

import android.annotation.SuppressLint;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.LinearSnapHelper;
import android.support.v7.widget.OrientationHelper;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import com.github.rubensousa.gravitysnaphelper.R;

public class GravitySnapHelper
extends LinearSnapHelper {
    private OrientationHelper mVerticalHelper;
    private OrientationHelper mHorizontalHelper;
    private int mGravity;
    private boolean mIsRtl;

    @SuppressLint(value={"RtlHardcoded"})
    public GravitySnapHelper(int gravity) {
        this.mGravity = gravity;
        if (this.mGravity == 3) {
            this.mGravity = 0x800003;
        } else if (this.mGravity == 5) {
            this.mGravity = 0x800005;
        }
    }

    public void attachToRecyclerView(@Nullable RecyclerView recyclerView) throws IllegalStateException {
        if (recyclerView != null) {
            this.mIsRtl = recyclerView.getContext().getResources().getBoolean(R.bool.is_rtl);
        }
        super.attachToRecyclerView(recyclerView);
    }

    public int[] calculateDistanceToFinalSnap(@NonNull RecyclerView.LayoutManager layoutManager, @NonNull View targetView) {
        int[] out = new int[2];
        out[0] = layoutManager.canScrollHorizontally() ? (this.mGravity == 0x800003 ? this.distanceToStart(targetView, this.getHorizontalHelper(layoutManager)) : this.distanceToEnd(targetView, this.getHorizontalHelper(layoutManager))) : 0;
        out[1] = layoutManager.canScrollVertically() ? (this.mGravity == 48 ? this.distanceToStart(targetView, this.getVerticalHelper(layoutManager)) : this.distanceToEnd(targetView, this.getVerticalHelper(layoutManager))) : 0;
        return out;
    }

    public View findSnapView(RecyclerView.LayoutManager layoutManager) {
        if (layoutManager instanceof LinearLayoutManager) {
            switch (this.mGravity) {
                case 0x800003: {
                    return this.findStartView(layoutManager, this.getHorizontalHelper(layoutManager));
                }
                case 48: {
                    return this.findStartView(layoutManager, this.getVerticalHelper(layoutManager));
                }
                case 0x800005: {
                    return this.findEndView(layoutManager, this.getHorizontalHelper(layoutManager));
                }
                case 80: {
                    return this.findEndView(layoutManager, this.getVerticalHelper(layoutManager));
                }
            }
        }
        return super.findSnapView(layoutManager);
    }

    private int distanceToStart(View targetView, OrientationHelper helper) {
        if (this.mIsRtl) {
            return this.distanceToEnd(targetView, helper);
        }
        return helper.getDecoratedStart(targetView) - helper.getStartAfterPadding();
    }

    private int distanceToEnd(View targetView, OrientationHelper helper) {
        if (this.mIsRtl) {
            return helper.getDecoratedStart(targetView) - helper.getStartAfterPadding();
        }
        return helper.getDecoratedEnd(targetView) - helper.getEndAfterPadding();
    }

    private View findStartView(RecyclerView.LayoutManager layoutManager, OrientationHelper helper) {
        if (layoutManager instanceof LinearLayoutManager) {
            int firstChild = ((LinearLayoutManager)layoutManager).findFirstVisibleItemPosition();
            if (firstChild == -1) {
                return null;
            }
            View child = layoutManager.findViewByPosition(firstChild);
            if (helper.getDecoratedEnd(child) >= helper.getDecoratedMeasurement(child) / 2 && helper.getDecoratedEnd(child) > 0) {
                return child;
            }
            if (((LinearLayoutManager)layoutManager).findLastCompletelyVisibleItemPosition() == layoutManager.getItemCount() - 1) {
                return null;
            }
            return layoutManager.findViewByPosition(firstChild + 1);
        }
        return super.findSnapView(layoutManager);
    }

    private View findEndView(RecyclerView.LayoutManager layoutManager, OrientationHelper helper) {
        if (layoutManager instanceof LinearLayoutManager) {
            int lastChild = ((LinearLayoutManager)layoutManager).findLastVisibleItemPosition();
            if (lastChild == -1) {
                return null;
            }
            View child = layoutManager.findViewByPosition(lastChild);
            if (helper.getDecoratedStart(child) + helper.getDecoratedMeasurement(child) / 2 <= helper.getTotalSpace()) {
                return child;
            }
            if (((LinearLayoutManager)layoutManager).findFirstCompletelyVisibleItemPosition() == 0) {
                return null;
            }
            return layoutManager.findViewByPosition(lastChild - 1);
        }
        return super.findSnapView(layoutManager);
    }

    private OrientationHelper getVerticalHelper(RecyclerView.LayoutManager layoutManager) {
        if (this.mVerticalHelper == null) {
            this.mVerticalHelper = OrientationHelper.createVerticalHelper((RecyclerView.LayoutManager)layoutManager);
        }
        return this.mVerticalHelper;
    }

    private OrientationHelper getHorizontalHelper(RecyclerView.LayoutManager layoutManager) {
        if (this.mHorizontalHelper == null) {
            this.mHorizontalHelper = OrientationHelper.createHorizontalHelper((RecyclerView.LayoutManager)layoutManager);
        }
        return this.mHorizontalHelper;
    }
}

