/*
 * Decompiled with CFR 0.152.
 */
package gopher.impl;

import cps.CpsAsyncMonad;
import gopher.Channel;
import gopher.ChannelClosedException;
import gopher.ChannelClosedException$;
import gopher.JVMGopher;
import gopher.ReadChannel;
import gopher.impl.Expirable;
import gopher.impl.Expirable$Capture$;
import gopher.impl.Expirable$Capture$Ready$;
import gopher.impl.GuardedSPSCBaseChannel$;
import gopher.impl.Reader;
import gopher.impl.Writer;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyVals$;
import scala.runtime.Nothing$;
import scala.util.Failure$;
import scala.util.Success$;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class GuardedSPSCBaseChannel<F, A>
implements Channel<F, A, A> {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffset(GuardedSPSCBaseChannel.class, "0bitmap$1");
    public ReadChannel done$lzy1;
    public long 0bitmap$1;
    private final JVMGopher gopherApi;
    private final ExecutorService controlExecutor;
    private final ExecutorService taskExecutor;
    private final ConcurrentLinkedDeque readers;
    private final ConcurrentLinkedDeque writers;
    private final ConcurrentLinkedDeque doneReaders;
    private final AtomicBoolean publishedClosed;
    private final AtomicInteger stepGuard;
    private final Runnable stepRunnable;

    public static int STEP_BUSY() {
        return GuardedSPSCBaseChannel$.MODULE$.STEP_BUSY();
    }

    public static int STEP_FREE() {
        return GuardedSPSCBaseChannel$.MODULE$.STEP_FREE();
    }

    public static int STEP_UPDATED() {
        return GuardedSPSCBaseChannel$.MODULE$.STEP_UPDATED();
    }

    public GuardedSPSCBaseChannel(JVMGopher<F> gopherApi, ExecutorService controlExecutor, ExecutorService taskExecutor, CpsAsyncMonad<F> evidence$1) {
        this.gopherApi = gopherApi;
        this.controlExecutor = controlExecutor;
        this.taskExecutor = taskExecutor;
        ReadChannel.$init$(this);
        this.readers = new ConcurrentLinkedDeque();
        this.writers = new ConcurrentLinkedDeque();
        this.doneReaders = new ConcurrentLinkedDeque();
        this.publishedClosed = new AtomicBoolean(false);
        this.stepGuard = new AtomicInteger(0);
        this.stepRunnable = () -> this.entryStep();
    }

    @Override
    public ReadChannel done() {
        long l;
        long l2;
        while ((l2 = LazyVals$.MODULE$.STATE(l = LazyVals$.MODULE$.get((Object)this, OFFSET$0), 0)) != 3L) {
            if (l2 == 0L) {
                if (!LazyVals$.MODULE$.CAS((Object)this, OFFSET$0, l, 1, 0)) continue;
                try {
                    ReadChannel readChannel;
                    this.done$lzy1 = readChannel = ReadChannel.done$(this);
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 3, 0);
                    return readChannel;
                }
                catch (Throwable throwable) {
                    LazyVals$.MODULE$.setFlag((Object)this, OFFSET$0, 0, 0);
                    throw throwable;
                }
            }
            LazyVals$.MODULE$.wait4Notification((Object)this, OFFSET$0, l, 0);
        }
        return this.done$lzy1;
    }

    @Override
    public JVMGopher<F> gopherApi() {
        return this.gopherApi;
    }

    public ConcurrentLinkedDeque<Reader<A>> readers() {
        return this.readers;
    }

    public ConcurrentLinkedDeque<Writer<A>> writers() {
        return this.writers;
    }

    public ConcurrentLinkedDeque<Reader<BoxedUnit>> doneReaders() {
        return this.doneReaders;
    }

    public AtomicBoolean publishedClosed() {
        return this.publishedClosed;
    }

    public AtomicInteger stepGuard() {
        return this.stepGuard;
    }

    public Runnable stepRunnable() {
        return this.stepRunnable;
    }

    @Override
    public void addReader(Reader<A> reader) {
        if (reader.canExpire()) {
            this.readers().removeIf(_$2 -> _$2.isExpired());
        }
        this.readers().add(reader);
        this.controlExecutor.submit(this.stepRunnable());
    }

    @Override
    public void addWriter(Writer<A> writer) {
        if (writer.canExpire()) {
            this.writers().removeIf(_$3 -> _$3.isExpired());
        }
        if (this.publishedClosed().get()) {
            this.closeWriter(writer);
        } else {
            this.writers().add(writer);
            this.controlExecutor.submit(this.stepRunnable());
        }
    }

    @Override
    public void addDoneReader(Reader<BoxedUnit> reader) {
        if (reader.canExpire()) {
            this.doneReaders().removeIf(_$4 -> _$4.isExpired());
        }
        if (this.publishedClosed().get()) {
            this.closeDoneReader(reader);
        } else {
            this.doneReaders().add(reader);
            this.controlExecutor.submit(this.stepRunnable());
        }
    }

    @Override
    public void close() {
        this.publishedClosed().set(true);
        this.controlExecutor.submit(this.stepRunnable());
    }

    @Override
    public boolean isClosed() {
        return this.publishedClosed().get();
    }

    public abstract void step();

    public void entryStep() {
        boolean done = false;
        int nSpins = 0;
        while (!done) {
            if (this.stepGuard().compareAndSet(0, 1)) {
                done = true;
                this.step();
                continue;
            }
            if (this.stepGuard().compareAndSet(1, 2)) {
                done = true;
                continue;
            }
            if (this.stepGuard().get() == 2) {
                done = true;
                continue;
            }
            ++nSpins;
            Thread.onSpinWait();
        }
    }

    public boolean checkLeaveStep() {
        return this.stepGuard().compareAndSet(1, 0) ? true : (this.stepGuard().compareAndSet(2, 1) ? false : false);
    }

    /*
     * WARNING - void declaration
     */
    public boolean processReadClose() {
        void var1_1;
        Predef$.MODULE$.require(this.writers().isEmpty());
        boolean progress = false;
        while (!this.readers().isEmpty()) {
            Reader<A> r = this.readers().poll();
            if (r == null || r.isExpired()) continue;
            Expirable.Capture capture = r.capture();
            if (capture instanceof Expirable.Capture.Ready) {
                Function1 function1;
                Expirable.Capture.Ready ready = Expirable$Capture$Ready$.MODULE$.unapply((Expirable.Capture.Ready)capture);
                Function1 f = function1 = (Function1)ready._1();
                progress = true;
                this.taskExecutor.execute(() -> {
                    String debugInfo = new StringBuilder(46).append("channel=").append(this).append(", writersEmpty=").append(this.writers().isEmpty()).append(", readersEmpty=").append(this.readers().isEmpty()).append(", r=").append(r).append(", f=").append(f).toString();
                    f.apply((Object)Failure$.MODULE$.apply((Throwable)new ChannelClosedException(debugInfo)));
                });
                r.markUsed();
                continue;
            }
            Expirable.Capture<Nothing$> capture2 = Expirable$Capture$.WaitChangeComplete;
            Expirable.Capture capture3 = capture;
            if (!(capture2 != null ? !capture2.equals(capture3) : capture3 != null)) {
                this.progressWaitReader(r);
                continue;
            }
            Expirable.Capture<Nothing$> capture4 = Expirable$Capture$.Expired;
            Expirable.Capture capture5 = capture;
            if (!(capture4 != null ? !capture4.equals(capture5) : capture5 != null)) {
                progress = true;
                continue;
            }
            throw new MatchError(capture);
        }
        return (boolean)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public boolean processWriteClose() {
        void var1_1;
        boolean progress = false;
        while (!this.writers().isEmpty()) {
            Expirable.Capture.Ready ready;
            Tuple2 tuple2;
            Writer<A> w = this.writers().poll();
            if (w == null || w.isExpired()) continue;
            Expirable.Capture capture = w.capture();
            if (capture instanceof Expirable.Capture.Ready && (tuple2 = (Tuple2)(ready = Expirable$Capture$Ready$.MODULE$.unapply((Expirable.Capture.Ready)capture))._1()) != null) {
                Object a = tuple2._1();
                Function1 f = (Function1)tuple2._2();
                progress = true;
                this.taskExecutor.execute(() -> f.apply((Object)Failure$.MODULE$.apply((Throwable)new ChannelClosedException(ChannelClosedException$.MODULE$.$lessinit$greater$default$1()))));
                w.markUsed();
                continue;
            }
            Expirable.Capture<Nothing$> capture2 = Expirable$Capture$.WaitChangeComplete;
            Expirable.Capture capture3 = capture;
            if (!(capture2 != null ? !capture2.equals(capture3) : capture3 != null)) {
                this.progressWaitWriter(w);
                continue;
            }
            Expirable.Capture<Nothing$> capture4 = Expirable$Capture$.Expired;
            Expirable.Capture capture5 = capture;
            if (!(capture4 != null ? !capture4.equals(capture5) : capture5 != null)) {
                progress = true;
                continue;
            }
            throw new MatchError(capture);
        }
        return (boolean)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public boolean processDoneClose() {
        void var1_1;
        boolean progress = false;
        while (!this.doneReaders().isEmpty()) {
            Reader<BoxedUnit> r = this.doneReaders().poll();
            if (r == null || r.isExpired()) continue;
            Expirable.Capture capture = r.capture();
            if (capture instanceof Expirable.Capture.Ready) {
                Function1 function1;
                Expirable.Capture.Ready ready = Expirable$Capture$Ready$.MODULE$.unapply((Expirable.Capture.Ready)capture);
                Function1 f = function1 = (Function1)ready._1();
                progress = true;
                this.taskExecutor.execute(() -> f.apply((Object)Success$.MODULE$.apply((Object)BoxedUnit.UNIT)));
                r.markUsed();
                continue;
            }
            Expirable.Capture<Nothing$> capture2 = Expirable$Capture$.WaitChangeComplete;
            Expirable.Capture capture3 = capture;
            if (!(capture2 != null ? !capture2.equals(capture3) : capture3 != null)) {
                this.progressWaitDoneReader(r);
                continue;
            }
            Expirable.Capture<Nothing$> capture4 = Expirable$Capture$.Expired;
            Expirable.Capture capture5 = capture;
            if (!(capture4 != null ? !capture4.equals(capture5) : capture5 != null)) {
                progress = true;
                continue;
            }
            throw new MatchError(capture);
        }
        return (boolean)var1_1;
    }

    public void closeDoneReader(Reader<BoxedUnit> r) {
        boolean bl;
        do {
            Expirable.Capture capture;
            if ((capture = r.capture()) instanceof Expirable.Capture.Ready) {
                Function1 function1;
                Expirable.Capture.Ready ready = Expirable$Capture$Ready$.MODULE$.unapply((Expirable.Capture.Ready)capture);
                Function1 f = function1 = (Function1)ready._1();
                this.taskExecutor.execute(() -> f.apply((Object)Success$.MODULE$.apply((Object)BoxedUnit.UNIT)));
                r.markUsed();
                bl = false;
                continue;
            }
            Expirable.Capture<Nothing$> capture2 = Expirable$Capture$.WaitChangeComplete;
            Expirable.Capture capture3 = capture;
            if (!(capture2 != null ? !capture2.equals(capture3) : capture3 != null)) {
                this.progressWaitDoneReader(r);
                bl = true;
                continue;
            }
            Expirable.Capture<Nothing$> capture4 = Expirable$Capture$.Expired;
            Expirable.Capture capture5 = capture;
            if (!(capture4 != null ? !capture4.equals(capture5) : capture5 != null)) {
                bl = false;
                continue;
            }
            throw new MatchError(capture);
        } while (bl);
    }

    public void closeWriter(Writer<A> w) {
        boolean done = false;
        while (!done && !w.isExpired()) {
            Expirable.Capture.Ready ready;
            Tuple2 tuple2;
            Expirable.Capture capture = w.capture();
            if (capture instanceof Expirable.Capture.Ready && (tuple2 = (Tuple2)(ready = Expirable$Capture$Ready$.MODULE$.unapply((Expirable.Capture.Ready)capture))._1()) != null) {
                Object a = tuple2._1();
                Function1 f = (Function1)tuple2._2();
                this.taskExecutor.execute(() -> f.apply((Object)Failure$.MODULE$.apply((Throwable)new ChannelClosedException(ChannelClosedException$.MODULE$.$lessinit$greater$default$1()))));
                w.markUsed();
                done = true;
                continue;
            }
            Expirable.Capture<Nothing$> capture2 = Expirable$Capture$.WaitChangeComplete;
            Expirable.Capture capture3 = capture;
            if (!(capture2 != null ? !capture2.equals(capture3) : capture3 != null)) {
                Thread.onSpinWait();
                continue;
            }
            Expirable.Capture<Nothing$> capture4 = Expirable$Capture$.Expired;
            Expirable.Capture capture5 = capture;
            if (!(capture4 != null ? !capture4.equals(capture5) : capture5 != null)) {
                done = true;
                continue;
            }
            throw new MatchError(capture);
        }
    }

    public void progressWaitReader(Reader<A> r) {
        this.progressWait(r, this.readers());
    }

    public void progressWaitWriter(Writer<A> w) {
        this.progressWait(w, this.writers());
    }

    public void progressWaitDoneReader(Reader<BoxedUnit> r) {
        this.progressWait(r, this.doneReaders());
    }

    public <T extends Expirable<?>> void progressWait(T v, ConcurrentLinkedDeque<T> queue) {
        if (!v.isExpired()) {
            if (queue.isEmpty()) {
                Thread.onSpinWait();
            }
            queue.addLast(v);
        }
    }
}

