/*
 * Decompiled with CFR 0.152.
 */
package gopher;

import gopher.Channel;
import gopher.ChannelClosedException;
import gopher.ChannelWithExpiration;
import gopher.Gopher;
import gopher.ReadChannel;
import gopher.impl.SimpleWriter;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.FiniteDuration$;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Success$;
import scala.util.Try;

public abstract class Time<F> {
    public final Gopher<F> gopher$Time$$gopherAPI;

    public Time(Gopher<F> gopherAPI) {
        this.gopher$Time$$gopherAPI = gopherAPI;
    }

    /*
     * WARNING - void declaration
     */
    public ReadChannel<F, FiniteDuration> after(FiniteDuration duration) {
        void var2_2;
        Channel ch = this.gopher$Time$$gopherAPI.makeOnceChannel();
        this.schedule((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            FiniteDuration now = FiniteDuration$.MODULE$.apply(System.currentTimeMillis(), TimeUnit.MILLISECONDS);
            ch.awrite(now);
        }, duration);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public F asleep(FiniteDuration duration) {
        void var3_3;
        ObjectRef fun = ObjectRef.create((JProcedure1 & Serializable)_$2 -> {});
        Object retval = this.gopher$Time$$gopherAPI.asyncMonad().adoptCallbackStyle((Function1)(JProcedure1 & Serializable)listener -> {
            Function1 function1 = listener;
            fun$1.elem = function1;
        });
        this.schedule((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            FiniteDuration now = FiniteDuration$.MODULE$.apply(System.currentTimeMillis(), TimeUnit.MILLISECONDS);
            ((Function1)fun$2.elem).apply((Object)Success$.MODULE$.apply((Object)now));
        }, duration);
        return var3_3;
    }

    public ReadChannel<F, FiniteDuration> tick(FiniteDuration duration) {
        return this.newTicker(duration).channel();
    }

    public Ticker newTicker(FiniteDuration duration) {
        return new Ticker(this, duration);
    }

    public FiniteDuration now() {
        return FiniteDuration$.MODULE$.apply(System.currentTimeMillis(), TimeUnit.MILLISECONDS);
    }

    public abstract Scheduled schedule(Function0<BoxedUnit> var1, FiniteDuration var2);

    public Gopher<F> inline$gopherAPI() {
        return this.gopher$Time$$gopherAPI;
    }

    public static interface Scheduled {
        public boolean cancel();

        public void onDone(Function1<Try<Object>, BoxedUnit> var1);
    }

    public class Ticker {
        private final FiniteDuration duration;
        private final ChannelWithExpiration channel;
        private final Scheduled scheduled;
        private final AtomicBoolean stopped;
        private final Time<F> $outer;

        public Ticker(Time $outer, FiniteDuration duration) {
            this.duration = duration;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            this.channel = $outer.gopher$Time$$gopherAPI.makeChannel(0, $outer.gopher$Time$$gopherAPI.makeChannel$default$2()).withExpiration(duration, false);
            this.scheduled = $outer.schedule((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.tick(), duration);
            this.stopped = new AtomicBoolean(false);
        }

        public ChannelWithExpiration<F, FiniteDuration, FiniteDuration> channel() {
            return this.channel;
        }

        public void stop() {
            this.scheduled.cancel();
            this.stopped.set(true);
        }

        private void tick() {
            if (!this.stopped.get()) {
                this.channel().addWriter(new SimpleWriter<FiniteDuration>(this.$outer.now(), (Function1<Try<BoxedUnit>, BoxedUnit>)(JProcedure1 & Serializable)x$1 -> {
                    Try try_ = x$1;
                    if (!(try_ instanceof Success)) {
                        if (try_ instanceof Failure) {
                            Throwable ex = ((Failure)try_).exception();
                            Throwable throwable = ex;
                            if (throwable instanceof ChannelClosedException) {
                                ChannelClosedException ex2 = (ChannelClosedException)throwable;
                                this.scheduled.cancel();
                                this.stopped.lazySet(true);
                            } else if (throwable instanceof TimeoutException) {
                                TimeoutException ex3 = (TimeoutException)throwable;
                            } else {
                                Throwable other = throwable;
                                this.$outer.gopher$Time$$gopherAPI.logImpossible(other);
                            }
                        } else {
                            throw new MatchError((Object)try_);
                        }
                    }
                }));
                this.$outer.schedule((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.tick(), this.duration);
            }
        }

        public final Time<F> gopher$Time$Ticker$$$outer() {
            return this.$outer;
        }
    }
}

