/*
 * Decompiled with CFR 0.152.
 */
package fr.romaindu35.enscryptsystem.encrypt;

import fr.romaindu35.enscryptsystem.encrypt.CipherMod;
import fr.romaindu35.enscryptsystem.encrypt.Keys;
import fr.romaindu35.enscryptsystem.utils.ScanDir;
import fr.romaindu35.enscryptsystem.utils.Utils;
import java.io.File;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class Encrypt {
    private File inputFile;
    private File outputFile;
    private ScanDir scanDir;
    private String extension;
    private Keys keys;
    private CipherMod cipherMod;
    private Type type;

    protected Encrypt(File inputFile, File outputFile, Keys keys, CipherMod cipherMod) {
        this.inputFile = inputFile;
        this.outputFile = outputFile;
        this.keys = keys;
        this.cipherMod = cipherMod;
        this.type = Type.FILE;
    }

    protected Encrypt(ScanDir scanDir, Keys keys, CipherMod cipherMod) {
        this.keys = keys;
        this.cipherMod = cipherMod;
        this.scanDir = scanDir;
        this.extension = scanDir.getConverExtension();
        this.inputFile = scanDir.getInput_directory();
        this.outputFile = scanDir.getOutput_directory();
        this.type = Type.DIR;
    }

    public void run() {
        if (this.type == Type.FILE) {
            this.crypt(this.inputFile, this.outputFile);
        } else {
            for (File listFile : this.inputFile.listFiles()) {
                if (!this.scanDir.getFilter().getExtensionUse().isEmpty()) {
                    for (String strings : this.scanDir.getFilter().getExtensionUse()) {
                        if (!listFile.getName().contains(strings)) continue;
                        this.crypt(listFile, new File(this.outputFile.getPath() + "/" + listFile.getName().subSequence(0, listFile.getName().lastIndexOf(".")) + this.extension));
                    }
                    continue;
                }
                this.crypt(listFile, new File(this.outputFile.getPath() + "/" + listFile.getName()));
            }
        }
    }

    private void crypt(File file, File fileTo) {
        try {
            Utils.crypt(file, fileTo, this.keys, this.cipherMod);
        }
        catch (IOException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            e.printStackTrace();
        }
    }

    static enum Type {
        FILE,
        DIR;

    }
}

