/*
 * Decompiled with CFR 0.152.
 */
package com.github.rkumsher.number;

import com.google.common.base.Preconditions;
import java.util.Random;

public class RandomNumberUtils {
    private static final Random RANDOM = new Random();

    private RandomNumberUtils() {
    }

    public static int randomInt() {
        return RandomNumberUtils.randomInt(Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public static int randomPositiveInt() {
        return RandomNumberUtils.randomInt(1, Integer.MAX_VALUE);
    }

    public static int randomNegativeInt() {
        return RandomNumberUtils.randomInt(Integer.MIN_VALUE, 0);
    }

    public static int randomInt(int startInclusive, int endExclusive) {
        Preconditions.checkArgument((startInclusive <= endExclusive ? 1 : 0) != 0, (Object)"End must be greater than or equal to start");
        if (startInclusive == endExclusive) {
            return startInclusive;
        }
        return RANDOM.ints(1L, startInclusive, endExclusive).sum();
    }

    public static int randomIntGreaterThan(int minExclusive) {
        Preconditions.checkArgument((minExclusive < Integer.MAX_VALUE ? 1 : 0) != 0, (String)"Cannot produce int greater than %s", (int)Integer.MAX_VALUE);
        return RandomNumberUtils.randomInt(minExclusive + 1, Integer.MAX_VALUE);
    }

    public static int randomIntLessThan(int maxExclusive) {
        Preconditions.checkArgument((maxExclusive > Integer.MIN_VALUE ? 1 : 0) != 0, (String)"Cannot produce int less than %s", (int)Integer.MIN_VALUE);
        return RandomNumberUtils.randomInt(Integer.MIN_VALUE, maxExclusive);
    }

    public static long randomLong() {
        return RandomNumberUtils.randomLong(Long.MIN_VALUE, Long.MAX_VALUE);
    }

    public static long randomPositiveLong() {
        return RandomNumberUtils.randomLong(1L, Long.MAX_VALUE);
    }

    public static long randomNegativeLong() {
        return RandomNumberUtils.randomLong(Long.MIN_VALUE, 0L);
    }

    public static long randomLong(long startInclusive, long endExclusive) {
        Preconditions.checkArgument((startInclusive <= endExclusive ? 1 : 0) != 0, (Object)"End must be greater than or equal to start");
        if (startInclusive == endExclusive) {
            return startInclusive;
        }
        return RANDOM.longs(1L, startInclusive, endExclusive).sum();
    }

    public static long randomLongGreaterThan(long minExclusive) {
        Preconditions.checkArgument((minExclusive < Long.MAX_VALUE ? 1 : 0) != 0, (String)"Cannot produce long greater than %s", (long)Long.MAX_VALUE);
        return RandomNumberUtils.randomLong(minExclusive + 1L, Long.MAX_VALUE);
    }

    public static long randomLongLessThan(long maxExclusive) {
        Preconditions.checkArgument((maxExclusive > Long.MIN_VALUE ? 1 : 0) != 0, (String)"Cannot produce long less than %s", (long)Long.MIN_VALUE);
        return RandomNumberUtils.randomLong(Long.MIN_VALUE, maxExclusive);
    }

    public static double randomDouble() {
        return RandomNumberUtils.randomDouble(-1.7976931348623157E308, Double.MAX_VALUE);
    }

    public static double randomPositiveDouble() {
        return RandomNumberUtils.randomDouble(1.0, Double.MAX_VALUE);
    }

    public static double randomNegativeDouble() {
        return RandomNumberUtils.randomDouble(-1.7976931348623157E308, 0.0);
    }

    public static double randomDouble(double startInclusive, double endExclusive) {
        Preconditions.checkArgument((startInclusive <= endExclusive ? 1 : 0) != 0, (Object)"End must be greater than or equal to start");
        if (startInclusive == endExclusive) {
            return startInclusive;
        }
        return RANDOM.doubles(1L, startInclusive, endExclusive).sum();
    }

    public static double randomDoubleGreaterThan(double minExclusive) {
        Preconditions.checkArgument((minExclusive < Double.MAX_VALUE ? 1 : 0) != 0, (String)"Cannot produce double greater than %s", (Object)Double.MAX_VALUE);
        return RandomNumberUtils.randomDouble(minExclusive + 1.0, Double.MAX_VALUE);
    }

    public static double randomDoubleLessThan(double maxExclusive) {
        Preconditions.checkArgument((maxExclusive > -1.7976931348623157E308 ? 1 : 0) != 0, (String)"Cannot produce double less than %s", (Object)-1.7976931348623157E308);
        return RandomNumberUtils.randomDouble(-1.7976931348623157E308, maxExclusive);
    }
}

