/*
 * Decompiled with CFR 0.152.
 */
package com.github.rkumsher.date;

import com.google.common.base.Preconditions;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.ZoneId;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Date;

public final class DateUtils {
    static final MonthDay LEAP_DAY = MonthDay.of(Month.FEBRUARY, 29);

    private DateUtils() {
    }

    public static boolean isLeapDay(TemporalAccessor temporal) {
        Preconditions.checkArgument((boolean)temporal.isSupported(ChronoField.MONTH_OF_YEAR), (String)"%s does not support MONTH_OF_YEAR", (Object)temporal);
        Preconditions.checkArgument((boolean)temporal.isSupported(ChronoField.DAY_OF_MONTH), (String)"%s does not support DAY_OF_MONTH", (Object)temporal);
        MonthDay monthDay = MonthDay.from(temporal);
        return monthDay.equals(LEAP_DAY);
    }

    public static Date atStartOfDay(Date date) {
        LocalDateTime localDateTime = DateUtils.dateToLocalDateTime(date);
        LocalDateTime startOfDay = localDateTime.with(LocalTime.MIN);
        return DateUtils.localDateTimeToDate(startOfDay);
    }

    public static Date atEndOfDay(Date date) {
        LocalDateTime localDateTime = DateUtils.dateToLocalDateTime(date);
        LocalDateTime endOfDay = localDateTime.with(LocalTime.MAX);
        return DateUtils.localDateTimeToDate(endOfDay);
    }

    private static LocalDateTime dateToLocalDateTime(Date date) {
        return LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
    }

    static Date localDateTimeToDate(LocalDateTime localDateTime) {
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }
}

