/*
 * Decompiled with CFR 0.152.
 */
package com.github.rkumsher.collection;

import com.github.rkumsher.collection.IterableUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.Iterables;
import com.google.common.collect.Range;
import java.util.Arrays;
import java.util.function.Supplier;
import java.util.stream.Stream;

public final class RandomArrayUtils {
    private RandomArrayUtils() {
    }

    public static <T> T[] randomArrayFrom(T[] elements, Range<Integer> size) {
        return RandomArrayUtils.randomArrayFrom(Arrays.asList(elements), size);
    }

    public static <T> T[] randomArrayFrom(Iterable<T> elements, Range<Integer> size) {
        Preconditions.checkArgument((!Iterables.isEmpty(elements) ? 1 : 0) != 0, (Object)"Elements to populate random array from must not be empty");
        return RandomArrayUtils.randomArrayFrom(() -> IterableUtils.randomFrom(elements), size);
    }

    public static <T> T[] randomArrayFrom(T[] elements, int size) {
        return RandomArrayUtils.randomArrayFrom(Arrays.asList(elements), size);
    }

    public static <T> T[] randomArrayFrom(Iterable<T> elements, int size) {
        Preconditions.checkArgument((!Iterables.isEmpty(elements) ? 1 : 0) != 0, (Object)"Elements to populate random array from must not be empty");
        return RandomArrayUtils.randomArrayFrom(() -> IterableUtils.randomFrom(elements), size);
    }

    public static <T> T[] randomArrayFrom(Supplier<T> elementSupplier, Range<Integer> size) {
        Preconditions.checkArgument((size.hasLowerBound() && (Integer)size.lowerEndpoint() >= 0 ? 1 : 0) != 0, (Object)"Size range must consist of only positive integers");
        ContiguousSet rangeSet = ContiguousSet.create(size, (DiscreteDomain)DiscreteDomain.integers());
        int limit = (Integer)IterableUtils.randomFrom(rangeSet);
        return RandomArrayUtils.randomArrayFrom(elementSupplier, limit);
    }

    public static <T> T[] randomArrayFrom(Supplier<T> elementSupplier, int size) {
        Preconditions.checkArgument((size >= 0 ? 1 : 0) != 0, (Object)"Size must be greater than or equal to zero");
        return Stream.generate(elementSupplier).limit(size).toArray(Object[]::new);
    }
}

