/*
 * Decompiled with CFR 0.152.
 */
package com.github.rkumsher.collection;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Random;
import java.util.stream.StreamSupport;

public final class IterableUtils {
    private static final Random RANDOM = new Random();

    private IterableUtils() {
    }

    public static <T> T randomFrom(Iterable<T> iterable) {
        Preconditions.checkArgument((!Iterables.isEmpty(iterable) ? 1 : 0) != 0, (Object)"Iterable cannot be empty");
        int randomIndex = RANDOM.nextInt(Iterables.size(iterable));
        return (T)Iterables.get(iterable, (int)randomIndex);
    }

    @SafeVarargs
    public static <T> T randomFrom(Iterable<T> iterable, T ... excludes) {
        return IterableUtils.randomFrom(iterable, Arrays.asList(excludes));
    }

    public static <T> T randomFrom(Iterable<T> iterable, Collection<T> excludes) {
        Preconditions.checkArgument((!Iterables.isEmpty(iterable) ? 1 : 0) != 0, (Object)"Iterable cannot be empty");
        Preconditions.checkArgument((!IterableUtils.containsAll(excludes, iterable) ? 1 : 0) != 0, (Object)"Iterable only consists of the given excludes");
        ArrayList copy = Lists.newArrayList(iterable);
        Iterables.removeAll((Iterable)copy, excludes);
        return IterableUtils.randomFrom(copy);
    }

    @SafeVarargs
    public static <T> boolean containsAll(Iterable<T> iterableToCheck, T ... elementsToCheckFor) {
        return IterableUtils.containsAll(iterableToCheck, Arrays.asList(elementsToCheckFor));
    }

    public static <T> boolean containsAll(Iterable<T> iterableToCheck, Iterable<T> elementsToCheckFor) {
        return StreamSupport.stream(elementsToCheckFor.spliterator(), false).allMatch(element -> Iterables.contains((Iterable)iterableToCheck, (Object)element));
    }
}

