/*
 * Decompiled with CFR 0.152.
 */
package com.github.rkumsher.collection;

import com.github.rkumsher.collection.IterableUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public final class ArrayUtils {
    private ArrayUtils() {
    }

    public static <T> T randomFrom(T[] array) {
        Preconditions.checkArgument((boolean)org.apache.commons.lang3.ArrayUtils.isNotEmpty((Object[])array), (Object)"Array cannot be empty");
        return IterableUtils.randomFrom(Arrays.asList(array));
    }

    @SafeVarargs
    public static <T> T randomFrom(T[] array, T ... excludes) {
        return ArrayUtils.randomFrom(array, Arrays.asList(excludes));
    }

    public static <T> T randomFrom(T[] array, Collection<T> excludes) {
        Preconditions.checkArgument((boolean)org.apache.commons.lang3.ArrayUtils.isNotEmpty((Object[])array), (Object)"Array cannot be empty");
        List<T> list = Arrays.asList(array);
        ArrayList copy = Lists.newArrayList(list);
        Iterables.removeAll((Iterable)copy, excludes);
        Preconditions.checkArgument((!Iterables.isEmpty((Iterable)copy) ? 1 : 0) != 0, (Object)"Array only consists of the given excludes");
        return IterableUtils.randomFrom(list, excludes);
    }

    @SafeVarargs
    public static <T> boolean containsAll(T[] arrayToCheck, T ... elementsToCheckFor) {
        return ArrayUtils.containsAll(arrayToCheck, Arrays.asList(elementsToCheckFor));
    }

    public static <T> boolean containsAll(T[] arrayToCheck, Iterable<T> elementsToCheckFor) {
        return IterableUtils.containsAll(Arrays.asList(arrayToCheck), elementsToCheckFor);
    }
}

