/*
 * Decompiled with CFR 0.152.
 */
package com.rey.material.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.NonNull;
import com.rey.material.R;
import com.rey.material.app.ThemeManager;
import com.rey.material.drawable.CircularProgressDrawable;
import com.rey.material.drawable.LinearProgressDrawable;
import com.rey.material.util.ViewUtil;

public class ProgressView
extends View
implements ThemeManager.OnThemeChangedListener {
    protected int mStyleId;
    protected int mCurrentStyle = Integer.MIN_VALUE;
    private boolean mAutostart = false;
    private boolean mCircular = true;
    private int mProgressId;
    public static final int MODE_DETERMINATE = 0;
    public static final int MODE_INDETERMINATE = 1;
    public static final int MODE_BUFFER = 2;
    public static final int MODE_QUERY = 3;
    private Drawable mProgressDrawable;

    public ProgressView(Context context) {
        super(context);
        this.init(context, null, 0, 0);
    }

    public ProgressView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs, 0, 0);
    }

    public ProgressView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr, 0);
    }

    protected void init(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.applyStyle(context, attrs, defStyleAttr, defStyleRes);
        if (!this.isInEditMode()) {
            this.mStyleId = ThemeManager.getStyleId(context, attrs, defStyleAttr, defStyleRes);
        }
    }

    public void applyStyle(int resId) {
        ViewUtil.applyStyle(this, resId);
        this.applyStyle(this.getContext(), null, 0, resId);
    }

    private boolean needCreateProgress(boolean circular) {
        if (this.mProgressDrawable == null) {
            return true;
        }
        if (circular) {
            return !(this.mProgressDrawable instanceof CircularProgressDrawable);
        }
        return !(this.mProgressDrawable instanceof LinearProgressDrawable);
    }

    protected void applyStyle(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ProgressView, defStyleAttr, defStyleRes);
        int progressId = 0;
        int progressMode = -1;
        float progress = -1.0f;
        float secondaryProgress = -1.0f;
        int count = a.getIndexCount();
        for (int i = 0; i < count; ++i) {
            int attr2 = a.getIndex(i);
            if (attr2 == R.styleable.ProgressView_pv_autostart) {
                this.mAutostart = a.getBoolean(attr2, false);
                continue;
            }
            if (attr2 == R.styleable.ProgressView_pv_circular) {
                this.mCircular = a.getBoolean(attr2, true);
                continue;
            }
            if (attr2 == R.styleable.ProgressView_pv_progressStyle) {
                progressId = a.getResourceId(attr2, 0);
                continue;
            }
            if (attr2 == R.styleable.ProgressView_pv_progressMode) {
                progressMode = a.getInteger(attr2, 0);
                continue;
            }
            if (attr2 == R.styleable.ProgressView_pv_progress) {
                progress = a.getFloat(attr2, 0.0f);
                continue;
            }
            if (attr2 != R.styleable.ProgressView_pv_secondaryProgress) continue;
            secondaryProgress = a.getFloat(attr2, 0.0f);
        }
        a.recycle();
        boolean needStart = false;
        if (this.needCreateProgress(this.mCircular)) {
            this.mProgressId = progressId;
            if (this.mProgressId == 0) {
                this.mProgressId = this.mCircular ? R.style.Material_Drawable_CircularProgress : R.style.Material_Drawable_LinearProgress;
            }
            needStart = this.mProgressDrawable != null && ((Animatable)this.mProgressDrawable).isRunning();
            this.mProgressDrawable = this.mCircular ? new CircularProgressDrawable.Builder(context, this.mProgressId).build() : new LinearProgressDrawable.Builder(context, this.mProgressId).build();
            ViewUtil.setBackground(this, this.mProgressDrawable);
        } else if (this.mProgressId != progressId) {
            this.mProgressId = progressId;
            if (this.mProgressDrawable instanceof CircularProgressDrawable) {
                ((CircularProgressDrawable)this.mProgressDrawable).applyStyle(context, this.mProgressId);
            } else {
                ((LinearProgressDrawable)this.mProgressDrawable).applyStyle(context, this.mProgressId);
            }
        }
        if (progressMode >= 0) {
            if (this.mProgressDrawable instanceof CircularProgressDrawable) {
                ((CircularProgressDrawable)this.mProgressDrawable).setProgressMode(progressMode);
            } else {
                ((LinearProgressDrawable)this.mProgressDrawable).setProgressMode(progressMode);
            }
        }
        if (progress >= 0.0f) {
            this.setProgress(progress);
        }
        if (secondaryProgress >= 0.0f) {
            this.setSecondaryProgress(secondaryProgress);
        }
        if (needStart) {
            this.start();
        }
    }

    @Override
    public void onThemeChanged(ThemeManager.OnThemeChangedEvent event) {
        int style2 = ThemeManager.getInstance().getCurrentStyle(this.mStyleId);
        if (this.mCurrentStyle != style2) {
            this.mCurrentStyle = style2;
            this.applyStyle(this.mCurrentStyle);
        }
    }

    protected void onVisibilityChanged(@NonNull View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        if (changedView != this) {
            return;
        }
        if (this.mAutostart) {
            if (visibility == 8 || visibility == 4) {
                this.stop();
            } else {
                this.start();
            }
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.getVisibility() == 0 && this.mAutostart) {
            this.start();
        }
        if (this.mStyleId != 0) {
            ThemeManager.getInstance().registerOnThemeChangedListener(this);
            this.onThemeChanged(null);
        }
    }

    protected void onDetachedFromWindow() {
        if (this.mAutostart) {
            this.stop();
        }
        super.onDetachedFromWindow();
        if (this.mStyleId != 0) {
            ThemeManager.getInstance().unregisterOnThemeChangedListener(this);
        }
    }

    public int getProgressMode() {
        if (this.mCircular) {
            return ((CircularProgressDrawable)this.mProgressDrawable).getProgressMode();
        }
        return ((LinearProgressDrawable)this.mProgressDrawable).getProgressMode();
    }

    public float getProgress() {
        if (this.mCircular) {
            return ((CircularProgressDrawable)this.mProgressDrawable).getProgress();
        }
        return ((LinearProgressDrawable)this.mProgressDrawable).getProgress();
    }

    public float getSecondaryProgress() {
        if (this.mCircular) {
            return ((CircularProgressDrawable)this.mProgressDrawable).getSecondaryProgress();
        }
        return ((LinearProgressDrawable)this.mProgressDrawable).getSecondaryProgress();
    }

    public void setProgress(float percent) {
        if (this.mCircular) {
            ((CircularProgressDrawable)this.mProgressDrawable).setProgress(percent);
        } else {
            ((LinearProgressDrawable)this.mProgressDrawable).setProgress(percent);
        }
    }

    public void setSecondaryProgress(float percent) {
        if (this.mCircular) {
            ((CircularProgressDrawable)this.mProgressDrawable).setSecondaryProgress(percent);
        } else {
            ((LinearProgressDrawable)this.mProgressDrawable).setSecondaryProgress(percent);
        }
    }

    public void start() {
        if (this.mProgressDrawable != null) {
            ((Animatable)this.mProgressDrawable).start();
        }
    }

    public void stop() {
        if (this.mProgressDrawable != null) {
            ((Animatable)this.mProgressDrawable).stop();
        }
    }
}

