/*
 * Decompiled with CFR 0.152.
 */
package com.rey.material.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.Interpolator;
import android.widget.TextView;
import androidx.appcompat.widget.AppCompatCheckedTextView;
import com.rey.material.drawable.CircleDrawable;
import com.rey.material.util.ViewUtil;

public class CircleCheckedTextView
extends AppCompatCheckedTextView {
    private CircleDrawable mBackground;
    private OnCheckedChangeListener mCheckedChangeListener;

    public CircleCheckedTextView(Context context) {
        super(context);
        this.init(context, null, 0, 0);
    }

    public CircleCheckedTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs, 0, 0);
    }

    public CircleCheckedTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr, 0);
    }

    protected void init(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.setGravity(17);
        this.setPadding(0, 0, 0, 0);
        this.mBackground = new CircleDrawable();
        this.mBackground.setInEditMode(this.isInEditMode());
        this.mBackground.setAnimEnable(false);
        ViewUtil.setBackground((View)this, this.mBackground);
        this.mBackground.setAnimEnable(true);
    }

    public void setOnCheckedChangeListener(OnCheckedChangeListener listener) {
        this.mCheckedChangeListener = listener;
    }

    public void setTextAppearance(int resId) {
        ViewUtil.applyTextAppearance((TextView)this, resId);
    }

    public void setTextAppearance(Context context, int resId) {
        ViewUtil.applyTextAppearance((TextView)this, resId);
    }

    public void setBackgroundColor(int color) {
        this.mBackground.setColor(color);
    }

    public void setAnimDuration(int duration) {
        this.mBackground.setAnimDuration(duration);
    }

    public void setInterpolator(Interpolator in, Interpolator out) {
        this.mBackground.setInterpolator(in, out);
    }

    public void setChecked(boolean checked) {
        boolean oldCheck = this.isChecked();
        if (oldCheck != checked) {
            super.setChecked(checked);
            if (this.mCheckedChangeListener != null) {
                this.mCheckedChangeListener.onCheckedChanged(this, checked);
            }
        }
    }

    public void setCheckedImmediately(boolean checked) {
        this.mBackground.setAnimEnable(false);
        this.setChecked(checked);
        this.mBackground.setAnimEnable(true);
    }

    public static interface OnCheckedChangeListener {
        public void onCheckedChanged(CircleCheckedTextView var1, boolean var2);
    }
}

