/*
 * Decompiled with CFR 0.152.
 */
package com.rey.material.drawable;

import android.content.res.ColorStateList;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.Region;
import android.graphics.drawable.Drawable;
import androidx.core.graphics.drawable.DrawableCompat;

public class PaddingDrawable
extends Drawable
implements Drawable.Callback {
    private Drawable mDrawable;
    private int mPaddingLeft;
    private int mPaddingTop;
    private int mPaddingRight;
    private int mPaddingBottom;

    public PaddingDrawable(Drawable drawable) {
        this.setWrappedDrawable(drawable);
    }

    public void setPadding(int paddingLeft, int paddingTop, int paddingRight, int paddingBottom) {
        this.mPaddingLeft = paddingLeft;
        this.mPaddingTop = paddingTop;
        this.mPaddingRight = paddingRight;
        this.mPaddingBottom = paddingBottom;
    }

    public int getPaddingLeft() {
        return this.mPaddingLeft;
    }

    public int getPaddingTop() {
        return this.mPaddingTop;
    }

    public int getPaddingRight() {
        return this.mPaddingRight;
    }

    public int getPaddingBottom() {
        return this.mPaddingBottom;
    }

    public void draw(Canvas canvas) {
        if (this.mDrawable != null) {
            this.mDrawable.draw(canvas);
        }
    }

    protected void onBoundsChange(Rect bounds) {
        if (this.mDrawable != null) {
            this.mDrawable.setBounds(bounds.left + this.mPaddingLeft, bounds.top + this.mPaddingTop, bounds.right - this.mPaddingRight, bounds.bottom - this.mPaddingBottom);
        }
    }

    public void setChangingConfigurations(int configs) {
        if (this.mDrawable != null) {
            this.mDrawable.setChangingConfigurations(configs);
        }
    }

    public int getChangingConfigurations() {
        return this.mDrawable != null ? this.mDrawable.getChangingConfigurations() : 0;
    }

    public void setDither(boolean dither) {
        if (this.mDrawable != null) {
            this.mDrawable.setDither(dither);
        }
    }

    public void setFilterBitmap(boolean filter) {
        if (this.mDrawable != null) {
            this.mDrawable.setFilterBitmap(filter);
        }
    }

    public void setAlpha(int alpha) {
        if (this.mDrawable != null) {
            this.mDrawable.setAlpha(alpha);
        }
    }

    public void setColorFilter(ColorFilter cf) {
        if (this.mDrawable != null) {
            this.mDrawable.setColorFilter(cf);
        }
    }

    public boolean isStateful() {
        return this.mDrawable != null && this.mDrawable.isStateful();
    }

    public boolean setState(int[] stateSet) {
        return this.mDrawable != null && this.mDrawable.setState(stateSet);
    }

    public int[] getState() {
        return this.mDrawable != null ? this.mDrawable.getState() : null;
    }

    public void jumpToCurrentState() {
        if (this.mDrawable != null) {
            DrawableCompat.jumpToCurrentState((Drawable)this.mDrawable);
        }
    }

    public Drawable getCurrent() {
        return this.mDrawable != null ? this.mDrawable.getCurrent() : null;
    }

    public boolean setVisible(boolean visible, boolean restart) {
        return super.setVisible(visible, restart) || this.mDrawable != null && this.mDrawable.setVisible(visible, restart);
    }

    public int getOpacity() {
        return this.mDrawable != null ? this.mDrawable.getOpacity() : 0;
    }

    public Region getTransparentRegion() {
        return this.mDrawable != null ? this.mDrawable.getTransparentRegion() : null;
    }

    public int getIntrinsicWidth() {
        return (this.mDrawable != null ? this.mDrawable.getIntrinsicWidth() : 0) + this.mPaddingLeft + this.mPaddingRight;
    }

    public int getIntrinsicHeight() {
        return (this.mDrawable != null ? this.mDrawable.getIntrinsicHeight() : 0) + this.mPaddingTop + this.mPaddingBottom;
    }

    public int getMinimumWidth() {
        return (this.mDrawable != null ? this.mDrawable.getMinimumWidth() : 0) + this.mPaddingLeft + this.mPaddingRight;
    }

    public int getMinimumHeight() {
        return (this.mDrawable != null ? this.mDrawable.getMinimumHeight() : 0) + this.mPaddingTop + this.mPaddingBottom;
    }

    public boolean getPadding(Rect padding) {
        boolean hasPadding;
        boolean bl = hasPadding = this.mDrawable != null && this.mDrawable.getPadding(padding);
        if (hasPadding) {
            padding.left += this.mPaddingLeft;
            padding.top += this.mPaddingTop;
            padding.right += this.mPaddingRight;
            padding.bottom += this.mPaddingBottom;
        } else {
            padding.set(this.mPaddingLeft, this.mPaddingTop, this.mPaddingRight, this.mPaddingBottom);
            hasPadding = this.mPaddingLeft != 0 || this.mPaddingTop != 0 || this.mPaddingRight != 0 || this.mPaddingBottom != 0;
        }
        return hasPadding;
    }

    public void invalidateDrawable(Drawable who) {
        this.invalidateSelf();
    }

    public void scheduleDrawable(Drawable who, Runnable what, long when) {
        this.scheduleSelf(what, when);
    }

    public void unscheduleDrawable(Drawable who, Runnable what) {
        this.unscheduleSelf(what);
    }

    protected boolean onLevelChange(int level) {
        return this.mDrawable != null && this.mDrawable.setLevel(level);
    }

    public void setAutoMirrored(boolean mirrored) {
        if (this.mDrawable != null) {
            DrawableCompat.setAutoMirrored((Drawable)this.mDrawable, (boolean)mirrored);
        }
    }

    public boolean isAutoMirrored() {
        return this.mDrawable != null && DrawableCompat.isAutoMirrored((Drawable)this.mDrawable);
    }

    public void setTint(int tint) {
        if (this.mDrawable != null) {
            DrawableCompat.setTint((Drawable)this.mDrawable, (int)tint);
        }
    }

    public void setTintList(ColorStateList tint) {
        if (this.mDrawable != null) {
            DrawableCompat.setTintList((Drawable)this.mDrawable, (ColorStateList)tint);
        }
    }

    public void setTintMode(PorterDuff.Mode tintMode) {
        if (this.mDrawable != null) {
            DrawableCompat.setTintMode((Drawable)this.mDrawable, (PorterDuff.Mode)tintMode);
        }
    }

    public void setHotspot(float x, float y) {
        if (this.mDrawable != null) {
            DrawableCompat.setHotspot((Drawable)this.mDrawable, (float)x, (float)y);
        }
    }

    public void setHotspotBounds(int left, int top, int right, int bottom) {
        if (this.mDrawable != null) {
            DrawableCompat.setHotspotBounds((Drawable)this.mDrawable, (int)left, (int)top, (int)right, (int)bottom);
        }
    }

    public Drawable getWrappedDrawable() {
        return this.mDrawable;
    }

    public void setWrappedDrawable(Drawable drawable) {
        if (this.mDrawable != null) {
            this.mDrawable.setCallback(null);
        }
        this.mDrawable = drawable;
        if (drawable != null) {
            drawable.setCallback((Drawable.Callback)this);
        }
        this.onBoundsChange(this.getBounds());
        this.invalidateSelf();
    }
}

