/*
 * Decompiled with CFR 0.152.
 */
package com.rey.material.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.support.annotation.NonNull;
import android.text.format.DateFormat;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.AnimationUtils;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import com.rey.material.R;
import com.rey.material.app.ThemeManager;
import com.rey.material.util.ColorUtil;
import com.rey.material.util.ThemeUtil;
import com.rey.material.util.TypefaceUtil;
import com.rey.material.util.ViewUtil;

public class TimePicker
extends View
implements ThemeManager.OnThemeChangedListener {
    protected int mStyleId;
    protected int mCurrentStyle = Integer.MIN_VALUE;
    private int mBackgroundColor;
    private int mSelectionColor;
    private int mSelectionRadius = -1;
    private int mTickSize = -1;
    private Typeface mTypeface = Typeface.DEFAULT;
    private int mTextSize = -1;
    private int mTextColor = -16777216;
    private int mTextHighlightColor = -1;
    private boolean m24Hour = true;
    private int mAnimDuration = -1;
    private Interpolator mInInterpolator;
    private Interpolator mOutInterpolator;
    private long mStartTime;
    private float mAnimProgress;
    private boolean mRunning;
    private Paint mPaint;
    private PointF mCenterPoint;
    private float mOuterRadius;
    private float mInnerRadius;
    private float mSecondInnerRadius;
    private float[] mLocations = new float[72];
    private Rect mRect;
    private String[] mTicks;
    private int mMode = 0;
    public static final int MODE_HOUR = 0;
    public static final int MODE_MINUTE = 1;
    private int mHour = 0;
    private int mMinute = 0;
    private boolean mEdited = false;
    private OnTimeChangedListener mOnTimeChangedListener;
    private final Runnable mUpdater = new Runnable(){

        @Override
        public void run() {
            TimePicker.this.update();
        }
    };

    public TimePicker(Context context) {
        super(context);
        this.init(context, null, 0, 0);
    }

    public TimePicker(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs, 0, 0);
    }

    public TimePicker(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr, 0);
    }

    public TimePicker(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr, defStyleRes);
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.mPaint = new Paint(1);
        this.mRect = new Rect();
        this.mBackgroundColor = ColorUtil.getColor(ThemeUtil.colorPrimary(context, -16777216), 0.25f);
        this.mSelectionColor = ThemeUtil.colorPrimary(context, -16777216);
        this.initTickLabels();
        this.setWillNotDraw(false);
        this.applyStyle(context, attrs, defStyleAttr, defStyleRes);
        this.mStyleId = ThemeManager.getStyleId(context, attrs, defStyleAttr, defStyleRes);
    }

    private void initTickLabels() {
        int i;
        String format = "%2d";
        this.mTicks = new String[36];
        for (i = 0; i < 23; ++i) {
            this.mTicks[i] = String.format(format, i + 1);
        }
        this.mTicks[23] = String.format(format, 0);
        this.mTicks[35] = this.mTicks[23];
        for (i = 24; i < 35; ++i) {
            this.mTicks[i] = String.format(format, (i - 23) * 5);
        }
    }

    public void applyStyle(int styleId) {
        ViewUtil.applyStyle(this, styleId);
        this.applyStyle(this.getContext(), null, 0, styleId);
    }

    protected void applyStyle(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.TimePicker, defStyleAttr, defStyleRes);
        boolean hourDefined = false;
        String familyName = null;
        int style2 = -1;
        int count = a.getIndexCount();
        for (int i = 0; i < count; ++i) {
            int attr2 = a.getIndex(i);
            if (attr2 == R.styleable.TimePicker_tp_backgroundColor) {
                this.mBackgroundColor = a.getColor(attr2, 0);
                continue;
            }
            if (attr2 == R.styleable.TimePicker_tp_selectionColor) {
                this.mSelectionColor = a.getColor(attr2, 0);
                continue;
            }
            if (attr2 == R.styleable.TimePicker_tp_selectionRadius) {
                this.mSelectionRadius = a.getDimensionPixelOffset(attr2, 0);
                continue;
            }
            if (attr2 == R.styleable.TimePicker_tp_tickSize) {
                this.mTickSize = a.getDimensionPixelOffset(attr2, 0);
                continue;
            }
            if (attr2 == R.styleable.TimePicker_tp_textSize) {
                this.mTextSize = a.getDimensionPixelOffset(attr2, 0);
                continue;
            }
            if (attr2 == R.styleable.TimePicker_tp_textColor) {
                this.mTextColor = a.getColor(attr2, 0);
                continue;
            }
            if (attr2 == R.styleable.TimePicker_tp_textHighlightColor) {
                this.mTextHighlightColor = a.getColor(attr2, 0);
                continue;
            }
            if (attr2 == R.styleable.TimePicker_tp_animDuration) {
                this.mAnimDuration = a.getInteger(attr2, 0);
                continue;
            }
            if (attr2 == R.styleable.TimePicker_tp_inInterpolator) {
                this.mInInterpolator = AnimationUtils.loadInterpolator((Context)context, (int)a.getResourceId(attr2, 0));
                continue;
            }
            if (attr2 == R.styleable.TimePicker_tp_outInterpolator) {
                this.mOutInterpolator = AnimationUtils.loadInterpolator((Context)context, (int)a.getResourceId(attr2, 0));
                continue;
            }
            if (attr2 == R.styleable.TimePicker_tp_mode) {
                this.setMode(a.getInteger(attr2, 0), false);
                continue;
            }
            if (attr2 == R.styleable.TimePicker_tp_24Hour) {
                this.set24Hour(a.getBoolean(attr2, false));
                hourDefined = true;
                continue;
            }
            if (attr2 == R.styleable.TimePicker_tp_hour) {
                this.setHour(a.getInteger(attr2, 0));
                continue;
            }
            if (attr2 == R.styleable.TimePicker_tp_minute) {
                this.setMinute(a.getInteger(attr2, 0));
                continue;
            }
            if (attr2 == R.styleable.TimePicker_tp_fontFamily) {
                familyName = a.getString(attr2);
                continue;
            }
            if (attr2 != R.styleable.TimePicker_tp_textStyle) continue;
            style2 = a.getInteger(attr2, 0);
        }
        a.recycle();
        if (this.mSelectionRadius < 0) {
            this.mSecondInnerRadius = ThemeUtil.dpToPx(context, 8);
        }
        if (this.mTickSize < 0) {
            this.mTickSize = ThemeUtil.dpToPx(context, 1);
        }
        if (this.mTextSize < 0) {
            this.mTextSize = context.getResources().getDimensionPixelOffset(R.dimen.abc_text_size_caption_material);
        }
        if (this.mAnimDuration < 0) {
            this.mAnimDuration = context.getResources().getInteger(0x10E0001);
        }
        if (this.mInInterpolator == null) {
            this.mInInterpolator = new DecelerateInterpolator();
        }
        if (this.mOutInterpolator == null) {
            this.mOutInterpolator = new DecelerateInterpolator();
        }
        if (!hourDefined) {
            this.set24Hour(DateFormat.is24HourFormat((Context)context));
        }
        if (familyName != null || style2 >= 0) {
            this.mTypeface = TypefaceUtil.load(context, familyName, style2);
        }
    }

    @Override
    public void onThemeChanged(ThemeManager.OnThemeChangedEvent event) {
        int style2 = ThemeManager.getInstance().getCurrentStyle(this.mStyleId);
        if (this.mCurrentStyle != style2) {
            this.mCurrentStyle = style2;
            this.applyStyle(this.mCurrentStyle);
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mStyleId != 0) {
            ThemeManager.getInstance().registerOnThemeChangedListener(this);
            this.onThemeChanged(null);
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mStyleId != 0) {
            ThemeManager.getInstance().unregisterOnThemeChangedListener(this);
        }
    }

    public int getBackgroundColor() {
        return this.mBackgroundColor;
    }

    public int getSelectionColor() {
        return this.mSelectionColor;
    }

    public Typeface getTypeface() {
        return this.mTypeface;
    }

    public int getTextSize() {
        return this.mTextSize;
    }

    public int getTextColor() {
        return this.mTextColor;
    }

    public int getTextHighlightColor() {
        return this.mTextHighlightColor;
    }

    public int getAnimDuration() {
        return this.mAnimDuration;
    }

    public Interpolator getInInterpolator() {
        return this.mInInterpolator;
    }

    public Interpolator getOutInterpolator() {
        return this.mOutInterpolator;
    }

    public int getMode() {
        return this.mMode;
    }

    public int getHour() {
        return this.mHour;
    }

    public int getMinute() {
        return this.mMinute;
    }

    public boolean is24Hour() {
        return this.m24Hour;
    }

    public void setMode(int mode, boolean animation) {
        if (this.mMode != mode) {
            this.mMode = mode;
            if (this.mOnTimeChangedListener != null) {
                this.mOnTimeChangedListener.onModeChanged(this.mMode);
            }
            if (animation) {
                this.startAnimation();
            } else {
                this.invalidate();
            }
        }
    }

    public void setHour(int hour) {
        hour = this.m24Hour ? Math.max(hour, 0) % 24 : Math.max(hour, 0) % 12;
        if (this.mHour != hour) {
            int old = this.mHour;
            this.mHour = hour;
            if (this.mOnTimeChangedListener != null) {
                this.mOnTimeChangedListener.onHourChanged(old, this.mHour);
            }
            if (this.mMode == 0) {
                this.invalidate();
            }
        }
    }

    public void setMinute(int minute) {
        if (this.mMinute != (minute = Math.min(Math.max(minute, 0), 59))) {
            int old = this.mMinute;
            this.mMinute = minute;
            if (this.mOnTimeChangedListener != null) {
                this.mOnTimeChangedListener.onMinuteChanged(old, this.mMinute);
            }
            if (this.mMode == 1) {
                this.invalidate();
            }
        }
    }

    public void setOnTimeChangedListener(OnTimeChangedListener listener) {
        this.mOnTimeChangedListener = listener;
    }

    public void set24Hour(boolean b) {
        if (this.m24Hour != b) {
            this.m24Hour = b;
            if (!this.m24Hour && this.mHour > 11) {
                this.setHour(this.mHour - 12);
            }
            this.calculateTextLocation();
        }
    }

    private float getAngle(int value, int mode) {
        switch (mode) {
            case 0: {
                return (float)(-1.5707963267948966 + 0.5235987755982988 * (double)value);
            }
            case 1: {
                return (float)(-1.5707963267948966 + 0.10471975511965977 * (double)value);
            }
        }
        return 0.0f;
    }

    private int getSelectedTick(int value, int mode) {
        switch (mode) {
            case 0: {
                return value == 0 ? (this.m24Hour ? 23 : 11) : value - 1;
            }
            case 1: {
                if (value % 5 != 0) break;
                return value == 0 ? 35 : value / 5 + 23;
            }
        }
        return -1;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = widthMode == 0 ? this.mSelectionRadius * 12 : View.MeasureSpec.getSize((int)widthMeasureSpec) - this.getPaddingLeft() - this.getPaddingRight();
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = heightMode == 0 ? this.mSelectionRadius * 12 : View.MeasureSpec.getSize((int)heightMeasureSpec) - this.getPaddingTop() - this.getPaddingBottom();
        int size = Math.min(widthSize, heightSize);
        int width = widthMode == 0x40000000 ? widthSize : size;
        int height = heightMode == 0x40000000 ? heightSize : size;
        this.setMeasuredDimension(width + this.getPaddingLeft() + this.getPaddingRight(), height + this.getPaddingTop() + this.getPaddingBottom());
    }

    private void calculateTextLocation() {
        if (this.mCenterPoint == null) {
            return;
        }
        double step = 0.5235987755982988;
        double angle = -1.0471975511965976;
        this.mPaint.setTextSize((float)this.mTextSize);
        this.mPaint.setTypeface(this.mTypeface);
        this.mPaint.setTextAlign(Paint.Align.CENTER);
        if (this.m24Hour) {
            float y;
            float x;
            int i;
            for (i = 0; i < 12; ++i) {
                this.mPaint.getTextBounds(this.mTicks[i], 0, this.mTicks[i].length(), this.mRect);
                if (i == 0) {
                    this.mSecondInnerRadius = this.mInnerRadius - (float)this.mSelectionRadius - (float)this.mRect.height();
                }
                x = this.mCenterPoint.x + (float)Math.cos(angle) * this.mSecondInnerRadius;
                y = this.mCenterPoint.y + (float)Math.sin(angle) * this.mSecondInnerRadius;
                this.mLocations[i * 2] = x;
                this.mLocations[i * 2 + 1] = y + (float)this.mRect.height() / 2.0f;
                angle += step;
            }
            for (i = 12; i < this.mTicks.length; ++i) {
                x = this.mCenterPoint.x + (float)Math.cos(angle) * this.mInnerRadius;
                y = this.mCenterPoint.y + (float)Math.sin(angle) * this.mInnerRadius;
                this.mPaint.getTextBounds(this.mTicks[i], 0, this.mTicks[i].length(), this.mRect);
                this.mLocations[i * 2] = x;
                this.mLocations[i * 2 + 1] = y + (float)this.mRect.height() / 2.0f;
                angle += step;
            }
        } else {
            float y;
            float x;
            int i;
            for (i = 0; i < 12; ++i) {
                x = this.mCenterPoint.x + (float)Math.cos(angle) * this.mInnerRadius;
                y = this.mCenterPoint.y + (float)Math.sin(angle) * this.mInnerRadius;
                this.mPaint.getTextBounds(this.mTicks[i], 0, this.mTicks[i].length(), this.mRect);
                this.mLocations[i * 2] = x;
                this.mLocations[i * 2 + 1] = y + (float)this.mRect.height() / 2.0f;
                angle += step;
            }
            for (i = 24; i < this.mTicks.length; ++i) {
                x = this.mCenterPoint.x + (float)Math.cos(angle) * this.mInnerRadius;
                y = this.mCenterPoint.y + (float)Math.sin(angle) * this.mInnerRadius;
                this.mPaint.getTextBounds(this.mTicks[i], 0, this.mTicks[i].length(), this.mRect);
                this.mLocations[i * 2] = x;
                this.mLocations[i * 2 + 1] = y + (float)this.mRect.height() / 2.0f;
                angle += step;
            }
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        int left = this.getPaddingLeft();
        int top = this.getPaddingTop();
        int size = Math.min(w - this.getPaddingLeft() - this.getPaddingRight(), h - this.getPaddingTop() - this.getPaddingBottom());
        if (this.mCenterPoint == null) {
            this.mCenterPoint = new PointF();
        }
        this.mOuterRadius = (float)size / 2.0f;
        this.mCenterPoint.set((float)left + this.mOuterRadius, (float)top + this.mOuterRadius);
        this.mInnerRadius = this.mOuterRadius - (float)this.mSelectionRadius - (float)ThemeUtil.dpToPx(this.getContext(), 4);
        this.calculateTextLocation();
    }

    private int getPointedValue(float x, float y, boolean isDown) {
        float radius = (float)Math.sqrt(Math.pow(x - this.mCenterPoint.x, 2.0) + Math.pow(y - this.mCenterPoint.y, 2.0));
        if (isDown && (this.mMode == 0 && this.m24Hour ? radius > this.mInnerRadius + (float)this.mSelectionRadius || radius < this.mSecondInnerRadius - (float)this.mSelectionRadius : radius > this.mInnerRadius + (float)this.mSelectionRadius || radius < this.mInnerRadius - (float)this.mSelectionRadius)) {
            return -1;
        }
        float angle = (float)Math.atan2(y - this.mCenterPoint.y, x - this.mCenterPoint.x);
        if (angle < 0.0f) {
            angle = (float)((double)angle + Math.PI * 2);
        }
        if (this.mMode == 0) {
            if (this.m24Hour) {
                if (radius > this.mSecondInnerRadius + (float)(this.mSelectionRadius / 2)) {
                    int value = (int)Math.round((double)(angle * 6.0f) / Math.PI) + 15;
                    if (value == 24) {
                        return 0;
                    }
                    if (value > 24) {
                        return value - 12;
                    }
                    return value;
                }
                int value = (int)Math.round((double)(angle * 6.0f) / Math.PI) + 3;
                return value > 12 ? value - 12 : value;
            }
            int value = (int)Math.round((double)(angle * 6.0f) / Math.PI) + 3;
            return value > 11 ? value - 12 : value;
        }
        if (this.mMode == 1) {
            int value = (int)Math.round((double)(angle * 30.0f) / Math.PI) + 15;
            return value > 59 ? value - 60 : value;
        }
        return -1;
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                int value = this.getPointedValue(event.getX(), event.getY(), true);
                if (value < 0) {
                    return false;
                }
                if (this.mMode == 0) {
                    this.setHour(value);
                } else if (this.mMode == 1) {
                    this.setMinute(value);
                }
                this.mEdited = true;
                return true;
            }
            case 2: {
                int value = this.getPointedValue(event.getX(), event.getY(), false);
                if (value < 0) {
                    return true;
                }
                if (this.mMode == 0) {
                    this.setHour(value);
                } else if (this.mMode == 1) {
                    this.setMinute(value);
                }
                this.mEdited = true;
                return true;
            }
            case 1: {
                if (!this.mEdited || this.mMode != 0) break;
                this.setMode(1, true);
                this.mEdited = false;
                return true;
            }
            case 3: {
                this.mEdited = false;
            }
        }
        return false;
    }

    public void draw(Canvas canvas) {
        super.draw(canvas);
        this.mPaint.setColor(this.mBackgroundColor);
        this.mPaint.setStyle(Paint.Style.FILL);
        canvas.drawCircle(this.mCenterPoint.x, this.mCenterPoint.y, this.mOuterRadius, this.mPaint);
        if (!this.mRunning) {
            float radius;
            int length;
            int start;
            int selectedTick;
            float angle;
            if (this.mMode == 0) {
                angle = this.getAngle(this.mHour, 0);
                selectedTick = this.getSelectedTick(this.mHour, 0);
                start = 0;
                length = this.m24Hour ? 24 : 12;
                radius = this.m24Hour && selectedTick < 12 ? this.mSecondInnerRadius : this.mInnerRadius;
            } else {
                angle = this.getAngle(this.mMinute, 1);
                selectedTick = this.getSelectedTick(this.mMinute, 1);
                start = 24;
                length = 12;
                radius = this.mInnerRadius;
            }
            this.mPaint.setColor(this.mSelectionColor);
            float x = this.mCenterPoint.x + (float)Math.cos(angle) * radius;
            float y = this.mCenterPoint.y + (float)Math.sin(angle) * radius;
            canvas.drawCircle(x, y, (float)this.mSelectionRadius, this.mPaint);
            this.mPaint.setStyle(Paint.Style.STROKE);
            this.mPaint.setStrokeWidth((float)this.mTickSize);
            canvas.drawLine(this.mCenterPoint.x, this.mCenterPoint.y, x -= (float)Math.cos(angle) * (float)this.mSelectionRadius, y -= (float)Math.sin(angle) * (float)this.mSelectionRadius, this.mPaint);
            this.mPaint.setStyle(Paint.Style.FILL);
            this.mPaint.setColor(this.mTextColor);
            canvas.drawCircle(this.mCenterPoint.x, this.mCenterPoint.y, (float)(this.mTickSize * 2), this.mPaint);
            this.mPaint.setTextSize((float)this.mTextSize);
            this.mPaint.setTypeface(this.mTypeface);
            this.mPaint.setTextAlign(Paint.Align.CENTER);
            for (int i = 0; i < length; ++i) {
                int index = start + i;
                this.mPaint.setColor(index == selectedTick ? this.mTextHighlightColor : this.mTextColor);
                canvas.drawText(this.mTicks[index], this.mLocations[index * 2], this.mLocations[index * 2 + 1], this.mPaint);
            }
        } else {
            int index;
            int i;
            float inRadius;
            int inLength;
            int inStart;
            float outRadius;
            int outLength;
            int outStart;
            int inSelectedTick;
            int outSelectedTick;
            float inOffset;
            float outOffset;
            float inAngle;
            float outAngle;
            float maxOffset = this.mOuterRadius - this.mInnerRadius + (float)(this.mTextSize / 2);
            int textOutColor = ColorUtil.getColor(this.mTextColor, 1.0f - this.mAnimProgress);
            int textHighlightOutColor = ColorUtil.getColor(this.mTextHighlightColor, 1.0f - this.mAnimProgress);
            int textInColor = ColorUtil.getColor(this.mTextColor, this.mAnimProgress);
            int textHighlightInColor = ColorUtil.getColor(this.mTextHighlightColor, this.mAnimProgress);
            if (this.mMode == 1) {
                outAngle = this.getAngle(this.mHour, 0);
                inAngle = this.getAngle(this.mMinute, 1);
                outOffset = this.mOutInterpolator.getInterpolation(this.mAnimProgress) * maxOffset;
                inOffset = (1.0f - this.mInInterpolator.getInterpolation(this.mAnimProgress)) * -maxOffset;
                outSelectedTick = this.getSelectedTick(this.mHour, 0);
                inSelectedTick = this.getSelectedTick(this.mMinute, 1);
                outStart = 0;
                outLength = this.m24Hour ? 24 : 12;
                outRadius = this.m24Hour && outSelectedTick < 12 ? this.mSecondInnerRadius : this.mInnerRadius;
                inStart = 24;
                inLength = 12;
                inRadius = this.mInnerRadius;
            } else {
                outAngle = this.getAngle(this.mMinute, 1);
                inAngle = this.getAngle(this.mHour, 0);
                outOffset = this.mOutInterpolator.getInterpolation(this.mAnimProgress) * -maxOffset;
                inOffset = (1.0f - this.mInInterpolator.getInterpolation(this.mAnimProgress)) * maxOffset;
                outSelectedTick = this.getSelectedTick(this.mMinute, 1);
                inSelectedTick = this.getSelectedTick(this.mHour, 0);
                outStart = 24;
                outLength = 12;
                outRadius = this.mInnerRadius;
                inStart = 0;
                inLength = this.m24Hour ? 24 : 12;
                inRadius = this.m24Hour && inSelectedTick < 12 ? this.mSecondInnerRadius : this.mInnerRadius;
            }
            this.mPaint.setColor(ColorUtil.getColor(this.mSelectionColor, 1.0f - this.mAnimProgress));
            float x = this.mCenterPoint.x + (float)Math.cos(outAngle) * (outRadius + outOffset);
            float y = this.mCenterPoint.y + (float)Math.sin(outAngle) * (outRadius + outOffset);
            canvas.drawCircle(x, y, (float)this.mSelectionRadius, this.mPaint);
            this.mPaint.setStyle(Paint.Style.STROKE);
            this.mPaint.setStrokeWidth((float)this.mTickSize);
            canvas.drawLine(this.mCenterPoint.x, this.mCenterPoint.y, x -= (float)Math.cos(outAngle) * (float)this.mSelectionRadius, y -= (float)Math.sin(outAngle) * (float)this.mSelectionRadius, this.mPaint);
            this.mPaint.setStyle(Paint.Style.FILL);
            this.mPaint.setColor(ColorUtil.getColor(this.mSelectionColor, this.mAnimProgress));
            x = this.mCenterPoint.x + (float)Math.cos(inAngle) * (inRadius + inOffset);
            y = this.mCenterPoint.y + (float)Math.sin(inAngle) * (inRadius + inOffset);
            canvas.drawCircle(x, y, (float)this.mSelectionRadius, this.mPaint);
            this.mPaint.setStyle(Paint.Style.STROKE);
            this.mPaint.setStrokeWidth((float)this.mTickSize);
            canvas.drawLine(this.mCenterPoint.x, this.mCenterPoint.y, x -= (float)Math.cos(inAngle) * (float)this.mSelectionRadius, y -= (float)Math.sin(inAngle) * (float)this.mSelectionRadius, this.mPaint);
            this.mPaint.setStyle(Paint.Style.FILL);
            this.mPaint.setColor(this.mTextColor);
            canvas.drawCircle(this.mCenterPoint.x, this.mCenterPoint.y, (float)(this.mTickSize * 2), this.mPaint);
            this.mPaint.setTextSize((float)this.mTextSize);
            this.mPaint.setTypeface(this.mTypeface);
            this.mPaint.setTextAlign(Paint.Align.CENTER);
            double step = 0.5235987755982988;
            double angle = -1.0471975511965976;
            for (i = 0; i < outLength; ++i) {
                index = i + outStart;
                x = this.mLocations[index * 2] + (float)Math.cos(angle) * outOffset;
                y = this.mLocations[index * 2 + 1] + (float)Math.sin(angle) * outOffset;
                this.mPaint.setColor(index == outSelectedTick ? textHighlightOutColor : textOutColor);
                canvas.drawText(this.mTicks[index], x, y, this.mPaint);
                angle += step;
            }
            for (i = 0; i < inLength; ++i) {
                index = i + inStart;
                x = this.mLocations[index * 2] + (float)Math.cos(angle) * inOffset;
                y = this.mLocations[index * 2 + 1] + (float)Math.sin(angle) * inOffset;
                this.mPaint.setColor(index == inSelectedTick ? textHighlightInColor : textInColor);
                canvas.drawText(this.mTicks[index], x, y, this.mPaint);
                angle += step;
            }
        }
    }

    private void resetAnimation() {
        this.mStartTime = SystemClock.uptimeMillis();
        this.mAnimProgress = 0.0f;
    }

    private void startAnimation() {
        if (this.getHandler() != null) {
            this.resetAnimation();
            this.mRunning = true;
            this.getHandler().postAtTime(this.mUpdater, SystemClock.uptimeMillis() + 16L);
        }
        this.invalidate();
    }

    private void stopAnimation() {
        this.mRunning = false;
        this.mAnimProgress = 1.0f;
        if (this.getHandler() != null) {
            this.getHandler().removeCallbacks(this.mUpdater);
        }
        this.invalidate();
    }

    private void update() {
        long curTime = SystemClock.uptimeMillis();
        this.mAnimProgress = Math.min(1.0f, (float)(curTime - this.mStartTime) / (float)this.mAnimDuration);
        if (this.mAnimProgress == 1.0f) {
            this.stopAnimation();
        }
        if (this.mRunning) {
            if (this.getHandler() != null) {
                this.getHandler().postAtTime(this.mUpdater, SystemClock.uptimeMillis() + 16L);
            } else {
                this.stopAnimation();
            }
        }
        this.invalidate();
    }

    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.mode = this.mMode;
        ss.hour = this.mHour;
        ss.minute = this.mMinute;
        ss.is24Hour = this.m24Hour;
        return ss;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.set24Hour(ss.is24Hour);
        this.setMode(ss.mode, false);
        this.setHour(ss.hour);
        this.setMinute(ss.minute);
    }

    static class SavedState
    extends View.BaseSavedState {
        int mode;
        int hour;
        int minute;
        boolean is24Hour;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.mode = in.readInt();
            this.hour = in.readInt();
            this.minute = in.readInt();
            this.is24Hour = in.readInt() == 1;
        }

        public void writeToParcel(@NonNull Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeValue((Object)this.mode);
            out.writeValue((Object)this.hour);
            out.writeValue((Object)this.minute);
            out.writeValue((Object)(this.is24Hour ? 1 : 0));
        }

        public String toString() {
            return "TimePicker.SavedState{" + Integer.toHexString(System.identityHashCode((Object)this)) + " mode=" + this.mode + " hour=" + this.hour + " minute=" + this.minute + "24hour=" + this.is24Hour + "}";
        }
    }

    public static interface OnTimeChangedListener {
        public void onModeChanged(int var1);

        public void onHourChanged(int var1, int var2);

        public void onMinuteChanged(int var1, int var2);
    }
}

