/*
 * Decompiled with CFR 0.152.
 */
package com.rey.material.widget;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.support.annotation.NonNull;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.HorizontalScrollView;
import android.widget.LinearLayout;
import com.rey.material.R;
import com.rey.material.app.ThemeManager;
import com.rey.material.drawable.RippleDrawable;
import com.rey.material.util.ThemeUtil;
import com.rey.material.util.ViewUtil;
import com.rey.material.widget.CheckedTextView;

@TargetApi(value=16)
public class TabPageIndicator
extends HorizontalScrollView
implements ViewPager.OnPageChangeListener,
View.OnClickListener,
ThemeManager.OnThemeChangedListener {
    protected int mStyleId;
    protected int mCurrentStyle = Integer.MIN_VALUE;
    private TabContainerLayout mTabContainer;
    private ViewPager mViewPager;
    private int mMode;
    private int mTabPadding = -1;
    private int mTabRippleStyle = 0;
    private int mTextAppearance = 0;
    private boolean mTabSingleLine = true;
    private int mIndicatorOffset;
    private int mIndicatorWidth;
    private int mIndicatorHeight = -1;
    private Paint mPaint;
    public static final int MODE_SCROLL = 0;
    public static final int MODE_FIXED = 1;
    private int mSelectedPosition;
    private boolean mScrolling = false;
    private boolean mIsRtl = false;
    private Runnable mTabAnimSelector;
    private ViewPager.OnPageChangeListener mListener;
    private DataSetObserver mObserver = new DataSetObserver(){

        public void onChanged() {
            TabPageIndicator.this.notifyDataSetChanged();
        }

        public void onInvalidated() {
            TabPageIndicator.this.notifyDataSetInvalidated();
        }
    };

    public TabPageIndicator(Context context) {
        super(context);
        this.init(context, null, 0, 0);
    }

    public TabPageIndicator(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs, 0, 0);
    }

    public TabPageIndicator(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr, 0);
    }

    public TabPageIndicator(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr, defStyleRes);
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.setHorizontalScrollBarEnabled(false);
        this.mPaint = new Paint(1);
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setColor(ThemeUtil.colorAccent(context, -1));
        this.mTabContainer = new TabContainerLayout(context);
        this.applyStyle(context, attrs, defStyleAttr, defStyleRes);
        if (this.isInEditMode()) {
            this.addTemporaryTab();
        }
        this.mStyleId = ThemeManager.getStyleId(context, attrs, defStyleAttr, defStyleRes);
    }

    public void applyStyle(int resId) {
        ViewUtil.applyStyle((View)this, resId);
        this.applyStyle(this.getContext(), null, 0, resId);
    }

    protected void applyStyle(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        int i;
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.TabPageIndicator, defStyleAttr, defStyleRes);
        int textAppearance = 0;
        int mode = -1;
        int rippleStyle = 0;
        int count = a.getIndexCount();
        for (i = 0; i < count; ++i) {
            int attr2 = a.getIndex(i);
            if (attr2 == R.styleable.TabPageIndicator_tpi_tabPadding) {
                this.mTabPadding = a.getDimensionPixelSize(attr2, 0);
                continue;
            }
            if (attr2 == R.styleable.TabPageIndicator_tpi_tabRipple) {
                rippleStyle = a.getResourceId(attr2, 0);
                continue;
            }
            if (attr2 == R.styleable.TabPageIndicator_tpi_indicatorColor) {
                this.mPaint.setColor(a.getColor(attr2, 0));
                continue;
            }
            if (attr2 == R.styleable.TabPageIndicator_tpi_indicatorHeight) {
                this.mIndicatorHeight = a.getDimensionPixelSize(attr2, 0);
                continue;
            }
            if (attr2 == R.styleable.TabPageIndicator_tpi_tabSingleLine) {
                this.mTabSingleLine = a.getBoolean(attr2, true);
                continue;
            }
            if (attr2 == R.styleable.TabPageIndicator_android_textAppearance) {
                textAppearance = a.getResourceId(attr2, 0);
                continue;
            }
            if (attr2 != R.styleable.TabPageIndicator_tpi_mode) continue;
            mode = a.getInteger(attr2, 0);
        }
        a.recycle();
        if (this.mTabPadding < 0) {
            this.mTabPadding = ThemeUtil.dpToPx(context, 12);
        }
        if (this.mIndicatorHeight < 0) {
            this.mIndicatorHeight = ThemeUtil.dpToPx(context, 2);
        }
        if (mode >= 0 && (this.mMode != mode || this.getChildCount() == 0)) {
            this.mMode = mode;
            this.removeAllViews();
            if (this.mMode == 0) {
                this.addView((View)this.mTabContainer, new ViewGroup.LayoutParams(-2, -1));
                this.setFillViewport(false);
            } else if (this.mMode == 1) {
                this.addView((View)this.mTabContainer, new ViewGroup.LayoutParams(-1, -1));
                this.setFillViewport(true);
            }
        }
        if (textAppearance != 0 && this.mTextAppearance != textAppearance) {
            this.mTextAppearance = textAppearance;
            count = this.mTabContainer.getChildCount();
            for (i = 0; i < count; ++i) {
                CheckedTextView tv = (CheckedTextView)this.mTabContainer.getChildAt(i);
                tv.setTextAppearance(context, this.mTextAppearance);
            }
        }
        if (rippleStyle != 0 && rippleStyle != this.mTabRippleStyle) {
            this.mTabRippleStyle = rippleStyle;
            count = this.mTabContainer.getChildCount();
            for (i = 0; i < count; ++i) {
                ViewUtil.setBackground(this.mTabContainer.getChildAt(i), new RippleDrawable.Builder(this.getContext(), this.mTabRippleStyle).build());
            }
        }
        if (this.mViewPager != null) {
            this.notifyDataSetChanged();
        }
        this.requestLayout();
    }

    @Override
    public void onThemeChanged(ThemeManager.OnThemeChangedEvent event) {
        int style2 = ThemeManager.getInstance().getCurrentStyle(this.mStyleId);
        if (this.mCurrentStyle != style2) {
            this.mCurrentStyle = style2;
            this.applyStyle(this.mCurrentStyle);
        }
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mTabAnimSelector != null) {
            this.post(this.mTabAnimSelector);
        }
        if (this.mStyleId != 0) {
            ThemeManager.getInstance().registerOnThemeChangedListener(this);
            this.onThemeChanged(null);
        }
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mTabAnimSelector != null) {
            this.removeCallbacks(this.mTabAnimSelector);
        }
        if (this.mStyleId != 0) {
            ThemeManager.getInstance().unregisterOnThemeChangedListener(this);
        }
    }

    public void onRtlPropertiesChanged(int layoutDirection) {
        boolean rtl;
        boolean bl = rtl = layoutDirection == 1;
        if (this.mIsRtl != rtl) {
            this.mIsRtl = rtl;
            this.invalidate();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int ws = widthMeasureSpec;
        if (ws != 0) {
            ws = View.MeasureSpec.makeMeasureSpec((int)(widthSize - this.getPaddingLeft() - this.getPaddingRight()), (int)widthMode);
        }
        int hs = heightMeasureSpec;
        if (heightMode != 0) {
            hs = View.MeasureSpec.makeMeasureSpec((int)(heightSize - this.getPaddingTop() - this.getPaddingBottom()), (int)heightMode);
        }
        this.mTabContainer.measure(ws, hs);
        int width = 0;
        switch (widthMode) {
            case 0: {
                width = this.mTabContainer.getMeasuredWidth() + this.getPaddingLeft() + this.getPaddingRight();
                break;
            }
            case -2147483648: {
                width = Math.min(this.mTabContainer.getMeasuredWidth() + this.getPaddingLeft() + this.getPaddingRight(), widthSize);
                break;
            }
            case 0x40000000: {
                width = widthSize;
            }
        }
        int height = 0;
        switch (heightMode) {
            case 0: {
                height = this.mTabContainer.getMeasuredHeight() + this.getPaddingTop() + this.getPaddingBottom();
                break;
            }
            case -2147483648: {
                height = Math.min(this.mTabContainer.getMeasuredHeight() + this.getPaddingTop() + this.getPaddingBottom(), heightSize);
                break;
            }
            case 0x40000000: {
                height = heightSize;
            }
        }
        if (this.mTabContainer.getMeasuredWidth() != width - this.getPaddingLeft() - this.getPaddingRight() || this.mTabContainer.getMeasuredHeight() != height - this.getPaddingTop() - this.getPaddingBottom()) {
            this.mTabContainer.measure(View.MeasureSpec.makeMeasureSpec((int)(width - this.getPaddingLeft() - this.getPaddingRight()), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)(height - this.getPaddingTop() - this.getPaddingBottom()), (int)0x40000000));
        }
        this.setMeasuredDimension(width, height);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        CheckedTextView tv = this.getTabView(this.mSelectedPosition);
        if (tv != null) {
            this.updateIndicator(tv.getLeft(), tv.getMeasuredWidth());
        }
    }

    private CheckedTextView getTabView(int position) {
        return (CheckedTextView)this.mTabContainer.getChildAt(position);
    }

    private void animateToTab(final int position) {
        if (this.getTabView(position) == null) {
            return;
        }
        if (this.mTabAnimSelector != null) {
            this.removeCallbacks(this.mTabAnimSelector);
        }
        this.mTabAnimSelector = new Runnable(){

            @Override
            public void run() {
                CheckedTextView tv = TabPageIndicator.this.getTabView(position);
                if (!TabPageIndicator.this.mScrolling) {
                    TabPageIndicator.this.updateIndicator(tv.getLeft(), tv.getMeasuredWidth());
                }
                TabPageIndicator.this.smoothScrollTo(tv.getLeft() - (TabPageIndicator.this.getWidth() - tv.getWidth()) / 2 + TabPageIndicator.this.getPaddingLeft(), 0);
                TabPageIndicator.this.mTabAnimSelector = null;
            }
        };
        this.post(this.mTabAnimSelector);
    }

    public void setOnPageChangeListener(ViewPager.OnPageChangeListener listener) {
        this.mListener = listener;
    }

    public void setViewPager(ViewPager view) {
        PagerAdapter adapter;
        if (this.mViewPager == view) {
            return;
        }
        if (this.mViewPager != null) {
            this.mViewPager.removeOnPageChangeListener((ViewPager.OnPageChangeListener)this);
            adapter = view.getAdapter();
            if (adapter != null) {
                adapter.unregisterDataSetObserver(this.mObserver);
            }
        }
        if ((adapter = view.getAdapter()) == null) {
            throw new IllegalStateException("ViewPager does not have adapter instance.");
        }
        adapter.registerDataSetObserver(this.mObserver);
        this.mViewPager = view;
        view.addOnPageChangeListener((ViewPager.OnPageChangeListener)this);
        this.notifyDataSetChanged();
        this.onPageSelected(this.mViewPager.getCurrentItem());
    }

    public void setViewPager(ViewPager view, int initialPosition) {
        this.setViewPager(view);
        this.setCurrentItem(initialPosition);
    }

    private void updateIndicator(int offset, int width) {
        this.mIndicatorOffset = offset;
        this.mIndicatorWidth = width;
        this.invalidate();
    }

    public void draw(@NonNull Canvas canvas) {
        super.draw(canvas);
        int x = this.mIndicatorOffset + this.getPaddingLeft();
        canvas.drawRect((float)x, (float)(this.getHeight() - this.mIndicatorHeight), (float)(x + this.mIndicatorWidth), (float)this.getHeight(), this.mPaint);
        if (this.isInEditMode()) {
            canvas.drawRect((float)this.getPaddingLeft(), (float)(this.getHeight() - this.mIndicatorHeight), (float)(this.getPaddingLeft() + this.mTabContainer.getChildAt(0).getWidth()), (float)this.getHeight(), this.mPaint);
        }
    }

    public void onPageScrollStateChanged(int state) {
        if (state == 0) {
            this.mScrolling = false;
            CheckedTextView tv = this.getTabView(this.mSelectedPosition);
            if (tv != null) {
                this.updateIndicator(tv.getLeft(), tv.getMeasuredWidth());
            }
        } else {
            this.mScrolling = true;
        }
        if (this.mListener != null) {
            this.mListener.onPageScrollStateChanged(state);
        }
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        if (this.mListener != null) {
            this.mListener.onPageScrolled(position, positionOffset, positionOffsetPixels);
        }
        CheckedTextView tv_scroll = this.getTabView(position);
        CheckedTextView tv_next = this.getTabView(position + 1);
        if (tv_scroll != null && tv_next != null) {
            int width_scroll = tv_scroll.getMeasuredWidth();
            int width_next = tv_next.getMeasuredWidth();
            float distance = (float)(width_scroll + width_next) / 2.0f;
            int width = (int)((float)width_scroll + (float)(width_next - width_scroll) * positionOffset + 0.5f);
            int offset = (int)((float)tv_scroll.getLeft() + (float)width_scroll / 2.0f + distance * positionOffset - (float)width / 2.0f + 0.5f);
            this.updateIndicator(offset, width);
        }
    }

    public void onPageSelected(int position) {
        this.setCurrentItem(position);
        if (this.mListener != null) {
            this.mListener.onPageSelected(position);
        }
    }

    public void onClick(View v) {
        int position = (Integer)v.getTag();
        if (position == this.mSelectedPosition && this.mListener != null) {
            this.mListener.onPageSelected(position);
        }
        this.mViewPager.setCurrentItem(position, true);
    }

    public void setCurrentItem(int position) {
        CheckedTextView tv;
        if (this.mSelectedPosition != position && (tv = this.getTabView(this.mSelectedPosition)) != null) {
            tv.setChecked(false);
        }
        this.mSelectedPosition = position;
        tv = this.getTabView(this.mSelectedPosition);
        if (tv != null) {
            tv.setChecked(true);
        }
        this.animateToTab(position);
    }

    private void notifyDataSetChanged() {
        this.mTabContainer.removeAllViews();
        PagerAdapter adapter = this.mViewPager.getAdapter();
        int count = adapter.getCount();
        if (this.mSelectedPosition > count) {
            this.mSelectedPosition = count - 1;
        }
        for (int i = 0; i < count; ++i) {
            CharSequence title = adapter.getPageTitle(i);
            if (title == null) {
                title = "NULL";
            }
            CheckedTextView tv = new CheckedTextView(this.getContext());
            tv.setCheckMarkDrawable(null);
            tv.setText(title);
            tv.setGravity(17);
            tv.setTextAppearance(this.getContext(), this.mTextAppearance);
            if (this.mTabSingleLine) {
                tv.setSingleLine(true);
            } else {
                tv.setSingleLine(false);
                tv.setMaxLines(2);
            }
            tv.setEllipsize(TextUtils.TruncateAt.END);
            tv.setOnClickListener(this);
            tv.setTag(i);
            if (this.mTabRippleStyle > 0) {
                ViewUtil.setBackground((View)tv, new RippleDrawable.Builder(this.getContext(), this.mTabRippleStyle).build());
            }
            tv.setPadding(this.mTabPadding, 0, this.mTabPadding, 0);
            this.mTabContainer.addView((View)tv, new ViewGroup.LayoutParams(-2, -1));
        }
        this.setCurrentItem(this.mSelectedPosition);
        this.requestLayout();
    }

    private void notifyDataSetInvalidated() {
        PagerAdapter adapter = this.mViewPager.getAdapter();
        int count = adapter.getCount();
        for (int i = 0; i < count; ++i) {
            CheckedTextView tv = this.getTabView(i);
            CharSequence title = adapter.getPageTitle(i);
            if (title == null) {
                title = "NULL";
            }
            tv.setText(title);
        }
        this.requestLayout();
    }

    private void addTemporaryTab() {
        for (int i = 0; i < 3; ++i) {
            String title = null;
            if (i == 0) {
                title = "TAB ONE";
            } else if (i == 1) {
                title = "TAB TWO";
            } else if (i == 2) {
                title = "TAB THREE";
            }
            CheckedTextView tv = new CheckedTextView(this.getContext());
            tv.setCheckMarkDrawable(null);
            tv.setText(title);
            tv.setGravity(17);
            tv.setTextAppearance(this.getContext(), this.mTextAppearance);
            tv.setSingleLine(true);
            tv.setEllipsize(TextUtils.TruncateAt.END);
            tv.setTag(i);
            tv.setChecked(i == 0);
            if (this.mMode == 0) {
                tv.setPadding(this.mTabPadding, 0, this.mTabPadding, 0);
                this.mTabContainer.addView((View)tv, new ViewGroup.LayoutParams(-2, -1));
                continue;
            }
            if (this.mMode != 1) continue;
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(0, -1);
            params.weight = 1.0f;
            this.mTabContainer.addView((View)tv, (ViewGroup.LayoutParams)params);
        }
    }

    private class TabContainerLayout
    extends FrameLayout {
        public TabContainerLayout(Context context) {
            super(context);
        }

        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            int i;
            int ws;
            int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
            int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
            int width = 0;
            int height = 0;
            if (TabPageIndicator.this.mMode == 0) {
                ws = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
                for (i = 0; i < this.getChildCount(); ++i) {
                    View child = this.getChildAt(i);
                    child.measure(ws, heightMeasureSpec);
                    width += child.getMeasuredWidth();
                    height = Math.max(height, child.getMeasuredHeight());
                }
                this.setMeasuredDimension(width, height);
            } else if (widthMode != 0x40000000) {
                ws = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
                for (i = 0; i < this.getChildCount(); ++i) {
                    View child = this.getChildAt(i);
                    child.measure(ws, heightMeasureSpec);
                    width += child.getMeasuredWidth();
                    height = Math.max(height, child.getMeasuredHeight());
                }
                if (widthMode == 0 || width < widthSize) {
                    this.setMeasuredDimension(widthSize, height);
                } else {
                    int childWidth = widthSize / this.getChildCount();
                    int count = this.getChildCount();
                    for (int i2 = 0; i2 < count; ++i2) {
                        View child = this.getChildAt(i2);
                        if (i2 != count - 1) {
                            child.measure(View.MeasureSpec.makeMeasureSpec((int)childWidth, (int)0x40000000), heightMeasureSpec);
                            continue;
                        }
                        child.measure(View.MeasureSpec.makeMeasureSpec((int)(widthSize - childWidth * (count - 1)), (int)0x40000000), heightMeasureSpec);
                    }
                    this.setMeasuredDimension(widthSize, height);
                }
            } else {
                int childWidth = widthSize / this.getChildCount();
                int count = this.getChildCount();
                for (i = 0; i < count; ++i) {
                    View child = this.getChildAt(i);
                    if (i != count - 1) {
                        child.measure(View.MeasureSpec.makeMeasureSpec((int)childWidth, (int)0x40000000), heightMeasureSpec);
                    } else {
                        child.measure(View.MeasureSpec.makeMeasureSpec((int)(widthSize - childWidth * (count - 1)), (int)0x40000000), heightMeasureSpec);
                    }
                    height = Math.max(height, child.getMeasuredHeight());
                }
                this.setMeasuredDimension(widthSize, height);
            }
            int hs = View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000);
            for (i = 0; i < this.getChildCount(); ++i) {
                View child = this.getChildAt(i);
                if (child.getMeasuredHeight() == height) continue;
                child.measure(View.MeasureSpec.makeMeasureSpec((int)child.getMeasuredWidth(), (int)0x40000000), hs);
            }
        }

        protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
            int childLeft = 0;
            int childTop = 0;
            int childRight = right - left;
            int childBottom = bottom - top;
            if (TabPageIndicator.this.mIsRtl) {
                int count = this.getChildCount();
                for (int i = 0; i < count; ++i) {
                    View child = this.getChildAt(i);
                    child.layout(childRight - child.getMeasuredWidth(), childTop, childRight, childBottom);
                    childRight -= child.getMeasuredWidth();
                }
            } else {
                int count = this.getChildCount();
                for (int i = 0; i < count; ++i) {
                    View child = this.getChildAt(i);
                    child.layout(childLeft, childTop, childLeft + child.getMeasuredWidth(), childBottom);
                    childLeft += child.getMeasuredWidth();
                }
            }
        }
    }
}

