/*
 * Decompiled with CFR 0.152.
 */
package com.rey.material.widget;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import com.rey.material.R;
import com.rey.material.app.ThemeManager;
import com.rey.material.drawable.RippleDrawable;
import com.rey.material.util.ThemeUtil;
import com.rey.material.util.ViewUtil;
import com.rey.material.widget.Button;
import com.rey.material.widget.TextView;

public class SnackBar
extends FrameLayout
implements ThemeManager.OnThemeChangedListener {
    protected int mStyleId;
    protected int mCurrentStyle = Integer.MIN_VALUE;
    private TextView mText;
    private Button mAction;
    public static final int MATCH_PARENT = -1;
    public static final int WRAP_CONTENT = -2;
    private BackgroundDrawable mBackground;
    private int mMarginStart = 0;
    private int mMarginBottom = 0;
    private int mWidth = -1;
    private int mHeight = -2;
    private int mMaxHeight;
    private int mMinHeight;
    private long mDuration = -1L;
    private int mActionId;
    private boolean mRemoveOnDismiss;
    private Animation mInAnimation;
    private Animation mOutAnimation;
    private Runnable mDismissRunnable = new Runnable(){

        @Override
        public void run() {
            SnackBar.this.dismiss();
        }
    };
    private int mState = 0;
    public static final int STATE_DISMISSED = 0;
    public static final int STATE_SHOWN = 1;
    public static final int STATE_SHOWING = 2;
    public static final int STATE_DISMISSING = 3;
    private boolean mIsRtl = false;
    private OnActionClickListener mActionClickListener;
    private OnStateChangeListener mStateChangeListener;

    public static SnackBar make(Context context) {
        return new SnackBar(context);
    }

    public SnackBar(Context context) {
        super(context);
        this.init(context, null, 0, 0);
    }

    public SnackBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs, 0, 0);
    }

    public SnackBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr, 0);
    }

    public SnackBar(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr, defStyleRes);
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.mText = new TextView(context);
        this.mText.setSingleLine(true);
        this.mText.setGravity(8388627);
        this.addView((View)this.mText, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
        this.mAction = new Button(context);
        this.mAction.setBackgroundResource(0);
        this.mAction.setGravity(17);
        this.mAction.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (SnackBar.this.mActionClickListener != null) {
                    SnackBar.this.mActionClickListener.onActionClick(SnackBar.this, SnackBar.this.mActionId);
                }
                SnackBar.this.dismiss();
            }
        });
        this.addView((View)this.mAction, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-2, -2));
        this.mBackground = new BackgroundDrawable();
        this.mBackground.setColor(-13487566);
        ViewUtil.setBackground((View)this, this.mBackground);
        this.setClickable(true);
        this.applyStyle(context, attrs, defStyleAttr, defStyleRes);
        this.mStyleId = ThemeManager.getStyleId(context, attrs, defStyleAttr, defStyleRes);
    }

    public SnackBar applyStyle(int resId) {
        ViewUtil.applyStyle((View)this, resId);
        this.applyStyle(this.getContext(), null, 0, resId);
        return this;
    }

    protected void applyStyle(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.SnackBar, defStyleAttr, defStyleRes);
        int horizontalPadding = -1;
        int verticalPadding = -1;
        int textSize = -1;
        int textColor = 0;
        boolean textColorDefined = false;
        int textAppearance = 0;
        int actionTextSize = -1;
        ColorStateList actionTextColor = null;
        int actionTextAppearance = 0;
        int count = a.getIndexCount();
        for (int i = 0; i < count; ++i) {
            int attr2 = a.getIndex(i);
            if (attr2 == R.styleable.SnackBar_sb_backgroundColor) {
                this.backgroundColor(a.getColor(attr2, 0));
                continue;
            }
            if (attr2 == R.styleable.SnackBar_sb_backgroundCornerRadius) {
                this.backgroundRadius(a.getDimensionPixelSize(attr2, 0));
                continue;
            }
            if (attr2 == R.styleable.SnackBar_sb_horizontalPadding) {
                horizontalPadding = a.getDimensionPixelSize(attr2, 0);
                continue;
            }
            if (attr2 == R.styleable.SnackBar_sb_verticalPadding) {
                verticalPadding = a.getDimensionPixelSize(attr2, 0);
                continue;
            }
            if (attr2 == R.styleable.SnackBar_sb_width) {
                if (ThemeUtil.getType(a, attr2) == 16) {
                    this.width(a.getInteger(attr2, 0));
                    continue;
                }
                this.width(a.getDimensionPixelSize(attr2, 0));
                continue;
            }
            if (attr2 == R.styleable.SnackBar_sb_height) {
                if (ThemeUtil.getType(a, attr2) == 16) {
                    this.height(a.getInteger(attr2, 0));
                    continue;
                }
                this.height(a.getDimensionPixelSize(attr2, 0));
                continue;
            }
            if (attr2 == R.styleable.SnackBar_sb_minWidth) {
                this.minWidth(a.getDimensionPixelSize(attr2, 0));
                continue;
            }
            if (attr2 == R.styleable.SnackBar_sb_maxWidth) {
                this.maxWidth(a.getDimensionPixelSize(attr2, 0));
                continue;
            }
            if (attr2 == R.styleable.SnackBar_sb_minHeight) {
                this.minHeight(a.getDimensionPixelSize(attr2, 0));
                continue;
            }
            if (attr2 == R.styleable.SnackBar_sb_maxHeight) {
                this.maxHeight(a.getDimensionPixelSize(attr2, 0));
                continue;
            }
            if (attr2 == R.styleable.SnackBar_sb_marginStart) {
                this.marginStart(a.getDimensionPixelSize(attr2, 0));
                continue;
            }
            if (attr2 == R.styleable.SnackBar_sb_marginBottom) {
                this.marginBottom(a.getDimensionPixelSize(attr2, 0));
                continue;
            }
            if (attr2 == R.styleable.SnackBar_sb_textSize) {
                textSize = a.getDimensionPixelSize(attr2, 0);
                continue;
            }
            if (attr2 == R.styleable.SnackBar_sb_textColor) {
                textColor = a.getColor(attr2, 0);
                textColorDefined = true;
                continue;
            }
            if (attr2 == R.styleable.SnackBar_sb_textAppearance) {
                textAppearance = a.getResourceId(attr2, 0);
                continue;
            }
            if (attr2 == R.styleable.SnackBar_sb_text) {
                this.text(a.getString(attr2));
                continue;
            }
            if (attr2 == R.styleable.SnackBar_sb_singleLine) {
                this.singleLine(a.getBoolean(attr2, true));
                continue;
            }
            if (attr2 == R.styleable.SnackBar_sb_maxLines) {
                this.maxLines(a.getInteger(attr2, 0));
                continue;
            }
            if (attr2 == R.styleable.SnackBar_sb_lines) {
                this.lines(a.getInteger(attr2, 0));
                continue;
            }
            if (attr2 == R.styleable.SnackBar_sb_ellipsize) {
                int ellipsize = a.getInteger(attr2, 0);
                switch (ellipsize) {
                    case 1: {
                        this.ellipsize(TextUtils.TruncateAt.START);
                        break;
                    }
                    case 2: {
                        this.ellipsize(TextUtils.TruncateAt.MIDDLE);
                        break;
                    }
                    case 3: {
                        this.ellipsize(TextUtils.TruncateAt.END);
                        break;
                    }
                    case 4: {
                        this.ellipsize(TextUtils.TruncateAt.MARQUEE);
                        break;
                    }
                    default: {
                        this.ellipsize(TextUtils.TruncateAt.END);
                        break;
                    }
                }
                continue;
            }
            if (attr2 == R.styleable.SnackBar_sb_actionTextSize) {
                actionTextSize = a.getDimensionPixelSize(attr2, 0);
                continue;
            }
            if (attr2 == R.styleable.SnackBar_sb_actionTextColor) {
                actionTextColor = a.getColorStateList(attr2);
                continue;
            }
            if (attr2 == R.styleable.SnackBar_sb_actionTextAppearance) {
                actionTextAppearance = a.getResourceId(attr2, 0);
                continue;
            }
            if (attr2 == R.styleable.SnackBar_sb_actionText) {
                this.actionText(a.getString(attr2));
                continue;
            }
            if (attr2 == R.styleable.SnackBar_sb_actionRipple) {
                this.actionRipple(a.getResourceId(attr2, 0));
                continue;
            }
            if (attr2 == R.styleable.SnackBar_sb_duration) {
                this.duration(a.getInteger(attr2, 0));
                continue;
            }
            if (attr2 == R.styleable.SnackBar_sb_removeOnDismiss) {
                this.removeOnDismiss(a.getBoolean(attr2, true));
                continue;
            }
            if (attr2 == R.styleable.SnackBar_sb_inAnimation) {
                this.animationIn(AnimationUtils.loadAnimation((Context)this.getContext(), (int)a.getResourceId(attr2, 0)));
                continue;
            }
            if (attr2 != R.styleable.SnackBar_sb_outAnimation) continue;
            this.animationOut(AnimationUtils.loadAnimation((Context)this.getContext(), (int)a.getResourceId(attr2, 0)));
        }
        a.recycle();
        if (horizontalPadding >= 0 || verticalPadding >= 0) {
            this.padding(horizontalPadding >= 0 ? horizontalPadding : this.mText.getPaddingLeft(), verticalPadding >= 0 ? verticalPadding : this.mText.getPaddingTop());
        }
        if (textAppearance != 0) {
            this.textAppearance(textAppearance);
        }
        if (textSize >= 0) {
            this.textSize(textSize);
        }
        if (textColorDefined) {
            this.textColor(textColor);
        }
        if (textAppearance != 0) {
            this.actionTextAppearance(actionTextAppearance);
        }
        if (actionTextSize >= 0) {
            this.actionTextSize(actionTextSize);
        }
        if (actionTextColor != null) {
            this.actionTextColor(actionTextColor);
        }
    }

    @Override
    public void onThemeChanged(ThemeManager.OnThemeChangedEvent event) {
        int style2 = ThemeManager.getInstance().getCurrentStyle(this.mStyleId);
        if (this.mCurrentStyle != style2) {
            this.mCurrentStyle = style2;
            this.applyStyle(this.mCurrentStyle);
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mStyleId != 0) {
            ThemeManager.getInstance().registerOnThemeChangedListener(this);
            this.onThemeChanged(null);
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mStyleId != 0) {
            ThemeManager.getInstance().unregisterOnThemeChangedListener(this);
        }
    }

    @TargetApi(value=17)
    public void onRtlPropertiesChanged(int layoutDirection) {
        boolean rtl;
        boolean bl = rtl = layoutDirection == 1;
        if (this.mIsRtl != rtl) {
            this.mIsRtl = rtl;
            if (Build.VERSION.SDK_INT >= 17) {
                this.mText.setTextDirection(this.mIsRtl ? 4 : 3);
                this.mAction.setTextDirection(this.mIsRtl ? 4 : 3);
            }
            this.requestLayout();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width;
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        if (this.mAction.getVisibility() == 0) {
            this.mAction.measure(View.MeasureSpec.makeMeasureSpec((int)0, (int)0), heightMeasureSpec);
            int padding = this.mIsRtl ? this.mText.getPaddingLeft() : this.mText.getPaddingRight();
            this.mText.measure(View.MeasureSpec.makeMeasureSpec((int)(widthSize - (this.mAction.getMeasuredWidth() - padding)), (int)widthMode), heightMeasureSpec);
            width = this.mText.getMeasuredWidth() + this.mAction.getMeasuredWidth() - padding;
        } else {
            this.mText.measure(View.MeasureSpec.makeMeasureSpec((int)widthSize, (int)widthMode), heightMeasureSpec);
            width = this.mText.getMeasuredWidth();
        }
        int height = Math.max(this.mText.getMeasuredHeight(), this.mAction.getMeasuredHeight());
        switch (widthMode) {
            case -2147483648: {
                width = Math.min(widthSize, width);
                break;
            }
            case 0x40000000: {
                width = widthSize;
            }
        }
        switch (heightMode) {
            case -2147483648: {
                height = Math.min(heightSize, height);
                break;
            }
            case 0x40000000: {
                height = heightSize;
            }
        }
        if (this.mMaxHeight > 0) {
            height = Math.min(this.mMaxHeight, height);
        }
        if (this.mMinHeight > 0) {
            height = Math.max(this.mMinHeight, height);
        }
        this.setMeasuredDimension(width, height);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int childLeft = this.getPaddingLeft();
        int childRight = r - l - this.getPaddingRight();
        int childTop = this.getPaddingTop();
        int childBottom = b - t - this.getPaddingBottom();
        if (this.mAction.getVisibility() == 0) {
            if (this.mIsRtl) {
                this.mAction.layout(childLeft, childTop, childLeft + this.mAction.getMeasuredWidth(), childBottom);
                childLeft += this.mAction.getMeasuredWidth() - this.mText.getPaddingLeft();
            } else {
                this.mAction.layout(childRight - this.mAction.getMeasuredWidth(), childTop, childRight, childBottom);
                childRight -= this.mAction.getMeasuredWidth() - this.mText.getPaddingRight();
            }
        }
        this.mText.layout(childLeft, childTop, childRight, childBottom);
    }

    public SnackBar text(CharSequence text) {
        this.mText.setText(text);
        return this;
    }

    public SnackBar text(int id) {
        return this.text(this.getContext().getResources().getString(id));
    }

    public SnackBar textColor(int color2) {
        this.mText.setTextColor(color2);
        return this;
    }

    public SnackBar textSize(float size) {
        this.mText.setTextSize(2, size);
        return this;
    }

    public SnackBar textAppearance(int resId) {
        if (resId != 0) {
            this.mText.setTextAppearance(this.getContext(), resId);
        }
        return this;
    }

    public SnackBar ellipsize(TextUtils.TruncateAt at) {
        this.mText.setEllipsize(at);
        return this;
    }

    public SnackBar singleLine(boolean b) {
        this.mText.setSingleLine(b);
        return this;
    }

    public SnackBar maxLines(int lines) {
        this.mText.setMaxLines(lines);
        return this;
    }

    public SnackBar lines(int lines) {
        this.mText.setLines(lines);
        return this;
    }

    public SnackBar actionId(int id) {
        this.mActionId = id;
        return this;
    }

    public SnackBar actionText(CharSequence text) {
        if (TextUtils.isEmpty((CharSequence)text)) {
            this.mAction.setVisibility(4);
        } else {
            this.mAction.setVisibility(0);
            this.mAction.setText(text);
        }
        return this;
    }

    public SnackBar actionText(int id) {
        if (id == 0) {
            return this.actionText(null);
        }
        return this.actionText(this.getContext().getResources().getString(id));
    }

    public SnackBar actionTextColor(int color2) {
        this.mAction.setTextColor(color2);
        return this;
    }

    public SnackBar actionTextColor(ColorStateList colors) {
        this.mAction.setTextColor(colors);
        return this;
    }

    public SnackBar actionTextAppearance(int resId) {
        if (resId != 0) {
            this.mAction.setTextAppearance(this.getContext(), resId);
        }
        return this;
    }

    public SnackBar actionTextSize(float size) {
        this.mAction.setTextSize(2, size);
        return this;
    }

    public SnackBar actionRipple(int resId) {
        if (resId != 0) {
            ViewUtil.setBackground((View)this.mAction, new RippleDrawable.Builder(this.getContext(), resId).build());
        }
        return this;
    }

    public SnackBar duration(long duration) {
        this.mDuration = duration;
        return this;
    }

    public SnackBar backgroundColor(int color2) {
        this.mBackground.setColor(color2);
        return this;
    }

    public SnackBar backgroundRadius(int radius) {
        this.mBackground.setRadius(radius);
        return this;
    }

    public SnackBar horizontalPadding(int padding) {
        this.mText.setPadding(padding, this.mText.getPaddingTop(), padding, this.mText.getPaddingBottom());
        this.mAction.setPadding(padding, this.mAction.getPaddingTop(), padding, this.mAction.getPaddingBottom());
        return this;
    }

    public SnackBar verticalPadding(int padding) {
        this.mText.setPadding(this.mText.getPaddingLeft(), padding, this.mText.getPaddingRight(), padding);
        this.mAction.setPadding(this.mAction.getPaddingLeft(), padding, this.mAction.getPaddingRight(), padding);
        return this;
    }

    public SnackBar padding(int horizontalPadding, int verticalPadding) {
        this.mText.setPadding(horizontalPadding, verticalPadding, horizontalPadding, verticalPadding);
        this.mAction.setPadding(horizontalPadding, verticalPadding, horizontalPadding, verticalPadding);
        return this;
    }

    public SnackBar width(int width) {
        this.mWidth = width;
        return this;
    }

    public SnackBar minWidth(int width) {
        this.mText.setMinWidth(width);
        return this;
    }

    public SnackBar maxWidth(int width) {
        this.mText.setMaxWidth(width);
        return this;
    }

    public SnackBar height(int height) {
        this.mHeight = height;
        return this;
    }

    public SnackBar maxHeight(int height) {
        this.mMaxHeight = height;
        return this;
    }

    public SnackBar minHeight(int height) {
        this.mMinHeight = height;
        return this;
    }

    public SnackBar marginStart(int size) {
        this.mMarginStart = size;
        return this;
    }

    public SnackBar marginBottom(int size) {
        this.mMarginBottom = size;
        return this;
    }

    public SnackBar actionClickListener(OnActionClickListener listener) {
        this.mActionClickListener = listener;
        return this;
    }

    public SnackBar stateChangeListener(OnStateChangeListener listener) {
        this.mStateChangeListener = listener;
        return this;
    }

    public SnackBar animationIn(Animation anim) {
        this.mInAnimation = anim;
        return this;
    }

    public SnackBar animationOut(Animation anim) {
        this.mOutAnimation = anim;
        return this;
    }

    public SnackBar removeOnDismiss(boolean b) {
        this.mRemoveOnDismiss = b;
        return this;
    }

    public void show(Activity activity) {
        this.show((ViewGroup)activity.getWindow().findViewById(0x1020002));
    }

    public void show(ViewGroup parent) {
        if (this.mState == 2 || this.mState == 3) {
            return;
        }
        if (this.getParent() != parent) {
            if (this.getParent() != null) {
                ((ViewGroup)this.getParent()).removeView((View)this);
            }
            parent.addView((View)this);
        }
        this.show();
    }

    public void show() {
        ViewGroup parent = (ViewGroup)this.getParent();
        if (parent == null || this.mState == 2 || this.mState == 3) {
            return;
        }
        if (parent instanceof FrameLayout) {
            FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)this.getLayoutParams();
            params.width = this.mWidth;
            params.height = this.mHeight;
            params.gravity = 8388691;
            if (this.mIsRtl) {
                params.rightMargin = this.mMarginStart;
            } else {
                params.leftMargin = this.mMarginStart;
            }
            params.bottomMargin = this.mMarginBottom;
        } else if (parent instanceof RelativeLayout) {
            RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)this.getLayoutParams();
            params.width = this.mWidth;
            params.height = this.mHeight;
            params.addRule(12);
            params.addRule(20);
            if (this.mIsRtl) {
                params.rightMargin = this.mMarginStart;
            } else {
                params.leftMargin = this.mMarginStart;
            }
            params.bottomMargin = this.mMarginBottom;
        }
        if (this.mInAnimation != null && this.mState != 1) {
            this.mInAnimation.cancel();
            this.mInAnimation.reset();
            this.mInAnimation.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                    SnackBar.this.setState(2);
                    SnackBar.this.setVisibility(0);
                }

                public void onAnimationRepeat(Animation animation) {
                }

                public void onAnimationEnd(Animation animation) {
                    SnackBar.this.setState(1);
                    SnackBar.this.startTimer();
                }
            });
            this.clearAnimation();
            this.startAnimation(this.mInAnimation);
        } else {
            this.setVisibility(0);
            this.setState(1);
            this.startTimer();
        }
    }

    private void startTimer() {
        this.removeCallbacks(this.mDismissRunnable);
        if (this.mDuration > 0L) {
            this.postDelayed(this.mDismissRunnable, this.mDuration);
        }
    }

    public void dismiss() {
        if (this.mState != 1) {
            return;
        }
        this.removeCallbacks(this.mDismissRunnable);
        if (this.mOutAnimation != null) {
            this.mOutAnimation.cancel();
            this.mOutAnimation.reset();
            this.mOutAnimation.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                    SnackBar.this.setState(3);
                }

                public void onAnimationRepeat(Animation animation) {
                }

                public void onAnimationEnd(Animation animation) {
                    if (SnackBar.this.mRemoveOnDismiss && SnackBar.this.getParent() != null && SnackBar.this.getParent() instanceof ViewGroup) {
                        ((ViewGroup)SnackBar.this.getParent()).removeView((View)SnackBar.this);
                    }
                    SnackBar.this.setState(0);
                    SnackBar.this.setVisibility(8);
                }
            });
            this.clearAnimation();
            this.startAnimation(this.mOutAnimation);
        } else {
            if (this.mRemoveOnDismiss && this.getParent() != null && this.getParent() instanceof ViewGroup) {
                ((ViewGroup)this.getParent()).removeView((View)this);
            }
            this.setState(0);
            this.setVisibility(8);
        }
    }

    public int getState() {
        return this.mState;
    }

    private void setState(int state) {
        if (this.mState != state) {
            int oldState = this.mState;
            this.mState = state;
            if (this.mStateChangeListener != null) {
                this.mStateChangeListener.onStateChange(this, oldState, this.mState);
            }
        }
    }

    private class BackgroundDrawable
    extends Drawable {
        private int mBackgroundColor;
        private int mBackgroundRadius;
        private Paint mPaint = new Paint();
        private RectF mRect;

        public BackgroundDrawable() {
            this.mPaint.setAntiAlias(true);
            this.mPaint.setStyle(Paint.Style.FILL);
            this.mRect = new RectF();
        }

        public void setColor(int color2) {
            if (this.mBackgroundColor != color2) {
                this.mBackgroundColor = color2;
                this.mPaint.setColor(this.mBackgroundColor);
                this.invalidateSelf();
            }
        }

        public void setRadius(int radius) {
            if (this.mBackgroundRadius != radius) {
                this.mBackgroundRadius = radius;
                this.invalidateSelf();
            }
        }

        protected void onBoundsChange(Rect bounds) {
            this.mRect.set(bounds);
        }

        public void draw(Canvas canvas) {
            canvas.drawRoundRect(this.mRect, (float)this.mBackgroundRadius, (float)this.mBackgroundRadius, this.mPaint);
        }

        public void setAlpha(int alpha) {
            this.mPaint.setAlpha(alpha);
        }

        public void setColorFilter(ColorFilter cf) {
            this.mPaint.setColorFilter(cf);
        }

        public int getOpacity() {
            return -3;
        }
    }

    public static interface OnStateChangeListener {
        public void onStateChange(SnackBar var1, int var2, int var3);
    }

    public static interface OnActionClickListener {
        public void onActionClick(SnackBar var1, int var2);
    }
}

