/*
 * Decompiled with CFR 0.152.
 */
package com.rey.material.drawable;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.view.animation.AnimationUtils;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import com.rey.material.R;
import com.rey.material.util.ColorUtil;
import com.rey.material.util.ThemeUtil;

public class CircularProgressDrawable
extends Drawable
implements Animatable {
    private long mLastUpdateTime;
    private long mLastProgressStateTime;
    private long mLastRunStateTime;
    private int mProgressState;
    private static final int PROGRESS_STATE_HIDE = -1;
    private static final int PROGRESS_STATE_STRETCH = 0;
    private static final int PROGRESS_STATE_KEEP_STRETCH = 1;
    private static final int PROGRESS_STATE_SHRINK = 2;
    private static final int PROGRESS_STATE_KEEP_SHRINK = 3;
    private int mRunState = 0;
    private static final int RUN_STATE_STOPPED = 0;
    private static final int RUN_STATE_STARTING = 1;
    private static final int RUN_STATE_STARTED = 2;
    private static final int RUN_STATE_RUNNING = 3;
    private static final int RUN_STATE_STOPPING = 4;
    private Paint mPaint;
    private RectF mRect;
    private float mStartAngle;
    private float mSweepAngle;
    private int mStrokeColorIndex;
    private int mPadding;
    private float mInitialAngle;
    private float mProgressPercent;
    private float mSecondaryProgressPercent;
    private float mMaxSweepAngle;
    private float mMinSweepAngle;
    private int mStrokeSize;
    private int[] mStrokeColors;
    private int mStrokeSecondaryColor;
    private boolean mReverse;
    private int mRotateDuration;
    private int mTransformDuration;
    private int mKeepDuration;
    private float mInStepPercent;
    private int[] mInColors;
    private int mInAnimationDuration;
    private int mOutAnimationDuration;
    private int mProgressMode;
    private Interpolator mTransformInterpolator;
    private final Runnable mUpdater = new Runnable(){

        @Override
        public void run() {
            CircularProgressDrawable.this.update();
        }
    };

    private CircularProgressDrawable(int padding, float initialAngle, float progressPercent, float secondaryProgressPercent, float maxSweepAngle, float minSweepAngle, int strokeSize, int[] strokeColors, int strokeSecondaryColor, boolean reverse, int rotateDuration, int transformDuration, int keepDuration, Interpolator transformInterpolator, int progressMode, int inAnimDuration, float inStepPercent, int[] inStepColors, int outAnimDuration) {
        this.mPadding = padding;
        this.mInitialAngle = initialAngle;
        this.setProgress(progressPercent);
        this.setSecondaryProgress(secondaryProgressPercent);
        this.mMaxSweepAngle = maxSweepAngle;
        this.mMinSweepAngle = minSweepAngle;
        this.mStrokeSize = strokeSize;
        this.mStrokeColors = strokeColors;
        this.mStrokeSecondaryColor = strokeSecondaryColor;
        this.mReverse = reverse;
        this.mRotateDuration = rotateDuration;
        this.mTransformDuration = transformDuration;
        this.mKeepDuration = keepDuration;
        this.mTransformInterpolator = transformInterpolator;
        this.mProgressMode = progressMode;
        this.mInAnimationDuration = inAnimDuration;
        this.mInStepPercent = inStepPercent;
        this.mInColors = inStepColors;
        this.mOutAnimationDuration = outAnimDuration;
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mPaint.setStrokeJoin(Paint.Join.ROUND);
        this.mRect = new RectF();
    }

    public void applyStyle(Context context, int resId) {
        TypedArray a = context.obtainStyledAttributes(resId, R.styleable.CircularProgressDrawable);
        int strokeColor = 0;
        boolean strokeColorDefined = false;
        int[] strokeColors = null;
        int count = a.getIndexCount();
        for (int i = 0; i < count; ++i) {
            int j;
            TypedArray ta;
            int attr2 = a.getIndex(i);
            if (attr2 == R.styleable.CircularProgressDrawable_cpd_padding) {
                this.mPadding = a.getDimensionPixelSize(attr2, 0);
                continue;
            }
            if (attr2 == R.styleable.CircularProgressDrawable_cpd_initialAngle) {
                this.mInitialAngle = a.getInteger(attr2, 0);
                continue;
            }
            if (attr2 == R.styleable.CircularProgressDrawable_pv_progress) {
                this.setProgress(a.getFloat(attr2, 0.0f));
                continue;
            }
            if (attr2 == R.styleable.CircularProgressDrawable_pv_secondaryProgress) {
                this.setSecondaryProgress(a.getFloat(attr2, 0.0f));
                continue;
            }
            if (attr2 == R.styleable.CircularProgressDrawable_cpd_maxSweepAngle) {
                this.mMaxSweepAngle = a.getInteger(attr2, 0);
                continue;
            }
            if (attr2 == R.styleable.CircularProgressDrawable_cpd_minSweepAngle) {
                this.mMinSweepAngle = a.getInteger(attr2, 0);
                continue;
            }
            if (attr2 == R.styleable.CircularProgressDrawable_cpd_strokeSize) {
                this.mStrokeSize = a.getDimensionPixelSize(attr2, 0);
                continue;
            }
            if (attr2 == R.styleable.CircularProgressDrawable_cpd_strokeColor) {
                strokeColor = a.getColor(attr2, 0);
                strokeColorDefined = true;
                continue;
            }
            if (attr2 == R.styleable.CircularProgressDrawable_cpd_strokeColors) {
                ta = context.getResources().obtainTypedArray(a.getResourceId(attr2, 0));
                strokeColors = new int[ta.length()];
                for (j = 0; j < ta.length(); ++j) {
                    strokeColors[j] = ta.getColor(j, 0);
                }
                ta.recycle();
                continue;
            }
            if (attr2 == R.styleable.CircularProgressDrawable_cpd_strokeSecondaryColor) {
                this.mStrokeSecondaryColor = a.getColor(attr2, 0);
                continue;
            }
            if (attr2 == R.styleable.CircularProgressDrawable_cpd_reverse) {
                this.mReverse = a.getBoolean(attr2, false);
                continue;
            }
            if (attr2 == R.styleable.CircularProgressDrawable_cpd_rotateDuration) {
                this.mRotateDuration = a.getInteger(attr2, 0);
                continue;
            }
            if (attr2 == R.styleable.CircularProgressDrawable_cpd_transformDuration) {
                this.mTransformDuration = a.getInteger(attr2, 0);
                continue;
            }
            if (attr2 == R.styleable.CircularProgressDrawable_cpd_keepDuration) {
                this.mKeepDuration = a.getInteger(attr2, 0);
                continue;
            }
            if (attr2 == R.styleable.CircularProgressDrawable_cpd_transformInterpolator) {
                this.mTransformInterpolator = AnimationUtils.loadInterpolator((Context)context, (int)a.getResourceId(attr2, 0));
                continue;
            }
            if (attr2 == R.styleable.CircularProgressDrawable_pv_progressMode) {
                this.mProgressMode = a.getInteger(attr2, 0);
                continue;
            }
            if (attr2 == R.styleable.CircularProgressDrawable_cpd_inAnimDuration) {
                this.mInAnimationDuration = a.getInteger(attr2, 0);
                continue;
            }
            if (attr2 == R.styleable.CircularProgressDrawable_cpd_inStepColors) {
                ta = context.getResources().obtainTypedArray(a.getResourceId(attr2, 0));
                this.mInColors = new int[ta.length()];
                for (j = 0; j < ta.length(); ++j) {
                    this.mInColors[j] = ta.getColor(j, 0);
                }
                ta.recycle();
                continue;
            }
            if (attr2 == R.styleable.CircularProgressDrawable_cpd_inStepPercent) {
                this.mInStepPercent = a.getFloat(attr2, 0.0f);
                continue;
            }
            if (attr2 != R.styleable.CircularProgressDrawable_cpd_outAnimDuration) continue;
            this.mOutAnimationDuration = a.getInteger(attr2, 0);
        }
        a.recycle();
        if (strokeColors != null) {
            this.mStrokeColors = strokeColors;
        } else if (strokeColorDefined) {
            this.mStrokeColors = new int[]{strokeColor};
        }
        if (this.mStrokeColorIndex >= this.mStrokeColors.length) {
            this.mStrokeColorIndex = 0;
        }
        this.invalidateSelf();
    }

    public void draw(Canvas canvas) {
        switch (this.mProgressMode) {
            case 0: {
                this.drawDeterminate(canvas);
                break;
            }
            case 1: {
                this.drawIndeterminate(canvas);
            }
        }
    }

    private void drawDeterminate(Canvas canvas) {
        Rect bounds = this.getBounds();
        float radius = 0.0f;
        float size = 0.0f;
        if (this.mRunState == 1) {
            size = (float)this.mStrokeSize * (float)Math.min((long)this.mInAnimationDuration, SystemClock.uptimeMillis() - this.mLastRunStateTime) / (float)this.mInAnimationDuration;
            if (size > 0.0f) {
                radius = ((float)(Math.min(bounds.width(), bounds.height()) - this.mPadding * 2 - this.mStrokeSize * 2) + size) / 2.0f;
            }
        } else if (this.mRunState == 4) {
            size = (float)this.mStrokeSize * (float)Math.max(0L, (long)this.mOutAnimationDuration - SystemClock.uptimeMillis() + this.mLastRunStateTime) / (float)this.mOutAnimationDuration;
            if (size > 0.0f) {
                radius = ((float)(Math.min(bounds.width(), bounds.height()) - this.mPadding * 2 - this.mStrokeSize * 2) + size) / 2.0f;
            }
        } else if (this.mRunState != 0) {
            size = this.mStrokeSize;
            radius = (float)(Math.min(bounds.width(), bounds.height()) - this.mPadding * 2 - this.mStrokeSize) / 2.0f;
        }
        if (radius > 0.0f) {
            float x = (float)(bounds.left + bounds.right) / 2.0f;
            float y = (float)(bounds.top + bounds.bottom) / 2.0f;
            this.mPaint.setStrokeWidth(size);
            this.mPaint.setStyle(Paint.Style.STROKE);
            if (this.mProgressPercent == 1.0f) {
                this.mPaint.setColor(this.mStrokeColors[0]);
                canvas.drawCircle(x, y, radius, this.mPaint);
            } else if (this.mProgressPercent == 0.0f) {
                this.mPaint.setColor(this.mStrokeSecondaryColor);
                canvas.drawCircle(x, y, radius, this.mPaint);
            } else {
                float sweepAngle = (float)(this.mReverse ? -360 : 360) * this.mProgressPercent;
                this.mRect.set(x - radius, y - radius, x + radius, y + radius);
                this.mPaint.setColor(this.mStrokeSecondaryColor);
                canvas.drawArc(this.mRect, this.mInitialAngle + sweepAngle, (float)(this.mReverse ? -360 : 360) - sweepAngle, false, this.mPaint);
                this.mPaint.setColor(this.mStrokeColors[0]);
                canvas.drawArc(this.mRect, this.mInitialAngle, sweepAngle, false, this.mPaint);
            }
        }
    }

    private int getIndeterminateStrokeColor() {
        if (this.mProgressState != 3 || this.mStrokeColors.length == 1) {
            return this.mStrokeColors[this.mStrokeColorIndex];
        }
        float value = Math.max(0.0f, Math.min(1.0f, (float)(SystemClock.uptimeMillis() - this.mLastProgressStateTime) / (float)this.mKeepDuration));
        int prev_index = this.mStrokeColorIndex == 0 ? this.mStrokeColors.length - 1 : this.mStrokeColorIndex - 1;
        return ColorUtil.getMiddleColor(this.mStrokeColors[prev_index], this.mStrokeColors[this.mStrokeColorIndex], value);
    }

    private void drawIndeterminate(Canvas canvas) {
        if (this.mRunState == 1) {
            Rect bounds = this.getBounds();
            float x = (float)(bounds.left + bounds.right) / 2.0f;
            float y = (float)(bounds.top + bounds.bottom) / 2.0f;
            float maxRadius = (float)(Math.min(bounds.width(), bounds.height()) - this.mPadding * 2) / 2.0f;
            float stepTime = 1.0f / (this.mInStepPercent * (float)(this.mInColors.length + 2) + 1.0f);
            float time = (float)(SystemClock.uptimeMillis() - this.mLastRunStateTime) / (float)this.mInAnimationDuration;
            float steps = time / stepTime;
            float outerRadius = 0.0f;
            float innerRadius = 0.0f;
            for (int i = (int)Math.floor(steps); i >= 0; --i) {
                innerRadius = outerRadius;
                outerRadius = Math.min(1.0f, (steps - (float)i) * this.mInStepPercent) * maxRadius;
                if (i >= this.mInColors.length) continue;
                if (innerRadius == 0.0f) {
                    this.mPaint.setColor(this.mInColors[i]);
                    this.mPaint.setStyle(Paint.Style.FILL);
                    canvas.drawCircle(x, y, outerRadius, this.mPaint);
                    continue;
                }
                if (!(outerRadius > innerRadius)) break;
                float radius = (innerRadius + outerRadius) / 2.0f;
                this.mRect.set(x - radius, y - radius, x + radius, y + radius);
                this.mPaint.setStrokeWidth(outerRadius - innerRadius);
                this.mPaint.setStyle(Paint.Style.STROKE);
                this.mPaint.setColor(this.mInColors[i]);
                canvas.drawCircle(x, y, radius, this.mPaint);
            }
            if (this.mProgressState == -1) {
                if (steps >= 1.0f / this.mInStepPercent || time >= 1.0f) {
                    this.resetAnimation();
                }
            } else {
                float radius = maxRadius - (float)this.mStrokeSize / 2.0f;
                this.mRect.set(x - radius, y - radius, x + radius, y + radius);
                this.mPaint.setStrokeWidth((float)this.mStrokeSize);
                this.mPaint.setStyle(Paint.Style.STROKE);
                this.mPaint.setColor(this.getIndeterminateStrokeColor());
                canvas.drawArc(this.mRect, this.mStartAngle, this.mSweepAngle, false, this.mPaint);
            }
        } else if (this.mRunState == 4) {
            float size = (float)this.mStrokeSize * (float)Math.max(0L, (long)this.mOutAnimationDuration - SystemClock.uptimeMillis() + this.mLastRunStateTime) / (float)this.mOutAnimationDuration;
            if (size > 0.0f) {
                Rect bounds = this.getBounds();
                float radius = ((float)(Math.min(bounds.width(), bounds.height()) - this.mPadding * 2 - this.mStrokeSize * 2) + size) / 2.0f;
                float x = (float)(bounds.left + bounds.right) / 2.0f;
                float y = (float)(bounds.top + bounds.bottom) / 2.0f;
                this.mRect.set(x - radius, y - radius, x + radius, y + radius);
                this.mPaint.setStrokeWidth(size);
                this.mPaint.setStyle(Paint.Style.STROKE);
                this.mPaint.setColor(this.getIndeterminateStrokeColor());
                canvas.drawArc(this.mRect, this.mStartAngle, this.mSweepAngle, false, this.mPaint);
            }
        } else if (this.mRunState != 0) {
            Rect bounds = this.getBounds();
            float radius = (float)(Math.min(bounds.width(), bounds.height()) - this.mPadding * 2 - this.mStrokeSize) / 2.0f;
            float x = (float)(bounds.left + bounds.right) / 2.0f;
            float y = (float)(bounds.top + bounds.bottom) / 2.0f;
            this.mRect.set(x - radius, y - radius, x + radius, y + radius);
            this.mPaint.setStrokeWidth((float)this.mStrokeSize);
            this.mPaint.setStyle(Paint.Style.STROKE);
            this.mPaint.setColor(this.getIndeterminateStrokeColor());
            canvas.drawArc(this.mRect, this.mStartAngle, this.mSweepAngle, false, this.mPaint);
        }
    }

    public void setAlpha(int alpha) {
        this.mPaint.setAlpha(alpha);
    }

    public void setColorFilter(ColorFilter cf) {
        this.mPaint.setColorFilter(cf);
    }

    public int getOpacity() {
        return -3;
    }

    public int getProgressMode() {
        return this.mProgressMode;
    }

    public void setProgressMode(int mode) {
        if (this.mProgressMode != mode) {
            this.mProgressMode = mode;
            this.invalidateSelf();
        }
    }

    public float getProgress() {
        return this.mProgressPercent;
    }

    public float getSecondaryProgress() {
        return this.mSecondaryProgressPercent;
    }

    public void setProgress(float percent) {
        if (this.mProgressPercent != (percent = Math.min(1.0f, Math.max(0.0f, percent)))) {
            this.mProgressPercent = percent;
            if (this.isRunning()) {
                this.invalidateSelf();
            } else if (this.mProgressPercent != 0.0f) {
                this.start();
            }
        }
    }

    public void setSecondaryProgress(float percent) {
        if (this.mSecondaryProgressPercent != (percent = Math.min(1.0f, Math.max(0.0f, percent)))) {
            this.mSecondaryProgressPercent = percent;
            if (this.isRunning()) {
                this.invalidateSelf();
            } else if (this.mSecondaryProgressPercent != 0.0f) {
                this.start();
            }
        }
    }

    private void resetAnimation() {
        this.mLastProgressStateTime = this.mLastUpdateTime = SystemClock.uptimeMillis();
        this.mStartAngle = this.mInitialAngle;
        this.mStrokeColorIndex = 0;
        this.mSweepAngle = this.mReverse ? -this.mMinSweepAngle : this.mMinSweepAngle;
        this.mProgressState = 0;
    }

    public void start() {
        this.start(this.mInAnimationDuration > 0);
    }

    public void stop() {
        this.stop(this.mOutAnimationDuration > 0);
    }

    private void start(boolean withAnimation) {
        if (this.isRunning()) {
            return;
        }
        if (withAnimation) {
            this.mRunState = 1;
            this.mLastRunStateTime = SystemClock.uptimeMillis();
            this.mProgressState = -1;
        } else {
            this.resetAnimation();
        }
        this.scheduleSelf(this.mUpdater, SystemClock.uptimeMillis() + 16L);
        this.invalidateSelf();
    }

    private void stop(boolean withAnimation) {
        if (!this.isRunning()) {
            return;
        }
        if (withAnimation) {
            this.mLastRunStateTime = SystemClock.uptimeMillis();
            if (this.mRunState == 2) {
                this.scheduleSelf(this.mUpdater, SystemClock.uptimeMillis() + 16L);
                this.invalidateSelf();
            }
            this.mRunState = 4;
        } else {
            this.mRunState = 0;
            this.unscheduleSelf(this.mUpdater);
            this.invalidateSelf();
        }
    }

    public boolean isRunning() {
        return this.mRunState != 0;
    }

    public void scheduleSelf(Runnable what, long when) {
        if (this.mRunState == 0) {
            this.mRunState = this.mInAnimationDuration > 0 ? 1 : 3;
        }
        super.scheduleSelf(what, when);
    }

    private void update() {
        switch (this.mProgressMode) {
            case 0: {
                this.updateDeterminate();
                break;
            }
            case 1: {
                this.updateIndeterminate();
            }
        }
    }

    private void updateDeterminate() {
        long curTime = SystemClock.uptimeMillis();
        if (this.mRunState == 1) {
            if (curTime - this.mLastRunStateTime > (long)this.mInAnimationDuration) {
                this.mRunState = 2;
                return;
            }
        } else if (this.mRunState == 4 && curTime - this.mLastRunStateTime > (long)this.mOutAnimationDuration) {
            this.stop(false);
            return;
        }
        if (this.isRunning()) {
            this.scheduleSelf(this.mUpdater, SystemClock.uptimeMillis() + 16L);
        }
        this.invalidateSelf();
    }

    private void updateIndeterminate() {
        long curTime = SystemClock.uptimeMillis();
        float rotateOffset = (float)(curTime - this.mLastUpdateTime) * 360.0f / (float)this.mRotateDuration;
        if (this.mReverse) {
            rotateOffset = -rotateOffset;
        }
        this.mLastUpdateTime = curTime;
        switch (this.mProgressState) {
            case 0: {
                if (this.mTransformDuration <= 0) {
                    this.mSweepAngle = this.mReverse ? -this.mMinSweepAngle : this.mMinSweepAngle;
                    this.mProgressState = 1;
                    this.mStartAngle += rotateOffset;
                    this.mLastProgressStateTime = curTime;
                    break;
                }
                float value = (float)(curTime - this.mLastProgressStateTime) / (float)this.mTransformDuration;
                float maxAngle = this.mReverse ? -this.mMaxSweepAngle : this.mMaxSweepAngle;
                float minAngle = this.mReverse ? -this.mMinSweepAngle : this.mMinSweepAngle;
                this.mStartAngle += rotateOffset;
                this.mSweepAngle = this.mTransformInterpolator.getInterpolation(value) * (maxAngle - minAngle) + minAngle;
                if (!(value > 1.0f)) break;
                this.mSweepAngle = maxAngle;
                this.mProgressState = 1;
                this.mLastProgressStateTime = curTime;
                break;
            }
            case 1: {
                this.mStartAngle += rotateOffset;
                if (curTime - this.mLastProgressStateTime <= (long)this.mKeepDuration) break;
                this.mProgressState = 2;
                this.mLastProgressStateTime = curTime;
                break;
            }
            case 2: {
                if (this.mTransformDuration <= 0) {
                    this.mSweepAngle = this.mReverse ? -this.mMinSweepAngle : this.mMinSweepAngle;
                    this.mProgressState = 3;
                    this.mStartAngle += rotateOffset;
                    this.mLastProgressStateTime = curTime;
                    this.mStrokeColorIndex = (this.mStrokeColorIndex + 1) % this.mStrokeColors.length;
                    break;
                }
                float value = (float)(curTime - this.mLastProgressStateTime) / (float)this.mTransformDuration;
                float maxAngle = this.mReverse ? -this.mMaxSweepAngle : this.mMaxSweepAngle;
                float minAngle = this.mReverse ? -this.mMinSweepAngle : this.mMinSweepAngle;
                float newSweepAngle = (1.0f - this.mTransformInterpolator.getInterpolation(value)) * (maxAngle - minAngle) + minAngle;
                this.mStartAngle += rotateOffset + this.mSweepAngle - newSweepAngle;
                this.mSweepAngle = newSweepAngle;
                if (!(value > 1.0f)) break;
                this.mSweepAngle = minAngle;
                this.mProgressState = 3;
                this.mLastProgressStateTime = curTime;
                this.mStrokeColorIndex = (this.mStrokeColorIndex + 1) % this.mStrokeColors.length;
                break;
            }
            case 3: {
                this.mStartAngle += rotateOffset;
                if (curTime - this.mLastProgressStateTime <= (long)this.mKeepDuration) break;
                this.mProgressState = 0;
                this.mLastProgressStateTime = curTime;
            }
        }
        if (this.mRunState == 1) {
            if (curTime - this.mLastRunStateTime > (long)this.mInAnimationDuration) {
                this.mRunState = 3;
                if (this.mProgressState == -1) {
                    this.resetAnimation();
                }
            }
        } else if (this.mRunState == 4 && curTime - this.mLastRunStateTime > (long)this.mOutAnimationDuration) {
            this.stop(false);
            return;
        }
        if (this.isRunning()) {
            this.scheduleSelf(this.mUpdater, SystemClock.uptimeMillis() + 16L);
        }
        this.invalidateSelf();
    }

    public static class Builder {
        private int mPadding;
        private float mInitialAngle;
        private float mProgressPercent;
        private float mSecondaryProgressPercent;
        private float mMaxSweepAngle;
        private float mMinSweepAngle;
        private int mStrokeSize;
        private int[] mStrokeColors;
        private int mStrokeSecondaryColor;
        private boolean mReverse;
        private int mRotateDuration;
        private int mTransformDuration;
        private int mKeepDuration;
        private Interpolator mTransformInterpolator;
        private int mProgressMode;
        private float mInStepPercent;
        private int[] mInColors;
        private int mInAnimationDuration;
        private int mOutAnimationDuration;

        public Builder() {
        }

        public Builder(Context context, int defStyleRes) {
            this(context, null, 0, defStyleRes);
        }

        public Builder(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
            int j;
            int[] colors;
            TypedArray ta;
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.CircularProgressDrawable, defStyleAttr, defStyleRes);
            this.padding(a.getDimensionPixelSize(R.styleable.CircularProgressDrawable_cpd_padding, 0));
            this.initialAngle(a.getInteger(R.styleable.CircularProgressDrawable_cpd_initialAngle, 0));
            this.progressPercent(a.getFloat(R.styleable.CircularProgressDrawable_pv_progress, 0.0f));
            this.secondaryProgressPercent(a.getFloat(R.styleable.CircularProgressDrawable_pv_secondaryProgress, 0.0f));
            this.maxSweepAngle(a.getInteger(R.styleable.CircularProgressDrawable_cpd_maxSweepAngle, 270));
            this.minSweepAngle(a.getInteger(R.styleable.CircularProgressDrawable_cpd_minSweepAngle, 1));
            this.strokeSize(a.getDimensionPixelSize(R.styleable.CircularProgressDrawable_cpd_strokeSize, ThemeUtil.dpToPx(context, 4)));
            this.strokeColors(a.getColor(R.styleable.CircularProgressDrawable_cpd_strokeColor, ThemeUtil.colorPrimary(context, -16777216)));
            int resId = a.getResourceId(R.styleable.CircularProgressDrawable_cpd_strokeColors, 0);
            if (resId != 0) {
                ta = context.getResources().obtainTypedArray(resId);
                colors = new int[ta.length()];
                for (j = 0; j < ta.length(); ++j) {
                    colors[j] = ta.getColor(j, 0);
                }
                ta.recycle();
                this.strokeColors(colors);
            }
            this.strokeSecondaryColor(a.getColor(R.styleable.CircularProgressDrawable_cpd_strokeSecondaryColor, 0));
            this.reverse(a.getBoolean(R.styleable.CircularProgressDrawable_cpd_reverse, false));
            this.rotateDuration(a.getInteger(R.styleable.CircularProgressDrawable_cpd_rotateDuration, context.getResources().getInteger(17694722)));
            this.transformDuration(a.getInteger(R.styleable.CircularProgressDrawable_cpd_transformDuration, context.getResources().getInteger(0x10E0001)));
            this.keepDuration(a.getInteger(R.styleable.CircularProgressDrawable_cpd_keepDuration, context.getResources().getInteger(0x10E0000)));
            resId = a.getResourceId(R.styleable.CircularProgressDrawable_cpd_transformInterpolator, 0);
            if (resId != 0) {
                this.transformInterpolator(AnimationUtils.loadInterpolator((Context)context, (int)resId));
            }
            this.progressMode(a.getInteger(R.styleable.CircularProgressDrawable_pv_progressMode, 1));
            this.inAnimDuration(a.getInteger(R.styleable.CircularProgressDrawable_cpd_inAnimDuration, context.getResources().getInteger(0x10E0001)));
            resId = a.getResourceId(R.styleable.CircularProgressDrawable_cpd_inStepColors, 0);
            if (resId != 0) {
                ta = context.getResources().obtainTypedArray(resId);
                colors = new int[ta.length()];
                for (j = 0; j < ta.length(); ++j) {
                    colors[j] = ta.getColor(j, 0);
                }
                ta.recycle();
                this.inStepColors(colors);
            }
            this.inStepPercent(a.getFloat(R.styleable.CircularProgressDrawable_cpd_inStepPercent, 0.5f));
            this.outAnimDuration(a.getInteger(R.styleable.CircularProgressDrawable_cpd_outAnimDuration, context.getResources().getInteger(0x10E0001)));
            a.recycle();
        }

        public CircularProgressDrawable build() {
            if (this.mStrokeColors == null) {
                this.mStrokeColors = new int[]{-16737793};
            }
            if (this.mInColors == null && this.mInAnimationDuration > 0) {
                this.mInColors = new int[]{-4860673, -2168068, -327682};
            }
            if (this.mTransformInterpolator == null) {
                this.mTransformInterpolator = new DecelerateInterpolator();
            }
            return new CircularProgressDrawable(this.mPadding, this.mInitialAngle, this.mProgressPercent, this.mSecondaryProgressPercent, this.mMaxSweepAngle, this.mMinSweepAngle, this.mStrokeSize, this.mStrokeColors, this.mStrokeSecondaryColor, this.mReverse, this.mRotateDuration, this.mTransformDuration, this.mKeepDuration, this.mTransformInterpolator, this.mProgressMode, this.mInAnimationDuration, this.mInStepPercent, this.mInColors, this.mOutAnimationDuration);
        }

        public Builder padding(int padding) {
            this.mPadding = padding;
            return this;
        }

        public Builder initialAngle(float angle) {
            this.mInitialAngle = angle;
            return this;
        }

        public Builder progressPercent(float percent) {
            this.mProgressPercent = percent;
            return this;
        }

        public Builder secondaryProgressPercent(float percent) {
            this.mSecondaryProgressPercent = percent;
            return this;
        }

        public Builder maxSweepAngle(float angle) {
            this.mMaxSweepAngle = angle;
            return this;
        }

        public Builder minSweepAngle(float angle) {
            this.mMinSweepAngle = angle;
            return this;
        }

        public Builder strokeSize(int strokeSize) {
            this.mStrokeSize = strokeSize;
            return this;
        }

        public Builder strokeColors(int ... strokeColors) {
            this.mStrokeColors = strokeColors;
            return this;
        }

        public Builder strokeSecondaryColor(int color) {
            this.mStrokeSecondaryColor = color;
            return this;
        }

        public Builder reverse(boolean reverse) {
            this.mReverse = reverse;
            return this;
        }

        public Builder reverse() {
            return this.reverse(true);
        }

        public Builder rotateDuration(int duration) {
            this.mRotateDuration = duration;
            return this;
        }

        public Builder transformDuration(int duration) {
            this.mTransformDuration = duration;
            return this;
        }

        public Builder keepDuration(int duration) {
            this.mKeepDuration = duration;
            return this;
        }

        public Builder transformInterpolator(Interpolator interpolator) {
            this.mTransformInterpolator = interpolator;
            return this;
        }

        public Builder progressMode(int mode) {
            this.mProgressMode = mode;
            return this;
        }

        public Builder inAnimDuration(int duration) {
            this.mInAnimationDuration = duration;
            return this;
        }

        public Builder inStepPercent(float percent) {
            this.mInStepPercent = percent;
            return this;
        }

        public Builder inStepColors(int ... colors) {
            this.mInColors = colors;
            return this;
        }

        public Builder outAnimDuration(int duration) {
            this.mOutAnimationDuration = duration;
            return this;
        }
    }
}

