/*
 * Decompiled with CFR 0.152.
 */
package com.rey.material.app;

import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.view.View;
import com.rey.material.app.Dialog;

public class DialogFragment
extends android.support.v4.app.DialogFragment {
    protected static final String ARG_BUILDER = "arg_builder";
    protected Builder mBuilder;
    private View.OnClickListener mActionListener = new View.OnClickListener(){

        public void onClick(View v) {
            if (DialogFragment.this.mBuilder == null) {
                return;
            }
            if (v.getId() == Dialog.ACTION_POSITIVE) {
                DialogFragment.this.mBuilder.onPositiveActionClicked(DialogFragment.this);
            } else if (v.getId() == Dialog.ACTION_NEGATIVE) {
                DialogFragment.this.mBuilder.onNegativeActionClicked(DialogFragment.this);
            } else if (v.getId() == Dialog.ACTION_NEUTRAL) {
                DialogFragment.this.mBuilder.onNeutralActionClicked(DialogFragment.this);
            }
        }
    };

    public static DialogFragment newInstance(Builder builder) {
        DialogFragment fragment = new DialogFragment();
        fragment.mBuilder = builder;
        return fragment;
    }

    @NonNull
    public Dialog onCreateDialog(Bundle savedInstanceState) {
        Dialog dialog = this.mBuilder == null ? new Dialog((Context)this.getActivity()) : this.mBuilder.build((Context)this.getActivity());
        dialog.positiveActionClickListener(this.mActionListener).negativeActionClickListener(this.mActionListener).neutralActionClickListener(this.mActionListener);
        return dialog;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState != null && this.mBuilder == null) {
            this.mBuilder = (Builder)savedInstanceState.getParcelable(ARG_BUILDER);
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        if (this.mBuilder != null && this.mBuilder instanceof Parcelable) {
            outState.putParcelable(ARG_BUILDER, (Parcelable)this.mBuilder);
        }
    }

    public void onDestroyView() {
        android.app.Dialog dialog = this.getDialog();
        if (dialog != null && dialog instanceof Dialog) {
            ((Dialog)dialog).dismissImmediately();
        }
        super.onDestroyView();
    }

    public static interface Builder {
        public Dialog build(Context var1);

        public void onPositiveActionClicked(DialogFragment var1);

        public void onNegativeActionClicked(DialogFragment var1);

        public void onNeutralActionClicked(DialogFragment var1);
    }
}

